/*
 * Decompiled with CFR 0.152.
 */
package sql.poc.useCase2.perf;

import cacheperf.CachePerfClient;
import cacheperf.CachePerfException;
import com.gemstone.gemfire.cache.query.Struct;
import hydra.HydraInternalException;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.gemfirexd.LonerHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import sql.GFEDBClientManager;
import sql.GFEDBManager;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.poc.useCase2.perf.QueryPerfPrms;
import sql.poc.useCase2.perf.QueryPerfStats;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class QueryPerfClient
extends CachePerfClient {
    protected static final int QUERIES = 10031;
    protected static final int SELECTQUERIES = 10055;
    protected static final String QUERY_NAME = "queries";
    protected static final String SELECT_QUERY_NAME = "selectqueries";
    protected static boolean exeQuery1 = false;
    protected static boolean exeQuery2 = false;
    protected static boolean exeselectQuery1 = false;
    protected static boolean exeselectQuery2 = false;
    protected static boolean exeselectQuery3 = false;
    protected static boolean exeselectQuery4 = false;
    protected static boolean exeselectQuery5 = false;
    protected static boolean exeselectQuery6 = false;
    protected static HydraThreadLocal myConn = new HydraThreadLocal();
    static boolean[] queryDataSet = new boolean[1];
    static List<Struct> queryData = null;
    static boolean[] queryDataSetDOC_3 = new boolean[1];
    static List<Struct> queryDataDOC_3 = null;
    public static boolean useOldListAgg = TestConfig.tab().booleanAt(SQLPrms.useOldListAgg, false);
    public static boolean useListAggNewImpl = TestConfig.tab().booleanAt(SQLPrms.useListAggNewImpl, false);
    public static boolean useListAggPreparedStmt = TestConfig.tab().booleanAt(SQLPrms.useListAggPreparedStmt, false);
    static String listAggCols = "IDX_COL1";
    static String tableName = "CDSDBA.XML_IDX_1_1";
    static String delimiter = ",";
    static String groupBy = "IDX_COL1 ASC,IDX_COL2 ASC,IDX_COL3 ASC,IDX_COL4 ASC,IDX_COL5 ASC,XML_DOC_ID_NBR ASC";
    static String[] selects = new String[]{"select IDX_COL1, XML_DOC_ID_NBR from XML_IDX_20_1 where IDX_COL1>?  ORDER BY IDX_COL1 asc, XML_DOC_ID_NBR asc OFFSET 0 ROWS FETCH FIRST 26 ROWS ONLY", "select LAST_UPDATE_TMSTP, LAST_UPDATE_SYSTEM_NM,XML_DOC_ID_NBR,MSG_PAYLOAD1_IMG,MSG_PAYLOAD_QTY,MSG_MINOR_VERSION_NBR,PRESET_DICTIONARY_ID_NBR,CREATE_MINT_CD,MSG_PAYLOAD_SIZE_NBR,DELETED_FLG,STRUCTURE_ID_NBR,MSG_PURGE_DT,MSG_PAYLOAD2_IMG,OPT_LOCK_TOKEN_NBR,LAST_UPDATE_TMSTP,MSG_MAJOR_VERSION_NBR from XML_DOC_3 where XML_DOC_ID_NBR in (?) and STRUCTURE_ID_NBR in (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", "select IDX_COL1, IDX_COL2, IDX_COL3, IDX_COL4, IDX_COL5, IDX_COL6, IDX_COL7, IDX_COL8, XML_DOC_ID_NBR from XML_IDX_65_1 where IDX_COL1=? and IDX_COL3<=? and IDX_COL4>=?  ORDER BY IDX_COL1 asc, IDX_COL2 asc, IDX_COL3 asc, IDX_COL4 asc, IDX_COL5 asc, IDX_COL6 asc, IDX_COL7 asc, IDX_COL8 asc, XML_DOC_ID_NBR asc OFFSET 0 ROWS FETCH FIRST 26 ROWS ONLY", "select IDX_COL1, IDX_COL2, IDX_COL3, XML_DOC_ID_NBR from XML_IDX_79_1 where IDX_COL1=? and IDX_COL2<=? and IDX_COL3>=?  ORDER BY IDX_COL1 asc, IDX_COL2 asc, IDX_COL3 asc, XML_DOC_ID_NBR asc OFFSET 0 ROWS FETCH FIRST 26 ROWS ONLY", "select LAST_UPDATE_SYSTEM_NM,XML_DOC_ID_NBR,MSG_PAYLOAD1_IMG,MSG_PAYLOAD_QTY,MSG_MINOR_VERSION_NBR,PRESET_DICTIONARY_ID_NBR,CREATE_MINT_CD,MSG_PAYLOAD_SIZE_NBR,DELETED_FLG,STRUCTURE_ID_NBR,MSG_PURGE_DT,MSG_PAYLOAD2_IMG,OPT_LOCK_TOKEN_NBR,LAST_UPDATE_TMSTP,MSG_MAJOR_VERSION_NBR from XML_DOC_3 where XML_DOC_ID_NBR in (?) and STRUCTURE_ID_NBR in (?)", "select IDX_COL1, IDX_COL2, IDX_COL3, IDX_COL4, IDX_COL5, XML_DOC_ID_NBR from XML_IDX_25_2 where IDX_COL1=? and IDX_COL2=? and IDX_COL3=?  ORDER BY IDX_COL1 asc, IDX_COL2 asc, IDX_COL3 asc, IDX_COL4 asc, IDX_COL5 asc, XML_DOC_ID_NBR asc OFFSET 0 ROWS FETCH FIRST 101 ROWS ONLY", "select LAST_UPDATE_SYSTEM_NM,XML_DOC_ID_NBR,MSG_PAYLOAD1_IMG,MSG_PAYLOAD_QTY,MSG_MINOR_VERSION_NBR,PRESET_DICTIONARY_ID_NBR,CREATE_MINT_CD,MSG_PAYLOAD_SIZE_NBR,DELETED_FLG,STRUCTURE_ID_NBR,MSG_PURGE_DT,MSG_PAYLOAD2_IMG,OPT_LOCK_TOKEN_NBR,LAST_UPDATE_TMSTP,MSG_MAJOR_VERSION_NBR from XML_DOC_3 where XML_DOC_ID_NBR in (?) and STRUCTURE_ID_NBR in (?)", "select IDX_COL1, IDX_COL2, IDX_COL3, IDX_COL4, IDX_COL5, XML_DOC_ID_NBR from XML_IDX_25_2 where IDX_COL1=? and IDX_COL2=? and IDX_COL3=?  ORDER BY IDX_COL1 asc, IDX_COL2 asc, IDX_COL3 asc, IDX_COL4 asc, IDX_COL5 asc, XML_DOC_ID_NBR asc OFFSET 0 ROWS FETCH FIRST 101 ROWS ONLY", "select LAST_UPDATE_SYSTEM_NM,XML_DOC_ID_NBR,MSG_PAYLOAD1_IMG,MSG_PAYLOAD_QTY,MSG_MINOR_VERSION_NBR,PRESET_DICTIONARY_ID_NBR,CREATE_MINT_CD,MSG_PAYLOAD_SIZE_NBR,DELETED_FLG,STRUCTURE_ID_NBR,MSG_PURGE_DT,MSG_PAYLOAD2_IMG,OPT_LOCK_TOKEN_NBR,LAST_UPDATE_TMSTP,MSG_MAJOR_VERSION_NBR from XML_DOC_3 where XML_DOC_ID_NBR in (?) and STRUCTURE_ID_NBR in (?)", "select IDX_COL1, IDX_COL2, IDX_COL3, IDX_COL4, IDX_COL5, XML_DOC_ID_NBR from XML_IDX_25_2 where IDX_COL1=? and IDX_COL2=? and IDX_COL3=?  ORDER BY IDX_COL1 asc, IDX_COL2 asc, IDX_COL3 asc, IDX_COL4 asc, IDX_COL5 asc, XML_DOC_ID_NBR asc OFFSET 0 ROWS FETCH FIRST 101 ROWS ONLY", "select LAST_UPDATE_SYSTEM_NM,XML_DOC_ID_NBR,MSG_PAYLOAD1_IMG,MSG_PAYLOAD_QTY,MSG_MINOR_VERSION_NBR,PRESET_DICTIONARY_ID_NBR,CREATE_MINT_CD,MSG_PAYLOAD_SIZE_NBR,DELETED_FLG,STRUCTURE_ID_NBR,MSG_PURGE_DT,MSG_PAYLOAD2_IMG,OPT_LOCK_TOKEN_NBR,LAST_UPDATE_TMSTP,MSG_MAJOR_VERSION_NBR from XML_DOC_3 where XML_DOC_ID_NBR in (?) and STRUCTURE_ID_NBR in (?)", "select LAST_UPDATE_SYSTEM_NM,XML_DOC_ID_NBR,MSG_PAYLOAD1_IMG,MSG_PAYLOAD_QTY,MSG_MINOR_VERSION_NBR,PRESET_DICTIONARY_ID_NBR,CREATE_MINT_CD,MSG_PAYLOAD_SIZE_NBR,DELETED_FLG,STRUCTURE_ID_NBR,MSG_PURGE_DT,MSG_PAYLOAD2_IMG,OPT_LOCK_TOKEN_NBR,LAST_UPDATE_TMSTP,MSG_MAJOR_VERSION_NBR from XML_DOC_3 where XML_DOC_ID_NBR in (?, ?, ?) and STRUCTURE_ID_NBR in (?)"};
    static String[] col3s = new String[]{"PP"};
    static int XML_DOC_ID_NBR_base = 500;
    static int base = 1000;
    protected static HydraThreadLocal numOfOp = new HydraThreadLocal();
    static String IDX_25_COL4 = "1234567891234545667";
    static String IDX_65_COL3 = "1198775361795";
    static String IDX_65_COL4 = "4102380000000";
    static String IDX_79_COL2 = "1198775361795";
    static String IDX_79_COL3 = "4102380000000";
    public static int numOfWorkers = (int)TestConfig.tab().longAt(SQLPrms.numOfWorkers, 400L);
    static int[] seedSTRUCTURE_ID_NBR = new int[5];
    static byte[] insertOps;
    public QueryPerfStats querystats;
    private static HydraThreadLocal localquerystats;

    public static void initQueryTask() {
        QueryPerfClient c = new QueryPerfClient();
        int exeQueryNum = QueryPerfPrms.exeQueryNum();
        switch (exeQueryNum) {
            case 1: {
                exeQuery1 = true;
                break;
            }
            case 2: {
                exeQuery2 = true;
                break;
            }
            default: {
                throw new HydraInternalException("Can't execute this query.");
            }
        }
    }

    public static void HydraTask_addData() {
        QueryPerfClient c = new QueryPerfClient();
        c.addData();
    }

    protected void addData() {
        Connection conn = (Connection)myConn.get();
        this.addDataDOC_3(conn);
        this.addDataIDX_25(conn);
        this.doInsertIDX_20_Op(conn, 0);
        this.doInsertIDX_65_Op(conn, 0);
        this.doInsertIDX_79_Op(conn, 0);
    }

    public static void HydraTask_generateQueryData() {
        QueryPerfClient c = new QueryPerfClient();
        c.generateQueryData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateQueryData() {
        boolean[] blArray = queryDataSet;
        synchronized (queryDataSet) {
            if (!queryDataSet[0]) {
                if (queryData == null) {
                    Connection conn = this.getConnection();
                    String sql = "select IDX_COL1, IDX_COL2, IDX_COL3 from CDSDBA.XML_IDX_1_1 ";
                    try {
                        ResultSet rs = conn.createStatement().executeQuery(sql);
                        queryData = ResultSetHelper.asList(rs, false);
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                } else {
                    throw new TestException("query data is already set but queryDataSet flag is not set");
                }
                QueryPerfClient.queryDataSet[0] = true;
            } else {
                QueryPerfClient.log().info("queryData is set");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void HydraTask_generateQueryDataDOC_3() {
        QueryPerfClient c = new QueryPerfClient();
        c.generateQueryDataDOC_3();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateQueryDataDOC_3() {
        boolean[] blArray = queryDataSetDOC_3;
        synchronized (queryDataSetDOC_3) {
            if (!queryDataSetDOC_3[0]) {
                if (queryDataDOC_3 == null) {
                    Connection conn = this.getConnection();
                    String sql = "select XML_DOC_ID_NBR, STRUCTURE_ID_NBR from CDSDBA.XML_DOC_3";
                    try {
                        QueryPerfClient.log().info("setting queryDataDOC_3 ");
                        ResultSet rs = conn.createStatement().executeQuery(sql);
                        queryDataDOC_3 = ResultSetHelper.asList(rs, false);
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                } else {
                    throw new TestException("query data is already set but queryDataSetDOC_3 flag is not set");
                }
                QueryPerfClient.queryDataSetDOC_3[0] = true;
            } else {
                QueryPerfClient.log().info("queryDataDOC_3 is set");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void queryTask() {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize(10031);
        c.executeQuery();
    }

    public static void selectQueryTask() {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize(10055);
        c.executeSelectQuery();
    }

    private void executeQuery() {
        Connection conn = (Connection)myConn.get();
        if (QueryPerfClient.log().fineEnabled()) {
            QueryPerfClient.log().fine("executing query");
        }
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            if (exeQuery1) {
                this.query1(conn);
            } else if (exeQuery2) {
                this.query2(conn);
            }
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
        if (QueryPerfClient.log().fineEnabled()) {
            QueryPerfClient.log().fine("finishing executing query");
        }
    }

    private void executeSelectQuery() {
        Connection conn = (Connection)myConn.get();
        if (QueryPerfClient.log().fineEnabled()) {
            QueryPerfClient.log().fine("executing select query");
        }
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.selectQuery(conn);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
        if (QueryPerfClient.log().fineEnabled()) {
            QueryPerfClient.log().fine("finishing executing query");
        }
    }

    private void query1(Connection conn) {
        try {
            this.callXML_IDXProcedures(conn);
        }
        catch (Exception e) {
            throw new CachePerfException("Could not get query result", e);
        }
    }

    private void query2(Connection conn) {
        try {
            this.callXML_DOCProcedures(conn);
        }
        catch (Exception e) {
            throw new CachePerfException("Could not get query result", e);
        }
    }

    protected void callXML_IDXProcedures(Connection conn) {
        Object[] fields = queryData.get(SQLTest.random.nextInt(queryData.size())).getFieldValues();
        String sql = null;
        if (!useListAggPreparedStmt) {
            if (useOldListAgg || useListAggNewImpl) {
                sql = "CALL CDSDBA.ListAgg('IDX_COL1 ASC,IDX_COL2 ASC,IDX_COL3 ASC,IDX_COL4 ASC,IDX_COL5 ASC,XML_DOC_ID_NBR ASC','IDX_COL1','CDSDBA.XML_IDX_1_1','IDX_COL1=''" + fields[0] + "'' " + " and IDX_COL2=''" + fields[1] + "'' " + " and IDX_COL3=''" + fields[2] + "'''," + " ',') WITH RESULT PROCESSOR ListAggProcessor";
                this.callListAggProcedure(conn, sql);
            } else {
                sql = "CALL CDSDBA.ListAgg('IDX_COL1 ASC,IDX_COL2 ASC,IDX_COL3 ASC,IDX_COL4 ASC,IDX_COL5 ASC,XML_DOC_ID_NBR ASC','IDX_COL1','CDSDBA.XML_IDX_1_1','IDX_COL1=? and IDX_COL2=? and IDX_COL3=?', '" + fields[0] + "," + fields[1] + "," + fields[2] + "'," + " ',') WITH RESULT PROCESSOR ListAggProcessor";
                this.callListAggProcedure(conn, sql);
            }
        } else if (useOldListAgg || useListAggNewImpl) {
            sql = "{CALL CDSDBA.ListAgg(?,?,?,?,?) WITH RESULT PROCESSOR ListAggProcessor ON TABLE CDSDBA.XML_IDX_1_1 }";
            this.callPreparedOldListAggProcedure(conn, sql, fields);
        } else {
            sql = "{CALL CDSDBA.ListAgg(?,?,?,?,?,?) WITH RESULT PROCESSOR ListAggProcessor ON TABLE CDSDBA.XML_IDX_1_1 }";
            this.callPreparedListAggProcedure(conn, sql, fields);
        }
    }

    protected void callPreparedOldListAggProcedure(Connection conn, String sql, Object[] fields) {
        try {
            CallableStatement stmt = conn.prepareCall(sql);
            long start = this.querystats.startQuery();
            String whereClause = "IDX_COL1='" + fields[0] + "' and IDX_COL2='" + fields[1] + "' and IDX_COL3='" + fields[2] + "'";
            stmt.setString(1, groupBy);
            stmt.setString(2, listAggCols);
            stmt.setString(3, tableName);
            stmt.setString(4, whereClause);
            stmt.setString(5, delimiter);
            stmt.execute();
            if (QueryPerfClient.log().fineEnabled()) {
                QueryPerfClient.log().fine(sql + " groupBy: " + groupBy + " listAggcols: " + listAggCols + " tableName: " + tableName + " whereClause: " + whereClause + " delimiter: " + delimiter);
            }
            ResultSet rs = stmt.getResultSet();
            List<Struct> list = ResultSetHelper.asList(rs, false);
            this.querystats.endQuery(start);
            if (QueryPerfClient.log().fineEnabled()) {
                QueryPerfClient.log().fine("Result set is " + ResultSetHelper.listToString(list));
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void callPreparedListAggProcedure(Connection conn, String sql, Object[] fields) {
        try {
            CallableStatement stmt = conn.prepareCall(sql);
            String whereClause = "IDX_COL1=? and IDX_COL2=? and IDX_COL3=?";
            String whereParams = fields[0] + "," + fields[1] + "," + fields[2];
            long start = this.querystats.startQuery();
            stmt.setString(1, groupBy);
            stmt.setString(2, listAggCols);
            stmt.setString(3, tableName);
            stmt.setString(4, whereClause);
            stmt.setString(5, whereParams);
            stmt.setString(6, delimiter);
            if (QueryPerfClient.log().fineEnabled()) {
                QueryPerfClient.log().fine(sql + " groupBy: " + groupBy + " listAggcols: " + listAggCols + " tableName: " + tableName + " whereClause: " + whereClause + " whereParams: " + whereParams + " delimiter: " + delimiter);
            }
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            List<Struct> list = ResultSetHelper.asList(rs, false);
            this.querystats.endQuery(start);
            if (QueryPerfClient.log().fineEnabled()) {
                QueryPerfClient.log().fine("Result set is " + ResultSetHelper.listToString(list));
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void callXML_DOCProcedures(Connection conn) {
    }

    protected void callListAggProcedure(Connection cxn, String sql) {
        try {
            Statement stmt = cxn.createStatement();
            long start = this.querystats.startQuery();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            if (QueryPerfClient.log().fineEnabled()) {
                QueryPerfClient.log().fine(sql);
            }
            ResultSetHelper.asList(rs, false);
            this.querystats.endQuery(start);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected Connection getConnection() {
        Connection conn = null;
        try {
            conn = SQLTest.isEdge ? GFEDBClientManager.getConnection() : GFEDBManager.getConnection();
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected void closeConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to release the connection " + TestHelper.getStackTrace((Throwable)e));
        }
    }

    public static void HydraTask_setupLoner() {
        LonerHelper.connect();
        QueryPerfClient c = new QueryPerfClient();
        c.setupConnection();
    }

    public static void HydraTask_setupConnection() {
        QueryPerfClient c = new QueryPerfClient();
        c.setupConnection();
    }

    protected void setupConnection() {
        Connection conn = this.getConnection();
        myConn.set((Object)conn);
    }

    public static void openStatisticsTask() {
        QueryPerfClient c = new QueryPerfClient();
        c.openStatistics();
    }

    private void openStatistics() {
        this.querystats = this.getQueryStats();
        if (this.querystats == null) {
            QueryPerfClient.log().info("Opening per-thread query performance statistics");
            this.querystats = QueryPerfStats.getInstance();
            RemoteTestModule.openClockSkewStatistics();
            QueryPerfClient.log().info("Opened per-thread query performance statistics");
        }
        this.setQueryStats(this.querystats);
    }

    public static void closeStatisticsTask() {
        QueryPerfClient c = new QueryPerfClient();
        c.initHydraThreadLocals();
        c.closeStatistics();
        c.updateHydraThreadLocals();
    }

    protected void closeStatistics() {
        MasterController.sleepForMs((int)2000);
        if (this.querystats != null) {
            QueryPerfClient.log().info("Closing per-thread Query performance statistics");
            this.querystats.close();
            QueryPerfClient.log().info("Closed per-thread Query performance statistics");
        }
    }

    protected void initHydraThreadLocals() {
        super.initHydraThreadLocals();
        this.querystats = this.getQueryStats();
    }

    protected void updateHydraThreadLocals() {
        super.updateHydraThreadLocals();
        this.setQueryStats(this.querystats);
    }

    protected QueryPerfStats getQueryStats() {
        QueryPerfStats querystats = (QueryPerfStats)((Object)localquerystats.get());
        return querystats;
    }

    protected void setQueryStats(QueryPerfStats querystats) {
        localquerystats.set((Object)querystats);
    }

    protected String nameFor(int name) {
        switch (name) {
            case 10031: {
                return QUERY_NAME;
            }
            case 10055: {
                return SELECT_QUERY_NAME;
            }
        }
        return super.nameFor(name);
    }

    private void selectQuery(Connection conn) {
        int num = (Integer)numOfOp.get();
        numOfOp.set((Object)(++num));
        try {
            conn.createStatement().execute("set schema CDSDBA");
            this.performInsert(conn, num);
            this.performSelectQuery(conn, num);
        }
        catch (Exception e) {
            throw new CachePerfException("Could not get query result", e);
        }
    }

    private void performInsert(Connection conn, int num) {
        this.doInsertIDX_20_Op(conn, num);
        this.doInsertIDX_25_Op(conn, num);
        this.doInsertIDX_65_Op(conn, num);
        this.doInsertIDX_79_Op(conn, num);
        this.doInsertOpDOC_3(conn, num);
    }

    private void performSelectQuery(Connection conn, int num) {
        int numberOfSelects = selects.length;
        try {
            for (int i = 0; i < numberOfSelects; ++i) {
                long start = this.querystats.startSelectQuery();
                this.selectQuery(conn, i, num);
                this.querystats.endSelectQuery(start);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    private void getSelect1Data(BigDecimal[] XML_DOC_ID_NBR, BigDecimal[] STRUCTURE_ID_NBR) {
        int i;
        int index = SQLTest.random.nextInt(queryDataDOC_3.size() - 17);
        XML_DOC_ID_NBR[0] = (BigDecimal)queryDataDOC_3.get(index).get("XML_DOC_ID_NBR");
        for (i = 0; i < 17; ++i) {
            STRUCTURE_ID_NBR[i] = (BigDecimal)queryDataDOC_3.get(index + i).get("STRUCTURE_ID_NBR");
        }
        for (i = 1; i < 3; ++i) {
            index = SQLTest.random.nextInt(queryDataDOC_3.size() - 17);
            XML_DOC_ID_NBR[i] = (BigDecimal)queryDataDOC_3.get(index).get("XML_DOC_ID_NBR");
        }
    }

    private void selectQuery(Connection conn, int whichSelect, int num) throws SQLException {
        String sql = selects[whichSelect];
        ResultSet rs = null;
        List<Struct> list = null;
        CallableStatement ps = conn.prepareCall(sql);
        if (QueryPerfClient.log().fineEnabled()) {
            QueryPerfClient.log().fine(sql);
        }
        switch (whichSelect) {
            case 0: {
                ps.setString(1, this.getRandomIDX_COL1(num));
                rs = ps.executeQuery();
                list = ResultSetHelper.asList(rs, false);
                if (!QueryPerfClient.log().fineEnabled()) break;
                QueryPerfClient.log().fine("query results is " + ResultSetHelper.listToString(list));
                break;
            }
            case 1: {
                rs = this.getSelectQueryResults(conn, sql);
                list = ResultSetHelper.asList(rs, false);
                Log.getLogWriter().info("query result size is " + list.size());
                if (!QueryPerfClient.log().fineEnabled()) break;
                QueryPerfClient.log().fine("query results is " + ResultSetHelper.listToString(list));
                break;
            }
            case 2: {
                ps.setString(1, this.getRandomIDX_COL1(num));
                ps.setBigDecimal(2, this.getIDX65_COL3QueryBase());
                ps.setBigDecimal(3, this.getIDX65_COL4QueryBase());
                rs = ps.executeQuery();
                list = ResultSetHelper.asList(rs, false);
                if (!QueryPerfClient.log().fineEnabled()) break;
                QueryPerfClient.log().fine("query results is " + ResultSetHelper.listToString(list));
                break;
            }
            case 3: {
                ps.setString(1, this.getRandomIDX_COL1(num));
                ps.setBigDecimal(2, this.getIDX79_COL2QueryBase());
                ps.setBigDecimal(3, this.getIDX79_COL3QueryBase());
                rs = ps.executeQuery();
                list = ResultSetHelper.asList(rs, false);
                if (!QueryPerfClient.log().fineEnabled()) break;
                QueryPerfClient.log().fine("query results is " + ResultSetHelper.listToString(list));
                break;
            }
            case 4: {
                rs = this.getSelectQueryResults_1(conn, sql);
                list = ResultSetHelper.asList(rs, false);
                if (!QueryPerfClient.log().fineEnabled()) break;
                QueryPerfClient.log().fine("query results is " + ResultSetHelper.listToString(list));
                break;
            }
            case 5: {
                rs = this.getSelectQueryResults_5(conn, sql, num);
                list = ResultSetHelper.asList(rs, false);
                if (!QueryPerfClient.log().fineEnabled()) break;
                QueryPerfClient.log().fine("query results is " + ResultSetHelper.listToString(list));
                break;
            }
            case 6: {
                rs = this.getSelectQueryResults_1(conn, sql);
                list = ResultSetHelper.asList(rs, false);
                if (!QueryPerfClient.log().fineEnabled()) break;
                QueryPerfClient.log().fine("query results is " + ResultSetHelper.listToString(list));
                break;
            }
            case 7: {
                rs = this.getSelectQueryResults_5(conn, sql, num);
                list = ResultSetHelper.asList(rs, false);
                if (!QueryPerfClient.log().fineEnabled()) break;
                QueryPerfClient.log().fine("query results is " + ResultSetHelper.listToString(list));
                break;
            }
            case 8: {
                rs = this.getSelectQueryResults_1(conn, sql);
                list = ResultSetHelper.asList(rs, false);
                if (!QueryPerfClient.log().fineEnabled()) break;
                QueryPerfClient.log().fine("query results is " + ResultSetHelper.listToString(list));
                break;
            }
            case 9: {
                rs = this.getSelectQueryResults_5(conn, sql, num);
                list = ResultSetHelper.asList(rs, false);
                if (!QueryPerfClient.log().fineEnabled()) break;
                QueryPerfClient.log().fine("query results is " + ResultSetHelper.listToString(list));
                break;
            }
            case 10: {
                rs = this.getSelectQueryResults_1(conn, sql);
                list = ResultSetHelper.asList(rs, false);
                if (!QueryPerfClient.log().fineEnabled()) break;
                QueryPerfClient.log().fine("query results is " + ResultSetHelper.listToString(list));
                break;
            }
            case 11: {
                rs = this.getSelectQueryResults_11(conn, sql);
                list = ResultSetHelper.asList(rs, false);
                if (!QueryPerfClient.log().fineEnabled()) break;
                QueryPerfClient.log().fine("query results is " + ResultSetHelper.listToString(list));
                break;
            }
        }
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new TestException("input file is too long");
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    private void doInsertIDX_25_Op(Connection conn, int num) {
        int IDX_COL1 = this.getIDX_COL1(num);
        int diff = num * this.getMyTid();
        BigDecimal col4 = new BigDecimal(IDX_25_COL4).add(new BigDecimal(Integer.toString(diff)));
        String sql = "insert into CDSDBA.xml_idx_25_2 (IDX_COL1, IDX_COL2, IDX_COL3, IDX_COL4, IDX_COL5, XML_DOC_ID_NBR, CREATE_MINT_CD, LAST_UPDATE_SYSTEM_NM, LAST_UPDATE_TMSTP)  values (?, 'FX', ?, ? , ?,  ?,  '1', 'APP4004', CURRENT_TIMESTAMP) ";
        try {
            PreparedStatement ps = conn.prepareStatement(sql);
            int n = 1;
            for (int i = 0; i < 10; ++i) {
                ps.setString(1, Integer.toString(IDX_COL1));
                ps.setString(2, col3s[SQLTest.random.nextInt(col3s.length)]);
                ps.setBigDecimal(3, col4);
                ps.setString(4, Integer.toString(n += i));
                ps.setBigDecimal(5, this.getRandomXML_DOC_ID_NBR(num));
                int n2 = ps.executeUpdate();
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    private void doInsertIDX_20_Op(Connection conn, int num) {
        int IDX_COL1 = this.getIDX_COL1(num);
        String sql = "insert into CDSDBA.xml_idx_20_1 (IDX_COL1, XML_DOC_ID_NBR, CREATE_MINT_CD, LAST_UPDATE_SYSTEM_NM, LAST_UPDATE_TMSTP)  values (?, ?, '1', 'APP4004', CURRENT_TIMESTAMP) ";
        try {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, Integer.toString(IDX_COL1));
            ps.setBigDecimal(2, this.getRandomXML_DOC_ID_NBR(num));
            int n = ps.executeUpdate();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    private int getIDX_COL1(int num) {
        return 100000001 + num * numOfWorkers + this.getMyTid();
    }

    private void doInsertIDX_65_Op(Connection conn, int num) {
        String sql = "insert into CDSDBA.xml_idx_65_1 (IDX_COL1, IDX_COL2, IDX_COL3, IDX_COL4, IDX_COL5, IDX_COL6, IDX_COL7, IDX_COL8, XML_DOC_ID_NBR, CREATE_MINT_CD, LAST_UPDATE_SYSTEM_NM, LAST_UPDATE_TMSTP)  values (?, 'FX', ?, ? ,'FX', '13020', NULL, '001', ?, '1', 'APP4004', CURRENT_TIMESTAMP) ";
        BigDecimal XML_DOC_ID_NBR = new BigDecimal("1111111111111111111").add(new BigDecimal(Integer.toString(this.getMyTid() + numOfWorkers * num)));
        try {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, this.getRandomIDX_COL1(num));
            ps.setBigDecimal(2, this.getRandomIDX65_COL3());
            ps.setBigDecimal(3, this.getRandomIDX65_COL4());
            ps.setBigDecimal(4, XML_DOC_ID_NBR);
            int n = ps.executeUpdate();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    private void doInsertIDX_79_Op(Connection conn, int num) {
        int IDX_COL1 = this.getIDX_COL1(num);
        String sql = "insert into CDSDBA.xml_idx_79_1 (IDX_COL1, IDX_COL2, IDX_COL3, XML_DOC_ID_NBR, CREATE_MINT_CD, LAST_UPDATE_SYSTEM_NM, LAST_UPDATE_TMSTP)   values (?, ?, ?, ?, '1', 'APP4004', CURRENT_TIMESTAMP) ";
        try {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, Integer.toString(IDX_COL1));
            ps.setBigDecimal(2, this.getRandomIDX65_COL3());
            ps.setBigDecimal(3, this.getRandomIDX65_COL4());
            ps.setBigDecimal(4, this.getRandomXML_DOC_ID_NBR(num));
            int n = ps.executeUpdate();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    private void doInsertOpDOC_3(Connection conn, int num) {
        BigDecimal XML_DOC_ID_NBR = new BigDecimal("1111111111111111111").add(new BigDecimal(Integer.toString(this.getMyTid() + numOfWorkers * num)));
        String sql = "  insert into CDSDBA.xml_doc_3 (XML_DOC_ID_NBR, STRUCTURE_ID_NBR, CREATE_MINT_CD, MSG_PAYLOAD_QTY, MSG_PAYLOAD1_IMG, MSG_PAYLOAD2_IMG, MSG_PAYLOAD_SIZE_NBR, MSG_PURGE_DT, DELETED_FLG, LAST_UPDATE_SYSTEM_NM, LAST_UPDATE_TMSTP, MSG_MAJOR_VERSION_NBR, MSG_MINOR_VERSION_NBR, OPT_LOCK_TOKEN_NBR, PRESET_DICTIONARY_ID_NBR)   values (?, ?, '1', 1, CAST(X'12345678452984560289456029847609487234785012934857109348156034650234560897628900985760289207856027895602785608560786085602857602985760206106110476191087345601456105610478568347562686289765927868972691785634975604562056104762978679451308956205620437861508561034756028475180756917856190348756012876510871789546913485620720476107856479238579385923847934' AS BLOB), NULL, 350, NULL, 'N', 'APP4004', CURRENT_TIMESTAMP, 0, 5, 1, 0) ";
        try {
            PreparedStatement ps = conn.prepareStatement(sql);
            int n = 1;
            for (int i = 0; i < 5; ++i) {
                ps.setBigDecimal(1, XML_DOC_ID_NBR);
                ps.setBigDecimal(2, new BigDecimal(Integer.toString(n += i)));
                int n2 = ps.executeUpdate();
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    private void addDataDOC_3(Connection conn) {
        int num = 1;
        numOfOp.set((Object)num);
        BigDecimal XML_DOC_ID_NBR = new BigDecimal("1111111111111111111").add(new BigDecimal(Integer.toString(this.getMyTid())));
        String sql = "  insert into CDSDBA.xml_doc_3 (XML_DOC_ID_NBR, STRUCTURE_ID_NBR, CREATE_MINT_CD, MSG_PAYLOAD_QTY, MSG_PAYLOAD1_IMG, MSG_PAYLOAD2_IMG, MSG_PAYLOAD_SIZE_NBR, MSG_PURGE_DT, DELETED_FLG, LAST_UPDATE_SYSTEM_NM, LAST_UPDATE_TMSTP, MSG_MAJOR_VERSION_NBR, MSG_MINOR_VERSION_NBR, OPT_LOCK_TOKEN_NBR, PRESET_DICTIONARY_ID_NBR)   values (?, ?, '1', 1, CAST(X'12345678452984560289456029847609487234785012934857109348156034650234560897628900985760289207856027895602785608560786085602857602985760206106110476191087345601456105610478568347562686289765927868972691785634975604562056104762978679451308956205620437861508561034756028475180756917856190348756012876510871789546913485620720476107856479238579385923847934' AS BLOB), NULL, 350, NULL, 'N', 'APP4004', CURRENT_TIMESTAMP, 0, 5, 1, 0) ";
        try {
            PreparedStatement ps = conn.prepareStatement(sql);
            for (int i = 0; i < 100; ++i) {
                ps.setBigDecimal(1, XML_DOC_ID_NBR);
                ps.setBigDecimal(2, new BigDecimal(Integer.toString(i)));
                int n = ps.executeUpdate();
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    private void addDataIDX_25(Connection conn) {
        int num = 1;
        int IDX_COL1 = 100000001 + this.getMyTid();
        int diff = num * this.getMyTid();
        BigDecimal col4 = new BigDecimal(IDX_25_COL4).add(new BigDecimal(Integer.toString(diff)));
        int IDX_COL5 = SQLTest.random.nextInt(99) + 1;
        String sql = "insert into CDSDBA.xml_idx_25_2 (IDX_COL1, IDX_COL2, IDX_COL3, IDX_COL4, IDX_COL5, XML_DOC_ID_NBR, CREATE_MINT_CD, LAST_UPDATE_SYSTEM_NM, LAST_UPDATE_TMSTP)  values (?, 'FX', ?, ? , ?,  ?,  '1', 'APP4004', CURRENT_TIMESTAMP) ";
        try {
            PreparedStatement ps = conn.prepareStatement(sql);
            for (int i = 1; i <= 50; ++i) {
                ps.setString(1, Integer.toString(IDX_COL1));
                ps.setString(2, col3s[SQLTest.random.nextInt(col3s.length)]);
                ps.setBigDecimal(3, col4);
                ps.setString(4, Integer.toString(2 * i - (SQLTest.random.nextBoolean() ? 0 : 1)));
                ps.setBigDecimal(5, this.getRandomXML_DOC_ID_NBR(num));
                int n = ps.executeUpdate();
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    private int getSTRUCTURE_ID_NBR() {
        return SQLTest.random.nextInt(99) + 1;
    }

    private ResultSet getSelectQueryResults(Connection conn, String sql) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        BigDecimal[] XML_DOC_ID_NBR = new BigDecimal[3];
        BigDecimal[] STRUCTURE_ID_NBR = new BigDecimal[17];
        if (SQLTest.random.nextBoolean()) {
            this.getSelect1Data(XML_DOC_ID_NBR, STRUCTURE_ID_NBR);
            ps.setBigDecimal(1, XML_DOC_ID_NBR[0]);
            if (QueryPerfClient.log().fineEnabled()) {
                QueryPerfClient.log().fine("XML_DOC_ID_NBR is " + XML_DOC_ID_NBR[0]);
            }
            for (int i = 2; i < 2 + STRUCTURE_ID_NBR.length; ++i) {
                ps.setBigDecimal(i, STRUCTURE_ID_NBR[i - 2]);
                if (!QueryPerfClient.log().fineEnabled()) continue;
                QueryPerfClient.log().fine("STRUCTURE_ID_NBR is " + STRUCTURE_ID_NBR[i - 2]);
            }
        } else {
            int diff = SQLTest.random.nextInt(XML_DOC_ID_NBR_base);
            BigDecimal _XML_DOC_ID_NBR = new BigDecimal("1111111111111111111").add(new BigDecimal(Integer.toString(diff)));
            ps.setBigDecimal(1, _XML_DOC_ID_NBR);
            for (int i = 2; i < 2 + STRUCTURE_ID_NBR.length; ++i) {
                ps.setBigDecimal(i, new BigDecimal(Integer.toString(this.getSTRUCTURE_ID_NBR())));
            }
        }
        return ps.executeQuery();
    }

    private ResultSet getSelectQueryResults_1(Connection conn, String sql) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        BigDecimal[] XML_DOC_ID_NBR = new BigDecimal[3];
        BigDecimal[] STRUCTURE_ID_NBR = new BigDecimal[17];
        if (SQLTest.random.nextBoolean()) {
            this.getSelect1Data(XML_DOC_ID_NBR, STRUCTURE_ID_NBR);
            ps.setBigDecimal(1, XML_DOC_ID_NBR[0]);
            if (QueryPerfClient.log().fineEnabled()) {
                QueryPerfClient.log().fine("XML_DOC_ID_NBR is " + XML_DOC_ID_NBR[0]);
            }
            ps.setBigDecimal(2, STRUCTURE_ID_NBR[0]);
            if (QueryPerfClient.log().fineEnabled()) {
                QueryPerfClient.log().fine("STRUCTURE_ID_NBR is " + STRUCTURE_ID_NBR[0]);
            }
        } else {
            int diff = SQLTest.random.nextInt(XML_DOC_ID_NBR_base) * (SQLTest.random.nextBoolean() ? 1 : -1);
            BigDecimal _XML_DOC_ID_NBR = new BigDecimal("1111111111111111111").add(new BigDecimal(Integer.toString(diff)));
            ps.setBigDecimal(1, _XML_DOC_ID_NBR);
            if (QueryPerfClient.log().fineEnabled()) {
                QueryPerfClient.log().fine("XML_DOC_ID_NBR is " + _XML_DOC_ID_NBR);
            }
            ps.setBigDecimal(2, new BigDecimal(Integer.toString(seedSTRUCTURE_ID_NBR[SQLTest.random.nextInt(seedSTRUCTURE_ID_NBR.length)])));
        }
        return ps.executeQuery();
    }

    private ResultSet getSelectQueryResults_11(Connection conn, String sql) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        BigDecimal[] XML_DOC_ID_NBR = new BigDecimal[3];
        BigDecimal[] STRUCTURE_ID_NBR = new BigDecimal[17];
        int whichOne = 0;
        if (SQLTest.random.nextBoolean()) {
            this.getSelect1Data(XML_DOC_ID_NBR, STRUCTURE_ID_NBR);
            if (QueryPerfClient.log().fineEnabled()) {
                QueryPerfClient.log().fine("XML_DOC_ID_NBR are " + XML_DOC_ID_NBR[0] + "," + XML_DOC_ID_NBR[1] + "," + XML_DOC_ID_NBR[2]);
            }
            whichOne = SQLTest.random.nextInt(STRUCTURE_ID_NBR.length);
            ps.setBigDecimal(1, XML_DOC_ID_NBR[0]);
            ps.setBigDecimal(2, XML_DOC_ID_NBR[1]);
            ps.setBigDecimal(3, XML_DOC_ID_NBR[2]);
            ps.setBigDecimal(4, STRUCTURE_ID_NBR[whichOne]);
            if (QueryPerfClient.log().fineEnabled()) {
                QueryPerfClient.log().fine("STRUCTURE_ID_NBR is " + STRUCTURE_ID_NBR[whichOne]);
            }
        } else {
            for (int i = 1; i < 4; ++i) {
                int diff = SQLTest.random.nextInt(XML_DOC_ID_NBR_base) * (SQLTest.random.nextBoolean() ? 1 : -1);
                ps.setBigDecimal(i, new BigDecimal("1111111111111111111").add(new BigDecimal(Integer.toString(diff))));
            }
            ps.setBigDecimal(4, new BigDecimal(Integer.toString(this.getSTRUCTURE_ID_NBR())));
        }
        return ps.executeQuery();
    }

    private ResultSet getSelectQueryResults_5(Connection conn, String sql, int num) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        if (SQLTest.random.nextInt(10) != 1) {
            ps.setString(1, this.getRandomIDX_COL1(1));
        } else {
            ps.setString(1, this.getRandomIDX_COL1(num));
        }
        ps.setString(2, "FX");
        ps.setString(3, col3s[SQLTest.random.nextInt(col3s.length)]);
        return ps.executeQuery();
    }

    private int getMyTid() {
        return RemoteTestModule.getCurrentThread().getThreadId();
    }

    private BigDecimal getRandomXML_DOC_ID_NBR(int num) {
        int diff = SQLTest.random.nextInt(num == 0 ? numOfWorkers : num * numOfWorkers);
        return new BigDecimal("1111111111111111111").add(new BigDecimal(Integer.toString(diff)));
    }

    private String getRandomIDX_COL1(int num) {
        int IDX_COL1 = 100000001 + SQLTest.random.nextInt(num == 0 ? numOfWorkers : num * numOfWorkers);
        return Integer.toString(IDX_COL1);
    }

    private BigDecimal getRandomIDX65_COL3() {
        return new BigDecimal(IDX_65_COL3).add(new BigDecimal(Integer.toString(SQLTest.random.nextInt(base))));
    }

    private BigDecimal getRandomIDX65_COL4() {
        return new BigDecimal(IDX_65_COL4).add(new BigDecimal(Integer.toString(SQLTest.random.nextInt(base))));
    }

    private BigDecimal getIDX65_COL3QueryBase() {
        return new BigDecimal(IDX_65_COL3).add(new BigDecimal(Integer.toString(base / 2)));
    }

    private BigDecimal getIDX65_COL4QueryBase() {
        return new BigDecimal(IDX_65_COL4).add(new BigDecimal(Integer.toString(base / 2)));
    }

    private BigDecimal getRandomIDX79_COL2() {
        return new BigDecimal(IDX_79_COL2).add(new BigDecimal(Integer.toString(SQLTest.random.nextInt(base))));
    }

    private BigDecimal getRandomIDX79_COL3() {
        return new BigDecimal(IDX_79_COL3).add(new BigDecimal(Integer.toString(SQLTest.random.nextInt(base))));
    }

    private BigDecimal getIDX79_COL2QueryBase() {
        return new BigDecimal(IDX_79_COL2).add(new BigDecimal(Integer.toString(base / 2)));
    }

    private BigDecimal getIDX79_COL3QueryBase() {
        return new BigDecimal(IDX_79_COL3).add(new BigDecimal(Integer.toString(base / 2)));
    }

    static {
        int n = 1;
        for (int i = 0; i < 5; ++i) {
            QueryPerfClient.seedSTRUCTURE_ID_NBR[i] = n += i;
        }
        insertOps = null;
        String jtests = System.getProperty("JTESTS");
        String sqlInsertOpFilePath = jtests + "/sql/poc/useCase2/insertOpsNoDOC_3.sql";
        File insertFile = new File(sqlInsertOpFilePath);
        try {
            insertOps = QueryPerfClient.getBytesFromFile(insertFile);
        }
        catch (IOException e) {
            throw new TestException("could not get bytes from file" + TestHelper.getStackTrace((Throwable)e));
        }
        localquerystats = new HydraThreadLocal();
    }
}

