/*
 * Decompiled with CFR 0.152.
 */
package sql.poc.useCase2.perf;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.NanoTimer;
import perffmwk.PerformanceStatistics;

public class QueryPerfStats
extends PerformanceStatistics {
    private static final int SCOPE = 0;
    protected static final String QUERIES = "queries";
    protected static final String QUERY_TIME = "queryTime";
    protected static final String SELECTQUERIES = "selectqueries";
    protected static final String SELECT_QUERY_TIME = "selectqueryTime";

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{QueryPerfStats.factory().createIntCounter(QUERIES, "Number of queries completed.", "operations", largerIsBetter), QueryPerfStats.factory().createLongCounter(QUERY_TIME, "Total time spent performing queries.", "nanoseconds", !largerIsBetter), QueryPerfStats.factory().createIntCounter(SELECTQUERIES, "Number of select queries completed.", "operations", largerIsBetter), QueryPerfStats.factory().createLongCounter(SELECT_QUERY_TIME, "Total time spent performing select queries.", "nanoseconds", !largerIsBetter)};
    }

    public static QueryPerfStats getInstance() {
        return (QueryPerfStats)QueryPerfStats.getInstance(QueryPerfStats.class, (int)0);
    }

    public static QueryPerfStats getInstance(String name) {
        return (QueryPerfStats)QueryPerfStats.getInstance(QueryPerfStats.class, (int)0, (String)name);
    }

    public static QueryPerfStats getInstance(String name, String trimspecName) {
        return (QueryPerfStats)QueryPerfStats.getInstance(QueryPerfStats.class, (int)0, (String)name, (String)trimspecName);
    }

    public QueryPerfStats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    public int getQueries() {
        return this.statistics().getInt(QUERIES);
    }

    public long getQUERYTime() {
        return this.statistics().getLong(QUERY_TIME);
    }

    public int getSelectQueries() {
        return this.statistics().getInt(SELECTQUERIES);
    }

    public long getSelectQUERYTime() {
        return this.statistics().getLong(SELECT_QUERY_TIME);
    }

    public void incQueries() {
        this.incQueries(1);
    }

    public void incQueries(int amount) {
        this.statistics().incInt(QUERIES, amount);
    }

    public void incQueryTime(long amount) {
        this.statistics().incLong(QUERY_TIME, amount);
    }

    public long startQuery() {
        return NanoTimer.getTime();
    }

    public void endQuery(long start) {
        long ts = NanoTimer.getTime();
        this.statistics().incInt(QUERIES, 1);
        long elapsed = ts - start;
        this.statistics().incLong(QUERY_TIME, elapsed);
    }

    public void incSelectQueries() {
        this.incSelectQueries(1);
    }

    public void incSelectQueries(int amount) {
        this.statistics().incInt(SELECTQUERIES, amount);
    }

    public void incSelectQueryTime(long amount) {
        this.statistics().incLong(SELECT_QUERY_TIME, amount);
    }

    public long startSelectQuery() {
        return NanoTimer.getTime();
    }

    public void endSelectQuery(long start) {
        long ts = NanoTimer.getTime();
        this.statistics().incInt(SELECTQUERIES, 1);
        long elapsed = ts - start;
        this.statistics().incLong(SELECT_QUERY_TIME, elapsed);
    }
}

