/*
 * Decompiled with CFR 0.152.
 */
package sql.rollingUpgrade;

import hydra.ClientVmInfo;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLTest;
import sql.ddlStatements.DDLStmtIF;
import sql.rollingUpgrade.SQLRollingUpgradeBB;
import sql.rollingUpgrade.SQLRollingUpgradePrms;
import util.PRObserver;
import util.SilenceListener;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class SQLRollingUpgradeTest
extends SQLTest {
    static HydraVector threadGroupNames = null;
    static HydraVector clientVMsToRestart = null;
    static String[] ddlCreateTableStatements = null;
    static String[] ddlCreateTableExtensions = null;
    static int threadCount = 0;
    protected static SQLRollingUpgradeTest sqlruTest = null;
    static Random rand = new Random();

    public static synchronized void HydraTask_initialize() {
        if (sqlruTest == null) {
            sqlruTest = new SQLRollingUpgradeTest();
        }
        if (threadGroupNames == null) {
            threadGroupNames = TestConfig.tab().vecAt(SQLRollingUpgradePrms.threadGroupNames);
            if (threadGroupNames == null) {
                throw new TestException("No thread groups specified for operations threads");
            }
            for (int i = 0; i < threadGroupNames.size(); ++i) {
                String threadGroupName = threadGroupNames.get(i).toString();
                Log.getLogWriter().info("Thread group name: " + threadGroupName);
                Log.getLogWriter().info("ThreadGroup:" + TestConfig.getInstance().getThreadGroup(threadGroupName));
                threadCount += TestConfig.getInstance().getThreadGroup(threadGroupName).getTotalThreads();
            }
        }
        String clientName = RemoteTestModule.getMyClientName();
        Log.getLogWriter().info("My client name: " + clientName);
        if (clientName.equals("peer") || clientName.startsWith("peerServer") || clientName.startsWith("server") || clientName.startsWith("datastore")) {
            Log.getLogWriter().info("My client name: " + clientName);
            Log.getLogWriter().info("Initializing PRObserver with my vmId: " + RemoteTestModule.getMyVmid());
            PRObserver.installObserverHook();
            PRObserver.initialize((int)RemoteTestModule.getMyVmid());
        }
        HydraVector statements = TestConfig.tab().vecAt(SQLRollingUpgradePrms.ddlCreateTableStatements, new HydraVector());
        HydraVector extensions = TestConfig.tab().vecAt(SQLRollingUpgradePrms.ddlCreateTableExtensions, new HydraVector());
        ddlCreateTableStatements = new String[statements.size()];
        ddlCreateTableExtensions = new String[extensions.size()];
        for (int i = 0; i < statements.size(); ++i) {
            SQLRollingUpgradeTest.ddlCreateTableStatements[i] = (String)statements.elementAt(i);
            SQLRollingUpgradeTest.ddlCreateTableExtensions[i] = (String)extensions.elementAt(i);
        }
        SQLRollingUpgradeTest.HydraTask_initializeFabricServer();
    }

    public static void HydraTask_doDMLOpPauseAndVerify() {
        sqlruTest.doOperationsAndPauseVerify();
    }

    public static void HydraTask_doOperations() {
        sqlruTest.doOperations();
    }

    private void doOperations() {
        long opsTaskGranularitySec = TestConfig.tab().longAt(SQLRollingUpgradePrms.opsTaskGranularitySec);
        long minTaskGranularityMS = opsTaskGranularitySec * 1000L;
        this.performOps(minTaskGranularityMS);
        if (SQLRollingUpgradeBB.getBB().getSharedCounters().read(SQLRollingUpgradeBB.recycledAllVMs) != 0L) {
            throw new StopSchedulingTaskOnClientOrder("All vms have paused");
        }
    }

    private void doOperationsAndPauseVerify() {
        int numTotalVMs = StopStartVMs.getAllVMs().size();
        long opsTaskGranularitySec = TestConfig.tab().longAt(SQLRollingUpgradePrms.opsTaskGranularitySec);
        long minTaskGranularityMS = opsTaskGranularitySec * 1000L;
        if (SQLRollingUpgradeBB.getBB().getSharedCounters().read(SQLRollingUpgradeBB.pausing) == 0L) {
            this.performOps(minTaskGranularityMS);
        }
        Log.getLogWriter().info("Done performing one invocation of performOps()");
        if (SQLRollingUpgradeBB.getBB().getSharedCounters().read(SQLRollingUpgradeBB.pausing) > 0L) {
            SQLRollingUpgradeBB.getBB().getSharedCounters().increment(SQLRollingUpgradeBB.pausing);
            int desiredCounterValue = threadCount + 1;
            TestHelper.waitForCounter((Blackboard)SQLRollingUpgradeBB.getBB(), (String)"SQLRollingUpgradeBB.pausing", (int)SQLRollingUpgradeBB.pausing, (long)desiredCounterValue, (boolean)true, (long)-1L, (long)2000L);
            SilenceListener.waitForSilence((long)30L, (long)2000L);
            this.verifyResultSets();
            SQLRollingUpgradeBB.getBB().getSharedCounters().decrement(SQLRollingUpgradeBB.pausing);
            if (SQLRollingUpgradeBB.getBB().getSharedCounters().read(SQLRollingUpgradeBB.pausing) == 1L) {
                SQLRollingUpgradeBB.getBB().getSharedCounters().setIfSmaller(SQLRollingUpgradeBB.pausing, 0L);
            }
            TestHelper.waitForCounter((Blackboard)SQLRollingUpgradeBB.getBB(), (String)"SQLRollingUpgradeBB.pausing", (int)SQLRollingUpgradeBB.pausing, (long)0L, (boolean)true, (long)-1L, (long)2000L);
        }
        if (SQLRollingUpgradeBB.getBB().getSharedCounters().read(SQLRollingUpgradeBB.recycledAllVMs) != 0L) {
            throw new StopSchedulingTaskOnClientOrder("All vms have paused");
        }
    }

    private void performOps(long taskTimeMS) {
        long startTime = System.currentTimeMillis();
        boolean performDDLOps = TestConfig.tab().booleanAt(SQLRollingUpgradePrms.performDDLOps, false);
        do {
            if (performDDLOps && rand.nextInt(10) > 6) {
                this.doDDLOp();
                continue;
            }
            Connection dConn = null;
            if (hasDerbyServer) {
                dConn = this.getDiscConnection();
            }
            Connection gConn = this.getGFEConnection();
            this.doDMLOp(dConn, gConn);
            if (dConn != null) {
                this.closeDiscConnection(dConn);
            }
            this.closeGFEConnection(gConn);
        } while (System.currentTimeMillis() - startTime < taskTimeMS);
        Log.getLogWriter().info("Done performing one batch of operations");
    }

    @Override
    protected void doDDLOp(Connection dConn, Connection gConn) {
        if (random.nextInt(2) == 0) {
            int ddl = ddls[random.nextInt(ddls.length)];
            DDLStmtIF ddlStmt = ddlFactory.createDDLStmt(ddl);
            ddlStmt.doDDLOp(dConn, gConn);
            this.commit(dConn);
            this.commit(gConn);
        } else {
            int i = random.nextInt(ddlCreateTableStatements.length);
            try {
                Statement stmt = gConn.createStatement();
                Log.getLogWriter().info("RemoteTestModule.getCurrentThread().getThreadId(): " + RemoteTestModule.getCurrentThread().getThreadId());
                Log.getLogWriter().info("RemoteTestModule.getMyVmid(): " + RemoteTestModule.getMyVmid());
                Log.getLogWriter().info("RemoteTestModule.getMyBaseThreadId(): " + RemoteTestModule.getMyBaseThreadId());
                String UniqueId = "_" + RemoteTestModule.getMyVmid() + "_" + RemoteTestModule.getCurrentThread().getThreadId();
                Log.getLogWriter().info("Dropping the sql table trade.temp (if exists)");
                stmt.execute("drop table if exists trade.temp" + UniqueId);
                Log.getLogWriter().info("Creating the sql table trade.temp");
                String sqlCommand = "create table trade.temp" + UniqueId + " " + ddlCreateTableStatements[i] + " " + ddlCreateTableExtensions[i];
                Log.getLogWriter().info("Commiting the sql create table");
                Log.getLogWriter().info("sqlCommand: " + sqlCommand);
                stmt.execute(sqlCommand);
                this.commit(gConn);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    public static synchronized void HydraTask_initController() {
        if (sqlruTest == null) {
            sqlruTest = new SQLRollingUpgradeTest();
        }
        if ((clientVMsToRestart = TestConfig.tab().vecAt(SQLRollingUpgradePrms.clientVMNamesForRestart)) == null) {
            throw new TestException("No client vm names specified for restart sequence");
        }
    }

    public static void HydraTask_UpgradeController() {
        sqlruTest.rollUpgradeVMs(true);
    }

    public static void HydraTask_UpgradeControllerNoVerify() {
        sqlruTest.rollUpgradeVMs(false);
    }

    private void rollUpgradeVMs(boolean waitForVerification) {
        ArrayList<ClientVmInfo> vms = new ArrayList<ClientVmInfo>();
        ArrayList allVMs = new ArrayList();
        for (int i = 0; i < clientVMsToRestart.size(); ++i) {
            allVMs.addAll(StopStartVMs.getMatchVMs((List)StopStartVMs.getAllVMs(), (String)clientVMsToRestart.get(i).toString()));
            if (!clientVMsToRestart.get(i).equals("peer") && !clientVMsToRestart.get(i).equals("peerServer") && !clientVMsToRestart.get(i).equals("server") && !clientVMsToRestart.get(i).equals("datastore")) continue;
            vms.addAll(StopStartVMs.getMatchVMs((List)StopStartVMs.getAllVMs(), (String)clientVMsToRestart.get(i).toString()));
        }
        do {
            if (waitForVerification) {
                TestHelper.waitForCounter((Blackboard)SQLRollingUpgradeBB.getBB(), (String)"SQLRollingUpgradeBB.pausing", (int)SQLRollingUpgradeBB.pausing, (long)0L, (boolean)true, (long)-1L, (long)2000L);
            }
            ClientVmInfo vmInfo = null;
            if (allVMs.size() != 0) {
                vmInfo = (ClientVmInfo)allVMs.get(0);
                allVMs.remove(0);
            }
            MasterController.sleepForMs((int)15000);
            StopStartVMs.stopVM((ClientVmInfo)vmInfo, (String)"nice_exit");
            Log.getLogWriter().info("Sleeping for 2 seconds to allow ops to run...");
            MasterController.sleepForMs((int)2000);
            StopStartVMs.startVM((ClientVmInfo)vmInfo);
            MasterController.sleepForMs((int)15000);
            if (vmInfo.getClientName().startsWith("peer") && !vmInfo.getClientName().startsWith("peerClient") || vmInfo.getClientName().startsWith("datastore") || vmInfo.getClientName().startsWith("server")) {
                int numOfPRs = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs);
                Log.getLogWriter().info("Total number of PR is " + numOfPRs);
                if (numOfPRs != 0) {
                    vms = new ArrayList();
                    vms.add(vmInfo);
                    PRObserver.waitForRebalRecov(vms, (int)1, (int)numOfPRs, null, null, (boolean)false);
                }
            }
            if (waitForVerification) {
                SQLRollingUpgradeBB.getBB().getSharedCounters().increment(SQLRollingUpgradeBB.pausing);
            }
            Log.getLogWriter().info("Remaining VMs size: " + allVMs.size());
            for (ClientVmInfo info : allVMs) {
                Log.getLogWriter().info("VM: " + info.getClientName() + ":" + info.getVmid());
            }
        } while (allVMs.size() != 0);
        SQLRollingUpgradeBB.getBB().getSharedCounters().increment(SQLRollingUpgradeBB.recycledAllVMs);
    }

    public static void HydraTask_UpgradeLocators() throws Exception {
        if (sqlruTest == null) {
            sqlruTest = new SQLRollingUpgradeTest();
        }
        sqlruTest.upgradeLocators();
    }

    private void upgradeLocators() throws Exception {
        boolean locatorUpgradeCompleted;
        boolean bl = locatorUpgradeCompleted = SQLRollingUpgradeBB.getBB().getSharedCounters().read(SQLRollingUpgradeBB.locatorUpgradeComplete) == 1L;
        if (locatorUpgradeCompleted) {
            return;
        }
        List vmInfoList = StopStartVMs.getAllVMs();
        int myVmID = RemoteTestModule.getMyVmid();
        ArrayList<ClientVmInfo> locatorVMs = new ArrayList<ClientVmInfo>();
        Log.getLogWriter().info("VMInfo list" + vmInfoList);
        for (int i = 0; i < vmInfoList.size(); ++i) {
            Object anObj = vmInfoList.get(i);
            Log.getLogWriter().info("VM info obj :" + anObj);
            if (!(anObj instanceof ClientVmInfo)) continue;
            ClientVmInfo info = (ClientVmInfo)anObj;
            Log.getLogWriter().info("info.getClientName()" + info.getClientName());
            if (info.getClientName().indexOf("locator") < 0) continue;
            locatorVMs.add(info);
        }
        Log.getLogWriter().info("locatorVMs" + locatorVMs);
        while (locatorVMs.size() != 0) {
            ClientVmInfo vmInfo = null;
            if (locatorVMs.size() != 0) {
                vmInfo = (ClientVmInfo)locatorVMs.get(0);
                locatorVMs.remove(0);
            }
            MasterController.sleepForMs((int)5000);
            StopStartVMs.stopVM((ClientVmInfo)vmInfo, (String)"nice_exit");
            Log.getLogWriter().info("Sleeping for 2 seconds to allow ops to run...");
            MasterController.sleepForMs((int)2000);
            StopStartVMs.startVM((ClientVmInfo)vmInfo);
            MasterController.sleepForMs((int)5000);
            Log.getLogWriter().info("Locator VMs size: " + locatorVMs.size());
        }
        MasterController.sleepForMs((int)5000);
        SQLRollingUpgradeBB.getBB().getSharedCounters().increment(SQLRollingUpgradeBB.locatorUpgradeComplete);
    }
}

