/*
 * Decompiled with CFR 0.152.
 */
package sql.schemas;

import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.engine.Misc;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.gemfirexd.GfxdConfigPrms;
import hydra.gemfirexd.GfxdHelperPrms;
import hydra.gemfirexd.NetworkServerHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import sql.GFEDBManager;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.backupAndRestore.BackupAndRestoreBB;
import sql.backupAndRestore.BackupRestoreTest;
import sql.sqlutil.ResultSetHelper;
import util.PRObserver;
import util.TestException;
import util.TestHelper;

public class SchemaTest
extends SQLTest {
    protected static SchemaTest stest;
    protected static boolean mixOffheapTables;
    protected static boolean isHDFSTest;
    protected static String hdfsStoreName;
    protected static boolean hasPersistentTables;
    public static final String PERSISTENTCLAUSE;
    public static String REDUNDANCYCLAUSE;
    public static long lastBackupTime;
    public static boolean logDML;
    public static String NUMOFPRSTABLENAME;
    public static String NUMOFPRSCOLUMNNAME;
    public static String NUMOFPRSIDNAME;
    public static final int MILLSECPERMIN = 60000;
    protected static double initEvictionHeapPercentage;
    protected boolean usePartitionBy = true;
    public static double criticalHeapPercentage;
    public static double criticalOffHeapPercentage;
    protected static long lastCriticalHeapUpdated;
    protected static boolean increaseCriticalHeapPercent;

    public static synchronized void HydraTask_initialize() {
        if (stest == null) {
            stest = new SchemaTest();
            PRObserver.installObserverHook();
            PRObserver.initialize((int)RemoteTestModule.getMyVmid());
            stest.initialize();
        }
    }

    @Override
    protected void initialize() {
    }

    public static synchronized void HydraTask_startFabricServer() {
        stest.startFabricServer();
    }

    public static synchronized void HydraTask_stopFabricServer() {
        stest.stopFabricServer();
    }

    public static synchronized void HydraTask_startNetworkServer() {
        String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
        NetworkServerHelper.startNetworkServers(networkServerConfig);
    }

    public StringBuilder getSqlScript() {
        String jtests = System.getProperty("JTESTS");
        String sqlFilePath = SQLPrms.getSqlFilePath();
        String s = new String();
        StringBuilder sb = new StringBuilder();
        try {
            FileReader fr = new FileReader(new File(jtests + "/" + sqlFilePath));
            BufferedReader br = new BufferedReader(fr);
            while ((s = br.readLine()) != null) {
                int indexOfCommentSign = s.indexOf("--");
                if (indexOfCommentSign != -1) {
                    s = s.startsWith("--") ? new String("") : new String(s.substring(0, indexOfCommentSign - 1));
                }
                sb.append(s);
            }
            br.close();
            return sb;
        }
        catch (Exception e) {
            throw new TestException("could not get sql script " + TestHelper.getStackTrace((Throwable)e));
        }
    }

    protected Connection getConnectionWithSchema(Connection conn, String schema, GFEDBManager.Isolation isolation) {
        String sql = "set schema " + schema;
        try {
            conn.createStatement().execute(sql);
            Log.getLogWriter().info(sql);
            this.setIsolation(conn, isolation);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        return conn;
    }

    protected Connection setIsolation(Connection conn, GFEDBManager.Isolation isolation) throws SQLException {
        switch (isolation) {
            case NONE: {
                conn.setTransactionIsolation(0);
                break;
            }
            case READ_COMMITTED: {
                conn.setTransactionIsolation(2);
                conn.setAutoCommit(false);
                break;
            }
            case REPEATABLE_READ: {
                conn.setTransactionIsolation(4);
                conn.setAutoCommit(false);
                break;
            }
            default: {
                throw new TestException("test issue -- unknow Isolation lever");
            }
        }
        return conn;
    }

    protected void runImportTable(Connection conn) throws SQLException {
        long start = System.currentTimeMillis();
        Log.getLogWriter().info("import table starts from " + start);
        this.importTable(conn);
        long end = System.currentTimeMillis();
        Log.getLogWriter().info("import table finishes at " + end);
        long time = end - start;
        Log.getLogWriter().info("import_table takes " + time / 1000L + " seconds");
    }

    protected void importTable(Connection conn) throws SQLException {
        StringBuilder sb = this.getSqlScript();
        String[] inst = sb.toString().split(";");
        Statement st = conn.createStatement();
        for (int i = 0; i < inst.length; ++i) {
            try {
                if (inst[i].trim().equals("") || inst[i].contains("exit")) continue;
                this.log().info(">>" + inst[i]);
                long start = System.currentTimeMillis();
                st.executeUpdate(inst[i]);
                long end = System.currentTimeMillis();
                Log.getLogWriter().info("executing " + inst[i] + " takes " + ((double)(end - start) / 1000.0 < 30.0 ? (double)(end - start) / 1000.0 + " seconds." : (double)(end - start) / 60000.0 + " minutes."));
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    public static void HydraTask_triggerBackup() {
        if (lastBackupTime == -1L || System.currentTimeMillis() - lastBackupTime > 300000L) {
            long start = System.currentTimeMillis();
            Log.getLogWriter().info("online backup starts from " + start);
            BackupRestoreTest.doBackup();
            long end = System.currentTimeMillis();
            Log.getLogWriter().info("online backup finishes at " + end);
            long time = end - start;
            Log.getLogWriter().info("online backup takes " + time / 1000L + " seconds");
            lastBackupTime = System.currentTimeMillis();
        }
    }

    protected void alterTableAddTxId(Connection conn, String tablename) {
        try {
            String sql = "alter table " + tablename + " add column txid bigint with default 0 not null";
            Log.getLogWriter().info(sql);
            conn.createStatement().execute(sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_doVodafoneInsertOp() {
        if (stest == null) {
            stest = new SchemaTest();
        }
        stest.doVodafoneInsertOps();
    }

    private void doVodafoneInsertOps() {
        Connection conn = this.getGFEConnection();
        for (int i = 0; i < 100; ++i) {
            this.doVodafoneInsertOp(conn);
        }
        this.closeGFEConnection(conn);
    }

    private void doVodafoneInsertOp(Connection conn) {
        boolean useBatchInsert = false;
        boolean useTransaction = random.nextBoolean();
        if (useTransaction) {
            try {
                conn.setTransactionIsolation(2);
                conn.setAutoCommit(false);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
        String sql = "insert into rti.kpi_aaa values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        int size = 10;
        long[] id = new long[size];
        String[] subscriber_id = new String[size];
        String[] cell_id = new String[size];
        String[] tac = new String[size];
        int[] aggregation_interval = new int[size];
        Timestamp[] time_from = new Timestamp[size];
        long[] input_octets = new long[size];
        long[] output_octets = new long[size];
        long[] input_packets = new long[size];
        long[] output_packets = new long[size];
        int[] count_2g = new int[size];
        int[] count_3g = new int[size];
        int[] count_4g = new int[size];
        Timestamp[] time_new = new Timestamp[size];
        short[] worker_id = new short[size];
        this.getDateForInsert(id, subscriber_id, cell_id, tac, aggregation_interval, time_from, input_octets, output_octets, input_packets, output_packets, count_2g, count_3g, count_4g, time_new, worker_id, size);
        try {
            PreparedStatement stmt = conn.prepareStatement(sql);
            try {
                for (int i = 0; i < size; ++i) {
                    stmt.setObject(1, id[i]);
                    stmt.setString(2, subscriber_id[i]);
                    stmt.setString(3, cell_id[i]);
                    stmt.setString(4, tac[i]);
                    stmt.setObject(5, time_from[i]);
                    stmt.setObject(6, aggregation_interval[i]);
                    stmt.setObject(7, input_octets[i]);
                    stmt.setObject(8, output_octets[i]);
                    stmt.setObject(9, input_packets[i]);
                    stmt.setObject(10, output_packets[i]);
                    stmt.setInt(11, count_2g[i]);
                    stmt.setInt(12, count_3g[i]);
                    stmt.setObject(13, count_4g[i]);
                    stmt.setObject(14, time_new[i]);
                    stmt.setObject(15, worker_id[i]);
                    if (useBatchInsert) {
                        stmt.addBatch();
                        continue;
                    }
                    int count = stmt.executeUpdate();
                    Log.getLogWriter().info("inserted with aggregation_interval: " + aggregation_interval[i]);
                    if (count == 1) continue;
                    throw new TestException("update count for insert is " + count);
                }
                if (useBatchInsert) {
                    stmt.executeBatch();
                }
                conn.commit();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    private void getDateForInsert(long[] id, String[] subscriber_id, String[] cell_id, String[] tac, int[] aggregation_interval, Timestamp[] time_from, long[] input_octets, long[] output_octets, long[] input_packets, long[] output_packets, int[] count_2g, int[] count_3g, int[] count_4g, Timestamp[] time_new, short[] worker_id, int size) {
        long key = SQLBB.getBB().getSharedCounters().add(SQLBB.tradeCustomersPrimary, (long)size);
        for (int i = 0; i < size; ++i) {
            long counter;
            id[i] = counter = key - (long)i;
            subscriber_id[i] = "name" + counter;
            cell_id[i] = "cell" + counter;
            tac[i] = this.getRandVarChar(8);
            aggregation_interval[i] = random.nextInt();
            time_from[i] = new Timestamp(System.currentTimeMillis());
            input_octets[i] = random.nextLong();
            output_octets[i] = random.nextLong();
            input_packets[i] = random.nextLong();
            output_packets[i] = random.nextLong();
            count_2g[i] = random.nextInt();
            count_3g[i] = random.nextInt();
            count_4g[i] = random.nextInt();
            time_new[i] = new Timestamp(System.currentTimeMillis());
            worker_id[i] = 0;
        }
    }

    protected String getRandVarChar(int length) {
        int aVal = 97;
        int symbolLength = random.nextInt(length) + 1;
        char[] charArray = new char[symbolLength];
        for (int j = 0; j < symbolLength; ++j) {
            charArray[j] = (char)(random.nextInt(26) + aVal);
        }
        String randChars = new String(charArray);
        return randChars;
    }

    protected int getNumOfPRs() {
        GemFireCacheImpl cache = Misc.getGemFireCache();
        Set prSet = cache.getPartitionedRegions();
        if (prSet == null) {
            throw new TestException("test issue, no pr is set in the test");
        }
        int numOfPRs = prSet.size();
        this.log().info("numOfPRs in cluster is " + numOfPRs);
        for (PartitionedRegion pr : prSet) {
            this.log().info("partitioned region name is " + pr.getName());
        }
        for (PartitionedRegion pr : prSet) {
            if (pr.getRedundantCopies() != 0) continue;
            this.log().info(pr.getRegion().getName() + " has redundancy set to 0");
            this.log().info("remove this pr from numOfPR calculation as there is no redundancy/recovery for this region");
            this.log().info("numOfPRs with redundancy in cluster now is " + --numOfPRs);
        }
        return numOfPRs;
    }

    public static void HydraTask_findNumOfPRs() throws SQLException {
        if (stest == null) {
            stest = new SchemaTest();
        }
        stest.findNumOfPRs();
    }

    protected void findNumOfPRs() throws SQLException {
        int numOfPRs = this.getNumOfPRs();
        String sql = "put into " + NUMOFPRSTABLENAME + " values (1, " + numOfPRs + ")";
        this.log().info(sql);
        Connection c = this.getGFEConnection();
        c.createStatement().executeUpdate(sql);
    }

    public static void HydraTask_createTableNumOfPRs() throws SQLException {
        if (stest == null) {
            stest = new SchemaTest();
        }
        stest.createTableNumOfPRs();
    }

    protected void createTableNumOfPRs() throws SQLException {
        Connection c = this.getGFEConnection();
        String sql = "create table " + NUMOFPRSTABLENAME + "(" + NUMOFPRSIDNAME + " int, " + NUMOFPRSCOLUMNNAME + " int," + " PRIMARY KEY (" + NUMOFPRSIDNAME + ")) " + (isHATest ? "replicate " : "") + "persistent ";
        this.log().info(sql);
        c.createStatement().execute(sql);
        c.commit();
    }

    public static void HydraTask_setNumOfPRs() throws SQLException {
        if (stest == null) {
            stest = new SchemaTest();
        }
        stest.setNumberOfPRs();
    }

    protected void setNumberOfPRs() throws SQLException {
        int numOfPRs = 0;
        int originalNumOfPRs = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs);
        if (originalNumOfPRs != 0) {
            throw new TestException("test issue, numOfPRs in SQLBB has been updated: " + originalNumOfPRs);
        }
        String sql = "select " + NUMOFPRSCOLUMNNAME + " from " + NUMOFPRSTABLENAME;
        this.log().info(sql);
        Connection c = this.getGFEConnection();
        ResultSet rs = c.createStatement().executeQuery(sql);
        if (!rs.next()) {
            throw new TestException("Could not get result for query: " + sql);
        }
        numOfPRs = rs.getInt(1);
        this.log().info("numOfPRs from table " + NUMOFPRSTABLENAME + " is " + numOfPRs);
        if (rs.next()) {
            throw new TestException("more than 1 row in the table " + NUMOFPRSTABLENAME + " value: " + rs.getInt(1));
        }
        SQLBB.getBB().getSharedCounters().add(SQLBB.numOfPRs, (long)numOfPRs);
        this.log().info("updated SQLBB.numOfPRs to " + numOfPRs);
    }

    public static void HydraTask_cycleStoreVms() {
        if (stest == null) {
            stest = new SchemaTest();
        }
        if (cycleVms) {
            stest.cycleStoreVms();
        }
    }

    public static void HydraTask_setupDsProperitesForThinClient() {
        Properties dsProp = DistributedSystemHelper.getDistributedSystem().getProperties();
        BackupAndRestoreBB.getBB().getSharedMap().put((Object)"dsProperties", (Object)dsProp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected double getCriticalHeapPercentage(Connection gConn, String sql, String serverGroup) {
        double heapPercent = 0.0;
        try {
            ResultSet rs = gConn.createStatement().executeQuery(sql);
            List<Struct> rsList = ResultSetHelper.asList(rs, false);
            if (rsList == null) return heapPercent;
            if (rsList.size() > 1) {
                String newsql = "select sys.get_critical_heap_percentage() as criticalHeapPercentage, id, servergroups as criticalHeapPercentage from sys.members where servergroups = '" + serverGroup + "'";
                this.log().info(newsql);
                ResultSet newrs = gConn.createStatement().executeQuery(newsql);
                List<Struct> newrsList = ResultSetHelper.asList(newrs, false);
                if (!isHATest) throw new TestException("more than 1 critical heap percentage are set in the same server group: " + sql + "\n" + ResultSetHelper.listToString(rsList) + "\n" + newsql + "\n" + ResultSetHelper.listToString(newrsList));
                this.log().warning("hit #51290, continue testing: " + sql + "\n" + ResultSetHelper.listToString(ResultSetHelper.asList(rs, false)));
                return heapPercent;
            }
            if (rsList.size() != 1) return heapPercent;
            float heapPercentF = ((Float)rsList.get(0).get("criticalHeapPercentage".toUpperCase())).floatValue();
            return Double.parseDouble(Float.toString(heapPercentF));
        }
        catch (SQLException se) {
            if (isHATest && se.getSQLState().equals("X0Z01")) {
                this.log().info("got expected node failure exception during select query, continue testing");
                return heapPercent;
            }
            if (isOfflineTest && (se.getSQLState().equals("X0Z09") || se.getSQLState().equals("X0Z08"))) {
                this.log().info("Got expected Offline exception, continuing test");
                return heapPercent;
            }
            SQLHelper.handleSQLException(se);
        }
        return heapPercent;
    }

    protected void increaseCriticalHeapPercentage(Connection gConn, double heapPercent, String serverGroup) {
        if (!setCriticalHeap) {
            Log.getLogWriter().info("No critical heap is set");
            return;
        }
        if (heapPercent > 0.0) {
            this.log().info("critical heap percentage is " + heapPercent);
        } else {
            this.log().info("could not get ciritical heap percentage");
        }
        long currentTime = System.currentTimeMillis();
        int waitMinute = 3;
        int waitTime = waitMinute * 60000;
        if (increaseCriticalHeapPercent && (lastCriticalHeapUpdated == 0L || currentTime - lastCriticalHeapUpdated > (long)waitTime)) {
            criticalHeapPercentage = heapPercent > 0.0 ? heapPercent + 3.0 : (criticalHeapPercentage += 3.0);
            this.log().info("new critical percent to be set " + criticalHeapPercentage);
            if (criticalHeapPercentage <= 82.0) {
                this.setCriticalHeapPercentage(gConn, criticalHeapPercentage, serverGroup);
                if (criticalHeapPercentage < 80.0) {
                    increaseCriticalHeapPercent = false;
                }
                this.log().info("increaseCriticalHeapPercent is set to " + increaseCriticalHeapPercent);
                lastCriticalHeapUpdated = System.currentTimeMillis();
            }
        }
    }

    static {
        mixOffheapTables = TestConfig.tab().booleanAt(Long.valueOf(SQLPrms.mixOffheapTables), false);
        isHDFSTest = TestConfig.tab().booleanAt(SQLPrms.hasHDFS, false);
        hdfsStoreName = "hdfsStore";
        hasPersistentTables = TestConfig.tab().booleanAt(GfxdHelperPrms.persistTables, false);
        PERSISTENTCLAUSE = " PERSISTENT " + (random.nextBoolean() ? "SYNCHRONOUS " : "ASYNCHRONOUS ");
        REDUNDANCYCLAUSE = SQLPrms.getRedundancyClause(0);
        lastBackupTime = -1L;
        logDML = TestConfig.tab().booleanAt(SQLPrms.logDML, false);
        NUMOFPRSTABLENAME = "numofprs";
        NUMOFPRSCOLUMNNAME = "number";
        NUMOFPRSIDNAME = "pr_id";
        initEvictionHeapPercentage = TestConfig.tab().doubleAt(SQLPrms.initEvictionHeapPercent, 10.0);
        criticalHeapPercentage = 50.0;
        criticalOffHeapPercentage = 50.0;
        lastCriticalHeapUpdated = 0L;
        increaseCriticalHeapPercent = false;
    }
}

