/*
 * Decompiled with CFR 0.152.
 */
package sql.schemas;

import hydra.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import sql.schemas.SchemaTest;
import sql.sqlutil.SQLStmt;

public class Transactions {
    protected final boolean logDML = SchemaTest.logDML;

    public final PreparedStatement getPreparedStatement(Connection conn, SQLStmt stmt, Object ... params) throws SQLException {
        String sql = stmt.getSQL();
        StringBuilder sb = new StringBuilder();
        sb.append(sql + " setting");
        PreparedStatement pStmt = conn.prepareStatement(sql);
        for (int i = 0; i < params.length; ++i) {
            if (this.logDML) {
                sb.append(" param" + i + ":" + params[i] + ",");
            }
            pStmt.setObject(i + 1, params[i]);
        }
        if (this.logDML) {
            Log.getLogWriter().info("executing " + sb.toString());
        }
        return pStmt;
    }
}

