/*
 * Decompiled with CFR 0.152.
 */
package sql.schemas.seats;

import hydra.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import sql.schemas.Transactions;
import sql.schemas.seats.SeatsTest;
import sql.sqlutil.SQLStmt;
import util.TestException;

public class DeleteReservation
extends Transactions {
    public final SQLStmt GetCustomerByIdStr = new SQLStmt("SELECT C_ID   FROM CUSTOMER  WHERE C_ID_STR = ?", new int[0]);
    public final SQLStmt GetCustomerByFFNumber = new SQLStmt("SELECT C_ID, FF_AL_ID   FROM CUSTOMER, FREQUENT_FLYER  WHERE FF_C_ID_STR = ? AND FF_C_ID = C_ID", new int[0]);
    public final SQLStmt GetCustomerReservation = new SQLStmt("SELECT C_SATTR00, C_SATTR02, C_SATTR04,        C_IATTR00, C_IATTR02, C_IATTR04, C_IATTR06,        F_SEATS_LEFT,        R_ID, R_SEAT, R_PRICE, R_IATTR00   FROM CUSTOMER, FLIGHT, RESERVATION  WHERE C_ID = ? AND C_ID = R_C_ID    AND F_ID = ? AND F_ID = R_F_ID    AND R_SEAT = ?", new int[0]);
    public final SQLStmt DeleteReservation = new SQLStmt("DELETE FROM RESERVATION  WHERE R_ID = ? AND R_C_ID = ? AND R_F_ID = ?", new int[0]);
    public final SQLStmt UpdateFlight = new SQLStmt("UPDATE FLIGHT    SET F_SEATS_LEFT = F_SEATS_LEFT + 1 " + (SeatsTest.addTxId ? ", TXID = " + SeatsTest.curTxId.get() : "") + " WHERE F_ID = ? ", new int[0]);
    public final SQLStmt UpdateCustomer = new SQLStmt("UPDATE CUSTOMER    SET C_BALANCE = C_BALANCE + ?,        C_IATTR00 = ?,        C_IATTR10 = C_IATTR10 - 1,        C_IATTR11 = C_IATTR10 - 1 " + (SeatsTest.addTxId ? ", TXID = " + SeatsTest.curTxId.get() : "") + " WHERE C_ID = ? ", new int[0]);
    public final SQLStmt UpdateFrequentFlyer = new SQLStmt("UPDATE FREQUENT_FLYER    SET FF_IATTR10 = FF_IATTR10 - 1 " + (SeatsTest.addTxId ? ", TXID = " + SeatsTest.curTxId.get() : "") + " WHERE FF_C_ID = ? " + "   AND FF_AL_ID = ?", new int[0]);

    public boolean doTxn(Connection conn, long f_id, Long c_id, String c_id_str, String ff_c_id_str, Long ff_al_id, Long r_seatnum) throws SQLException {
        ResultSet results;
        PreparedStatement stmt = null;
        if (c_id == null) {
            boolean has_al_id = false;
            if (c_id_str != null && c_id_str.length() > 0) {
                stmt = this.getPreparedStatement(conn, this.GetCustomerByIdStr, c_id_str);
            } else {
                if (ff_c_id_str.isEmpty()) {
                    throw new TestException("Test issue, ff_c_id_str should not be empty for delete reservation");
                }
                if (ff_al_id == null) {
                    throw new TestException("Test issue, ff_al_id should be set for delete reservation");
                }
                stmt = this.getPreparedStatement(conn, this.GetCustomerByFFNumber, ff_c_id_str);
                has_al_id = true;
            }
            ResultSet results2 = stmt.executeQuery();
            if (results2.next()) {
                c_id = results2.getLong(1);
                if (has_al_id) {
                    ff_al_id = results2.getLong(2);
                }
            } else {
                results2.close();
                Log.getLogWriter().info(String.format("No Customer record was found [c_id_str=%s, ff_c_id_str=%s, ff_al_id=%s]", c_id_str, ff_c_id_str, ff_al_id));
                return false;
            }
            results2.close();
        }
        if (!(results = (stmt = this.getPreparedStatement(conn, this.GetCustomerReservation, c_id, f_id, r_seatnum)).executeQuery()).next()) {
            results.close();
            throw new TestException(String.format("No Customer information record found for id '%d'", c_id));
        }
        long c_iattr00 = results.getLong(4) + 1L;
        long seats_left = results.getLong(8);
        long r_id = results.getLong(9);
        double r_price = results.getDouble(11);
        results.close();
        int updated = 0;
        stmt = this.getPreparedStatement(conn, this.DeleteReservation, r_id, c_id, f_id);
        updated = stmt.executeUpdate();
        if (updated != 1) {
            throw new TestException("Delete reservation deletes " + updated + " row for " + this.DeleteReservation.getSQL());
        }
        stmt = this.getPreparedStatement(conn, this.UpdateFlight, f_id);
        updated = stmt.executeUpdate();
        stmt = this.getPreparedStatement(conn, this.UpdateCustomer, -1.0 * r_price, c_iattr00, c_id);
        updated = stmt.executeUpdate();
        if (updated != 1) {
            throw new TestException("Update customer updates " + updated + " row for " + this.DeleteReservation.getSQL());
        }
        if (ff_al_id != null && (updated = (stmt = this.getPreparedStatement(conn, this.UpdateFrequentFlyer, c_id, ff_al_id)).executeUpdate()) != 1) {
            Log.getLogWriter().info(String.format("Updated " + updated + " row. " + "Failed to update FrequentFlyer info [c_id=%d, ff_al_id=%d]", c_id, ff_al_id));
        }
        if (this.logDML) {
            Log.getLogWriter().info(String.format("Deleted reservation on flight %d for customer %d [seatsLeft=%d]", f_id, c_id, seats_left + 1L));
        }
        return true;
    }
}

