/*
 * Decompiled with CFR 0.152.
 */
package sql.schemas.seats;

import hydra.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import sql.schemas.Transactions;
import sql.sqlutil.SQLStmt;

public class FindFlight
extends Transactions {
    public final SQLStmt GetNearbyAirports = new SQLStmt("SELECT *   FROM AIRPORT_DISTANCE WHERE D_AP_ID0 = ?   AND D_DISTANCE <= ?  ORDER BY D_DISTANCE ASC ", new int[0]);
    public final SQLStmt GetAirportInfo = new SQLStmt("SELECT AP_CODE, AP_NAME, AP_CITY, AP_LONGITUDE, AP_LATITUDE,  CO_ID, CO_NAME, CO_CODE_2, CO_CODE_3  FROM AIRPORT, COUNTRY  WHERE AP_ID = ? AND AP_CO_ID = CO_ID ", new int[0]);
    private static final String BaseGetFlights = "SELECT F_ID, F_AL_ID, F_SEATS_LEFT,  F_DEPART_AP_ID, F_DEPART_TIME, F_ARRIVE_AP_ID, F_ARRIVE_TIME,  AL_NAME, AL_IATTR00, AL_IATTR01  FROM FLIGHT, AIRLINE  WHERE F_DEPART_AP_ID = ?    AND F_DEPART_TIME >= ? AND F_DEPART_TIME <= ?    AND F_AL_ID = AL_ID    AND F_ARRIVE_AP_ID IN (??)";
    public final SQLStmt GetFlights1 = new SQLStmt("SELECT F_ID, F_AL_ID, F_SEATS_LEFT,  F_DEPART_AP_ID, F_DEPART_TIME, F_ARRIVE_AP_ID, F_ARRIVE_TIME,  AL_NAME, AL_IATTR00, AL_IATTR01  FROM FLIGHT, AIRLINE  WHERE F_DEPART_AP_ID = ?    AND F_DEPART_TIME >= ? AND F_DEPART_TIME <= ?    AND F_AL_ID = AL_ID    AND F_ARRIVE_AP_ID IN (??)", 1);
    public final SQLStmt GetFlights2 = new SQLStmt("SELECT F_ID, F_AL_ID, F_SEATS_LEFT,  F_DEPART_AP_ID, F_DEPART_TIME, F_ARRIVE_AP_ID, F_ARRIVE_TIME,  AL_NAME, AL_IATTR00, AL_IATTR01  FROM FLIGHT, AIRLINE  WHERE F_DEPART_AP_ID = ?    AND F_DEPART_TIME >= ? AND F_DEPART_TIME <= ?    AND F_AL_ID = AL_ID    AND F_ARRIVE_AP_ID IN (??)", 2);
    public final SQLStmt GetFlights3 = new SQLStmt("SELECT F_ID, F_AL_ID, F_SEATS_LEFT,  F_DEPART_AP_ID, F_DEPART_TIME, F_ARRIVE_AP_ID, F_ARRIVE_TIME,  AL_NAME, AL_IATTR00, AL_IATTR01  FROM FLIGHT, AIRLINE  WHERE F_DEPART_AP_ID = ?    AND F_DEPART_TIME >= ? AND F_DEPART_TIME <= ?    AND F_AL_ID = AL_ID    AND F_ARRIVE_AP_ID IN (??)", 3);

    public List<Object[]> doTxn(Connection conn, long depart_aid, long arrive_aid, Timestamp start_date, Timestamp end_date, long distance) throws SQLException {
        int num_nearby;
        assert (!start_date.equals(end_date));
        ArrayList<Long> arrive_aids = new ArrayList<Long>();
        arrive_aids.add(arrive_aid);
        ArrayList<Object[]> finalResults = new ArrayList<Object[]>();
        if (distance > 0L) {
            PreparedStatement nearby_stmt = this.getPreparedStatement(conn, this.GetNearbyAirports, depart_aid, distance);
            ResultSet nearby_results = nearby_stmt.executeQuery();
            while (nearby_results.next()) {
                long aid = nearby_results.getLong(1);
                double aid_distance = nearby_results.getDouble(2);
                if (this.logDML) {
                    Log.getLogWriter().info("DEPART NEARBY: " + aid + " distance=" + aid_distance + " miles");
                }
                arrive_aids.add(aid);
            }
            nearby_results.close();
        }
        if ((num_nearby = arrive_aids.size()) > 0) {
            PreparedStatement f_stmt = null;
            if (num_nearby == 1) {
                f_stmt = this.getPreparedStatement(conn, this.GetFlights1, new Object[0]);
                Log.getLogWriter().info("executing " + this.GetFlights1);
            } else if (num_nearby == 2) {
                f_stmt = this.getPreparedStatement(conn, this.GetFlights2, new Object[0]);
                Log.getLogWriter().info("executing " + this.GetFlights2);
            } else {
                f_stmt = this.getPreparedStatement(conn, this.GetFlights3, new Object[0]);
                Log.getLogWriter().info("executing " + this.GetFlights3);
            }
            assert (f_stmt != null);
            StringBuilder sb = new StringBuilder();
            sb.append("setting F_DEPART_AP_ID:" + depart_aid);
            f_stmt.setLong(1, depart_aid);
            sb.append(", F_DEPART_TIME:" + start_date);
            f_stmt.setTimestamp(2, start_date);
            sb.append(", F_DEPART_TIME:" + end_date);
            f_stmt.setTimestamp(3, end_date);
            sb.append(", F_ARRIVE_AP_ID IN(");
            int cnt = Math.min(3, num_nearby);
            for (int i = 0; i < cnt; ++i) {
                long aid = (Long)arrive_aids.get(i);
                f_stmt.setLong(4 + i, aid);
                if (i < cnt - 1) {
                    sb.append(aid + ", ");
                    continue;
                }
                sb.append(aid + ")");
            }
            if (this.logDML) {
                Log.getLogWriter().info(sb.toString());
            }
            ResultSet flightResults = f_stmt.executeQuery();
            Log.getLogWriter().info("executing " + this.GetAirportInfo);
            PreparedStatement ai_stmt = this.getPreparedStatement(conn, this.GetAirportInfo, new Object[0]);
            ResultSet ai_results = null;
            while (flightResults.next()) {
                long f_depart_airport = flightResults.getLong(4);
                long f_arrive_airport = flightResults.getLong(6);
                Object[] row = new Object[13];
                int r = 0;
                row[r++] = flightResults.getLong(1);
                row[r++] = flightResults.getLong(3);
                row[r++] = flightResults.getString(8);
                ai_stmt.setLong(1, f_depart_airport);
                if (this.logDML) {
                    Log.getLogWriter().info("setting AP_ID = " + f_depart_airport);
                }
                ai_results = ai_stmt.executeQuery();
                boolean adv = ai_results.next();
                assert (adv);
                row[r++] = flightResults.getDate(5);
                row[r++] = ai_results.getString(1);
                row[r++] = ai_results.getString(2);
                row[r++] = ai_results.getString(3);
                row[r++] = ai_results.getString(7);
                ai_results.close();
                ai_stmt.setLong(1, f_arrive_airport);
                ai_results = ai_stmt.executeQuery();
                adv = ai_results.next();
                assert (adv);
                row[r++] = flightResults.getDate(7);
                row[r++] = ai_results.getString(1);
                row[r++] = ai_results.getString(2);
                row[r++] = ai_results.getString(3);
                row[r++] = ai_results.getString(7);
                ai_results.close();
                finalResults.add(row);
                if (!this.logDML) continue;
                Log.getLogWriter().info(String.format("Flight %d / %s /  %s -> %s / %s", row[0], row[2], row[4], row[9], row[3]));
            }
            flightResults.close();
        }
        if (this.logDML) {
            for (Object[] row : finalResults) {
                StringBuilder sb = new StringBuilder();
                for (Object info : row) {
                    sb.append(info + ",");
                }
                Log.getLogWriter().info("Flight Information:" + sb.toString());
            }
        }
        return finalResults;
    }
}

