/*
 * Decompiled with CFR 0.152.
 */
package sql.schemas.seats;

import hydra.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import sql.schemas.Transactions;
import sql.sqlutil.SQLStmt;
import util.TestException;

public class FindOpenSeats
extends Transactions {
    public final SQLStmt GetFlight = new SQLStmt("SELECT F_STATUS, F_BASE_PRICE, F_SEATS_TOTAL, F_SEATS_LEFT,        (F_BASE_PRICE + (F_BASE_PRICE * (1 - (F_SEATS_LEFT / cast(F_SEATS_TOTAL as double))))) AS F_PRICE   FROM FLIGHT WHERE F_ID = ?", new int[0]);
    public final SQLStmt GetSeats = new SQLStmt("SELECT R_ID, R_F_ID, R_SEAT   FROM RESERVATION WHERE R_F_ID = ?", new int[0]);
    protected boolean reproduce51122 = false;

    public Object[][] doTxn(Connection conn, long f_id) throws SQLException {
        ResultSet f_results;
        long[] seatmap = new long[]{-1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L};
        assert (seatmap.length == 150);
        PreparedStatement f_stmt = this.getPreparedStatement(conn, this.GetFlight, new Object[0]);
        f_stmt.setLong(1, f_id);
        if (this.logDML) {
            Log.getLogWriter().info("F_ID:" + f_id);
        }
        if (!(f_results = f_stmt.executeQuery()).next()) {
            throw new TestException("does not get result for " + this.GetFlight.getSQL() + " for F_ID:" + f_id);
        }
        double base_price = f_results.getDouble(2);
        long seats_total = f_results.getLong(3);
        long seats_left = f_results.getLong(4);
        double seat_price = f_results.getDouble(5);
        f_results.close();
        double _seat_price = base_price + base_price * (1.0 - (double)seats_left / (double)seats_total);
        if (this.logDML) {
            Log.getLogWriter().info(String.format("Flight %d - SQL[%.2f] <-> JAVA[%.2f] [basePrice=%f, total=%d, left=%d]", f_id, seat_price, _seat_price, base_price, seats_total, seats_left));
        }
        PreparedStatement s_stmt = this.getPreparedStatement(conn, this.GetSeats, new Object[0]);
        s_stmt.setLong(1, f_id);
        ResultSet s_results = s_stmt.executeQuery();
        while (s_results.next()) {
            long r_id = s_results.getLong(1);
            int seatnum = s_results.getInt(3);
            if (this.logDML) {
                Log.getLogWriter().info(String.format("Reserved Seat: fid %d / rid %d / seat %d", f_id, r_id, seatnum));
            }
            if (seatmap[seatnum] != -1L) {
                throw new TestException("Duplicate seat reservation: R_ID=" + r_id);
            }
            seatmap[seatnum] = 1L;
        }
        s_results.close();
        int ctr = 0;
        Object[][] returnResults = new Object[150][];
        for (int i = 0; i < seatmap.length; ++i) {
            if (seatmap[i] != -1L) continue;
            double price = seat_price * (i < 10 ? 2.0 : 1.0);
            if (!this.reproduce51122) {
                price = (float)Math.round(price * 100.0) / 100.0f;
            }
            Object[] row = new Object[]{f_id, i, price};
            returnResults[ctr++] = row;
            if (ctr == returnResults.length) break;
        }
        return returnResults;
    }
}

