/*
 * Decompiled with CFR 0.152.
 */
package sql.schemas.seats;

import hydra.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import sql.schemas.Transactions;
import sql.schemas.seats.SeatsTest;
import sql.sqlutil.SQLStmt;
import util.TestException;

public class NewReservation
extends Transactions {
    public final SQLStmt GetFlight = new SQLStmt("SELECT F_AL_ID, F_SEATS_LEFT, AIRLINE.*   FROM FLIGHT, AIRLINE WHERE F_ID = ? AND F_AL_ID = AL_ID", new int[0]);
    public final SQLStmt GetCustomer = new SQLStmt("SELECT C_BASE_AP_ID, C_BALANCE, C_SATTR00   FROM CUSTOMER WHERE C_ID = ? ", new int[0]);
    public final SQLStmt CheckSeat = new SQLStmt("SELECT R_ID   FROM RESERVATION  WHERE R_F_ID = ? and R_SEAT = ?", new int[0]);
    public final SQLStmt CheckCustomer = new SQLStmt("SELECT R_ID   FROM RESERVATION  WHERE R_F_ID = ? AND R_C_ID = ?", new int[0]);
    public final SQLStmt UpdateFlight = new SQLStmt("UPDATE FLIGHT    SET F_SEATS_LEFT = F_SEATS_LEFT - 1 " + (SeatsTest.addTxId ? ", TXID = " + SeatsTest.curTxId.get() : "") + " WHERE F_ID = ? ", new int[0]);
    public final SQLStmt UpdateCustomer = new SQLStmt("UPDATE CUSTOMER    SET C_BALANCE = C_BALANCE + ?,        C_IATTR10 = C_IATTR10 + 1,        C_IATTR11 = C_IATTR11 + 1,        C_IATTR12 = ?,        C_IATTR13 = ?,        C_IATTR14 = ?,        C_IATTR15 = ? " + (SeatsTest.addTxId ? ", TXID = " + SeatsTest.curTxId.get() : "") + " WHERE C_ID = ? ", new int[0]);
    public final SQLStmt UpdateFrequentFlyer = new SQLStmt("UPDATE FREQUENT_FLYER    SET FF_IATTR10 = FF_IATTR10 + 1,        FF_IATTR11 = ?,        FF_IATTR12 = ?,        FF_IATTR13 = ?,        FF_IATTR14 = ? " + (SeatsTest.addTxId ? ", TXID = " + SeatsTest.curTxId.get() : "") + " WHERE FF_C_ID = ? " + "   AND FF_AL_ID = ?", new int[0]);
    public final SQLStmt InsertReservation = new SQLStmt("INSERT INTO RESERVATION (   R_ID,    R_C_ID,    R_F_ID,    R_SEAT,    R_PRICE,    R_IATTR00,    R_IATTR01,    R_IATTR02,    R_IATTR03,    R_IATTR04,    R_IATTR05,    R_IATTR06,    R_IATTR07,    R_IATTR08 " + (SeatsTest.addTxId ? ", TXID " : "") + ") VALUES (" + "   ?, " + "   ?, " + "   ?, " + "   ?, " + "   ?, " + "   ?, " + "   ?, " + "   ?, " + "   ?, " + "   ?, " + "   ?, " + "   ?, " + "   ?, " + "   ? " + (SeatsTest.addTxId ? ", " + SeatsTest.curTxId.get() : "") + ")", new int[0]);

    public boolean doTxn(Connection conn, long r_id, long c_id, long f_id, long seatnum, double price, long[] attrs) throws SQLException {
        int updated;
        PreparedStatement stmt = this.getPreparedStatement(conn, this.GetFlight, f_id);
        ResultSet results = stmt.executeQuery();
        if (!results.next()) {
            throw new TestException(String.format(" Invalid flight #%d", f_id));
        }
        long airline_id = results.getLong(1);
        long seats_left = results.getLong(2);
        results.close();
        if (seats_left <= 0L) {
            Log.getLogWriter().warning(String.format(" No more seats available for flight #%d", f_id));
            return false;
        }
        stmt = this.getPreparedStatement(conn, this.CheckSeat, f_id, seatnum);
        results = stmt.executeQuery();
        if (results.next()) {
            Log.getLogWriter().warning(String.format(" Seat %d is already reserved on flight #%d", seatnum, f_id));
            return false;
        }
        results.close();
        stmt = this.getPreparedStatement(conn, this.CheckCustomer, f_id, c_id);
        results = stmt.executeQuery();
        if (results.next()) {
            Log.getLogWriter().warning(String.format(" Customer %d already owns on a reservations on flight #%d", c_id, f_id));
        }
        results.close();
        stmt = this.getPreparedStatement(conn, this.GetCustomer, c_id);
        results = stmt.executeQuery();
        if (!results.next()) {
            throw new TestException(String.format(" Invalid customer id: %d", c_id));
        }
        results.close();
        StringBuilder sb = new StringBuilder();
        stmt = this.getPreparedStatement(conn, this.InsertReservation, new Object[0]);
        stmt.setLong(1, r_id);
        stmt.setLong(2, c_id);
        stmt.setLong(3, f_id);
        stmt.setLong(4, seatnum);
        stmt.setDouble(5, price);
        sb.append("setting R_ID:" + r_id + "  R_C_ID:" + c_id + "  R_F_ID:" + f_id + " R_SEAT:" + seatnum + " R_PRICE:" + price);
        for (int i = 0; i < attrs.length; ++i) {
            stmt.setLong(6 + i, attrs[i]);
            sb.append(" R_IATTR0" + i + ":" + attrs[i]);
        }
        if (this.logDML) {
            Log.getLogWriter().info(sb.toString());
        }
        if ((updated = stmt.executeUpdate()) != 1) {
            String msg = String.format("Failed to add reservation for flight #%d - Inserted %d records for InsertReservation", f_id, updated);
            if (this.logDML) {
                Log.getLogWriter().warning(msg);
            }
            throw new TestException(msg);
        }
        updated = this.getPreparedStatement(conn, this.UpdateFlight, f_id).executeUpdate();
        if (updated != 1) {
            String msg = String.format("Failed to add reservation for flight #%d - Updated %d records for UpdateFlight", f_id, updated);
            if (this.logDML) {
                Log.getLogWriter().warning(msg);
            }
            throw new TestException(msg);
        }
        updated = this.getPreparedStatement(conn, this.UpdateCustomer, price, attrs[0], attrs[1], attrs[2], attrs[3], c_id).executeUpdate();
        if (updated != 1) {
            String msg = String.format("Failed to add reservation for flight #%d - Updated %d records for UpdateCustomer", f_id, updated);
            if (this.logDML) {
                Log.getLogWriter().warning(msg);
            }
            throw new TestException(msg);
        }
        updated = this.getPreparedStatement(conn, this.UpdateFrequentFlyer, attrs[4], attrs[5], attrs[6], attrs[7], c_id, airline_id).executeUpdate();
        if (this.logDML) {
            Log.getLogWriter().info(String.format("Reserved new seat on flight %d for customer %d [seatsLeft=%d]", f_id, c_id, seats_left - 1L));
        }
        return true;
    }
}

