/*
 * Decompiled with CFR 0.152.
 */
package sql.schemas.seats;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.ConfigPrms;
import hydra.HDFSStoreDescription;
import hydra.HDFSStoreHelper;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.TestConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import sql.GFEDBManager;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.schemas.SchemaTest;
import sql.schemas.seats.DeleteReservation;
import sql.schemas.seats.FindFlight;
import sql.schemas.seats.FindOpenSeats;
import sql.schemas.seats.NewReservation;
import sql.schemas.seats.UpdateCustomer;
import sql.schemas.seats.UpdateReservation;
import sql.sqlTx.SQLTxBB;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class SeatsTest
extends SchemaTest {
    public static SeatsTest seats;
    protected static final String SCHEMA_NAME = "SEATS";
    protected static String dataGroup;
    protected static final String DATAGROUPCLAUSE;
    protected static final String VERIFIERGROUPCLAUSE = " SERVER GROUPS (VerifierGroup) ";
    protected static List<Struct> flights;
    protected static boolean[] flightSet;
    protected static List<Struct> customers;
    protected static List<Struct> customersInitBalance;
    protected static boolean[] customerSet;
    protected static Map<Long, List<Struct>> customerByAP;
    private static Timestamp startDate;
    public static int[] DISTANCES;
    public static final int PROB_FIND_FLIGHTS_NEARBY_AIRPORT = 25;
    public static final int PROB_REPOPULATE_FLIGHTINFO = 5;
    public static final int PROB_ADD_RESERVATION = 3;
    public static final int FLIGHTS_NUM_SEATS = 150;
    public static final int FLIGHTS_FIRST_CLASS_OFFSET = 10;
    public static final int HUNDRED = 100;
    public static final int THOUSAND = 1000;
    public static final int MILLION = 1000000;
    public static final int CACHE_LIMIT_PENDING_INSERTS = 10000;
    public static final int CACHE_LIMIT_PENDING_UPDATES = 5000;
    public static final int CACHE_LIMIT_PENDING_DELETES = 5000;
    public static final int RESERVATION_PRICE_MIN = 100;
    public static final int RESERVATION_PRICE_MAX = 1000;
    public static final int PROB_DELETE_WITH_CUSTOMER_ID_STR = 20;
    public static final int PROB_UPDATE_WITH_CUSTOMER_ID_STR = 20;
    public static final int PROB_DELETE_WITH_FREQUENTFLYER_ID_STR = 20;
    public static final int PROB_REQUEUE_DELETED_RESERVATION = 50;
    public static final int PROB_UPDATE_FREQUENT_FLYER = 25;
    private final HydraThreadLocal my_reservations = new HydraThreadLocal();
    private int[] setFlightThread = new int[1];
    public static HydraThreadLocal gfxdNonTxnConn;
    public static HydraThreadLocal curTxId;
    public static boolean useNonTxnConn;
    public static boolean addTxId;
    public static final String INSERT = "insert";
    public static final String UPDATE = "update";
    public static final String DELETE = "delete";
    protected static boolean verifyBalance;
    protected String initBalTablePrefix = "init_cust_price_";
    protected String tempTablePrefix = "session.";
    protected String updateBalTablePrefix = "cust_price_";
    protected boolean useTempTable = false;
    protected long num_reservations = 0L;
    protected static boolean reproduce50962;
    protected static boolean reproduce51113;
    protected static boolean reproduce51090;
    protected static boolean reproduce43511;
    protected static boolean reproduce51255;
    protected static HydraThreadLocal increaseMemOpExectued;
    public static final long MILLISECONDS_PER_MINUTE = 60000L;
    public static final long MILLISECONDS_PER_DAY = 86400000L;
    protected boolean verifyBalanceTablesCreated = false;
    protected final Map<CacheType, LinkedList<Reservation>> CACHE_RESERVATIONS = new HashMap<CacheType, LinkedList<Reservation>>();
    protected final Map<CustomerId, Set<FlightInfo>> CACHE_CUSTOMER_BOOKED_FLIGHTS;
    protected final Map<FlightInfo, BitSet> CACHE_BOOKED_SEATS;
    private static final BitSet FULL_FLIGHT_BITSET;

    public SeatsTest() {
        for (CacheType ctype : CacheType.values()) {
            this.CACHE_RESERVATIONS.put(ctype, new LinkedList());
        }
        this.CACHE_CUSTOMER_BOOKED_FLIGHTS = new HashMap<CustomerId, Set<FlightInfo>>();
        this.CACHE_BOOKED_SEATS = new HashMap<FlightInfo, BitSet>();
    }

    public static void HydraTask_createSchema() throws SQLException {
        if (seats == null) {
            seats = new SeatsTest();
        }
        seats.createSchema();
    }

    protected void createSchema() throws SQLException {
        ddlThread = this.getMyTid();
        Connection c = this.getGFEConnection();
        Statement st = c.createStatement();
        String sql = "create schema SEATS";
        Log.getLogWriter().info(sql);
        st.execute(sql);
        Log.getLogWriter().info("executed " + sql);
    }

    public static void HydraTask_createSeatsTables() throws SQLException {
        if (seats == null) {
            seats = new SeatsTest();
        }
        seats.createSeatsTables();
    }

    protected void createSeatsTables() throws SQLException {
        if (isHDFSTest) {
            HDFSStoreDescription hdfsStoreDesc = HDFSStoreHelper.getHDFSStoreDescription((String)ConfigPrms.getHDFSStoreConfig());
            hdfsStoreName = hdfsStoreDesc.getName();
        }
        StringBuilder sb = this.getSqlScript();
        String[] inst = sb.toString().split(";");
        Connection c = this.getGFEConnection();
        Statement st = this.getConnectionWithSchema(c, SCHEMA_NAME, GFEDBManager.Isolation.NONE).createStatement();
        for (int i = 0; i < inst.length; ++i) {
            try {
                if (inst[i].trim().equals("") || inst[i].contains("exit")) continue;
                if (isOffheap && inst[i].contains("CREATE TABLE")) {
                    if (!mixOffheapTables) {
                        int n = i;
                        inst[n] = inst[n] + " OFFHEAP ";
                    } else if (random.nextBoolean()) {
                        int n = i;
                        inst[n] = inst[n] + " OFFHEAP ";
                    }
                }
                if (hasPersistentTables && inst[i].contains("CREATE TABLE")) {
                    int n = i;
                    inst[n] = inst[n] + PERSISTENTCLAUSE;
                }
                if (isHATest && !inst[i].toUpperCase().contains("REPLICATE") && inst[i].contains("CREATE TABLE")) {
                    int n = i;
                    inst[n] = inst[n] + REDUNDANCYCLAUSE;
                }
                if (isHDFSTest && inst[i].contains("CREATE TABLE RESERVATION ")) {
                    int n = i;
                    inst[n] = inst[n] + this.getFlightHDFSClause();
                }
                if (inst[i].contains("CREATE TABLE")) {
                    int n = i;
                    inst[n] = inst[n] + DATAGROUPCLAUSE;
                }
                this.log().info(">>" + inst[i]);
                st.executeUpdate(inst[i]);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    private String getFlightHDFSClause() {
        return " EVICTION BY CRITERIA ( DATE(F_ARRIVE_TIME) < CURRENT_DATE - 7) EVICTION FREQUENCY 1 MINUTES HDFSSTORE (" + hdfsStoreName + ")";
    }

    public static void HydraTask_runImportTable() throws SQLException {
        seats.runImportTable();
    }

    protected void runImportTable() throws SQLException {
        Properties p = new Properties();
        p.setProperty("skip-constraint-checks", "true");
        Log.getLogWriter().info("setting skip-constraint-checks to true");
        Connection conn = this.getGFEConnection(p);
        this.runImportTable(this.getConnectionWithSchema(conn, SCHEMA_NAME, GFEDBManager.Isolation.READ_COMMITTED));
    }

    public static synchronized void HydraTask_initialize() {
        if (seats == null) {
            seats = new SeatsTest();
        }
        seats.initialize();
    }

    public static synchronized void HydraTask_createCaseInsensitiveIndexOnSystable() {
        if (seats == null) {
            seats = new SeatsTest();
        }
        seats.createCaseInsensitiveIndexOnSystable();
    }

    protected void createCaseInsensitiveIndexOnSystable() {
        ddlThread = this.getMyTid();
        Connection conn = this.getConnectionWithSchema(this.getGFEConnection(), SCHEMA_NAME, GFEDBManager.Isolation.NONE);
        this.createCaseInsensitiveIndexOnSystable(conn);
    }

    public static synchronized void HydraTask_initializeInfo() {
        if (seats == null) {
            seats = new SeatsTest();
        }
        seats.initializeInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeInfo() {
        Connection conn = this.getConnectionWithSchema(this.getGFEConnection(), SCHEMA_NAME, GFEDBManager.Isolation.NONE);
        gfxdNonTxnConn.set((Object)conn);
        try {
            int[] nArray = this.setFlightThread;
            synchronized (this.setFlightThread) {
                if (flights == null) {
                    this.setFlightThread[0] = this.getMyTid();
                    flights = this.getFlights(true, conn);
                    this.num_reservations = this.getInitNumReservations(conn);
                    customers = this.getCustomer(true, conn);
                    boolean set = false;
                    while (!set) {
                        try {
                            customersInitBalance = this.getCustomerInitBalance(conn);
                            if (customersInitBalance == null) continue;
                            set = true;
                        }
                        catch (SQLException se) {
                            if (se.getSQLState().equals("XCL54") && setCriticalHeap) {
                                this.log().info("got expected query cancellation exception, continue testing");
                                increaseCriticalHeapPercent = true;
                                continue;
                            }
                            SQLHelper.handleSQLException(se);
                        }
                    }
                    this.setCustomersMapByAP(conn);
                    this.commit(conn);
                }
                if (setCriticalHeap) {
                    this.createNewReservationTables(conn);
                }
                if (!reproduce51255 && ddlThread == this.getMyTid()) {
                    String createTable = "create table " + this.updateBalTablePrefix + this.getMyTid() + "(C_ID bigint, C_BALANCE float) " + (this.usePartitionBy ? " partition by column(c_id) " : "") + DATAGROUPCLAUSE;
                    if (!this.verifyBalanceTablesCreated) {
                        this.log().info(createTable);
                        conn.createStatement().execute(createTable);
                        this.createNewTableAvoidLeftJoin(conn);
                        this.verifyBalanceTablesCreated = true;
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        {
            return;
        }
    }

    @Override
    protected void initialize() {
        this.my_reservations.set(new ArrayList());
    }

    protected void setCustomersMapByAP(Connection conn) throws SQLException {
        String sql = "select AP_ID from AIRPORT";
        this.log().info(sql);
        ResultSet rs = conn.createStatement().executeQuery(sql);
        while (rs.next()) {
            long airport_depart_id = rs.getLong(1);
            List<Struct> customersByAP = this.getCustomersByAP(airport_depart_id, conn);
            customerByAP.put(airport_depart_id, customersByAP);
        }
    }

    public static void HydraTask_doTxns() throws SQLException {
        if (seats == null) {
            seats = new SeatsTest();
        }
        if (startDate == null) {
            seats.setStartDate();
        }
        if (setCriticalHeap) {
            boolean[] executed = (boolean[])increaseMemOpExectued.get();
            if (executed == null) {
                increaseMemOpExectued.set((Object)new boolean[1]);
            } else if (executed[0]) {
                throw new TestException("Test issue, increaseMemOpExectued is not being reset");
            }
        }
        int numOfTxnsInTask = 5;
        for (int i = 0; i < numOfTxnsInTask; ++i) {
            boolean[] executed;
            seats.doTxns(GFEDBManager.Isolation.READ_COMMITTED);
            if (!setCriticalHeap || !(executed = (boolean[])increaseMemOpExectued.get())[0]) continue;
            executed[0] = false;
            increaseMemOpExectued.set((Object)executed);
            break;
        }
    }

    protected void doTxns(GFEDBManager.Isolation isolation) {
        Connection conn = this.getConnectionWithSchema(this.getGFEConnection(), SCHEMA_NAME, isolation);
        long txId = SQLTxBB.getBB().getSharedCounters().incrementAndRead(SQLTxBB.txId);
        Log.getLogWriter().info("setting hydra thread local curTxId to " + txId);
        curTxId.set((Object)txId);
        try {
            if (reproduce50962) {
                this.executeFindFlights(conn);
            } else {
                int whichOne = 0;
                int chance = random.nextInt(100);
                if (chance < 20) {
                    whichOne = 0;
                } else if (chance < 60) {
                    whichOne = 1;
                } else if (chance < 80) {
                    whichOne = 2;
                } else if (chance < 90) {
                    whichOne = 3;
                } else {
                    whichOne = 4;
                    if (setCriticalHeap) {
                        if (reproduce43511) {
                            if (random.nextInt(100) < 10) {
                                this.performOrderByWithoutIndex(conn);
                            }
                        } else if (random.nextInt(1000) == 0 && ddlThread == this.getMyTid()) {
                            this.performOrderByWithoutIndex(conn);
                        } else if (!increaseCriticalHeapPercent) {
                            if (random.nextInt(100) < 10) {
                                this.doSelectReservation();
                                whichOne = 1;
                            } else if (random.nextInt(100) < 20) {
                                this.increaseMemOp(conn);
                                boolean[] executed = (boolean[])increaseMemOpExectued.get();
                                executed[0] = true;
                                increaseMemOpExectued.set((Object)executed);
                                return;
                            }
                        }
                    }
                }
                switch (whichOne) {
                    case 0: {
                        this.executeFindFlights(conn);
                        break;
                    }
                    case 1: {
                        LinkedList<Reservation> cache = this.CACHE_RESERVATIONS.get((Object)CacheType.PENDING_INSERTS);
                        int insertSize = cache.size();
                        if (insertSize < 1000) {
                            this.executeFindOpenSeats(conn);
                            break;
                        }
                        if (insertSize > 9000) {
                            this.executeNewReservation(conn);
                            break;
                        }
                        if (random.nextBoolean()) {
                            this.executeFindOpenSeats(conn);
                            break;
                        }
                        this.executeNewReservation(conn);
                        break;
                    }
                    case 2: {
                        LinkedList<Reservation> cache = this.CACHE_RESERVATIONS.get((Object)CacheType.PENDING_UPDATES);
                        int updateSize = cache.size();
                        if (updateSize <= 500) break;
                        this.executeUpdateReservation(conn);
                        break;
                    }
                    case 3: {
                        LinkedList<Reservation> cache = this.CACHE_RESERVATIONS.get((Object)CacheType.PENDING_DELETES);
                        int deleteSize = cache.size();
                        if (deleteSize <= 500) break;
                        this.executeDeleteReservation(conn);
                        break;
                    }
                    case 4: {
                        this.executeUpdateCustomer(conn);
                        break;
                    }
                    default: {
                        throw new TestException("Test issue, wrong txn chosen");
                    }
                }
            }
            this.commit(conn);
            this.closeGFEConnection(conn);
        }
        catch (SQLException se) {
            if (isHATest) {
                if (se.getSQLState().equals("X0Z01")) {
                    this.log().info("Got expected node failure exception during select query, continue testing");
                } else if (SQLHelper.gotTXNodeFailureException(se)) {
                    this.log().info("Got expected node failure exception during dml op using txn, continue testing");
                } else if (isOfflineTest && (se.getSQLState().equals("X0Z09") || se.getSQLState().equals("X0Z08"))) {
                    this.log().info("Got expected Offline exception, continuing test");
                } else {
                    SQLHelper.handleSQLException(se);
                }
            }
            SQLHelper.handleSQLException(se);
        }
        boolean[] getCanceled = (boolean[])SQLTest.getCanceled.get();
        if (getCanceled != null && getCanceled[0]) {
            increaseCriticalHeapPercent = true;
            this.log().info("increaseCriticalHeapPercent is set to " + increaseCriticalHeapPercent);
            getCanceled[0] = false;
            SQLTest.getCanceled.set((Object)getCanceled);
            System.gc();
            this.log().info("Garbage collector is called");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performOrderByWithoutIndex(Connection conn) throws SQLException {
        String sql = "select * from reservation r, customer c, flight f  where r.r_c_id = c.c_id and f.f_id = r.r_f_id and r.r_id < ? order by r.r_id";
        try (ResultSet rs = null;){
            PreparedStatement ps = conn.prepareStatement(sql);
            int r_id = random.nextInt(1000000);
            ps.setLong(1, r_id);
            this.log().info("executing " + sql + " with r.r_id < " + r_id);
            rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int numColumns = rsmd.getColumnCount();
            while (rs.next()) {
                for (int i = 0; i < numColumns; ++i) {
                    rs.getObject(i + 1);
                }
            }
        }
    }

    protected void createNewReservationTables(Connection conn) throws SQLException {
        String tableName = "reservation_" + this.getMyTid();
        String dropTable = "DROP TABLE IF EXISTS " + tableName;
        String createTable = "create table " + tableName + " as select * FROM reservation WITH NO DATA" + " partition by column(r_id) " + (isHATest ? " BUCKETS 17 maxpartsize 10 persistent " + REDUNDANCYCLAUSE + " " : "") + (isOffheap ? (!mixOffheapTables ? " OFFHEAP " : (random.nextBoolean() ? " OFFHEAP " : "")) : "") + (isOffheap ? PERSISTENTCLAUSE : (random.nextBoolean() ? PERSISTENTCLAUSE : "")) + DATAGROUPCLAUSE;
        String checkSystables = " select * from sys.systables where tablename = '" + tableName.toUpperCase() + "'";
        boolean tableExist = false;
        if (!tableExist) {
            this.log().info(dropTable);
            conn.createStatement().execute(dropTable);
            this.log().info(createTable);
            conn.createStatement().execute(createTable);
        }
        this.log().info(checkSystables);
        ResultSet rs = conn.createStatement().executeQuery(checkSystables);
        if (!rs.next()) {
            rs = conn.createStatement().executeQuery("select * from sys.systables");
            throw new TestException(tableName + " is created but not in the systables\n" + ResultSetHelper.listToString(ResultSetHelper.asList(rs, false)));
        }
        this.log().info(tableName + " has been created");
    }

    protected String getReservationTableName(Connection conn, String tablePrefix) throws SQLException {
        String sql = "select tablename from sys.systables where tablename like '" + tablePrefix.toUpperCase() + "%'";
        List<Struct> rsList = this.getResultSet(conn, sql);
        if (rsList != null && rsList.size() > 0) {
            return (String)rsList.get(random.nextInt(rsList.size())).get("tablename".toUpperCase());
        }
        return tablePrefix + this.getMyTid();
    }

    protected void increaseMemOp(Connection conn) throws SQLException {
        String tableName = this.getReservationTableName(conn, "reservation_");
        String truncateTable = "truncate table " + tableName;
        String deleteTable = "delete from " + tableName;
        String insertSubselect = " put into " + tableName + " select * from reservation";
        if (increaseCriticalHeapPercent && random.nextInt(100) < 10) {
            if (random.nextBoolean()) {
                this.log().info(deleteTable);
                conn.createStatement().execute(deleteTable);
            } else {
                this.log().info(truncateTable);
                conn.createStatement().execute(truncateTable);
            }
        }
        try {
            this.log().info(insertSubselect);
            conn.createStatement().execute(insertSubselect);
            conn.commit();
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z03")) {
                this.log().info("got bug #51253, continue testing");
                return;
            }
            throw se;
        }
        conn.commit();
    }

    protected void setStartDate() throws SQLException {
        Connection conn = this.getConnectionWithSchema(this.getGFEConnection(), SCHEMA_NAME, GFEDBManager.Isolation.NONE);
        String sql = "select CFP_FLIGHT_START from CONFIG_PROFILE";
        ResultSet rs = conn.createStatement().executeQuery(sql);
        if (!rs.next()) {
            throw new TestException("Does not get result for " + sql);
        }
        startDate = rs.getTimestamp(1);
        Log.getLogWriter().info("startDate is " + startDate);
    }

    public static void HydraTask_createSeatsIndex() throws SQLException {
        if (seats == null) {
            seats = new SeatsTest();
        }
        seats.createSeatsIndexes();
    }

    protected void createSeatsIndexes() {
        try {
            String sql = "create index index_airport on AIRPORT_DISTANCE (D_AP_ID0, D_DISTANCE asc)";
            this.createSeatsIndex(sql);
            sql = "create index index_customer on CUSTOMER (C_BASE_AP_ID)";
            this.createSeatsIndex(sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void createCaseInsensitiveIndexOnSystable(Connection conn) {
        try {
            String sql = "create index index_systables_insensitive on sys.systables (tablename) -- GEMFIREXD-PROPERTIES caseSensitive = false";
            this.log().info("executing " + sql);
            this.createSeatsIndex(sql);
            this.log().info("executed " + sql);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("42X62")) {
                this.log().info("got expected 'CREATE INDEX' is not allowed in the 'SYS' schema");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected void createSeatsIndex(String sql) throws SQLException {
        long start = System.currentTimeMillis();
        Log.getLogWriter().info("create index starts from " + start);
        this.createIndex(sql);
        long end = System.currentTimeMillis();
        Log.getLogWriter().info("create index finishes at " + end);
        long time = end - start;
        Log.getLogWriter().info("create index takes " + time / 1000L + " seconds");
    }

    protected void createIndex(String sql) throws SQLException {
        Connection conn = this.getConnectionWithSchema(this.getGFEConnection(), SCHEMA_NAME, GFEDBManager.Isolation.NONE);
        conn.createStatement().execute(sql);
        Log.getLogWriter().info("executed " + sql);
    }

    protected void doSelectReservation() {
        try {
            Connection conn = this.getConnectionWithSchema(this.getGFEConnection(), SCHEMA_NAME, GFEDBManager.Isolation.READ_COMMITTED);
            String sql = "select * from reservation ";
            this.log().info(sql);
            ResultSet rs = conn.createStatement().executeQuery(sql);
            List<Struct> list = ResultSetHelper.asList(rs, false);
            if (list != null) {
                list.clear();
            }
        }
        catch (SQLException se) {
            if (isOfflineTest && (se.getSQLState().equals("X0Z09") || se.getSQLState().equals("X0Z08"))) {
                this.log().info("Got expected Offline exception, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BitSet getSeatsBitSet(FlightInfo flight_id) {
        BitSet seats = this.CACHE_BOOKED_SEATS.get(flight_id);
        if (seats == null) {
            Map<FlightInfo, BitSet> map = this.CACHE_BOOKED_SEATS;
            synchronized (map) {
                seats = this.CACHE_BOOKED_SEATS.get(flight_id);
                if (seats == null) {
                    seats = new BitSet(150);
                    this.CACHE_BOOKED_SEATS.put(flight_id, seats);
                }
            }
        }
        return seats;
    }

    protected boolean isFlightFull(BitSet seats) {
        assert (FULL_FLIGHT_BITSET.size() == seats.size());
        return FULL_FLIGHT_BITSET.equals(seats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FlightInfo getRandomFlightInfo(Connection conn) {
        int sleepMs = 10000;
        try {
            if (reproduce50962) {
                List<Struct> myflight = this.getFlights(true, conn);
                Struct aStruct = myflight.get(random.nextInt(myflight.size()));
                if (myflight != null) {
                    aStruct = myflight.get(random.nextInt(myflight.size()));
                    return new FlightInfo((Long)aStruct.get("F_ID"), (Long)aStruct.get("F_AL_ID"), (Long)aStruct.get("F_DEPART_AP_ID"), (Long)aStruct.get("F_ARRIVE_AP_ID"), (Timestamp)aStruct.get("F_DEPART_TIME"));
                }
                return null;
            }
            if (flights == null) {
                if (random.nextInt(10) == 0) {
                    int[] myflight = this.setFlightThread;
                    synchronized (this.setFlightThread) {
                        if (flights == null) {
                            flights = this.getFlights(true, conn);
                            this.setFlightThread[0] = this.getMyTid();
                        }
                        // ** MonitorExit[myflight] (shouldn't be in output)
                    }
                } else {
                    Log.getLogWriter().info("sleep for " + sleepMs);
                    MasterController.sleepForMs((int)sleepMs);
                    return null;
                }
            }
            {
                List<Struct> flightInfo;
                if (random.nextInt(100) < 5 && this.setFlightThread[0] == this.getMyTid() && (flightInfo = this.getFlights(true, conn)) != null) {
                    flights = flightInfo;
                }
                if (flights != null) {
                    int size = flights.size();
                    if (size < 1) {
                        return null;
                    }
                    Struct aStruct = flights.get(random.nextInt(size));
                    return new FlightInfo((Long)aStruct.get("F_ID"), (Long)aStruct.get("F_AL_ID"), (Long)aStruct.get("F_DEPART_AP_ID"), (Long)aStruct.get("F_ARRIVE_AP_ID"), (Timestamp)aStruct.get("F_DEPART_TIME"));
                }
                return null;
            }
        }
        catch (SQLException se) {
            if (isOfflineTest && (se.getSQLState().equals("X0Z09") || se.getSQLState().equals("X0Z08"))) {
                this.log().info("Got expected Offline exception, continuing test");
            } else {
                SQLHelper.handleSQLException(se);
            }
            return null;
        }
    }

    protected List<Struct> getFlights(boolean doSelect, Connection conn) throws SQLException {
        if (!doSelect) {
            return null;
        }
        String sql = "select F_ID, F_AL_ID, F_DEPART_AP_ID, F_ARRIVE_AP_ID, F_DEPART_TIME from flight";
        if (logDML) {
            Log.getLogWriter().info(sql);
        }
        ResultSet rs = conn.createStatement().executeQuery(sql);
        return ResultSetHelper.asList(rs, false);
    }

    protected long getInitNumReservations(Connection conn) throws SQLException {
        ResultSet rs;
        String sql = "select CFP_NUM_RESERVATIONS from CONFIG_PROFILE";
        if (logDML) {
            Log.getLogWriter().info(sql);
        }
        if ((rs = conn.createStatement().executeQuery(sql)).next()) {
            return rs.getLong(1);
        }
        throw new TestException("Could not get result for " + sql);
    }

    private boolean executeFindFlights(Connection conn) throws SQLException {
        FlightInfo flight = this.getRandomFlightInfo(conn);
        while (flight == null) {
            flight = this.getRandomFlightInfo(conn);
        }
        long depart_airport_id = flight.getDepartAirportId();
        long arrive_airport_id = flight.getArriveAirportId();
        Timestamp flightDate = flight.getDepartDate(startDate);
        long range = Math.round(4.32E7);
        Timestamp start_date = new Timestamp(flightDate.getTime() - range);
        Timestamp stop_date = new Timestamp(flightDate.getTime() + range);
        long distance = -1L;
        if (random.nextInt(100) < 25) {
            distance = DISTANCES[random.nextInt(DISTANCES.length)];
        }
        new FindFlight().doTxn(conn, depart_airport_id, arrive_airport_id, start_date, stop_date, distance);
        conn.commit();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean executeFindOpenSeats(Connection conn) throws SQLException {
        FlightInfo flight = this.getRandomFlightInfo(conn);
        while (flight == null) {
            flight = this.getRandomFlightInfo(conn);
        }
        Long airport_depart_id = flight.getDepartAirportId();
        Object[][] results = new FindOpenSeats().doTxn(conn, flight.getFlightId());
        conn.commit();
        int rowCount = results.length;
        assert (rowCount <= 150) : String.format("Unexpected %d open seats returned for %s", rowCount, flight);
        if (rowCount == 0) {
            return true;
        }
        BitSet seats = this.getSeatsBitSet(flight);
        ArrayList tmp_reservations = (ArrayList)this.my_reservations.get();
        tmp_reservations.clear();
        ArrayList<CustomerId> customerList = new ArrayList<CustomerId>();
        for (Object[] row : results) {
            List<Struct> customersByAP;
            if (row == null || random.nextInt(100) > 3) continue;
            Integer seatnum = (Integer)row[1];
            Double price = (Double)row[2];
            if (logDML) {
                this.log().info("Looking for a random customer to fly on " + flight);
            }
            List<Struct> list = customersByAP = random.nextInt(100) == 1 ? this.getCustomersByAP(airport_depart_id, conn) : customerByAP.get(airport_depart_id);
            while (customersByAP == null) {
                customersByAP = this.getCustomersByAP(airport_depart_id, conn);
            }
            CustomerId customer_id = this.getRandomCustomerId(customersByAP);
            int tries = 150;
            while (tries-- > 0 && (customer_id == null || customerList.contains(customer_id))) {
                customer_id = this.getRandomCustomerId(conn);
                if (!logDML) continue;
                this.log().info("RANDOM CUSTOMER: " + customer_id);
            }
            assert (customer_id != null) : String.format("Failed to find a unique Customer to reserve for seat #%d on %s", seatnum, flight);
            customerList.add(customer_id);
            Reservation r = new Reservation(this.getNextReservationId(this.getMyTid()), flight, customer_id, seatnum, price);
            seats.set(seatnum);
            tmp_reservations.add(r);
            if (!logDML) continue;
            this.log().info("QUEUED INSERT: " + r);
        }
        if (tmp_reservations.isEmpty()) return true;
        Collections.shuffle(tmp_reservations);
        String string = INSERT;
        synchronized (INSERT) {
            LinkedList<Reservation> cache = this.CACHE_RESERVATIONS.get((Object)CacheType.PENDING_INSERTS);
            for (int i = 0; i < tmp_reservations.size(); ++i) {
                if (i == 0) {
                    cache.addFirst((Reservation)tmp_reservations.get(i));
                    continue;
                }
                if (i == 1) {
                    cache.addLast((Reservation)tmp_reservations.get(i));
                    continue;
                }
                cache.add(cache.size() / i, (Reservation)tmp_reservations.get(i));
            }
            while (cache.size() > 10000) {
                cache.remove();
            }
            if (!logDML) return true;
            this.log().info(String.format("Stored %d pending inserts for %s [totalPendingInserts=%d]", tmp_reservations.size(), flight, cache.size()));
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return true;
        }
    }

    public long getNextReservationId(int id) {
        return (long)id | this.num_reservations++ << 48;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CustomerId getRandomCustomerId(Connection c) {
        Connection conn = useNonTxnConn ? (Connection)gfxdNonTxnConn.get() : c;
        int sleepMs = 10000;
        try {
            if (customers == null) {
                if (random.nextInt(10) == 0) {
                    boolean[] blArray = customerSet;
                    synchronized (customerSet) {
                        if (customers == null) {
                            customers = this.getCustomer(true, conn);
                        }
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                    }
                } else {
                    Log.getLogWriter().info("sleep for " + sleepMs);
                    MasterController.sleepForMs((int)sleepMs);
                    return null;
                }
            }
            {
                List<Struct> custInfo;
                if (random.nextInt(1000) == 0 && this.setFlightThread[0] == this.getMyTid() && !verifyBalance && (custInfo = this.getCustomer(true, conn)) != null) {
                    customers = custInfo;
                }
                if (customers != null) {
                    int size = customers.size();
                    if (size < 1) {
                        return null;
                    }
                    Struct aStruct = customers.get(random.nextInt(size));
                    return new CustomerId((Long)aStruct.get("C_ID"), (Long)aStruct.get("C_BASE_AP_ID"));
                }
                return null;
            }
        }
        catch (SQLException se) {
            if (isOfflineTest && (se.getSQLState().equals("X0Z09") || se.getSQLState().equals("X0Z08"))) {
                this.log().info("Got expected Offline exception, continuing test");
            } else {
                SQLHelper.handleSQLException(se);
            }
            return null;
        }
    }

    protected List<Struct> getCustomer(boolean doSelect, Connection conn) throws SQLException {
        if (!doSelect) {
            return null;
        }
        String sql = "select C_ID, C_BASE_AP_ID, C_BALANCE from customer";
        if (logDML) {
            Log.getLogWriter().info(sql);
        }
        ResultSet rs = conn.createStatement().executeQuery(sql);
        return ResultSetHelper.asList(rs, false);
    }

    protected List<Struct> getCustomerInitBalance(Connection conn) throws SQLException {
        boolean[] getCanceled;
        ResultSet rs;
        String sql = "select C_ID, C_BALANCE from customer order by c_id";
        if (logDML) {
            Log.getLogWriter().info(sql);
        }
        if ((rs = conn.createStatement().executeQuery(sql)) == null && setCriticalHeap && (getCanceled = (boolean[])SQLTest.getCanceled.get())[0]) {
            if (ddlThread != -1) {
                this.increaseCriticalHeapPercentage();
            } else {
                MasterController.sleepForMs((int)10000);
            }
            getCanceled[0] = false;
            SQLTest.getCanceled.set((Object)getCanceled);
            return null;
        }
        return ResultSetHelper.asList(rs, false);
    }

    protected CustomerId getRandomCustomerId(List<Struct> list) throws SQLException {
        if (list != null && list.size() > 0) {
            Struct aStruct = list.get(random.nextInt(list.size()));
            return new CustomerId((Long)aStruct.get("C_ID"), (Long)aStruct.get("C_BASE_AP_ID"));
        }
        return null;
    }

    protected List<Struct> getCustomersByAP(long airport_depart_id, Connection c) throws SQLException {
        Connection conn = useNonTxnConn ? (Connection)gfxdNonTxnConn.get() : c;
        String sql = "select C_ID, C_BASE_AP_ID from customer where C_BASE_AP_ID = " + airport_depart_id;
        if (logDML) {
            Log.getLogWriter().info(sql);
        }
        ResultSet rs = conn.createStatement().executeQuery(sql);
        List<Struct> list = ResultSetHelper.asList(rs, false);
        return list;
    }

    protected boolean checkCustomer(GFEDBManager.Isolation isolation, long flight_id, long customer_id) throws SQLException {
        Connection conn = this.getConnectionWithSchema(this.getGFEConnection(), SCHEMA_NAME, isolation);
        String sql = "select R_C_ID from RESERVATION where R_F_ID = " + flight_id + " and R_C_ID = " + customer_id;
        ResultSet rs = conn.createStatement().executeQuery(sql);
        if (!rs.next()) {
            return false;
        }
        if (rs.next()) {
            throw new TestException("A customer( " + customer_id + ") reservered more than once on the the same flight " + flight_id);
        }
        return true;
    }

    private boolean executeNewReservation(Connection conn) throws SQLException {
        boolean success = false;
        try {
            success = this.makeNewReservation(conn);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z02")) {
                this.log().info("Get expected conflict exception, continue testing");
            }
            if (se.getSQLState().equals("23505")) {
                this.log().info("Get expected duplicate key exception, continue testing");
            }
            throw se;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean makeNewReservation(Connection conn) throws SQLException {
        Reservation reservation = null;
        BitSet seats = null;
        boolean success = false;
        while (reservation == null) {
            Reservation r = null;
            String string = INSERT;
            // MONITORENTER : "insert"
            LinkedList<Reservation> cache = this.CACHE_RESERVATIONS.get((Object)CacheType.PENDING_INSERTS);
            if (cache == null) {
                throw new TestException("Unexpected " + (Object)((Object)CacheType.PENDING_INSERTS));
            }
            if (logDML) {
                this.log().info(String.format("Attempting to get a new pending insert Reservation [totalPendingInserts=%d]", cache.size()));
            }
            r = cache.poll();
            // MONITOREXIT : string
            if (r == null) {
                if (!logDML) break;
                this.log().warning("Unable to execute NewReservation - No available reservations to insert");
                break;
            }
            seats = this.getSeatsBitSet(r.flightInfo);
            if (this.isFlightFull(seats)) {
                if (!logDML) continue;
                this.log().info(String.format("%s is full", r.flightInfo));
                continue;
            }
            if (this.isCustomerBookedOnFlight(r.customer_id, r.flightInfo)) {
                if (!logDML) continue;
                this.log().info(String.format("%s is already booked on %s", r.customer_id, r.flightInfo));
                continue;
            }
            reservation = r;
        }
        if (reservation == null) {
            if (!logDML) return false;
            this.log().warning("Failed to find a valid pending insert Reservation\n" + this.toString());
            return false;
        }
        double price = reservation.price;
        long[] attributes = new long[9];
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i] = random.nextLong();
        }
        if (logDML) {
            this.log().info("Calling NewResveraton");
        }
        boolean retry = true;
        int retryNum = 0;
        int maxRetries = 3;
        while (retry && retryNum < maxRetries) {
            try {
                success = new NewReservation().doTxn(conn, reservation.id, reservation.customer_id.id, reservation.flightInfo.flight_id, reservation.seatnum, price, attributes);
                retry = false;
                ++retryNum;
            }
            catch (SQLException se) {
                if (!se.getSQLState().equals("X0Z02")) throw se;
                this.log().info("update on flight could get conflict exception, will retry");
                retry = true;
            }
        }
        if (!success) {
            conn.rollback();
            return success;
        }
        conn.commit();
        seats.set(reservation.seatnum);
        this.requeueReservation(reservation);
        return success;
    }

    protected boolean isCustomerBookedOnFlight(CustomerId customer_id, FlightInfo flight_id) {
        Set<FlightInfo> flights = this.CACHE_CUSTOMER_BOOKED_FLIGHTS.get(customer_id);
        return flights != null && flights.contains(flight_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requeueReservation(Reservation r) {
        CacheType ctype = null;
        ctype = random.nextBoolean() ? CacheType.PENDING_DELETES : CacheType.PENDING_UPDATES;
        assert (ctype != null);
        if (ctype == CacheType.PENDING_DELETES) {
            String string = DELETE;
            synchronized (DELETE) {
                this.addToQueue(ctype, r);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        String string = UPDATE;
        synchronized (UPDATE) {
            this.addToQueue(ctype, r);
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    private void addToQueue(CacheType ctype, Reservation r) {
        LinkedList<Reservation> cache = this.CACHE_RESERVATIONS.get((Object)ctype);
        if (cache == null) {
            throw new TestException("Unexpected " + (Object)((Object)ctype));
        }
        cache.add(r);
        if (logDML) {
            this.log().info(String.format("Queued %s for %s [cache=%d]", new Object[]{r, ctype, cache.size()}));
        }
        while (cache.size() > ctype.limit) {
            cache.remove();
        }
    }

    private boolean executeUpdateReservation(Connection conn) throws SQLException {
        boolean success = false;
        try {
            success = this.updateReservation(conn);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("23505")) {
                this.log().info("Get expected duplicate key exception, continue testing");
            }
            if (se.getSQLState().equals("X0Z02")) {
                this.log().info("Get expected conflict exception, continue testing");
            }
            throw se;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateReservation(Connection conn) throws SQLException {
        if (logDML) {
            this.log().info("Let's look for a Reservation that we can update");
        }
        Reservation r = null;
        String string = UPDATE;
        synchronized (UPDATE) {
            LinkedList<Reservation> cache = this.CACHE_RESERVATIONS.get((Object)CacheType.PENDING_UPDATES);
            if (cache == null) {
                throw new TestException("Unexpected " + (Object)((Object)CacheType.PENDING_UPDATES));
            }
            r = cache.poll();
            if (r == null) {
                if (logDML) {
                    this.log().info(String.format("Failed to find Reservation to update [cache=%d]", cache.size()));
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (logDML) {
                this.log().info("Ok let's try to update " + r);
            }
            long value = random.nextInt(0x100000);
            long attribute_idx = random.nextInt(4);
            int newseatnum = random.nextInt(150);
            if (logDML) {
                this.log().info("Calling UpdateReservation");
            }
            new UpdateReservation().doTxn(conn, r.id, r.flightInfo.getFlightId(), r.customer_id.getId(), r.seatnum, newseatnum, attribute_idx, value);
            conn.commit();
            r.setSeatnum(newseatnum);
            this.requeueReservation(r);
            return true;
        }
    }

    private boolean executeDeleteReservation(Connection conn) throws SQLException {
        boolean success = false;
        try {
            success = this.deleteReservation(conn);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z02")) {
                this.log().info("Get expected conflict exception, continue testing");
            }
            throw se;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean deleteReservation(Connection conn) throws SQLException {
        if (logDML) {
            this.log().info("Let's look for a Reservation that we can delete");
        }
        Reservation r = null;
        String string = DELETE;
        synchronized (DELETE) {
            boolean success;
            LinkedList<Reservation> cache = this.CACHE_RESERVATIONS.get((Object)CacheType.PENDING_DELETES);
            if (cache == null) {
                throw new TestException("Unexpected " + (Object)((Object)CacheType.PENDING_DELETES));
            }
            r = cache.poll();
            if (r == null) {
                if (!logDML) return false;
                this.log().info(String.format("Failed to find Reservation to delete [cache=%d]", cache.size()));
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (logDML) {
                this.log().info("Ok let's try to delete " + r);
            }
            int rand = random.nextInt(100);
            long f_id = r.flightInfo.getFlightId();
            Long c_id = null;
            String c_id_str = null;
            String ff_c_id_str = null;
            Long ff_al_id = null;
            long r_seatnum = r.seatnum;
            if (rand < 20) {
                c_id_str = Long.toString(r.customer_id.getId());
            } else if (rand < 40) {
                ff_c_id_str = Long.toString(r.customer_id.getId());
                ff_al_id = r.flightInfo.getAlId();
            } else {
                c_id = r.customer_id.getId();
            }
            if (logDML) {
                this.log().info("Calling deleteReservation txn");
            }
            if (!(success = new DeleteReservation().doTxn(conn, f_id, c_id, c_id_str, ff_c_id_str, ff_al_id, r_seatnum))) {
                conn.rollback();
                this.log().info("rollback the connection");
                return false;
            }
            conn.commit();
            BitSet seats = this.getSeatsBitSet(r.flightInfo);
            seats.set(r.seatnum, false);
            if (random.nextInt(100) >= 50) return true;
            String string2 = INSERT;
            synchronized (INSERT) {
                this.CACHE_RESERVATIONS.get((Object)CacheType.PENDING_INSERTS).add(r);
                // ** MonitorExit[var14_15] (shouldn't be in output)
                return true;
            }
        }
    }

    private boolean executeUpdateCustomer(Connection conn) throws SQLException {
        boolean success = false;
        try {
            success = this.updateCustomer(conn);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z02")) {
                this.log().info("Get expected conflict exception, continue testing");
            }
            throw se;
        }
        return success;
    }

    private boolean updateCustomer(Connection conn) throws SQLException {
        CustomerId customer_id = this.getRandomCustomerId(conn);
        Long c_id = null;
        String c_id_str = null;
        long attr0 = random.nextLong();
        long attr1 = random.nextLong();
        long update_ff = random.nextInt(100) < 25 ? 1 : 0;
        if (random.nextInt(100) < 20) {
            c_id_str = Long.toString(customer_id.getId());
        } else {
            c_id = customer_id.getId();
        }
        if (logDML) {
            this.log().info("Calling updateCustomer ");
        }
        new UpdateCustomer().doTxn(conn, c_id, c_id_str, update_ff, attr0, attr1);
        conn.commit();
        return true;
    }

    public static void HydraTask_addTxIdCol() {
        if (seats == null) {
            seats = new SeatsTest();
        }
        seats.addTxIdCol();
    }

    protected void addTxIdCol() {
        if (!addTxId) {
            return;
        }
        Connection conn = this.getConnectionWithSchema(this.getGFEConnection(), SCHEMA_NAME, GFEDBManager.Isolation.NONE);
        ArrayList<String[]> tables = this.getTableNames(conn);
        for (String[] table : tables) {
            if (table[1].equals("AIRPORT") || table[1].contains("PRICE")) continue;
            this.alterTableAddTxId(conn, table[0] + "." + table[1]);
        }
    }

    public static void HydraTask_verifyBalance() {
        if (seats == null) {
            seats = new SeatsTest();
        }
        seats.verifyBalance();
    }

    protected void verifyBalance() {
        Connection conn = this.getConnectionWithSchema(this.getGFEConnection(), SCHEMA_NAME, GFEDBManager.Isolation.NONE);
        List<Struct> calJoinBalance = null;
        List<Struct> calLeftJoinBalance = null;
        String tableName = null;
        int newheap = 95;
        if (setCriticalHeap) {
            this.setCriticalHeapPercentage(conn, newheap, dataGroup);
            MasterController.sleepForMs((int)60000);
        }
        List<Struct> priceList = null;
        String sql = null;
        try {
            sql = "select R_C_ID, sum(R_PRICE) as price from reservation " + (reproduce51113 ? "" : " where txid > 0 ") + " group by R_C_ID";
            if (logDML) {
                Log.getLogWriter().info(sql);
            }
            ResultSet rs = conn.createStatement().executeQuery(sql);
            priceList = ResultSetHelper.asList(rs, false);
            rs.close();
            String createTempTable = "DECLARE GLOBAL TEMPORARY TABLE " + this.updateBalTablePrefix + this.getMyTid() + "(R_C_ID bigint, PRICE float) NOT LOGGED";
            String createTable = "create table " + this.updateBalTablePrefix + this.getMyTid() + "(C_ID bigint, C_BALANCE float) " + (this.usePartitionBy ? " partition by column(c_id) " : "") + DATAGROUPCLAUSE;
            if (this.useTempTable) {
                this.log().info(createTempTable);
                conn.createStatement().execute(createTempTable);
                tableName = this.tempTablePrefix + this.updateBalTablePrefix + this.getMyTid();
            } else {
                if (!this.verifyBalanceTablesCreated && reproduce51255) {
                    this.log().info(createTable);
                    conn.createStatement().execute(createTable);
                }
                tableName = this.updateBalTablePrefix + this.getMyTid();
                if (!this.verifyBalanceTablesCreated && !reproduce51090) {
                    String createIndex = "create index index_" + tableName + " on " + tableName + "(c_id)";
                    this.log().info(createIndex);
                    conn.createStatement().execute(createIndex);
                }
            }
            conn.commit();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        try {
            if (priceList == null) {
                throw new TestException("priceList should not be null by now");
            }
            this.log().info("inserting into " + tableName + " with results of " + sql);
            this.insertBalIntoNewTable(conn, tableName, priceList, "R_C_ID", "PRICE");
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("XCL54") && reproduce51255) {
                throw new TestException("got ticket #51255 unexpected low memory exception: " + TestHelper.getStackTrace((Throwable)se));
            }
            SQLHelper.handleSQLException(se);
        }
        boolean useOrderBy = true;
        String orderByClause = " order by c.c_id";
        String join = "select c.C_ID, c.C_BALANCE - nvl(r.c_balance, 0) as C_BALANCE from customer as c join " + tableName + " as r" + " on c.c_ID = r.C_ID " + (useOrderBy ? orderByClause : "");
        String leftjoin = "select c.C_ID, c.C_BALANCE - nvl(r.c_balance, 0) as C_BALANCE from customer as c left outer join " + tableName + " as r" + " on c.c_ID = r.C_ID " + (useOrderBy ? orderByClause : "");
        try {
            this.log().info("executing join query " + join);
            calJoinBalance = this.getQueryResultSet(conn, join);
            this.log().info("join results size is " + calJoinBalance.size());
            this.log().info("executing join query " + leftjoin);
            calLeftJoinBalance = this.getQueryResultSet(conn, leftjoin);
            this.log().info("join results size is " + calLeftJoinBalance.size());
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        if (useOrderBy) {
            try {
                if (reproduce51255 && !this.verifyBalanceTablesCreated) {
                    this.createNewTableAvoidLeftJoin(conn);
                }
                this.verifyBalanceTablesCreated = true;
                String initBalTableName = this.initBalTablePrefix + this.getMyTid();
                this.insertBalIntoNewTable(conn, initBalTableName, customersInitBalance, "C_ID", "C_BALANCE");
                this.removeNotUpdatedCustomerBal(conn);
                ResultSet newInitRs = this.getNewInitCustBal(conn);
                List<Struct> newInitCustBal = ResultSetHelper.asList(newInitRs, false);
                if (reproduce51113) {
                    return;
                }
                if (calJoinBalance != null) {
                    ResultSetHelper.compareSortedResultSets(newInitCustBal, calJoinBalance, "UpdatedInitialCustomersBalance", "CalculatedCustomerBalance");
                }
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
        if (useOrderBy && calLeftJoinBalance != null) {
            ResultSetHelper.compareSortedResultSets(customersInitBalance, calLeftJoinBalance, "InitialCustomersBalance", "CalculatedLeftJoinCustomerBalance");
        }
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    private void removeNotUpdatedCustomerBal(Connection conn) throws SQLException {
        String tableName = (this.useTempTable ? this.tempTablePrefix : "") + this.updateBalTablePrefix + this.getMyTid();
        String delete = "delete from " + this.initBalTablePrefix + this.getMyTid() + " as i where not exists (select * from " + tableName + " as u where u.c_id = i.c_ID )";
        this.log().info(delete);
        conn.createStatement().execute(delete);
        conn.commit();
    }

    private ResultSet getNewInitCustBal(Connection conn) throws SQLException {
        String tableName = this.initBalTablePrefix + this.getMyTid();
        String sql = "select * from " + tableName + " order by c_id";
        this.log().info(sql);
        return conn.createStatement().executeQuery(sql);
    }

    private void insertBalIntoNewTable(Connection conn, String tableName, List<Struct> priceList, String fieldName1, String fieldName2) throws SQLException {
        String insertUsingBatching = "insert into " + tableName + " values(?, ?)";
        this.log().info(insertUsingBatching);
        PreparedStatement stmt = conn.prepareStatement(insertUsingBatching);
        int[] counts = null;
        int size = priceList.size();
        this.log().info("inserting total size of " + size);
        for (int i = 0; i < size; ++i) {
            try {
                stmt.setObject(1, priceList.get(i).get(fieldName1));
                stmt.setObject(2, priceList.get(i).get(fieldName2));
                stmt.addBatch();
                Log.getLogWriter().info("batch insert into " + tableName + " with " + fieldName1 + ":" + priceList.get(i).get(fieldName1) + "," + fieldName2 + ":" + priceList.get(i).get(fieldName2));
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            if (!isEdge || i % 65534 != 0) continue;
            this.log().info("executing batch statement");
            counts = stmt.executeBatch();
            conn.commit();
        }
        try {
            this.log().info("executing last batch statement to finish insert");
            counts = stmt.executeBatch();
            conn.commit();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    private void createNewTableAvoidLeftJoin(Connection conn) {
        try {
            String createTable = "create table " + this.initBalTablePrefix + this.getMyTid() + "(C_ID bigint, C_BALANCE float) partition by column (c_id) " + (this.usePartitionBy ? " colocate with (" + this.updateBalTablePrefix + this.getMyTid() + ")" : "") + DATAGROUPCLAUSE;
            if (!this.verifyBalanceTablesCreated) {
                this.log().info(createTable);
                conn.createStatement().execute(createTable);
            }
            String tableName = this.initBalTablePrefix + this.getMyTid();
            conn.commit();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    private List<Struct> getQueryResultSet(Connection conn, String sql) throws SQLException {
        List<Struct> list = null;
        long start = System.currentTimeMillis();
        Log.getLogWriter().info("query starts from " + start);
        ResultSet rs = conn.createStatement().executeQuery(sql);
        long selectDone = System.currentTimeMillis();
        Log.getLogWriter().info("query result available at " + selectDone);
        long selectTime = selectDone - start;
        long seconds = selectTime / 1000L;
        long minutes = seconds / 60L;
        Log.getLogWriter().info("select takes " + (minutes > 0L ? minutes + " minutes" : seconds + " seconds"));
        list = ResultSetHelper.asList(rs, false);
        long end = System.currentTimeMillis();
        Log.getLogWriter().info("process query finishes at " + end);
        long queryProcessTime = end - selectDone;
        seconds = queryProcessTime / 1000L;
        minutes = seconds / 60L;
        Log.getLogWriter().info("process select query results takes " + (minutes > 0L ? minutes + " minutes" : seconds + " seconds"));
        return list;
    }

    public static void HydraTask_setHeapPercentage() {
        if (useHeapPercentage) {
            seats.setHeapPercentage();
        } else {
            Log.getLogWriter().info("eviction heap percentage is not set");
        }
    }

    @Override
    protected void setHeapPercentage() {
        this.setHeapPercentage(initEvictionHeapPercentage);
    }

    protected double getEvictionHeapPercentage() {
        double heapPercent;
        block4: {
            heapPercent = 0.0;
            Connection gConn = this.getConnectionWithSchema(this.getGFEConnection(), SCHEMA_NAME, GFEDBManager.Isolation.NONE);
            try {
                String sql = "select distinct sys.get_eviction_heap_percentage() from sys.members where servergroups = '" + dataGroup.toUpperCase() + "'";
                ResultSet rs = gConn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    heapPercent = rs.getDouble(1);
                    if (rs.next()) {
                        sql = "select sys.get_eviction_heap_percentage(), id, servergroups from sys.members ";
                        rs = gConn.createStatement().executeQuery(sql);
                        throw new TestException("more than 1 heap percentage is set in the same server group: " + sql + "\n" + ResultSetHelper.listToString(ResultSetHelper.asList(rs, false)));
                    }
                    break block4;
                }
                throw new TestException("test issue, heap eviction is not set in the test");
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
        return heapPercent;
    }

    protected double getCriticalHeapPercentage() {
        Connection gConn = this.getConnectionWithSchema(this.getGFEConnection(), SCHEMA_NAME, GFEDBManager.Isolation.NONE);
        String sql = "select distinct sys.get_critical_heap_percentage() as criticalHeapPercentage from sys.members where servergroups = '" + dataGroup.toUpperCase() + "'";
        this.log().info(sql);
        return this.getCriticalHeapPercentage(gConn, sql, dataGroup.toUpperCase());
    }

    protected double getCriticalOffHeapPercentage() {
        Connection gConn = this.getConnectionWithSchema(this.getGFEConnection(), SCHEMA_NAME, GFEDBManager.Isolation.NONE);
        String sql = "select distinct sys.get_critical_offheap_percentage() as criticalOffHeapPercentage from sys.members where servergroups = '" + dataGroup.toUpperCase() + "'";
        this.log().info(sql);
        return this.getCriticalHeapPercentage(gConn, sql, dataGroup.toUpperCase());
    }

    public static void HydraTask_setCriticalHeapPercentage() {
        seats.setCriticalHeapPercentage();
    }

    @Override
    protected void setCriticalHeapPercentage() {
        if (!setCriticalHeap) {
            Log.getLogWriter().info("No critical heap is set");
            return;
        }
        ddlThread = this.getMyTid();
        Connection gConn = this.getConnectionWithSchema(this.getGFEConnection(), SCHEMA_NAME, GFEDBManager.Isolation.NONE);
        double heapPercent = this.getEvictionHeapPercentage();
        criticalHeapPercentage = heapPercent + 10.0;
        this.setCriticalHeapPercentage(gConn, criticalHeapPercentage, dataGroup);
    }

    public static void HydraTask_increaseCriticalHeapPercentage() {
        seats.increaseCriticalHeapPercentage();
    }

    protected void increaseCriticalHeapPercentage() {
        if (!setCriticalHeap) {
            Log.getLogWriter().info("No critical heap is set");
            return;
        }
        Connection gConn = this.getConnectionWithSchema(this.getGFEConnection(), SCHEMA_NAME, GFEDBManager.Isolation.NONE);
        double heapPercent = this.getCriticalHeapPercentage();
        this.increaseCriticalHeapPercentage(gConn, heapPercent, dataGroup);
    }

    public static void HydraTask_addInitialData() throws SQLException {
        if (isHATest && setCriticalHeap) {
            try {
                seats.addInitialData();
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("XCL54") && setCriticalHeap) {
                    Log.getLogWriter().info("got expected query cancellation exception, continue testing");
                    increaseCriticalHeapPercent = true;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected void addInitialData() throws SQLException {
        String tableName = "reservation_" + this.getMyTid();
        String sql = "put into " + tableName + " select * from reservation where r_id < 200 ";
        this.log().info(sql);
        Connection conn = this.getConnectionWithSchema(this.getGFEConnection(), SCHEMA_NAME, GFEDBManager.Isolation.READ_COMMITTED);
        conn.createStatement().execute(sql);
        conn.commit();
    }

    public static synchronized void HydraTask_initEdges() {
        isEdge = true;
    }

    static {
        dataGroup = "DataGroup";
        DATAGROUPCLAUSE = random.nextBoolean() ? " SERVER GROUPS (" + dataGroup + ") " : " SERVER GROUPS (" + dataGroup.toUpperCase() + ") ";
        flightSet = new boolean[1];
        customerSet = new boolean[1];
        customerByAP = new HashMap<Long, List<Struct>>();
        DISTANCES = new int[]{20, 50, 100};
        gfxdNonTxnConn = new HydraThreadLocal();
        curTxId = new HydraThreadLocal();
        useNonTxnConn = false;
        addTxId = true;
        verifyBalance = true;
        reproduce50962 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50962, false);
        reproduce51113 = TestConfig.tab().booleanAt(SQLPrms.toReproduce51113, false);
        reproduce51090 = TestConfig.tab().booleanAt(SQLPrms.toReproduce51090, false);
        reproduce43511 = TestConfig.tab().booleanAt(SQLPrms.toReproduce43511, false);
        reproduce51255 = TestConfig.tab().booleanAt(SQLPrms.toReproduce51255, true);
        increaseMemOpExectued = new HydraThreadLocal();
        FULL_FLIGHT_BITSET = new BitSet(150);
        for (int i = 0; i < 150; ++i) {
            FULL_FLIGHT_BITSET.set(i);
        }
    }

    protected static class Reservation {
        public final long id;
        public final FlightInfo flightInfo;
        public final CustomerId customer_id;
        public int seatnum;
        public final Double price;

        public Reservation(long id, FlightInfo flightInfo, CustomerId customer_id, int seatnum, double price) {
            this.id = id;
            this.flightInfo = flightInfo;
            this.customer_id = customer_id;
            this.seatnum = seatnum;
            this.price = price;
            assert (this.seatnum >= 0) : "Invalid seat number\n" + this;
            assert (this.seatnum < 150) : "Invalid seat number\n" + this;
        }

        public void setSeatnum(int seat) {
            this.seatnum = seat;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Reservation) {
                Reservation r = (Reservation)obj;
                return this.seatnum == r.seatnum && this.flightInfo.equals(r.flightInfo) && this.customer_id.equals(r.customer_id) && this.price == r.price;
            }
            return false;
        }

        public String toString() {
            return String.format("{Id:%d / %s / %s / SeatNum:%d}", this.id, this.flightInfo, this.customer_id, this.seatnum);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (int)this.id;
            result = 37 * result + this.seatnum;
            result = 37 * result + new Double(this.price).hashCode();
            result = 37 * result + (int)(this.flightInfo.flight_id ^ this.flightInfo.flight_id >>> 32);
            result = 37 * result + (int)(this.customer_id.id ^ this.customer_id.id >>> 32);
            return result;
        }
    }

    class CustomerId {
        private long id;
        private long depart_airport_id;

        public CustomerId(long id, long depart_airport_id) {
            this.id = id;
            this.depart_airport_id = depart_airport_id;
        }

        public long[] toArray() {
            return new long[]{this.id, this.depart_airport_id};
        }

        public long getId() {
            return this.id;
        }

        public long getDepartAirportId() {
            return this.depart_airport_id;
        }

        public String toString() {
            return String.format("CustomerId{airport=%d,id=%d}", this.depart_airport_id, this.id);
        }

        public boolean equals(Object obj) {
            if (obj instanceof CustomerId) {
                CustomerId c = (CustomerId)obj;
                return this.depart_airport_id == c.depart_airport_id && this.id == c.id;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (int)this.id;
            result = 37 * result + (int)this.depart_airport_id;
            return result;
        }
    }

    class FlightInfo {
        long flight_id;
        long airline_id;
        long depart_airport_id;
        long arrive_airport_id;
        Timestamp departDate;

        FlightInfo(long flight_id, long airline_id, long depart_airport_id, long arrive_airport_id, Timestamp departDate) {
            this.flight_id = flight_id;
            this.airline_id = airline_id;
            this.depart_airport_id = depart_airport_id;
            this.arrive_airport_id = arrive_airport_id;
            this.departDate = departDate;
        }

        protected long getFlightId() {
            return this.flight_id;
        }

        protected long getAlId() {
            return this.airline_id;
        }

        protected long getDepartAirportId() {
            return this.depart_airport_id;
        }

        protected long getArriveAirportId() {
            return this.arrive_airport_id;
        }

        protected int calDepartTime(Timestamp startDate) {
            return (int)((this.departDate.getTime() - startDate.getTime()) / 3600000L);
        }

        public Timestamp getDepartDate(Timestamp start) {
            return new Timestamp(start.getTime() + (long)this.calDepartTime(start) * 60000L * 60L);
        }

        public boolean equals(Object obj) {
            if (obj instanceof FlightInfo) {
                FlightInfo o = (FlightInfo)obj;
                return this.flight_id == o.flight_id;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (int)(this.flight_id ^ this.flight_id >>> 32);
            return result;
        }

        public String toString() {
            return String.format("FlightInfo{flight_id=%d,airline_id=%d,depart_airport_id=%d,arrive_airport_id=%d,departDate%1$TD %1$TT}", this.flight_id, this.airline_id, this.depart_airport_id, this.arrive_airport_id, this.departDate);
        }
    }

    public static enum CacheType {
        PENDING_INSERTS(10000),
        PENDING_UPDATES(5000),
        PENDING_DELETES(5000);

        private final int limit;

        private CacheType(int limit) {
            this.limit = limit;
        }

        public int getLimit() {
            return this.limit;
        }
    }
}

