/*
 * Decompiled with CFR 0.152.
 */
package sql.schemas.seats;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import sql.schemas.Transactions;
import sql.schemas.seats.SeatsTest;
import sql.sqlutil.SQLStmt;
import util.TestException;

public class UpdateCustomer
extends Transactions {
    public final SQLStmt GetCustomerIdStr = new SQLStmt("SELECT C_ID   FROM CUSTOMER  WHERE C_ID_STR = ? ", new int[0]);
    public final SQLStmt GetCustomer = new SQLStmt("SELECT *   FROM CUSTOMER  WHERE C_ID = ? ", new int[0]);
    public final SQLStmt GetBaseAirport = new SQLStmt("SELECT *   FROM AIRPORT, COUNTRY  WHERE AP_ID = ? AND AP_CO_ID = CO_ID ", new int[0]);
    public final SQLStmt UpdateCustomer = new SQLStmt("UPDATE CUSTOMER    SET C_IATTR00 = ?,        C_IATTR01 = ? " + (SeatsTest.addTxId ? ", TXID = " + SeatsTest.curTxId.get() : "") + " WHERE C_ID = ?", new int[0]);
    public final SQLStmt GetFrequentFlyers = new SQLStmt("SELECT * FROM FREQUENT_FLYER  WHERE FF_C_ID = ?", new int[0]);
    public final SQLStmt UpdatFrequentFlyers = new SQLStmt("UPDATE FREQUENT_FLYER    SET FF_IATTR00 = ?,        FF_IATTR01 = ? " + (SeatsTest.addTxId ? ", TXID = " + SeatsTest.curTxId.get() : "") + " WHERE FF_C_ID = ? " + "   AND FF_AL_ID = ? ", new int[0]);

    public void doTxn(Connection conn, Long c_id, String c_id_str, Long update_ff, long attr0, long attr1) throws SQLException {
        int updated;
        ResultSet rs;
        if (c_id == null) {
            assert (c_id_str != null);
            assert (!c_id_str.isEmpty());
            rs = this.getPreparedStatement(conn, this.GetCustomerIdStr, c_id_str).executeQuery();
            if (!rs.next()) {
                rs.close();
                throw new TestException(String.format("No Customer information record found for string '%s'", c_id_str));
            }
            c_id = rs.getLong(1);
            rs.close();
        }
        assert (c_id != null);
        rs = this.getPreparedStatement(conn, this.GetCustomer, c_id).executeQuery();
        if (!rs.next()) {
            rs.close();
            throw new TestException(String.format("No Customer information record found for id '%d'", c_id));
        }
        assert (c_id.longValue() == rs.getLong(1));
        long base_airport = rs.getLong(3);
        rs.close();
        ResultSet airport_results = this.getPreparedStatement(conn, this.GetBaseAirport, base_airport).executeQuery();
        boolean adv = airport_results.next();
        airport_results.close();
        assert (adv);
        if (update_ff != null) {
            ResultSet ff_results = this.getPreparedStatement(conn, this.GetFrequentFlyers, c_id).executeQuery();
            while (ff_results.next()) {
                long ff_al_id = ff_results.getLong(2);
                this.getPreparedStatement(conn, this.UpdatFrequentFlyers, attr0, attr1, c_id, ff_al_id).executeUpdate();
            }
            ff_results.close();
        }
        if ((updated = this.getPreparedStatement(conn, this.UpdateCustomer, attr0, attr1, c_id).executeUpdate()) != 1) {
            String msg = String.format("Failed to update customer #%d - Updated %d records", c_id, updated);
            throw new TestException(msg);
        }
    }
}

