/*
 * Decompiled with CFR 0.152.
 */
package sql.schemas.seats;

import hydra.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import sql.schemas.Transactions;
import sql.schemas.seats.SeatsTest;
import sql.sqlutil.SQLStmt;
import util.TestException;

public class UpdateReservation
extends Transactions {
    public final SQLStmt CheckSeat = new SQLStmt("SELECT R_ID   FROM RESERVATION  WHERE R_F_ID = ? and R_SEAT = ?", new int[0]);
    public final SQLStmt CheckCustomer = new SQLStmt("SELECT R_ID   FROM RESERVATION  WHERE R_F_ID = ? AND R_C_ID = ?", new int[0]);
    private static final String BASE_SQL = "UPDATE RESERVATION    SET R_SEAT = ?, %s = ? " + (SeatsTest.addTxId ? ", TXID = " + SeatsTest.curTxId.get() : "") + " WHERE R_ID = ? AND R_C_ID = ? AND R_F_ID = ?";
    public final SQLStmt ReserveSeat0 = new SQLStmt(String.format(BASE_SQL, "R_IATTR00"), new int[0]);
    public final SQLStmt ReserveSeat1 = new SQLStmt(String.format(BASE_SQL, "R_IATTR01"), new int[0]);
    public final SQLStmt ReserveSeat2 = new SQLStmt(String.format(BASE_SQL, "R_IATTR02"), new int[0]);
    public final SQLStmt ReserveSeat3 = new SQLStmt(String.format(BASE_SQL, "R_IATTR03"), new int[0]);
    public static final int NUM_UPDATES = 4;
    public final SQLStmt[] ReserveSeats = new SQLStmt[]{this.ReserveSeat0, this.ReserveSeat1, this.ReserveSeat2, this.ReserveSeat3};

    public void doTxn(Connection conn, long r_id, long f_id, long c_id, long seatnum, long newseatnum, long attr_idx, long attr_val) throws SQLException {
        assert (attr_idx >= 0L);
        assert (attr_idx < (long)this.ReserveSeats.length);
        PreparedStatement stmt = null;
        ResultSet results = null;
        stmt = this.getPreparedStatement(conn, this.CheckSeat, f_id, newseatnum);
        results = stmt.executeQuery();
        boolean found = results.next();
        results.close();
        if (found) {
            Log.getLogWriter().info(String.format(" Seat %d is already reserved on flight #%d", seatnum, f_id));
        }
        stmt = this.getPreparedStatement(conn, this.CheckCustomer, f_id, c_id);
        results = stmt.executeQuery();
        found = results.next();
        results.close();
        if (!found) {
            throw new TestException(String.format(" Customer %d does not have an existing reservation on flight #%d", c_id, f_id));
        }
        stmt = this.getPreparedStatement(conn, this.ReserveSeats[(int)attr_idx], newseatnum, attr_val, r_id, c_id, f_id);
        int updated = stmt.executeUpdate();
        if (updated != 1) {
            String msg = String.format("Failed to update reservation on flight %d for customer #%d - Updated %d records", f_id, c_id, updated);
            if (this.logDML) {
                Log.getLogWriter().warning(msg);
            }
            throw new TestException(msg);
        }
        if (this.logDML) {
            Log.getLogWriter().info(String.format("Updated reservation on flight %d for customer %d", f_id, c_id));
        }
    }
}

