/*
 * Decompiled with CFR 0.152.
 */
package sql.security;

import hydra.Log;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import sql.SQLBB;
import sql.SQLHelper;
import sql.security.SQLSecurityTest;

public class AuthenticationTest {
    static String derby_setProperty = "CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(";
    static String derby_getProperty = "VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY(";
    static String derby_defaultConnMode = "'derby.database.defaultConnectionMode'";
    static String derby_fullAccessUsers = "'derby.database.fullAccessUsers'";
    static String derby_readOnlyAccessUsers = "'derby.database.readOnlyAccessUsers'";
    static String derby_requireAuth = "'derby.connection.requireAuthentication'";
    static String derby_sqlAuthorization = "'derby.database.sqlAuthorization'";
    static String gfxd_setProperty = "CALL SYSCS_UTIL.SET_DATABASE_PROPERTY(";
    static String gfxd_getProperty = "VALUES SYSCS_UTIL.GET_DATABASE_PROPERTY(";
    static String gfxd_defaultConnMode = "'gemfirexd.authz-default-connection-mode'";
    static String gfxd_fullAccessUsers = "'gemfirexd.authz-full-access-users'";
    static String gfxd_readOnlyAccessUsers = "'gemfirexd.authz-read-only-access-users'";
    static String derbyDBPropertiesOnly = "'derby.database.propertiesOnly'";

    public static void createUserAuthentication(Connection conn) throws SQLException {
        String whichUser = SQLHelper.isDerbyConn(conn) ? "derby.user." : "gemfirexd.user.";
        String prefix = SQLHelper.isDerbyConn(conn) ? "SYSCS_" : "";
        Map userPasswd = (Map)SQLBB.getBB().getSharedMap().get((Object)SQLSecurityTest.userPasswdMap);
        for (Map.Entry e : userPasswd.entrySet()) {
            String sql = "CALL SYSCS_UTIL." + prefix + "SET_DATABASE_PROPERTY" + "('" + whichUser + (String)e.getKey() + "', '" + (String)e.getValue() + "')";
            CallableStatement cs = conn.prepareCall(sql);
            Log.getLogWriter().info("executed: " + sql);
            cs.execute();
            conn.commit();
        }
    }

    public static void turnOnAuthorization(Connection dConn, Connection gConn) {
        String derby_sql = "CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY( 'derby.database.sqlAuthorization', 'true')";
        String gfxd_sql = "CALL SYSCS_UTIL.SET_DATABASE_PROPERTY( 'gemfirexd.sql-authorization', 'true')";
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        if (dConn != null) {
            AuthenticationTest.turnOnDerbyAuthentication(dConn);
            AuthenticationTest.turnOnDerbyAuthorization(dConn, derby_sql, exList);
            AuthenticationTest.turnOnGfxdAuthorization(gConn, gfxd_sql, exList);
            SQLHelper.handleMissedSQLException(exList);
        } else {
            AuthenticationTest.turnOnGfxdAuthorization(gConn, gfxd_sql);
        }
    }

    public static void turnOnDerbyAuthentication(Connection conn) {
        try {
            AuthenticationTest.getDerbyAuthorizationInfo(conn);
            Statement stmt = conn.createStatement();
            Log.getLogWriter().info("turn on authentication statement in derby");
            stmt.executeUpdate(derby_setProperty + derby_requireAuth + ", 'true')");
            conn.commit();
            AuthenticationTest.getDerbyAuthorizationInfo(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void turnOnDerbyAuthorization(Connection conn, String sql, ArrayList<SQLException> exList) {
        try {
            AuthenticationTest.getDerbyAuthorizationInfo(conn);
            Log.getLogWriter().info("turn on authorization statement in derby");
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            conn.commit();
            AuthenticationTest.getDerbyAuthorizationInfo(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleDerbySQLException(se, exList);
        }
    }

    public static void setDerbyPropertiesOnly(Connection conn) {
        try {
            Log.getLogWriter().info("turn on database only properties in derby");
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(derby_setProperty + derbyDBPropertiesOnly + ", 'true')");
            conn.commit();
            AuthenticationTest.getDerbyAuthorizationInfo(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void getDerbyAuthorizationInfo(Connection conn) {
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(derby_getProperty + derby_requireAuth + ")");
            rs.next();
            Log.getLogWriter().info("Value of derby database properties requireAuth is " + rs.getString(1));
            rs.close();
            rs = stmt.executeQuery(derby_getProperty + "'derby.database.sqlAuthorization')");
            rs.next();
            Log.getLogWriter().info("Value of derby sqlAuthorization is " + rs.getString(1));
            rs.close();
            rs = stmt.executeQuery(derby_getProperty + derby_defaultConnMode + ")");
            rs.next();
            Log.getLogWriter().info("Value of derby defaultConnectionMode is " + rs.getString(1));
            rs.close();
            conn.commit();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void turnOnGfxdAuthorization(Connection conn, String sql, ArrayList<SQLException> exList) {
        Log.getLogWriter().info("turn on authorization statement in Gfxd");
        try {
            AuthenticationTest.getGfxdAuthorizationInfo(conn);
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            conn.commit();
            AuthenticationTest.getGfxdAuthorizationInfo(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleDerbySQLException(se, exList);
        }
    }

    public static void getGfxdAuthorizationInfo(Connection conn) {
        Properties sprops = System.getProperties();
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(gfxd_getProperty + "'gemfirexd.sql-authorization')");
            rs.next();
            Log.getLogWriter().info("Value of gfxd database properties sqlAuthorization is " + rs.getString(1));
            rs.close();
            Log.getLogWriter().info("Value of gemfirexd system properties sqlAuthorization is " + sprops.getProperty("gemfirexd.sql-authorization"));
            rs = stmt.executeQuery(gfxd_getProperty + gfxd_defaultConnMode + ")");
            rs.next();
            Log.getLogWriter().info("Value of gemfirexd system properties defaultConnectionMode is " + sprops.getProperty("gemfirexd.authz-default-connection-mode"));
            Log.getLogWriter().info("Value of gfxd defaultConnectionMode is " + rs.getString(1));
            rs.close();
            conn.commit();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void turnOnGfxdAuthorization(Connection conn, String sql) {
        Log.getLogWriter().info("turn on authorization statement in Gfxd");
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            conn.commit();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void logFullAccessUsers(Connection conn) {
        boolean isDerbyConn = SQLHelper.isDerbyConn(conn);
        String getProperty = isDerbyConn ? derby_getProperty : gfxd_getProperty;
        String fullAccessUsers = isDerbyConn ? derby_fullAccessUsers : gfxd_fullAccessUsers;
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(getProperty + fullAccessUsers + ")");
            rs.next();
            Log.getLogWriter().info(fullAccessUsers + " are " + rs.getString(1));
            rs.close();
            conn.commit();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void logReadyOnlyAccessUsers(Connection conn) {
        boolean isDerbyConn = SQLHelper.isDerbyConn(conn);
        String getProperty = isDerbyConn ? derby_getProperty : gfxd_getProperty;
        String readOnlyAccessUsers = isDerbyConn ? derby_readOnlyAccessUsers : gfxd_readOnlyAccessUsers;
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(getProperty + readOnlyAccessUsers + ")");
            rs.next();
            Log.getLogWriter().info(readOnlyAccessUsers + " are " + rs.getString(1));
            rs.close();
            conn.commit();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void setUserFullAccessMode(Connection conn, String user) {
        try {
            boolean isDerbyConn = SQLHelper.isDerbyConn(conn);
            String setProperty = isDerbyConn ? derby_setProperty : gfxd_setProperty;
            String fullAccessUsers = isDerbyConn ? derby_fullAccessUsers : gfxd_fullAccessUsers;
            Statement stmt = conn.createStatement();
            Log.getLogWriter().info(setProperty + fullAccessUsers + ", '" + user + "')");
            stmt.executeUpdate(setProperty + fullAccessUsers + ", '" + user + "')");
            conn.commit();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void setUserReadOnlyAccessMode(Connection conn, String user) {
        try {
            boolean isDerbyConn = SQLHelper.isDerbyConn(conn);
            String setProperty = isDerbyConn ? derby_setProperty : gfxd_setProperty;
            String readOnlyAccessUsers = isDerbyConn ? derby_readOnlyAccessUsers : gfxd_readOnlyAccessUsers;
            Statement stmt = conn.createStatement();
            Log.getLogWriter().info(setProperty + readOnlyAccessUsers + ", '" + user + "')");
            stmt.executeUpdate(setProperty + readOnlyAccessUsers + ", '" + user + "')");
            conn.commit();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void setFullAccessMode(Connection dConn, Connection gConn, String user) {
        if (dConn != null) {
            AuthenticationTest.setUserFullAccessMode(dConn, user);
        }
        AuthenticationTest.setUserFullAccessMode(gConn, user);
    }

    public static void setReadOnlyAccessMode(Connection dConn, Connection gConn, String user) {
        if (dConn != null) {
            AuthenticationTest.setUserReadOnlyAccessMode(dConn, user);
        }
        AuthenticationTest.setUserReadOnlyAccessMode(gConn, user);
    }

    public static void logFullAccessUsers(Connection dConn, Connection gConn) {
        if (dConn != null) {
            AuthenticationTest.logFullAccessUsers(dConn);
        }
        AuthenticationTest.logFullAccessUsers(gConn);
    }

    public static void logReadyOnlyAccessUsers(Connection dConn, Connection gConn) {
        if (dConn != null) {
            AuthenticationTest.logReadyOnlyAccessUsers(dConn);
        }
        AuthenticationTest.logReadyOnlyAccessUsers(gConn);
    }
}

