/*
 * Decompiled with CFR 0.152.
 */
package sql.security;

import hydra.ClientVmInfo;
import hydra.Log;
import hydra.Prms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.gemfirexd.GfxdConfigPrms;
import hydra.gemfirexd.NetworkServerHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import sql.ClientDiscDBManager;
import sql.GFEDBClientManager;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.ddlStatements.AuthorizationDDLStmt;
import sql.ddlStatements.FunctionDDLStmt;
import sql.security.SQLSecurityTest;
import util.PRObserver;
import util.TestException;
import util.TestHelper;

public class SQLSecurityClientTest
extends SQLSecurityTest {
    protected static SQLSecurityClientTest ssClientTest;

    public static synchronized void HydraTask_initialize() {
        if (ssClientTest == null) {
            ssClientTest = new SQLSecurityClientTest();
            PRObserver.installObserverHook();
            PRObserver.initialize((int)RemoteTestModule.getMyVmid());
            ssClientTest.initialize();
        }
    }

    public static void HydraTask_setupUsers() {
        ssClientTest.setupUsers();
    }

    public static void HydraTask_initUsers() {
        ssClientTest.initUsers();
    }

    public static void HydraTask_createAuthDiscDB() {
        ssClientTest.createAuthDiscDB();
    }

    public static void HydraTask_setupDerbyUserAuthentication() {
        ssClientTest.setupDerbyUserAuthentication();
    }

    public static synchronized void HydraTask_startAuthFabricServer() {
        if (serverStarted[0]) {
            Log.getLogWriter().info("fabric server is started");
            return;
        }
        ssClientTest.startAuthFabricServer();
    }

    public static void HydraTask_startAuthFabricServerAsSuperUser() {
        ssClientTest.startAuthFabricServerAsSuperUser();
    }

    public static synchronized void HydraTask_startNetworkServer() {
        String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
        NetworkServerHelper.startNetworkServers(networkServerConfig);
    }

    public static synchronized void HydraTask_initEdges() {
        if (ssClientTest == null) {
            ssClientTest = new SQLSecurityClientTest();
        }
        hasDerbyServer = TestConfig.tab().booleanAt(Prms.manageDerbyServer, false);
        testUniqueKeys = TestConfig.tab().booleanAt(SQLPrms.testUniqueKeys, true);
        randomData = TestConfig.tab().booleanAt(SQLPrms.randomData, false);
        isSerial = TestConfig.tab().booleanAt(Prms.serialExecution, false);
        isSingleDMLThread = TestConfig.tab().booleanAt(SQLPrms.isSingleDMLThread, false);
        usingTrigger = TestConfig.tab().booleanAt(SQLPrms.usingTrigger, false);
        queryAnyTime = TestConfig.tab().booleanAt(SQLPrms.queryAnyTime, true);
        hasNetworth = TestConfig.tab().booleanAt(SQLPrms.hasNetworth, false);
        isEdge = true;
    }

    public static void HydraTask_setupGfxdUserAuthentication() {
        if (!useLDAP) {
            ssClientTest.setupGfxdUserAuthentication();
        }
    }

    public static void HydraTask_changePassword() {
        if (!useLDAP) {
            ssClientTest.changePassword();
        }
    }

    @Override
    protected void changePassword() {
        Log.getLogWriter().info("in gfxd to change my password");
        Connection conn = this.getAuthGfxdClientConnection();
        try {
            this.changePassword(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static synchronized void HydraTask_createDiscDB() {
        ssClientTest.createDiscDB();
    }

    public static synchronized void HydraTask_createDiscSchemas() {
        ssClientTest.createDiscSchemas();
    }

    public static synchronized void HydraTask_createDiscTables() {
        ssClientTest.createDiscTables();
    }

    public static void HydraTask_createGFESchemas() {
        ssClientTest.createGFESchemas();
    }

    @Override
    protected void createGFESchemas() {
        Connection conn = null;
        conn = !sqlAuthorization || !bootedAsSuperUser ? this.getAuthGfxdClientConnection() : this.getGfxdSuperUserClientConnection();
        Log.getLogWriter().info("creating schemas in gfxd.");
        if (!testServerGroupsInheritence) {
            this.createSchemas(conn);
        } else {
            String[] schemas = SQLPrms.getGFESchemas();
            this.createSchemas(conn, schemas);
        }
        Log.getLogWriter().info("done creating schemas in gfxd.");
        this.closeGFEConnection(conn);
    }

    protected Connection getAuthGfxdClientConnection() {
        Connection conn = null;
        try {
            conn = GFEDBClientManager.getAuthConnection(this.getMyTid());
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    @Override
    protected Connection getAuthGfxdConnection(String user, String password) throws SQLException {
        Connection conn = null;
        try {
            conn = GFEDBClientManager.getAuthConnection(user, password);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw se;
        }
        return conn;
    }

    protected Connection getGfxdSuperUserClientConnection() {
        Connection conn = null;
        try {
            conn = GFEDBClientManager.getSuperUserConnection();
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection as system user " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    public static void HydraTask_createGFETables() {
        ssClientTest.createFuncMonth();
        ssClientTest.createGFETables();
    }

    @Override
    protected void createFuncMonth() {
        Connection conn = this.getAuthGfxdClientConnection();
        this.createFuncMonth(conn);
        this.closeGFEConnection(conn);
    }

    @Override
    protected void createGFETables() {
        Connection conn = this.getAuthGfxdClientConnection();
        Log.getLogWriter().info("dropping tables in gfe.");
        this.dropTables(conn);
        Log.getLogWriter().info("done dropping tables in gfe");
        Log.getLogWriter().info("creating tables in gfe.");
        this.createTables(conn);
        Log.getLogWriter().info("done creating tables in gfe.");
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_createFunctionToPopulate() {
        ssClientTest.createFunctionToPopulate();
    }

    @Override
    protected void createFunctionToPopulate() {
        Connection gConn = this.getAuthGfxdClientConnection();
        try {
            FunctionDDLStmt.createFuncPortf(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_setTableCols() {
        ssClientTest.setTableCols();
    }

    @Override
    protected void setTableCols() {
        Connection gConn = this.getAuthGfxdClientConnection();
        SQLSecurityClientTest.setTableCols(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_createFuncForSubquery() {
        ssClientTest.createFuncForSubquery();
    }

    @Override
    protected void createFuncForSubquery() {
        Log.getLogWriter().info("performing create function maxCid Op, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getAuthDerbyConnection();
        }
        Connection gConn = this.getAuthGfxdClientConnection();
        try {
            FunctionDDLStmt.createFuncMaxCid(dConn);
            FunctionDDLStmt.createFuncMaxCid(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        if (dConn != null) {
            this.commit(dConn);
            this.closeDiscConnection(dConn);
        }
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_setSuperUserConnections() {
        ssClientTest.initThreadLocalConnection();
    }

    @Override
    protected void initThreadLocalConnection() {
        if (hasDerbyServer) {
            Connection derbySuperUser = this.getDerbySuperUserConnection();
            derbySuperUserConn.set((Object)derbySuperUser);
        }
        if (bootedAsSuperUser) {
            Connection gfxdSuperUser = this.getGfxdSuperUserClientConnection();
            gfxdSuperUserConn.set((Object)gfxdSuperUser);
        } else {
            Log.getLogWriter().info("booted as systemUser, getting connection as systemUser");
            Connection gfxdSystemUser = this.getGfxdSystemUserConnection();
            gfxdSystemUserConn.set((Object)gfxdSystemUser);
        }
    }

    @Override
    protected Connection getGfxdSystemUserConnection() {
        Connection conn = null;
        try {
            conn = GFEDBClientManager.getAuthConnection(systemUser);
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection as system user " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    public static void HydraTask_delegatePrivilege() {
        ssClientTest.delegatePrivilege();
    }

    @Override
    protected void delegatePrivilege() {
        Log.getLogWriter().info("performing ddlOp, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getAuthDerbyConnection();
        }
        Connection gConn = this.getAuthGfxdClientConnection();
        AuthorizationDDLStmt authDDL = new AuthorizationDDLStmt();
        authDDL.delegateGrantOption(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_grantDelegatedPrivilege() {
        ssClientTest.grantDelegatedPrivilege();
    }

    public static void HydraTask_revokeDelegatedPrivilege() {
        ssClientTest.revokeDelegatedPrivilege();
    }

    @Override
    protected void grantDelegatedPrivilege() {
        Log.getLogWriter().info("performing ddlOp, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getAuthDerbyConnection();
        }
        Connection gConn = this.getAuthGfxdClientConnection();
        AuthorizationDDLStmt authDDL = new AuthorizationDDLStmt();
        authDDL.useDelegatedPrivilege(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    @Override
    protected void revokeDelegatedPrivilege() {
        Log.getLogWriter().info("performing ddlOp, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getAuthDerbyConnection();
        }
        Connection gConn = this.getAuthGfxdClientConnection();
        AuthorizationDDLStmt authDDL = new AuthorizationDDLStmt();
        authDDL.revokeDelegatedPrivilege(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_populateTables() {
        ssClientTest.populateTables();
    }

    @Override
    protected void populateTables() {
        Connection dConn = this.getCorrectDerbyAuthConnection();
        Connection gConn = this.getAuthGfxdClientConnection();
        this.populateTables(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_setUserAccessPriviledge() {
        ssClientTest.setUserAccessPriviledge();
    }

    @Override
    protected void setUserAccessPriviledge() {
        Connection dConn = null;
        Connection gConn = this.getGfxdSuperUserClientConnection();
        this.setUserAccessPriviledge(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_provideAllPrivToAll() {
        ssClientTest.provideAllPrivToAll();
    }

    @Override
    protected void provideAllPrivToAll() {
        Log.getLogWriter().info("performing ddlOp, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getAuthDerbyConnection();
        }
        Connection gConn = this.getAuthGfxdClientConnection();
        AuthorizationDDLStmt authDDL = new AuthorizationDDLStmt();
        authDDL.provideAllPrivToAll(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_verifyResultSets() {
        ssClientTest.verifyResultSets();
    }

    @Override
    protected void verifyResultSets() {
        if (!hasDerbyServer) {
            Log.getLogWriter().info("skipping verification of query results due to manageDerbyServer as false, myTid=" + this.getMyTid());
            return;
        }
        Connection dConn = this.getAuthDerbyConnection();
        Connection gConn = this.getAuthGfxdClientConnection();
        this.verifyResultSets(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_doOps() {
        ssClientTest.doOps();
    }

    @Override
    protected void doOps() {
        if (random.nextInt(100) == 1) {
            this.connectWithInvalidPassword();
        }
        Connection dConn = this.getCorrectDerbyAuthConnection();
        Connection gConn = this.getAuthGfxdClientConnection();
        this.doOps(dConn, gConn);
        if (hasDerbyServer) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        if (hasDerbyServer) {
            this.waitForBarrier();
        }
    }

    @Override
    protected void doAuthOp() {
        Connection dConn = this.getCorrectDerbyAuthConnection();
        Connection gConn = this.getAuthGfxdClientConnection();
        this.doAuthOp(dConn, gConn);
        if (hasDerbyServer) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static synchronized void HydraTask_shutdownFabricServers() {
        if (ssClientTest == null) {
            ssClientTest = new SQLSecurityClientTest();
        }
        ssClientTest.shutdownFabricServers();
    }

    @Override
    protected void connectWithInvalidPassword() {
        ArrayList<SQLException> exList;
        if (hasDerbyServer) {
            exList = new ArrayList<SQLException>();
            try {
                ClientDiscDBManager.getInvalidAuthConnection(this.getMyTid());
            }
            catch (SQLException se) {
                SQLHelper.handleDerbySQLException(se, exList);
            }
            try {
                GFEDBClientManager.getInvalidAuthConnection(this.getMyTid());
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exList);
            }
        } else {
            try {
                GFEDBClientManager.getInvalidAuthConnection(this.getMyTid());
            }
            catch (SQLException se) {
                if (se.getSQLState().equalsIgnoreCase("08004")) {
                    Log.getLogWriter().info("Got expected invalid credentials, continuing tests");
                    return;
                }
                SQLHelper.handleSQLException(se);
            }
            throw new TestException("does not get invalid credentials exception while using invalid credentials");
        }
        SQLHelper.handleMissedSQLException(exList);
    }

    public static void HydraTask_shutdownFabricLocators() {
        ssClientTest.shutdownFabricLocators();
    }

    public static synchronized void HydraTask_cycleStoreVms() {
        if (ssClientTest == null) {
            ssClientTest = new SQLSecurityClientTest();
        }
        ssClientTest.cycleStoreVms();
    }

    @Override
    protected List<ClientVmInfo> stopStartVMs(int numToKill) {
        return this.stopStartVMs(numToKill, "server");
    }

    public static void HydraTask_createProcedures() {
        ssClientTest.createProcedures();
    }

    @Override
    protected void createProcedures() {
        Log.getLogWriter().info("performing create procedure Op, myTid is " + this.getMyTid());
        Connection dConn = this.getCorrectDerbyAuthConnection();
        Connection gConn = this.getAuthGfxdClientConnection();
        this.createProcedures(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }
}

