/*
 * Decompiled with CFR 0.152.
 */
package sql.security;

import com.pivotal.gemfirexd.FabricServer;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.gemfirexd.FabricSecurityPrms;
import hydra.gemfirexd.FabricServerHelper;
import hydra.gemfirexd.GfxdConfigPrms;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import sql.ClientDiscDBManager;
import sql.GFEDBManager;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.ddlStatements.AuthorizationDDLStmt;
import sql.ddlStatements.DDLStmtIF;
import sql.ddlStatements.FunctionDDLStmt;
import sql.security.AuthenticationTest;
import util.PRObserver;
import util.TestException;
import util.TestHelper;

public class SQLSecurityTest
extends SQLTest {
    protected static SQLSecurityTest ssTest;
    public static String userPasswdMap;
    public static String systemUserPasswdMap;
    public static String userPrefix;
    protected static boolean[] serverStarted;
    public static boolean sqlAuthorization;
    static boolean useBUILTIN;
    public static String gfxdUserCreated;
    public static boolean bootedAsSuperUser;
    public static boolean useLDAP;
    protected static String systemUser;
    public static boolean hasMultiSystemUsers;
    protected static boolean hasRoutine;
    public static HydraThreadLocal prepareStmtException;
    public static HydraThreadLocal derbySuperUserConn;
    public static HydraThreadLocal gfxdSuperUserConn;
    public static HydraThreadLocal gfxdSystemUserConn;

    public static synchronized void HydraTask_initialize() {
        if (ssTest == null) {
            ssTest = new SQLSecurityTest();
            PRObserver.installObserverHook();
            PRObserver.initialize((int)RemoteTestModule.getMyVmid());
            ssTest.initialize();
        }
    }

    public static void HydraTask_createGfxdLocatorTask() {
        FabricServerHelper.createLocator();
    }

    public static void HydraTask_startGfxdLocatorTask() {
        String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
        if (!hasMultiSystemUsers) {
            FabricServerHelper.startLocator(networkServerConfig);
        } else {
            Map<String, String> m = SQLSecurityTest.getMultiSystemUserLocatorMap();
            FabricServerHelper.startLocator(networkServerConfig, m);
        }
    }

    private static Map<String, String> getMultiSystemUserLocatorMap() {
        return (Map)SQLBB.getBB().getSharedMap().get((Object)systemUserPasswdMap);
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    public static void HydraTask_createAuthDiscDB() {
        ssTest.createAuthDiscDB();
    }

    protected void createAuthDiscDB() {
        if (hasDerbyServer && discConn == null) {
            discConn = this.getDerbySuperUserConnection();
        }
    }

    public static void HydraTask_setupDerbyUserAuthentication() {
        ssTest.setupDerbyUserAuthentication();
    }

    public static void HydraTask_setupGfxdUserAuthentication() {
        if (!useLDAP) {
            ssTest.setupGfxdUserAuthentication();
        }
    }

    public static void HydraTask_setupUsers() {
        ssTest.setupUsers();
    }

    public static synchronized void HydraTask_startAuthFabricServer() {
        if (serverStarted[0]) {
            Log.getLogWriter().info("fabric server is started");
            return;
        }
        ssTest.startAuthFabricServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startAuthFabricServer() {
        if (useLDAP) {
            this.startAuthFabricServerAsSuperUser();
            return;
        }
        Properties p = FabricServerHelper.getBootProperties();
        Log.getLogWriter().info("user password is " + p.getProperty("gemfirexd.user.superUser"));
        p.setProperty("gemfirexd.user.thr_" + this.getMyTid(), "thr_" + this.getMyTid());
        p.remove("gemfirexd.user.superUser");
        Log.getLogWriter().info("boot with this authentication setting -- user: gemfirexd.user.thr_" + this.getMyTid() + "password: thr_" + this.getMyTid());
        p.setProperty(random.nextBoolean() ? "user" : "UserName", "thr_" + this.getMyTid());
        p.setProperty("password", "thr_" + this.getMyTid());
        p.setProperty("table-default-partitioned", "true");
        if (p != null && "false".equalsIgnoreCase(p.getProperty("host-data")) && "true".equalsIgnoreCase(p.getProperty("persist-dd"))) {
            p.setProperty("persist-dd", "false");
        }
        FabricServer fs = FabricServiceManager.getFabricServerInstance();
        boolean userCreated = SQLBB.getBB().getSharedMap().get((Object)gfxdUserCreated) != null;
        try {
            fs.start(p);
        }
        catch (SQLException se) {
            if (!(!se.getSQLState().equalsIgnoreCase("XJ040") || userCreated && systemUser.equals(userPrefix + this.getMyTid()))) {
                Log.getLogWriter().info("got expected userid or password invalid exception, continuing test");
                return;
            }
            if (se.getSQLState().equalsIgnoreCase("XJ040") && userCreated && systemUser.equals(userPrefix + this.getMyTid())) {
                SQLHelper.printSQLException(se);
                throw new TestException("the system user has been created and received but got userid  or password invalid exception" + TestHelper.getStackTrace((Throwable)se));
            }
            SQLHelper.handleSQLException(se);
        }
        boolean[] blArray = serverStarted;
        synchronized (serverStarted) {
            SQLSecurityTest.serverStarted[0] = true;
            bootedAsSuperUser = false;
            Log.getLogWriter().info("booted as systemUser: thr_" + this.getMyTid());
            // ** MonitorExit[var4_5] (shouldn't be in output)
            if (!userCreated) {
                throw new TestException("did not get expected invalid userid or password exception due to #42496");
            }
            return;
        }
    }

    public static void HydraTask_startAuthFabricServerAsSuperUser() {
        ssTest.startAuthFabricServerAsSuperUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startAuthFabricServerAsSuperUser() {
        boolean[] blArray = serverStarted;
        synchronized (serverStarted) {
            if (serverStarted[0]) {
                Log.getLogWriter().info("to workaround #42499, no more fabric servers will be started");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this._startAuthFabricServerAsSuperUser();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.logGfxdSystemProperties();
            return;
        }
    }

    protected void _startAuthFabricServerAsSuperUser() {
        Properties bootProperties = FabricServerHelper.getBootProperties();
        FabricServer fs = FabricServiceManager.getFabricServerInstance();
        if (bootProperties != null) {
            bootProperties.setProperty("table-default-partitioned", "true");
        } else {
            System.setProperty("gemfirexd.table-default-partitioned", "true");
        }
        if (bootProperties != null && "false".equalsIgnoreCase(bootProperties.getProperty("host-data")) && "true".equalsIgnoreCase(bootProperties.getProperty("persist-dd"))) {
            bootProperties.setProperty("persist-dd", "false");
        }
        try {
            fs.start(bootProperties);
            SQLSecurityTest.serverStarted[0] = true;
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        catch (IllegalStateException ise) {
            if (serverStarted[0]) {
                Log.getLogWriter().info("server has been started already, continuing tests");
            }
            throw new TestException("got unexpected IllegalStateException during fabric server start");
        }
    }

    protected void setupUsers() {
        HashMap userPasswd = new HashMap();
        SQLBB.getBB().getSharedMap().put((Object)userPasswdMap, userPasswd);
        if (hasMultiSystemUsers) {
            HashMap systemUserPasswd = new HashMap();
            SQLBB.getBB().getSharedMap().put((Object)systemUserPasswdMap, systemUserPasswd);
            this.initUsers();
        }
    }

    public static void HydraTask_initUsers() {
        ssTest.initUsers();
    }

    public static void HydraTask_addLoader() {
        ssTest.addLoader();
    }

    @Override
    protected void addLoader() {
        if (!populateThruLoader && !testLoaderCreateRandomRow) {
            Log.getLogWriter().info("no loader is attached");
            return;
        }
        Connection conn = this.getAuthGfxdConnection();
        try {
            this.addLoader(conn);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("42504")) {
                Log.getLogWriter().info("gets expected authorization exception when user by default does not have the right to call SYS.ATTACH_LOADER procedure, continue testing");
            }
            SQLHelper.handleSQLException(se);
        }
        conn = this.getGfxdSuperUserConnection();
        String grantProcedure = "GRANT EXECUTE ON PROCEDURE SYS.ATTACH_LOADER TO thr_" + this.getMyTid();
        try {
            conn.createStatement().execute(grantProcedure);
            Log.getLogWriter().info("executed " + grantProcedure);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        conn = this.getAuthGfxdConnection();
        try {
            this.addLoader(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void addLoader(Connection conn) throws SQLException {
        String schemaName = "trade";
        String tableName = "buyorders";
        String loader = "sql.loader.BuyOrdersLoader";
        String initStr = testLoaderCreateRandomRow ? "createRandomRow" : null;
        this.addLoader(conn, schemaName, tableName, loader, initStr);
        conn.commit();
    }

    protected synchronized void initUsers() {
        String user;
        int tid = this.getMyTid();
        String password = user = userPrefix + tid;
        this.getLock();
        Map userPasswd = (Map)SQLBB.getBB().getSharedMap().get((Object)userPasswdMap);
        userPasswd.put(user, password);
        SQLBB.getBB().getSharedMap().put((Object)userPasswdMap, (Object)userPasswd);
        if (systemUser == null && hasMultiSystemUsers) {
            systemUser = userPrefix + this.getMyTid();
            Map systemUserPasswd = (Map)SQLBB.getBB().getSharedMap().get((Object)systemUserPasswdMap);
            systemUserPasswd.put(systemUser, password);
            Log.getLogWriter().info("system user for this member is " + systemUser);
            SQLBB.getBB().getSharedMap().put((Object)systemUserPasswdMap, (Object)systemUserPasswd);
        }
        this.releaseLock();
    }

    protected void setupDerbyUserAuthentication() {
        Log.getLogWriter().info("in derby setupUserAuth");
        Connection dConn = this.getDerbySuperUserConnection();
        AuthenticationTest.getDerbyAuthorizationInfo(dConn);
        try {
            AuthenticationTest.createUserAuthentication(dConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void setupGfxdUserAuthentication() {
        Log.getLogWriter().info("in gfxd setupUserAuth");
        Connection conn = this.getGfxdSuperUserConnection();
        this.logGfxdSystemProperties();
        try {
            SQLSecurityTest.createGfxdUserAuthentication(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.closeGFEConnection(conn);
    }

    protected void logGfxdSystemProperties() {
        Properties sprops = System.getProperties();
        Log.getLogWriter().info("Value of gemfirexd system properties sqlAuthorization is " + sprops.getProperty("gemfirexd.sql-authorization"));
        Log.getLogWriter().info("Value of gemfirexd system properties defaultConnectionMode is " + sprops.getProperty("gemfirexd.authz-default-connection-mode"));
    }

    public static void createGfxdUserAuthentication(Connection conn) throws SQLException {
        Map userPasswd = (Map)SQLBB.getBB().getSharedMap().get((Object)userPasswdMap);
        if (useBUILTIN) {
            try {
                Iterator i$ = userPasswd.entrySet().iterator();
                if (i$.hasNext()) {
                    Map.Entry e = i$.next();
                    SQLSecurityTest.changeUsersPassword(conn, (String)e.getKey(), "", (String)e.getValue());
                    throw new TestException("change_password call should get exception when the user has not been created");
                }
            }
            catch (SQLException se) {
                if (se.getSQLState().equalsIgnoreCase("28502")) {
                    Log.getLogWriter().info("got expected user not valid exception, continuing tests");
                }
                SQLHelper.handleSQLException(se);
            }
        }
        try {
            for (Map.Entry e : userPasswd.entrySet()) {
                SQLSecurityTest.createGfxdUsers(conn, (String)e.getKey(), (String)e.getValue());
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        if (useBUILTIN) {
            for (Map.Entry e : userPasswd.entrySet()) {
                String emptyPasswd = "";
                String oldPasswd = (String)e.getValue();
                try {
                    SQLSecurityTest.changeUsersPassword(conn, "gemfirexd.user." + (String)e.getKey(), emptyPasswd, oldPasswd);
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
                if (random.nextBoolean()) {
                    String newPasswd = oldPasswd + 'a';
                    SQLSecurityTest.changeUsersPassword(conn, "gemfirexd.user." + (String)e.getKey(), oldPasswd, newPasswd);
                    oldPasswd = newPasswd;
                }
                SQLSecurityTest.changeUsersPassword(conn, "gemfirexd.user." + (String)e.getKey(), oldPasswd, (String)e.getValue());
            }
        }
        boolean[] userCreated = new boolean[]{true};
        SQLBB.getBB().getSharedMap().put((Object)gfxdUserCreated, (Object)userCreated);
    }

    public static void HydraTask_changePassword() {
        if (!useLDAP) {
            ssTest.changePassword();
        }
    }

    protected void changePassword() {
        Log.getLogWriter().info("in gfxd to change my password");
        Connection conn = this.getAuthGfxdConnection();
        try {
            this.changePassword(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.closeGFEConnection(conn);
    }

    public void changePassword(Connection conn) throws SQLException {
        if (useBUILTIN) {
            String oldPasswd;
            String prefix = "thr_";
            String newPasswd = oldPasswd = prefix + this.getMyTid();
            String user = oldPasswd;
            String otheruser = prefix + (this.getMyTid() - 1);
            String wrongPasswd = oldPasswd + 'b';
            boolean reproduce47917 = false;
            if (this.getMyTid() != 0 && reproduce47917) {
                try {
                    SQLSecurityTest.changeUsersPassword(conn, "gemfirexd.user." + otheruser, wrongPasswd, oldPasswd);
                    throw new TestException("change_password call should get exception when the old password is an invalid one");
                }
                catch (SQLException se) {
                    if (se.getSQLState().equals("08004")) {
                        this.log().info("Got expected invalid password exception, continue testing");
                    }
                    SQLHelper.handleSQLException(se);
                }
            }
            if (random.nextBoolean()) {
                String changedPasswd = oldPasswd + 'a';
                SQLSecurityTest.changeUsersPassword(conn, "gemfirexd.user." + user, oldPasswd, changedPasswd);
                Connection newconn = this.getAuthGfxdConnection(user, changedPasswd);
                this.closeGFEConnection(newconn);
                try {
                    newconn = this.getAuthGfxdConnection(user, oldPasswd);
                }
                catch (SQLException se) {
                    if (se.getSQLState().equals("08004")) {
                        this.log().info("Got expected invalid password exception, continue testing");
                    }
                    SQLHelper.handleSQLException(se);
                }
                this.closeGFEConnection(newconn);
                oldPasswd = changedPasswd;
            }
            SQLSecurityTest.changeUsersPassword(conn, "gemfirexd.user." + user, oldPasswd, newPasswd);
        }
        boolean[] userCreated = new boolean[]{true};
        SQLBB.getBB().getSharedMap().put((Object)gfxdUserCreated, (Object)userCreated);
    }

    private static void createGfxdUsers(Connection conn, String user, String passwd) throws SQLException {
        String sql = "CALL sys.create_user('" + user + "', '" + passwd + "')";
        Log.getLogWriter().info(sql);
        CallableStatement cs = conn.prepareCall(sql);
        cs.execute();
        conn.commit();
    }

    private static void changeUsersPassword(Connection conn, String user, String oldPasswd, String newPasswd) throws SQLException {
        String sql = "CALL sys.change_password('" + user + "', '" + oldPasswd + "', '" + newPasswd + "')";
        Log.getLogWriter().info(sql);
        CallableStatement cs = conn.prepareCall(sql);
        cs.execute();
        conn.commit();
    }

    protected Connection getDerbySuperUserConnection() {
        Connection conn = null;
        try {
            conn = ClientDiscDBManager.getSuperUserConnection();
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection as a super user: " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected Connection getGfxdSuperUserConnection() {
        Connection conn = null;
        try {
            conn = GFEDBManager.getSuperUserConnection();
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection as system user " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected Connection getGfxdSystemUserConnection() {
        Connection conn = null;
        try {
            conn = GFEDBManager.getAuthConnection(systemUser);
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection as system user " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    public static void HydraTask_turnOnAuthorization() {
        ssTest.turnOnAuthorization();
    }

    protected void turnOnAuthorization() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDerbySuperUserConnection();
        }
        Connection gConn = this.getGfxdSuperUserConnection();
        AuthenticationTest.turnOnAuthorization(dConn, gConn);
    }

    protected Connection getAuthGfxdConnection() {
        Connection conn = null;
        try {
            conn = GFEDBManager.getAuthConnection(this.getMyTid());
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected Connection getAuthGfxdConnection(String user) {
        Connection conn = null;
        try {
            conn = GFEDBManager.getAuthConnection(user);
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected Connection getAuthGfxdConnection(String user, String password) throws SQLException {
        Connection conn = null;
        try {
            conn = GFEDBManager.getAuthConnection(user, password);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw se;
        }
        return conn;
    }

    protected Connection getInvalidAuthGfxdConnection() {
        Connection conn = null;
        try {
            conn = GFEDBManager.getInvalidAuthConnection(this.getMyTid());
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected Connection getNoneAuthGfxdConnection() {
        Connection conn = null;
        try {
            conn = GFEDBManager.getNoneAuthConnection(this.getMyTid());
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected Connection getAuthDerbyConnection() {
        Connection conn = null;
        try {
            conn = ClientDiscDBManager.getAuthConnection(this.getMyTid());
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to create database " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    public static synchronized void HydraTask_createDiscDB() {
        ssTest.createDiscDB();
    }

    @Override
    protected void createDiscDB() {
        if (hasDerbyServer && discConn == null) {
            while (true) {
                try {
                    discConn = this.getFirstDiscConnection();
                }
                catch (SQLException se) {
                    Log.getLogWriter().info("Not able to connect to Derby server yet, Derby server may not be ready.");
                    SQLHelper.printSQLException(se);
                    int sleepMS = 10000;
                    MasterController.sleepForMs((int)sleepMS);
                    continue;
                }
                break;
            }
        }
    }

    public static synchronized void HydraTask_createDiscSchemas() {
        ssTest.createDiscSchemas();
    }

    public static synchronized void HydraTask_createDiscTables() {
        ssTest.createDiscTables();
    }

    @Override
    protected void createDiscSchemas() {
        if (!hasDerbyServer) {
            return;
        }
        Connection conn = null;
        conn = sqlAuthorization ? this.getDerbySuperUserConnection() : this.getAuthDerbyConnection();
        Log.getLogWriter().info("creating schemas on disc.");
        this.createSchemas(conn);
        Log.getLogWriter().info("done creating schemas on disc.");
        this.closeDiscConnection(conn);
    }

    @Override
    protected void createDiscTables() {
        if (!hasDerbyServer) {
            return;
        }
        Connection conn = this.getAuthDerbyConnection();
        Log.getLogWriter().info("creating tables on disc.");
        this.createTables(conn);
        Log.getLogWriter().info("done creating tables on disc.");
        this.closeDiscConnection(conn);
    }

    public static void HydraTask_createGFETables() {
        ssTest.createFuncMonth();
        ssTest.createGFETables();
    }

    @Override
    protected void createFuncMonth() {
        Connection conn = this.getAuthGfxdConnection();
        this.createFuncMonth(conn);
        this.closeGFEConnection(conn);
    }

    @Override
    protected void createGFETables() {
        Connection conn = this.getAuthGfxdConnection();
        Log.getLogWriter().info("dropping tables in gfe.");
        this.dropTables(conn);
        Log.getLogWriter().info("done dropping tables in gfe");
        Log.getLogWriter().info("creating tables in gfe.");
        this.createTables(conn);
        Log.getLogWriter().info("done creating tables in gfe.");
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_createGFESchemas() {
        ssTest.createGFESchemas();
    }

    @Override
    protected void createGFESchemas() {
        Connection conn = null;
        conn = !sqlAuthorization || !bootedAsSuperUser ? this.getAuthGfxdConnection() : this.getGfxdSuperUserConnection();
        Log.getLogWriter().info("creating schemas in gfxd.");
        if (!testServerGroupsInheritence) {
            this.createSchemas(conn);
        } else {
            String[] schemas = SQLPrms.getGFESchemas();
            this.createSchemas(conn, schemas);
        }
        Log.getLogWriter().info("done creating schemas in gfxd.");
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_createFuncForSubquery() {
        ssTest.createFuncForSubquery();
    }

    @Override
    protected void createFuncForSubquery() {
        Log.getLogWriter().info("performing create function maxCid Op, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getAuthDerbyConnection();
        }
        Connection gConn = this.getAuthGfxdConnection();
        try {
            FunctionDDLStmt.createFuncMaxCid(dConn);
            FunctionDDLStmt.createFuncMaxCid(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        if (dConn != null) {
            this.commit(dConn);
            this.closeDiscConnection(dConn);
        }
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_createFunctionToPopulate() {
        ssTest.createFunctionToPopulate();
    }

    @Override
    protected void createFunctionToPopulate() {
        Connection gConn = this.getAuthGfxdConnection();
        try {
            FunctionDDLStmt.createFuncPortf(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_setTableCols() {
        ssTest.setTableCols();
    }

    @Override
    protected void setTableCols() {
        Connection gConn = this.getAuthGfxdConnection();
        SQLSecurityTest.setTableCols(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_fineGrainAuthorization() {
        ssTest.fineGrainAuthorization();
    }

    protected void fineGrainAuthorization() {
    }

    public static void HydraTask_provideAllPrivToAll() {
        ssTest.provideAllPrivToAll();
    }

    protected void provideAllPrivToAll() {
        Log.getLogWriter().info("performing ddlOp, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getAuthDerbyConnection();
        }
        Connection gConn = this.getAuthGfxdConnection();
        AuthorizationDDLStmt authDDL = new AuthorizationDDLStmt();
        authDDL.provideAllPrivToAll(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_connectWithInvalidPassword() {
        ssTest.connectWithInvalidPassword();
    }

    public static void HydraTask_connectWithNoCredentials() {
        ssTest.connectWithNoCredentials();
    }

    protected void connectWithInvalidPassword() {
        ArrayList<SQLException> exList;
        if (hasDerbyServer) {
            exList = new ArrayList<SQLException>();
            try {
                ClientDiscDBManager.getInvalidAuthConnection(this.getMyTid());
            }
            catch (SQLException se) {
                SQLHelper.handleDerbySQLException(se, exList);
            }
            try {
                GFEDBManager.getInvalidAuthConnection(this.getMyTid());
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exList);
            }
        } else {
            try {
                GFEDBManager.getInvalidAuthConnection(this.getMyTid());
            }
            catch (SQLException se) {
                if (se.getSQLState().equalsIgnoreCase("08004")) {
                    Log.getLogWriter().info("Got expected invalid credentials, continuing tests");
                    return;
                }
                SQLHelper.handleSQLException(se);
            }
            throw new TestException("does not get invalid credentials exception while using invalid credentials");
        }
        SQLHelper.handleMissedSQLException(exList);
    }

    protected void connectWithNoCredentials() {
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        if (hasDerbyServer) {
            try {
                ClientDiscDBManager.getNoneAuthConnection(this.getMyTid());
            }
            catch (SQLException se) {
                SQLHelper.handleDerbySQLException(se, exList);
            }
            try {
                GFEDBManager.getNoneAuthConnection(this.getMyTid());
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exList);
            }
        } else {
            try {
                GFEDBManager.getInvalidAuthConnection(this.getMyTid());
            }
            catch (SQLException se) {
                if (se.getSQLState().equalsIgnoreCase("08004")) {
                    Log.getLogWriter().info("Got expected invalid credentials, continuing tests");
                    return;
                }
                SQLHelper.handleSQLException(se);
            }
            throw new TestException("does not get invalid credentials exception while using no credentials");
        }
        SQLHelper.handleMissedSQLException(exList);
    }

    public static void HydraTask_populateTables() {
        ssTest.populateTables();
    }

    @Override
    protected void populateTables() {
        Connection dConn = this.getCorrectDerbyAuthConnection();
        Connection gConn = this.getAuthGfxdConnection();
        this.populateTables(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_getUserAccessPriviledge() {
        ssTest.getUserAccessPriviledge();
    }

    protected void getUserAccessPriviledge() {
        Connection dConn = null;
        Connection gConn = null;
        if (hasDerbyServer) {
            dConn = this.getDerbySuperUserConnection();
            AuthenticationTest.logFullAccessUsers(dConn);
            AuthenticationTest.logReadyOnlyAccessUsers(dConn);
        }
        gConn = this.getGfxdSuperUserConnection();
        AuthenticationTest.logFullAccessUsers(gConn);
        AuthenticationTest.logReadyOnlyAccessUsers(gConn);
        AuthenticationTest.getGfxdAuthorizationInfo(gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_setUserAccessPriviledge() {
        ssTest.setUserAccessPriviledge();
    }

    protected void setUserAccessPriviledge() {
        Connection dConn = null;
        Connection gConn = this.getGfxdSuperUserConnection();
        this.setUserAccessPriviledge(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void setUserAccessPriviledge(Connection dConn, Connection gConn) {
        Map userPasswd = (Map)SQLBB.getBB().getSharedMap().get((Object)userPasswdMap);
        StringBuilder fullAccessUsers = new StringBuilder();
        StringBuilder readOnlyAccessUsers = new StringBuilder();
        for (String e : userPasswd.keySet()) {
            if (e.equalsIgnoreCase("thr_" + this.getMyTid())) {
                fullAccessUsers.append(e + ",");
                continue;
            }
            if (random.nextBoolean()) {
                fullAccessUsers.append(e + ",");
                continue;
            }
            readOnlyAccessUsers.append(e + ",");
        }
        fullAccessUsers.delete(fullAccessUsers.lastIndexOf(","), fullAccessUsers.length());
        readOnlyAccessUsers.delete(readOnlyAccessUsers.lastIndexOf(","), readOnlyAccessUsers.length());
        if (hasDerbyServer) {
            dConn = this.getDerbySuperUserConnection();
            AuthenticationTest.setFullAccessMode(dConn, gConn, fullAccessUsers.toString());
            AuthenticationTest.setReadOnlyAccessMode(dConn, gConn, readOnlyAccessUsers.toString());
        } else {
            AuthenticationTest.setUserFullAccessMode(gConn, fullAccessUsers.toString());
            AuthenticationTest.setUserReadOnlyAccessMode(gConn, readOnlyAccessUsers.toString());
        }
        AuthenticationTest.logFullAccessUsers(dConn, gConn);
        AuthenticationTest.logReadyOnlyAccessUsers(dConn, gConn);
    }

    public static synchronized void HydraTask_shutDownDerby() {
        ssTest.shutDownDerby();
    }

    protected void shutDownDerby() {
        if (hasDerbyServer) {
            ClientDiscDBManager.shutDownDB();
            discConn = null;
        }
    }

    public static synchronized void HydraTask_shutDownGemFireXD() {
        ssTest.shutDownGemFireXD();
    }

    public static synchronized void HydraTask_shutDownGemFireXDAsSuperUser() {
        ssTest.shutDownGemFireXDAsSuperUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDownGemFireXDAsSuperUser() {
        boolean[] blArray = serverStarted;
        synchronized (serverStarted) {
            if (!serverStarted[0]) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            GFEDBManager.shutDownDB();
            SQLSecurityTest.serverStarted[0] = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void shutDownGemFireXD() {
        if (!serverStarted[0]) {
            return;
        }
        GFEDBManager.shutDownDB("thr_" + this.getMyTid(), "thr_" + this.getMyTid());
        SQLSecurityTest.serverStarted[0] = false;
    }

    public static void HydraTask_createProcedures() {
        ssTest.createProcedures();
    }

    @Override
    protected void createProcedures() {
        Log.getLogWriter().info("performing create procedure Op, myTid is " + this.getMyTid());
        Connection dConn = this.getCorrectDerbyAuthConnection();
        Connection gConn = this.getAuthGfxdConnection();
        this.createProcedures(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected Connection getCorrectDerbyAuthConnection() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = !bootedAsSuperUser && systemUser.equalsIgnoreCase(userPrefix + this.getMyTid()) ? this.getDerbySuperUserConnection() : this.getAuthDerbyConnection();
        }
        return dConn;
    }

    public static void HydraTask_doDMLOp() {
        ssTest.doDMLOp();
    }

    public static void HydraTask_doOps() {
        ssTest.doOps();
    }

    @Override
    protected void doOps() {
        if (random.nextInt(100) == 1) {
            this.connectWithInvalidPassword();
        }
        Connection dConn = this.getCorrectDerbyAuthConnection();
        Connection gConn = this.getAuthGfxdConnection();
        this.doOps(dConn, gConn);
        if (hasDerbyServer) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        if (hasDerbyServer) {
            this.waitForBarrier();
        }
    }

    protected void doOps(Connection dConn, Connection gConn) {
        this.doAuthOp(dConn, gConn);
        if (hasDerbyServer) {
            this.waitForBarrier();
        }
        if (hasRoutine) {
            boolean dmlOp;
            int num = 10;
            boolean bl = dmlOp = random.nextInt(num) != 0;
            if (dmlOp) {
                this.doDMLOp(dConn, gConn);
            } else if (random.nextBoolean()) {
                this.doDDLOp(dConn, gConn);
            } else {
                this.callProcedures(dConn, gConn);
            }
        } else {
            this.doDMLOp(dConn, gConn);
        }
    }

    @Override
    protected void doDMLOp() {
        this.doAuthOp();
        if (hasDerbyServer) {
            this.waitForBarrier();
        }
        Connection dConn = this.getCorrectDerbyAuthConnection();
        Connection gConn = this.getAuthGfxdConnection();
        this.doDMLOp(dConn, gConn);
        if (hasDerbyServer) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        if (hasDerbyServer) {
            this.waitForBarrier();
        }
    }

    public static void HydraTask_doAuthOp() {
        ssTest.doAuthOp();
    }

    protected void doAuthOp() {
        Connection dConn = this.getCorrectDerbyAuthConnection();
        Connection gConn = this.getAuthGfxdConnection();
        this.doAuthOp(dConn, gConn);
        if (hasDerbyServer) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void doAuthOp(Connection dConn, Connection gConn) {
        DDLStmtIF authStmt = ddlFactory.createDDLStmt(2);
        authStmt.doDDLOp(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
        Log.getLogWriter().info("done ddlOp");
    }

    public static void HydraTask_verifyResultSets() {
        ssTest.verifyResultSets();
    }

    @Override
    protected void verifyResultSets() {
        if (!hasDerbyServer) {
            Log.getLogWriter().info("skipping verification of query results due to manageDerbyServer as false, myTid=" + this.getMyTid());
            return;
        }
        Connection dConn = this.getAuthDerbyConnection();
        Connection gConn = this.getAuthGfxdConnection();
        this.verifyResultSets(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    public static synchronized void HydraTask_reStartAuthFabricServerWithAuthorizationAsSuperUser() {
        ssTest.reStartAuthFabricServerWithAuthorizationAsSuperUser();
    }

    protected void reStartAuthFabricServerWithAuthorizationAsSuperUser() {
        if (serverStarted[0]) {
            Log.getLogWriter().info("to workaround #42499, no more fabric servers will be started");
            return;
        }
        Properties p = FabricServerHelper.getBootProperties();
        Log.getLogWriter().info("gfxd sqlAuthorization is " + p.getProperty("gemfirexd.sql-authorization"));
        p.setProperty("gemfirexd.sql-authorization", "true");
        Log.getLogWriter().info("boot with this sqlAuthorization setting -- gemfirexd.sql-authorization=" + p.getProperty("gemfirexd.sql-authorization"));
        FabricServer fs = FabricServiceManager.getFabricServerInstance();
        p.setProperty("table-default-partitioned", "true");
        if (p != null && "false".equalsIgnoreCase(p.getProperty("host-data")) && "true".equalsIgnoreCase(p.getProperty("persist-dd"))) {
            p.setProperty("persist-dd", "false");
        }
        try {
            fs.start(p);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        SQLSecurityTest.serverStarted[0] = true;
        sqlAuthorization = true;
    }

    public static void HydraTask_setSuperUserConnections() {
        ssTest.initThreadLocalConnection();
    }

    protected void initThreadLocalConnection() {
        if (hasDerbyServer) {
            Connection derbySuperUser = this.getDerbySuperUserConnection();
            derbySuperUserConn.set((Object)derbySuperUser);
        }
        if (bootedAsSuperUser) {
            Connection gfxdSuperUser = this.getGfxdSuperUserConnection();
            gfxdSuperUserConn.set((Object)gfxdSuperUser);
        } else {
            Log.getLogWriter().info("booted as systemUser, getting connection as systemUser");
            Connection gfxdSystemUser = this.getGfxdSystemUserConnection();
            gfxdSystemUserConn.set((Object)gfxdSystemUser);
        }
    }

    public static synchronized void HydraTask_shutdownFabricServers() {
        if (ssTest == null) {
            ssTest = new SQLSecurityTest();
        }
        ssTest.shutdownFabricServers();
    }

    public static void HydraTask_shutdownFabricLocators() {
        if (ssTest == null) {
            ssTest = new SQLSecurityTest();
        }
        ssTest.shutdownFabricLocators();
    }

    protected void shutdownFabricServers() {
        FabricService fs = FabricServiceManager.currentFabricServiceInstance();
        if (fs == null) {
            Log.getLogWriter().info("fabric server already shut down");
            return;
        }
        Properties p = new Properties();
        String user = bootedAsSuperUser ? "superUser" : "thr_" + this.getMyTid();
        p.setProperty("gemfirexd.user." + user, user);
        p.setProperty(random.nextBoolean() ? "UserName" : "user", user);
        p.setProperty("password", user);
        try {
            fs.stop(p);
            Log.getLogWriter().info("fabric server has been shut down");
        }
        catch (SQLException se) {
            if (se.getSQLState().equalsIgnoreCase("08004")) {
                Log.getLogWriter().info("Got expected invalid credentials, continuing tests");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected void shutdownFabricLocators() {
        this.shutdownFabricServers();
    }

    public static void HydraTask_delegatePrivilege() {
        ssTest.delegatePrivilege();
    }

    protected void delegatePrivilege() {
        Log.getLogWriter().info("performing ddlOp, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getAuthDerbyConnection();
        }
        Connection gConn = this.getAuthGfxdConnection();
        AuthorizationDDLStmt authDDL = new AuthorizationDDLStmt();
        authDDL.delegateGrantOption(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_grantDelegatedPrivilege() {
        ssTest.grantDelegatedPrivilege();
    }

    public static void HydraTask_revokeDelegatedPrivilege() {
        ssTest.revokeDelegatedPrivilege();
    }

    protected void grantDelegatedPrivilege() {
        Log.getLogWriter().info("performing ddlOp, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getAuthDerbyConnection();
        }
        Connection gConn = this.getAuthGfxdConnection();
        AuthorizationDDLStmt authDDL = new AuthorizationDDLStmt();
        authDDL.useDelegatedPrivilege(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void revokeDelegatedPrivilege() {
        Log.getLogWriter().info("performing ddlOp, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getAuthDerbyConnection();
        }
        Connection gConn = this.getAuthGfxdConnection();
        AuthorizationDDLStmt authDDL = new AuthorizationDDLStmt();
        authDDL.revokeDelegatedPrivilege(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_populateThruLoader() {
        int number = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.populateThruLoader);
        if (number == 1) {
            ssTest.assignSelectToMe();
            ssTest.populateThruLoader();
        }
    }

    @Override
    protected void populateThruLoader() {
        try {
            Connection gConn = GFEDBManager.getAuthConnection(this.getMyTid());
            this.populateThruLoader(gConn);
            this.closeGFEConnection(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void assignSelectToMe() {
        Connection dConn = this.getDerbySuperUserConnection();
        Connection gConn = this.getGfxdSuperUserConnection();
        new AuthorizationDDLStmt().assignSelectToMe(dConn, gConn, this.getMyTid());
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    static {
        userPasswdMap = "userPasswdMap";
        systemUserPasswdMap = "systemUserPasswdMap";
        userPrefix = "thr_";
        serverStarted = new boolean[1];
        sqlAuthorization = TestConfig.tab().booleanAt(FabricSecurityPrms.sqlAuthorization, false);
        useBUILTIN = TestConfig.tab().booleanAt(SQLPrms.useBUILTINSchema, true);
        gfxdUserCreated = "userCreated";
        bootedAsSuperUser = true;
        useLDAP = TestConfig.tab().booleanAt(SQLPrms.useLDAPSchema, false);
        systemUser = null;
        hasMultiSystemUsers = TestConfig.tab().booleanAt(SQLPrms.hasMultiSystemUsers, false);
        hasRoutine = TestConfig.tab().booleanAt(SQLPrms.hasRoutineInSecurityTest, false);
        prepareStmtException = new HydraThreadLocal();
        derbySuperUserConn = new HydraThreadLocal();
        gfxdSuperUserConn = new HydraThreadLocal();
        gfxdSystemUserConn = new HydraThreadLocal();
    }
}

