/*
 * Decompiled with CFR 0.152.
 */
package sql.security.thinClient;

import hydra.Log;
import hydra.RemoteTestModule;
import hydra.gemfirexd.GfxdConfigPrms;
import hydra.gemfirexd.NetworkServerHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import sql.ClientDiscDBManager;
import sql.GFEDBClientManager;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.ddlStatements.AuthorizationDDLStmt;
import sql.security.SQLSecurityTest;
import util.PRObserver;
import util.TestException;
import util.TestHelper;

public class SQLBridgeSecurityTest
extends SQLSecurityTest {
    protected static SQLBridgeSecurityTest sbsTest;

    public static synchronized void HydraTask_initialize() {
        if (sbsTest == null) {
            sbsTest = new SQLBridgeSecurityTest();
            if (ssTest == null) {
                ssTest = new SQLSecurityTest();
            }
            PRObserver.installObserverHook();
            PRObserver.initialize((int)RemoteTestModule.getMyVmid());
            sbsTest.initialize();
        }
    }

    public static void HydraTask_setupGfxdUserAuthentication() {
        sbsTest.setupGfxdUserAuthentication();
    }

    @Override
    protected void setupGfxdUserAuthentication() {
        Log.getLogWriter().info("in gfxd setupUserAuth");
        Connection conn = this.getGfxdSuperUserClientConnection();
        this.logGfxdSystemProperties();
        try {
            SQLBridgeSecurityTest.createGfxdUserAuthentication(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static synchronized void HydraTask_startNetworkServer() {
        String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
        NetworkServerHelper.startNetworkServers(networkServerConfig);
    }

    public static void HydraTask_createGFESchemas() {
        sbsTest.createGFESchemas();
    }

    @Override
    protected void createGFESchemas() {
        Connection conn = null;
        conn = !sqlAuthorization || !bootedAsSuperUser ? this.getAuthGfxdClientConnection() : this.getGfxdSuperUserClientConnection();
        Log.getLogWriter().info("creating schemas in gfxd.");
        if (!testServerGroupsInheritence) {
            this.createSchemas(conn);
        } else {
            String[] schemas = SQLPrms.getGFESchemas();
            this.createSchemas(conn, schemas);
        }
        Log.getLogWriter().info("done creating schemas in gfxd.");
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_createGFETables() {
        sbsTest.createFuncMonth();
        sbsTest.createGFETables();
    }

    @Override
    protected void createFuncMonth() {
        Connection conn = this.getAuthGfxdClientConnection();
        this.createFuncMonth(conn);
    }

    @Override
    protected void createGFETables() {
        Connection conn = this.getAuthGfxdClientConnection();
        Log.getLogWriter().info("dropping tables in gfe.");
        this.dropTables(conn);
        Log.getLogWriter().info("done dropping tables in gfe");
        Log.getLogWriter().info("creating tables in gfe.");
        this.createTables(conn);
        Log.getLogWriter().info("done creating tables in gfe.");
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_setTableCols() {
        sbsTest.setTableCols();
    }

    @Override
    protected void setTableCols() {
        Connection gConn = this.getAuthGfxdClientConnection();
        SQLBridgeSecurityTest.setTableCols(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    protected Connection getGfxdSuperUserClientConnection() {
        Connection conn = null;
        try {
            conn = GFEDBClientManager.getSuperUserConnection();
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection as system user " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected Connection getAuthGfxdClientConnection() {
        Connection conn = null;
        try {
            conn = GFEDBClientManager.getAuthConnection(this.getMyTid());
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected Connection getGfxdSystemUserClientConnection() {
        Connection conn = null;
        try {
            conn = GFEDBClientManager.getAuthConnection(systemUser);
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection as system user " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    public static void HydraTask_connectWithInvalidPassword() {
        sbsTest.connectWithInvalidPassword();
    }

    public static void HydraTask_connectWithNoCredentials() {
        sbsTest.connectWithNoCredentials();
    }

    @Override
    protected void connectWithInvalidPassword() {
        ArrayList<SQLException> exList;
        if (hasDerbyServer) {
            exList = new ArrayList<SQLException>();
            try {
                ClientDiscDBManager.getInvalidAuthConnection(this.getMyTid());
            }
            catch (SQLException se) {
                SQLHelper.handleDerbySQLException(se, exList);
            }
            try {
                GFEDBClientManager.getInvalidAuthConnection(this.getMyTid());
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exList);
            }
        } else {
            try {
                GFEDBClientManager.getInvalidAuthConnection(this.getMyTid());
            }
            catch (SQLException se) {
                if (se.getSQLState().equalsIgnoreCase("08004")) {
                    Log.getLogWriter().info("Got expected invalid credentials, continuing tests");
                    return;
                }
                SQLHelper.handleSQLException(se);
            }
            throw new TestException("does not get invalid credentials exception while using invalid credentials");
        }
        SQLHelper.handleMissedSQLException(exList);
    }

    @Override
    protected void connectWithNoCredentials() {
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        if (hasDerbyServer) {
            try {
                ClientDiscDBManager.getNoneAuthConnection(this.getMyTid());
            }
            catch (SQLException se) {
                SQLHelper.handleDerbySQLException(se, exList);
            }
            try {
                GFEDBClientManager.getNoneAuthConnection(this.getMyTid());
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exList);
            }
        } else {
            try {
                GFEDBClientManager.getInvalidAuthConnection(this.getMyTid());
            }
            catch (SQLException se) {
                if (se.getSQLState().equalsIgnoreCase("08004")) {
                    Log.getLogWriter().info("Got expected invalid credentials, continuing tests");
                    return;
                }
                SQLHelper.handleSQLException(se);
            }
            throw new TestException("does not get invalid credentials exception while using no credentials");
        }
        SQLHelper.handleMissedSQLException(exList);
    }

    public static void HydraTask_setSuperUserConnections() {
        sbsTest.initThreadLocalConnection();
    }

    @Override
    protected void initThreadLocalConnection() {
        if (hasDerbyServer) {
            Connection derbySuperUser = this.getDerbySuperUserConnection();
            derbySuperUserConn.set((Object)derbySuperUser);
        }
        if (bootedAsSuperUser) {
            Connection gfxdSuperUser = this.getGfxdSuperUserClientConnection();
            gfxdSuperUserConn.set((Object)gfxdSuperUser);
        } else {
            Log.getLogWriter().info("booted as systemUser, getting connection as systemUser");
            Connection gfxdSystemUser = this.getGfxdSystemUserClientConnection();
            gfxdSystemUserConn.set((Object)gfxdSystemUser);
        }
    }

    public static void HydraTask_provideAllPrivToAll() {
        sbsTest.provideAllPrivToAll();
    }

    @Override
    protected void provideAllPrivToAll() {
        Log.getLogWriter().info("performing ddlOp, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getAuthDerbyConnection();
        }
        Connection gConn = this.getAuthGfxdClientConnection();
        AuthorizationDDLStmt authDDL = new AuthorizationDDLStmt();
        authDDL.provideAllPrivToAll(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_populateTables() {
        sbsTest.populateTables();
    }

    @Override
    protected void populateTables() {
        Connection dConn = this.getCorrectDerbyAuthConnection();
        Connection gConn = this.getAuthGfxdClientConnection();
        this.populateTables(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_verifyResultSets() {
        sbsTest.verifyResultSets();
    }

    @Override
    protected void verifyResultSets() {
        if (!hasDerbyServer) {
            Log.getLogWriter().info("skipping verification of query results due to manageDerbyServer as false, myTid=" + this.getMyTid());
            return;
        }
        Connection dConn = this.getAuthDerbyConnection();
        Connection gConn = this.getAuthGfxdClientConnection();
        this.verifyResultSets(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_doOps() {
        sbsTest.doOps();
    }

    @Override
    protected void doOps() {
        Connection dConn = this.getCorrectDerbyAuthConnection();
        Connection gConn = this.getAuthGfxdClientConnection();
        this.doOps(dConn, gConn);
        if (hasDerbyServer) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        if (hasDerbyServer) {
            this.waitForBarrier();
        }
    }
}

