/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlBridge;

import com.pivotal.gemfirexd.internal.drda.NetworkServerControl;
import hydra.ClientVmInfo;
import hydra.DistributedSystemHelper;
import hydra.HostHelper;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.PortHelper;
import hydra.Prms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.gemfirexd.GfxdConfigPrms;
import hydra.gemfirexd.NetworkServerHelper;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import splitBrain.SplitBrainBB;
import sql.GFEDBClientManager;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.ddlStatements.DDLStmtIF;
import sql.ddlStatements.FunctionDDLStmt;
import sql.ddlStatements.ProcedureDDLStmt;
import sql.ddlStatements.Procedures;
import sql.sqlutil.ResultSetHelper;
import util.PRObserver;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class SQLBridgeTest
extends SQLTest {
    protected static SQLBridgeTest sqlbtest;
    protected static boolean useMcast;
    protected static String locatorString;
    protected static Properties bootProps;
    protected static Properties connProps;
    protected static String hostName;
    protected static int portNo;
    protected static NetworkServerControl netServer;
    public static boolean useGemFireXDHA;
    public static HydraThreadLocal myConn;
    static String[] getQueries;

    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startAndConnectLocatorTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void stopLocatorTask() {
        DistributedSystemHelper.stopLocator();
    }

    public static void HydraTask_initForServerGroup() {
        if (sqlbtest == null) {
            sqlbtest = new SQLBridgeTest();
        }
        sqlbtest.initForServerGroup();
    }

    public static synchronized void HydraTask_initializeServer() {
        if (sqlbtest == null) {
            sqlbtest = new SQLBridgeTest();
        }
        PRObserver.installObserverHook();
        PRObserver.initialize((int)RemoteTestModule.getMyVmid());
        SQLBridgeTest.initializeParams();
    }

    private static void initializeParams() {
        hasDerbyServer = TestConfig.tab().booleanAt(Prms.manageDerbyServer, false);
        testUniqueKeys = TestConfig.tab().booleanAt(SQLPrms.testUniqueKeys, true);
        randomData = TestConfig.tab().booleanAt(SQLPrms.randomData, false);
        isSerial = TestConfig.tab().booleanAt(Prms.serialExecution, false);
        isSingleDMLThread = TestConfig.tab().booleanAt(SQLPrms.isSingleDMLThread, false);
        usingTrigger = TestConfig.tab().booleanAt(SQLPrms.usingTrigger, false);
        queryAnyTime = TestConfig.tab().booleanAt(SQLPrms.queryAnyTime, true);
        hasNetworth = TestConfig.tab().booleanAt(SQLPrms.hasNetworth, false);
    }

    public static synchronized void HydraTask_initialize() {
        if (sqlbtest == null) {
            sqlbtest = new SQLBridgeTest();
        }
        PRObserver.installObserverHook();
        PRObserver.initialize((int)RemoteTestModule.getMyVmid());
        bootProps = sqlbtest.getGemFireProperties();
        bootProps.setProperty("host-data", "true");
        hostName = HostHelper.getIPAddress().getHostName();
        Log.getLogWriter().info("Connecting with properties: " + bootProps);
        SQLBridgeTest.initializeParams();
    }

    public static synchronized void HydraTask_initialize_replayHA() {
        Object initDelayed = SQLBB.getBB().getSharedMap().get((Object)("initDelayed_" + RemoteTestModule.getMyVmid()));
        if (initDelayed == null) {
            SQLBB.getBB().getSharedMap().put((Object)("initDelayed_" + RemoteTestModule.getMyVmid()), (Object)"true");
            Log.getLogWriter().info("first time for init DDL replay, do nothing");
            return;
        }
        if (sqlbtest == null) {
            sqlbtest = new SQLBridgeTest();
            SQLBridgeTest.HydraTask_initialize();
            sqlbtest.createGFXDDB();
            int numOfPRs = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs);
            ArrayList<ClientVmInfo> vms = new ArrayList<ClientVmInfo>();
            vms.add(new ClientVmInfo(RemoteTestModule.getMyVmid()));
            PRObserver.waitForRebalRecov(vms, (int)1, (int)numOfPRs, null, null, (boolean)false);
            StopStartVMs.StopStart_initTask();
        }
        int sleepMS = 30000;
        Log.getLogWriter().info("sleep for " + sleepMS / 1000 + " sec");
        MasterController.sleepForMs((int)sleepMS);
    }

    public static synchronized void HydraTask_initConnBridgePort() {
        ArrayList<Integer> portLists;
        portNo = PortHelper.getRandomPort();
        int count = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.initServerPort);
        while (count != 1) {
            count = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.initServerPort);
        }
        HashMap map = (HashMap)SQLBB.getBB().getSharedMap().get((Object)"serverPorts");
        if (map == null) {
            map = new HashMap();
            portLists = new ArrayList<Integer>();
        } else {
            portLists = (ArrayList<Integer>)map.get(hostName);
            if (portLists == null) {
                portLists = new ArrayList();
            }
        }
        portLists.add(portNo);
        map.put(hostName, portLists);
        SQLBB.getBB().getSharedMap().put((Object)"serverPorts", map);
        SQLBB.getBB().getSharedCounters().zero(SQLBB.initServerPort);
        Log.getLogWriter().info("host " + hostName + " port " + portNo + " is available for client connection");
    }

    protected static String getLocatorString() {
        List endpoints = DistributedSystemHelper.getEndpoints();
        return DistributedSystemHelper.endpointsToString((List)endpoints);
    }

    public static synchronized void HydraTask_createGFXDDB() {
        sqlbtest.createGFXDDB();
        Object tableCreated = SQLBB.getBB().getSharedMap().get((Object)("tableCreated_" + RemoteTestModule.getMyVmid()));
        if (tableCreated == null) {
            SQLBB.getBB().getSharedMap().put((Object)("tableCreated_" + RemoteTestModule.getMyVmid()), (Object)"true");
            Log.getLogWriter().info("first time, table has not been created, do nothing");
            return;
        }
        if (isHATest) {
            SQLBridgeTest.addObserver();
        }
    }

    public static synchronized void HydraTask_startFabricServer() {
        sqlbtest.startFabricServer();
    }

    public static synchronized void HydraTask_startFabricServerSG() {
        sqlbtest.startFabricServerSG();
    }

    public static synchronized void HydraTask_createGFXDDBSGDBSynchronizer() {
        sqlbtest.createGFXDDBSGDBSynchronizer();
    }

    public static synchronized void HydraTask_startNetworkServer() {
        String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
        NetworkServerHelper.startNetworkServers(networkServerConfig);
    }

    public static synchronized void HydraTask_stopFabricServer() {
        sqlbtest.stopFabricServer();
    }

    @Override
    protected void createGFXDDB() {
        this.startGFXDDB(bootProps);
    }

    protected static void addObserver() {
        int numOfPRs = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs);
        ArrayList<ClientVmInfo> vms = new ArrayList<ClientVmInfo>();
        vms.add(new ClientVmInfo(RemoteTestModule.getMyVmid()));
        PRObserver.waitForRebalRecov(vms, (int)1, (int)numOfPRs, null, null, (boolean)false);
        StopStartVMs.StopStart_initTask();
    }

    public static synchronized void HydraTask_initEdges() {
        if (sqlbtest == null) {
            sqlbtest = new SQLBridgeTest();
        }
        hasDerbyServer = TestConfig.tab().booleanAt(Prms.manageDerbyServer, false);
        testUniqueKeys = TestConfig.tab().booleanAt(SQLPrms.testUniqueKeys, true);
        randomData = TestConfig.tab().booleanAt(SQLPrms.randomData, false);
        isSerial = TestConfig.tab().booleanAt(Prms.serialExecution, false);
        isSingleDMLThread = TestConfig.tab().booleanAt(SQLPrms.isSingleDMLThread, false);
        usingTrigger = TestConfig.tab().booleanAt(SQLPrms.usingTrigger, false);
        queryAnyTime = TestConfig.tab().booleanAt(SQLPrms.queryAnyTime, true);
        hasNetworth = TestConfig.tab().booleanAt(SQLPrms.hasNetworth, false);
        isEdge = true;
    }

    public static synchronized void HydraTask_createGFXDNetServer() throws Exception {
        sqlbtest.createGFXDNetServer();
    }

    protected void createGFXDNetServer() throws Exception {
        netServer = new NetworkServerControl(InetAddress.getByName(hostName), portNo);
        netServer.start(new PrintWriter(System.out));
        while (true) {
            MasterController.sleepForMs((int)500);
            try {
                netServer.ping();
            }
            catch (Exception e) {
                Log.getLogWriter().info("could not ping netServer " + TestHelper.getStackTrace((Throwable)e));
                continue;
            }
            break;
        }
        netServer.logConnections(true);
    }

    public static void HydraTask_createGFESchemasByClients() {
        sqlbtest.createGFESchemasByClients();
    }

    protected void createGFESchemasByClients() {
        ddlThread = this.getMyTid();
        Connection conn = this.getGFXDClientConnection();
        Log.getLogWriter().info("creating schema in gfxd.");
        if (!testServerGroupsInheritence) {
            this.createSchemas(conn);
        } else {
            String[] schemas = SQLPrms.getGFESchemas();
            this.createSchemas(conn, schemas);
        }
        Log.getLogWriter().info("done creating schema in gfxd.");
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_createGFETablesByClients() {
        sqlbtest.createGFETablesByClients();
    }

    protected void createGFETablesByClients() {
        Connection conn = this.getGFXDClientConnection();
        Log.getLogWriter().info("creating tables in gfxd.");
        this.createTables(conn);
        Log.getLogWriter().info("done creating tables in gfxd.");
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_populateTables() {
        sqlbtest.populateTables();
    }

    @Override
    protected void populateTables() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDClientConnection();
        this.populateTables(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_doDMLOp() {
        sqlbtest.doDMLOp();
    }

    @Override
    protected void doDMLOp() {
        if (networkPartitionDetectionEnabled) {
            this.doDMLOp_HandlePartition();
        } else {
            Connection dConn = null;
            if (hasDerbyServer) {
                dConn = this.getDiscConnection();
            }
            Connection gConn = this.getGFXDClientConnection();
            this.doDMLOp(dConn, gConn);
            if (dConn != null) {
                this.closeDiscConnection(dConn);
            }
            this.closeGFEConnection(gConn);
        }
        Log.getLogWriter().info("done dmlOp");
    }

    public static void HydraTask_createIndex() {
        sqlbtest.createIndex();
    }

    @Override
    protected void createIndex() {
        Connection gConn = this.getGFXDClientConnection();
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (setTx && isHATest) {
            this.resetNodeFailureFlag();
        }
        if (setTx && testEviction) {
            this.resetEvictionConflictFlag();
        }
        this.createIndex(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    @Override
    protected List<ClientVmInfo> stopStartVMs(int numToKill) {
        if (useGemFireXDHA) {
            return this.stopStartVMs(numToKill, "server");
        }
        return this.stopStartVMs(numToKill, "store");
    }

    public static void HydraTask_setTableCols() {
        sqlbtest.setTableCols();
    }

    @Override
    protected void setTableCols() {
        Connection gConn = this.getGFXDClientConnection();
        SQLBridgeTest.setTableCols(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_cycleStoreVms() {
        if (cycleVms) {
            sqlbtest.cycleStoreVms();
        }
    }

    public static synchronized void HydraTask_createDiscDB() {
        sqlbtest.createDiscDB();
    }

    public static synchronized void HydraTask_createDiscSchemas() {
        sqlbtest.createDiscSchemas();
    }

    public static synchronized void HydraTask_createDiscTables() {
        sqlbtest.createDiscTables();
    }

    public static void HydraTask_createProcedures() {
        sqlbtest.createProcedures();
    }

    public static void HydraTask_verifyProcedures() {
        sqlbtest.verifyProcedures();
    }

    @Override
    protected void createProcedures() {
        Log.getLogWriter().info("performing create procedure Op, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDClientConnection();
        ProcedureDDLStmt procStmt = new ProcedureDDLStmt();
        procStmt.createDDLs(dConn, gConn);
        if (dConn != null) {
            this.commit(dConn);
            this.closeDiscConnection(dConn);
        }
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    @Override
    protected void verifyProcedures() {
        if (!hasDerbyServer) {
            Log.getLogWriter().warning("skipping verify of query results through created procedure call due to manageDerbyServer as false, myTid=" + this.getMyTid());
            return;
        }
        Log.getLogWriter().info("verifying query results through created procedure call, myTid is " + this.getMyTid());
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFXDClientConnection();
        this.verifyProcedures(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_callProcedures() {
        sqlbtest.callProcedures();
    }

    @Override
    protected void callProcedures() {
        Log.getLogWriter().info("call procedures, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDClientConnection();
        Procedures.callProcedures(dConn, gConn);
        if (hasDerbyServer) {
            this.commit(dConn);
            this.closeDiscConnection(dConn);
        }
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_doOp() {
        boolean dmlOp;
        int num = 10;
        boolean bl = dmlOp = random.nextInt(num) != 0;
        if (dmlOp) {
            sqlbtest.doDMLOp();
        } else {
            sqlbtest.doDDLOp();
        }
    }

    @Override
    protected void doDDLOp() {
        Log.getLogWriter().info("performing ddlOp, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDClientConnection();
        int ddl = ddls[random.nextInt(ddls.length)];
        DDLStmtIF ddlStmt = ddlFactory.createDDLStmt(ddl);
        ddlStmt.doDDLOp(dConn, gConn);
        if (hasDerbyServer) {
            this.commit(dConn);
            this.closeDiscConnection(dConn);
        }
        this.commit(gConn);
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done DDLOp");
    }

    public static void HydraTask_createFuncForProcedures() {
        sqlbtest.createFuncForProcedures();
    }

    @Override
    protected void createFuncForProcedures() {
        Log.getLogWriter().info("performing create function multiply Op, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDClientConnection();
        try {
            FunctionDDLStmt.createFuncMultiply(dConn);
            FunctionDDLStmt.createFuncMultiply(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        if (dConn != null) {
            this.commit(dConn);
            this.closeDiscConnection(dConn);
        }
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_createGFXDDBSG() {
        sqlbtest.createGFXDDBSG();
    }

    public static void HydraTask_startFabricServerSGDBSynchronizer() {
        sqlbtest.startFabricServerSGDBSynchronizer();
    }

    public static synchronized void HydraTask_createDBSynchronizer() {
        sqlbtest.createDBSynchronizer();
    }

    public static synchronized void HydraTask_createOracleDBSynchronizer() throws SQLException {
        sqlbtest.createOracleDBSynchronizer();
    }

    @Override
    protected void createOracleDBSynchronizer() throws SQLException {
        Connection conn = this.getGFXDClientConnection();
        this.createOracleDBSynchronizer(conn);
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    @Override
    protected void createDBSynchronizer() {
        Connection conn = this.getGFXDClientConnection();
        this.createNewDBSynchronizer(conn);
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    public static synchronized void HydraTask_startDBSynchronizer() {
        sqlbtest.startDBSynchronizer();
    }

    @Override
    protected void startDBSynchronizer() {
        boolean useNewApi = true;
        Connection conn = this.getGFXDClientConnection();
        if (useNewApi) {
            this.startNewDBSynchronizer(conn);
        } else {
            this.startDBSynchronizer(conn);
        }
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_populateTablesDBSynchronizer() {
        sqlbtest.populateTablesDBSynchronizer();
    }

    @Override
    protected void populateTablesDBSynchronizer() {
        Connection gConn = this.getGFXDClientConnection();
        this.populateTables(null, gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_doDMLOpDBSynchronizer() {
        sqlbtest.doDMLOpDBSynchronizer();
    }

    @Override
    protected void doDMLOpDBSynchronizer() {
        Connection gConn = this.getGFXDClientConnection();
        this.doDMLOp(null, gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_putLastKeyDBSynchronizer() {
        sqlbtest.putLastKeyDBSynchronizer();
    }

    @Override
    protected void putLastKeyDBSynchronizer() {
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFXDClientConnection();
        this.putLastKeyDBSynchronizer(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_verifyResultSetsDBSynchronizer() {
        sqlbtest.verifyResultSetsDBSynchronizer();
    }

    @Override
    protected void verifyResultSetsDBSynchronizer() {
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFXDClientConnection();
        this.verifyResultSets(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    public static synchronized void HydraTask_createDiskStores() {
        sqlbtest.createDiskStores();
    }

    @Override
    protected void createDiskStores() {
        Connection conn = this.getGFXDClientConnection();
        this.createDiskStores(conn);
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_setMyConn() {
        sqlbtest.setMyConn();
    }

    protected Connection getMyGFXDClientConnection() {
        Connection conn = null;
        try {
            conn = GFEDBClientManager.getMyConnection();
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get the connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected void setMyConn() {
        Connection conn = this.getMyGFXDClientConnection();
        myConn.set((Object)conn);
    }

    public static void HydraTask_getQuery() {
        sqlbtest.getQuery();
    }

    protected void getQuery() {
        Connection conn = (Connection)myConn.get();
        this.getConvertQuery(conn);
    }

    protected void getConvertQuery(Connection conn) {
        try {
            String whichQuery = getQueries[random.nextInt(getQueries.length)];
            Log.getLogWriter().info(whichQuery);
            PreparedStatement query = conn.prepareStatement(whichQuery);
            this.executeQuery(query, conn);
        }
        catch (SQLException se) {
            throw new TestException("could not execute query: " + TestHelper.getStackTrace((Throwable)se));
        }
    }

    private void executeQuery(PreparedStatement query, Connection conn) {
        ResultSet rs = null;
        for (int i = 0; i < 100; ++i) {
            try {
                int key = random.nextInt(300);
                query.setInt(1, key);
                Log.getLogWriter().info("selected primary key is " + key);
                rs = query.executeQuery();
                ResultSetHelper.asList(rs, false);
            }
            catch (SQLException se) {
                try {
                    throw new TestException("could not execute query: " + TestHelper.getStackTrace((Throwable)se));
                }
                catch (Throwable throwable) {
                    SQLHelper.closeResultSet(rs, conn);
                    throw throwable;
                }
            }
            SQLHelper.closeResultSet(rs, conn);
        }
    }

    public static void HydraTask_populateGetTablesForGet() {
        sqlbtest.populateTablesForGet();
    }

    protected void populateTablesForGet() {
        Connection gConn = (Connection)myConn.get();
        if (this.getMyTid() % 15 == 0) {
            this.populateTables(null, gConn);
        }
    }

    public static void HydraTask_verifyResultSets() {
        sqlbtest.verifyResultSets();
    }

    @Override
    protected void verifyResultSets() {
        if (!hasDerbyServer) {
            Log.getLogWriter().info("skipping verification of query results due to manageDerbyServer as false, myTid=" + this.getMyTid());
            return;
        }
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFXDClientConnection();
        this.verifyResultSets(dConn, gConn);
        this.closeGFEConnection(gConn);
        this.closeDiscConnection(dConn);
    }

    public static void HydraTask_verifyScrollableResultSet() {
        int chance = 5;
        if (random.nextInt(chance) == 1) {
            sqlbtest.verifyScrollableResultSet();
        } else {
            sqlbtest.doDMLOp();
        }
    }

    @Override
    protected void verifyScrollableResultSet() {
        if (!hasDerbyServer) {
            Connection gConn = this.getGFXDClientConnection();
            this.verifyScrollableResultSet(gConn);
            this.commit(gConn);
            this.closeGFEConnection(gConn);
            return;
        }
        if (!testUniqueKeys) {
            Log.getLogWriter().info("Do not have derby server to verify results");
            return;
        }
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFXDClientConnection();
        this.verifyScrollableResultSet(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
        this.closeDiscConnection(dConn);
    }

    public static void HydraTask_alterTableGenerateDefaultId() {
        sqlbtest.alterTableGenerateDefaultId();
    }

    @Override
    protected void alterTableGenerateDefaultId() {
        Connection gConn = this.getGFXDClientConnection();
        this.alterTableGenerateDefaultId(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_createUniqIndex() {
        sqlbtest.createUniqIndex();
    }

    public static synchronized void HydraTask_waitForReconnect() {
        boolean reconnected = sqlbtest.waitForReconnect();
        if (!reconnected) {
            throw new TestException("Wait for reconnect returned false");
        }
        SplitBrainBB.addReconnectedClient((int)RemoteTestModule.getMyVmid());
    }

    public static synchronized void HydraTask_verifyReconnect() {
        Set expectedDisconnectList = SplitBrainBB.getExpectForcedDisconnects();
        Set reconnectedClients = SplitBrainBB.getReconnectedList();
        StringBuffer aStr = new StringBuffer();
        if (!expectedDisconnectList.equals(reconnectedClients)) {
            aStr.append("Expected all clients to reconnect but only these did: " + reconnectedClients + ".   expected list is " + expectedDisconnectList + "\n");
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
        sqlbtest.reconnected();
    }

    public static void HydraTask_verifyDMLExecution() {
        SQLBridgeTest.HydraTask_doDMLOp();
    }

    @Override
    protected void reconnected() {
        Connection gConn;
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        if ((gConn = this.getGFEConnection()) == null || hasDerbyServer && dConn == null) {
            throw new TestException("After reconnect connections were found to be null. dConn =  " + dConn + " gConn = " + gConn);
        }
    }

    public static void HydraTask_createCompaniesTable() {
        sqlbtest.createCompaniesTable();
    }

    public static void HydraTask_createIndexOnCompanies() {
        sqlbtest.createIndexOnCompanies();
    }

    public static void hydraTask_createUDTPriceFunctions() {
        sqlbtest.createUDTPriceFunctions();
    }

    public static void HydraTask_createUDTPriceType() {
        sqlbtest.createUDTPriceType();
    }

    public static void HydraTask_createUUIDType() {
        sqlbtest.createUUIDType();
    }

    public static void HydraTask_dropCompaniesFK() {
        sqlbtest.dropCompaniesFK();
    }

    public static void HydraTask_addCompaniesFK() {
        if (ticket46803fixed) {
            sqlbtest.addCompaniesFK();
        }
    }

    public static void HydraTask_alterTableDropColumn() {
        sqlbtest.alterTableDropColumn();
    }

    public static void HydraTask_createTestTrigger() throws SQLException {
        sqlbtest.createTestTrigger();
    }

    protected void createTestTrigger() throws SQLException {
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFXDClientConnection();
        this.createTestTrigger(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void createTestTrigger(Connection dConn, Connection gConn) throws SQLException {
        String createCustomerDupTable = "create table trade.customersDup as select * from trade.customers with no data";
        String createTestInsertTrigger = "CREATE TRIGGER TRADE.CUSTOMERS_INSERTTRIGGER AFTER INSERT ON TRADE.CUSTOMERS REFERENCING NEW AS NEWROW FOR EACH ROW INSERT INTO TRADE.CUSTOMERSDUP  VALUES ( NEWROW.CID ,    NEWROW.CUST_NAME ,  NEWROW.SINCE ,  NEWROW.ADDR , NEWROW.TID )";
        String createTestDeleteTrigger = "CREATE TRIGGER TRADE.CUSTOMERS_DELETETRIGGER AFTER DELETE ON TRADE.CUSTOMERS REFERENCING OLD AS OLDROW FOR EACH ROW DELETE FROM TRADE.CUSTOMERSDUP WHERE CID = OLDROW.CID";
        String createGfxdCustomerDupTable = createTableCustomersStmt.replace("trade.customers", "trade.customersDup");
        if (dConn != null) {
            Log.getLogWriter().info("In derby, executing " + createCustomerDupTable);
            dConn.createStatement().execute(createCustomerDupTable);
            Log.getLogWriter().info("In derby, executed " + createCustomerDupTable);
            Log.getLogWriter().info("In derby, executing " + createTestInsertTrigger);
            dConn.createStatement().execute(createTestInsertTrigger);
            Log.getLogWriter().info("In derby, executed " + createTestInsertTrigger);
            Log.getLogWriter().info("In derby, executing " + createTestDeleteTrigger);
            dConn.createStatement().execute(createTestDeleteTrigger);
            Log.getLogWriter().info("In derby, executed " + createTestDeleteTrigger);
            this.commit(dConn);
        }
        Log.getLogWriter().info("In gfxd, executing " + createGfxdCustomerDupTable);
        gConn.createStatement().execute(createGfxdCustomerDupTable);
        Log.getLogWriter().info("In gfxd, executed " + createGfxdCustomerDupTable);
        Log.getLogWriter().info("In gfxd, executing " + createTestInsertTrigger);
        gConn.createStatement().execute(createTestInsertTrigger);
        Log.getLogWriter().info("In gfxd, executed " + createTestInsertTrigger);
        Log.getLogWriter().info("In gfxd, executing " + createTestDeleteTrigger);
        gConn.createStatement().execute(createTestDeleteTrigger);
        Log.getLogWriter().info("In gfxd, executed " + createTestDeleteTrigger);
        this.commit(gConn);
    }

    public static void HydraTask_cleanupOracleRun() throws SQLException {
        if (sqlbtest == null) {
            sqlbtest = new SQLBridgeTest();
        }
        sqlbtest.cleanupOracleRun();
    }

    public static void HydraTask_createOracleUsers() throws SQLException {
        sqlbtest.createOracleUsers();
    }

    public static void HydraTask_createOracleTables() throws SQLException {
        sqlbtest.createOracleTables();
    }

    public static void HydraTask_putLastKeyOracleDBSynchronizer() throws SQLException {
        sqlbtest.putLastKeyOracleDBSynchronizer();
    }

    @Override
    protected void putLastKeyOracleDBSynchronizer() throws SQLException {
        Connection oraConn = this.getOracleConnection();
        Connection gConn = this.getGFXDClientConnection();
        this.putLastKeyDBSynchronizer(oraConn, gConn);
        this.closeConnection(oraConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_verifyResultSetsOracleDBSynchronizer() throws SQLException {
        sqlbtest.verifyResultSetsOracleDBSynchronizer();
    }

    @Override
    protected void verifyResultSetsOracleDBSynchronizer() throws SQLException {
        Connection oraConn = this.getOracleConnection();
        Connection gConn = this.getGFXDClientConnection();
        this.verifyResultSets(oraConn, gConn);
        this.closeConnection(oraConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_stopOracleDBSynchronizer() throws SQLException {
        if (sqlbtest == null) {
            sqlbtest = new SQLBridgeTest();
        }
        sqlbtest.stopOracleDBSynchronizer();
    }

    @Override
    protected void stopOracleDBSynchronizer() throws SQLException {
        Connection gConn = this.getGFXDClientConnection();
        this.stopOracleDBSynchronizer(gConn);
        this.closeGFEConnection(gConn);
    }

    public static synchronized void HydraTask_startFabricServer_Once() {
        if (!fabricServerStarted.get()) {
            fabricServerStarted.set(true);
            sqlbtest.startFabricServer();
        }
    }

    static {
        netServer = null;
        useGemFireXDHA = TestConfig.tab().booleanAt(SQLPrms.useGemFireXDHA, false);
        myConn = new HydraThreadLocal();
        getQueries = new String[]{"select * from trade.customers where cid = ?", "select * from trade.securities where sec_id = ?", "select * from trade.networth where cid = ?", "select * from trade.buyorders where oid = ?", "select * from trade.sellorders where oid = ?"};
    }
}

