/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlCallback;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.TestConfig;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlStatements.DMLStmtIF;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class SQLListenerTest
extends SQLTest {
    protected static SQLListenerTest sqlListenerTest;
    public static String backendDB_url;

    public static synchronized void HydraTask_initialize() {
        if (sqlListenerTest == null) {
            sqlListenerTest = new SQLListenerTest();
        }
    }

    public static void HydraTask_doDMLOp() {
        sqlListenerTest.doDMLOp();
    }

    @Override
    protected void doDMLOp() {
        Connection gConn = this.getGFEConnection();
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (setTx && isHATest) {
            this.resetNodeFailureFlag();
        }
        if (setTx && testEviction) {
            this.resetEvictionConflictFlag();
        }
        this.doDMLOp(null, gConn);
        Log.getLogWriter().info("done dmlOp");
    }

    @Override
    protected void doDMLOp(Connection dConn, Connection gConn) {
        Log.getLogWriter().info("performing dmlOp, myTid is " + this.getMyTid());
        int table = dmlTables[random.nextInt(dmlTables.length)];
        DMLStmtIF dmlStmt = dmlFactory.createWriterDMLStmt(table);
        int upto = 10;
        int size = random.nextInt(upto);
        String operation = TestConfig.tab().stringAt(SQLPrms.dmlOperations);
        if (operation.equals("insert")) {
            dmlStmt.insert(dConn, gConn, size);
        } else if (operation.equals("update")) {
            dmlStmt.update(dConn, gConn, size);
        } else if (operation.equals("delete")) {
            dmlStmt.delete(dConn, gConn);
        } else if (operation.equals("query")) {
            if (testUniqueKeys) {
                dmlStmt.query(dConn, gConn);
            } else {
                dmlStmt.query(null, gConn);
            }
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        try {
            if (dConn != null) {
                dConn.commit();
                this.closeDiscConnection(dConn);
                Log.getLogWriter().info("closed the disc connection");
            }
            gConn.commit();
            this.closeGFEConnection(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        Log.getLogWriter().info("done dmlOp");
    }

    public static void HydraTask_populateTables() {
        sqlListenerTest.populateTables();
    }

    @Override
    protected void populateTables(Connection dConn, Connection gConn) {
        for (int i = 0; i < dmlTables.length; ++i) {
            DMLStmtIF dmlStmt = dmlFactory.createWriterDMLStmt(dmlTables[i]);
            dmlStmt.populate(null, gConn);
            try {
                gConn.commit();
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    public static void HydraTask_createListener() {
        sqlListenerTest.createListeners();
    }

    protected void createListeners() {
        try {
            String[] tableNames;
            Connection conn = this.getGFEConnection();
            for (String tableName : tableNames = SQLPrms.getTableNames()) {
                this.createListener(conn, tableName);
                conn.commit();
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void createListener(Connection conn, String tableName) throws SQLException {
        String[] str = tableName.split("\\.");
        String schema = str[0];
        String table = str[1];
        String tableListener = table.substring(0, 1).toUpperCase() + table.substring(1) + "Listener";
        CallableStatement cs = conn.prepareCall("CALL SYS.ADD_LISTENER(?,?,?,?,?,?)");
        cs.setString(1, tableListener);
        cs.setString(2, schema);
        cs.setString(3, table);
        cs.setString(4, "sql.sqlCallback.listener." + tableListener);
        cs.setString(5, backendDB_url);
        cs.setString(6, "");
        cs.execute();
        Log.getLogWriter().info("add the listener " + tableListener + " for " + tableName);
    }

    public static void HydraTask_clearTables() {
        sqlListenerTest.clearTables();
    }

    @Override
    protected void clearTables() {
        if (!hasDerbyServer) {
            return;
        }
        if (this.getMyTid() > 6) {
            return;
        }
        Connection gConn = this.getGFEConnection();
        if (random.nextBoolean() && hasNetworth) {
            this.clearTablesInOrder(null, gConn);
        } else {
            this.clearTables(null, gConn);
        }
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    @Override
    protected void clearTablesInOrder(Connection dConn, Connection gConn) {
        this.clearTables(dConn, gConn, "trade", "buyorders");
        this.clearTables(dConn, gConn, "trade", "txhistory");
        this.clearTables(dConn, gConn, "trade", "sellorders");
        this.clearTables(dConn, gConn, "trade", "portfolio");
        this.clearTables(dConn, gConn, "trade", "networth");
        this.clearTables(dConn, gConn, "trade", "customers");
        this.clearTables(dConn, gConn, "trade", "securities");
    }

    @Override
    protected void clearTables(Connection dConn, Connection gConn) {
        try {
            ResultSet rs = gConn.createStatement().executeQuery("select tableschemaname, tablename from sys.systables where tabletype = 'T' and tableschemaname not like 'SYS%'");
            List<Struct> list = ResultSetHelper.asList(rs, false);
            for (Struct e : list) {
                Object[] table = e.getFieldValues();
                this.clearTables(dConn, gConn, (String)table[0], (String)table[1]);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    @Override
    protected void clearTables(Connection dConn, Connection gConn, String schema, String table) {
        int gCount = 0;
        String delete = "delete from " + schema + "." + table;
        String truncate = "truncate table " + schema + "." + table;
        try {
            Log.getLogWriter().info(delete);
            gCount = gConn.createStatement().executeUpdate(delete);
            Log.getLogWriter().info("gemfirexd deletes " + gCount + " rows from " + table);
        }
        catch (SQLException se) {
            if (se.getSQLState().equalsIgnoreCase("23503")) {
                Log.getLogWriter().info("could not delete due to delete restrict in gfxd");
            }
            if (se.getSQLState().equalsIgnoreCase("XCL48")) {
                Log.getLogWriter().info("could not truncate due to foreign key reference in gfxd");
            }
            SQLHelper.handleSQLException(se);
        }
        this.commit(gConn);
    }

    static {
        backendDB_url = TestConfig.tab().stringAt(SQLPrms.backendDB_url, "jdbc:derby:test");
    }
}

