/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlCallback;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlStatements.DMLStmtIF;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class SQLWriterTest
extends SQLTest {
    protected static SQLWriterTest sqlWriterTest;
    public static String backendDB_url;

    public static synchronized void HydraTask_initialize() {
        if (sqlWriterTest == null) {
            sqlWriterTest = new SQLWriterTest();
        }
    }

    public static void HydraTask_doDMLOp() {
        sqlWriterTest.doDMLOp();
    }

    @Override
    protected void doDMLOp(Connection dConn, Connection gConn) {
        String operation;
        Log.getLogWriter().info("performing dmlOp, myTid is " + this.getMyTid());
        int table = dmlTables[random.nextInt(dmlTables.length)];
        DMLStmtIF dmlStmt = dmlFactory.createWriterDMLStmt(table);
        int upto = 10;
        int size = random.nextInt(upto);
        if (setTx) {
            size = 1;
        }
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (setTx && isHATest) {
            this.resetNodeFailureFlag();
        }
        if (setTx && testEviction) {
            this.resetEvictionConflictFlag();
        }
        if ((operation = TestConfig.tab().stringAt(SQLPrms.dmlOperations)).equals("insert")) {
            dmlStmt.insert(dConn, gConn, size);
        } else if (operation.equals("update")) {
            dmlStmt.update(dConn, gConn, size);
        } else if (operation.equals("delete")) {
            dmlStmt.delete(dConn, gConn);
        } else if (operation.equals("query")) {
            if (testUniqueKeys) {
                dmlStmt.query(dConn, gConn);
            } else {
                dmlStmt.query(null, gConn);
            }
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        try {
            if (dConn != null) {
                dConn.commit();
                this.closeDiscConnection(dConn);
                Log.getLogWriter().info("closed the disc connection");
            }
            gConn.commit();
            this.closeGFEConnection(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        Log.getLogWriter().info("done dmlOp");
    }

    public static void HydraTask_populateTables() {
        sqlWriterTest.populateTables();
    }

    @Override
    protected void populateTables(Connection dConn, Connection gConn) {
        for (int i = 0; i < dmlTables.length; ++i) {
            DMLStmtIF dmlStmt = dmlFactory.createWriterDMLStmt(dmlTables[i]);
            dmlStmt.populate(null, gConn);
            try {
                gConn.commit();
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    public static void HydraTask_createWriter() {
        sqlWriterTest.createWriters();
    }

    protected void createWriters() {
        try {
            String[] tableNames;
            Connection conn = this.getGFEConnection();
            for (String tableName : tableNames = SQLPrms.getTableNames()) {
                this.createWriter(conn, tableName);
                conn.commit();
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void createWriter(Connection conn, String tableName) throws SQLException {
        String[] str = tableName.split("\\.");
        String schema = str[0];
        String table = str[1];
        String tableWriter = table.substring(0, 1).toUpperCase() + table.substring(1) + "Writer";
        CallableStatement cs = conn.prepareCall("CALL SYS.ATTACH_WRITER(?,?,?,?,?)");
        cs.setString(1, schema);
        cs.setString(2, table);
        cs.setString(3, "sql.sqlCallback.writer." + tableWriter);
        cs.setString(4, backendDB_url);
        cs.setString(5, "");
        cs.execute();
        Log.getLogWriter().info("attach the writer " + tableWriter + " for " + tableName);
    }

    public static void HydraTask_clearTables() {
        sqlWriterTest.clearTables();
    }

    @Override
    protected void clearTables() {
        if (!hasDerbyServer) {
            return;
        }
        Connection gConn = this.getGFEConnection();
        this.clearTablesInOrder(null, gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
        if (this.getMyTid() == ddlThread) {
            this.verifyResultSets();
        }
    }

    @Override
    protected void clearTablesInOrder(Connection dConn, Connection gConn) {
        this.clearTables(dConn, gConn, "trade", "buyorders");
        this.clearTables(dConn, gConn, "trade", "txhistory");
        this.clearTables(dConn, gConn, "trade", "sellorders");
        this.clearTables(dConn, gConn, "trade", "portfolio");
        this.clearTables(dConn, gConn, "trade", "networth");
        this.clearTables(dConn, gConn, "trade", "customers");
        this.clearTables(dConn, gConn, "trade", "securities");
    }

    @Override
    protected void clearTables(Connection dConn, Connection gConn) {
        try {
            String sql = "select tableschemaname, tablename from sys.systables where tabletype = 'T' and tableschemaname not like 'SYS%'";
            ResultSet rs = gConn.createStatement().executeQuery(sql);
            Log.getLogWriter().info(sql);
            List<Struct> list = ResultSetHelper.asList(rs, false);
            Log.getLogWriter().info(ResultSetHelper.listToString(list));
            for (Struct e : list) {
                Object[] table = e.getFieldValues();
                this.clearTables(dConn, gConn, (String)table[0], (String)table[1]);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    @Override
    protected void clearTables(Connection dConn, Connection gConn, String schema, String table) {
        boolean testTruncate = false;
        int gCount = 0;
        String delete = "delete from " + schema + "." + table;
        String truncate = "truncate table " + schema + "." + table;
        try {
            if (setTx) {
                if (this.getMyTid() == ddlThread) {
                    Log.getLogWriter().info(delete);
                    gCount = gConn.createStatement().executeUpdate(delete);
                    Log.getLogWriter().info("gemfirexd deletes " + gCount + " rows from " + table);
                }
                return;
            }
            if (RemoteTestModule.getCurrentThread().getThreadId() != 0) {
                if (testTruncate) {
                    return;
                }
                Log.getLogWriter().info(delete);
                gCount = gConn.createStatement().executeUpdate(delete);
                Log.getLogWriter().info("gemfirexd deletes " + gCount + " rows from " + table);
            } else if (testTruncate) {
                Log.getLogWriter().info(truncate);
                gCount = gConn.createStatement().executeUpdate(truncate);
                Log.getLogWriter().info("gemfirexd truncate table returns " + gCount);
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equalsIgnoreCase("23503")) {
                Log.getLogWriter().info("could not delete due to delete restrict in gfxd");
            }
            if (se.getSQLState().equalsIgnoreCase("XCL48")) {
                Log.getLogWriter().info("could not truncate due to foreign key reference in gfxd");
            }
            if (setTx && se.getSQLState().equalsIgnoreCase("X0Z02")) {
                Log.getLogWriter().info("Got expected conflict exception using txn");
                return;
            }
            SQLHelper.handleSQLException(se);
        }
        this.commit(gConn);
    }

    static {
        backendDB_url = TestConfig.tab().stringAt(SQLPrms.backendDB_url, "jdbc:derby:test");
    }
}

