/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlCallback.asyncEventListener;

import com.pivotal.gemfirexd.callbacks.AsyncEventListener;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.callbacks.TableMetaData;
import hydra.DerbyServerHelper;
import hydra.Log;
import hydra.TestConfig;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import sql.ClientDiscDBManager;
import sql.SQLHelper;
import sql.SQLPrms;
import util.TestException;
import util.TestHelper;

public abstract class AbstractAsyncListener
implements AsyncEventListener {
    public static String initStr = "org.apache.derby.jdbc.ClientDriver,jdbc:derby://" + DerbyServerHelper.getEndpoint().getHost() + ":" + DerbyServerHelper.getEndpoint().getPort() + "/" + ClientDiscDBManager.getDBName() + ";create=true";
    protected static boolean testUniqueKeys = TestConfig.tab().booleanAt(SQLPrms.testUniqueKeys, true);
    public static boolean useResultSetImpl = true;

    public void close() {
        Log.getLogWriter().info("AsyncEventListener.close() gets called");
    }

    public void init(String initStr) {
        Log.getLogWriter().info("in init AsyncListener");
        if (!AbstractAsyncListener.initStr.equals(initStr)) {
            throw new TestException("init in Listener() does not get the initStr.");
        }
    }

    public abstract boolean processEvents(List<Event> var1);

    public abstract boolean processEvent(Event var1);

    protected String getSql(Event event) throws SQLException {
        StringBuilder str = new StringBuilder();
        if (useResultSetImpl) {
            int i;
            ResultSet newRowRs = event.getNewRowsAsResultSet();
            if (newRowRs == null) {
                throw new TestException("new row from event.getNewRowAsResultSet() is " + newRowRs + " on AFTER_UPDATE");
            }
            ResultSetMetaData updatedColMeta = newRowRs.getMetaData();
            Log.getLogWriter().info("newRowRs is ");
            for (i = 0; i < updatedColMeta.getColumnCount(); ++i) {
                Log.getLogWriter().info(newRowRs.getObject(i + 1) + ", ");
            }
            str.append("update " + updatedColMeta.getSchemaName(1) + "." + updatedColMeta.getTableName(1) + " set ");
            for (i = 0; i < updatedColMeta.getColumnCount(); ++i) {
                str.append(" " + updatedColMeta.getColumnName(i + 1) + "=");
                this.appendValue(str, newRowRs.getObject(i + 1), updatedColMeta.getColumnType(i + 1));
            }
        } else {
            TableMetaData meta = event.getResultSetMetaData();
            List newRow = event.getNewRow();
            if (event.getModifiedColumns() == null) {
                throw new TestException("event.getModifiedColumns return null on AFTER_UPDATE");
            }
            str.append("update " + meta.getSchemaName(1) + "." + meta.getTableName(1) + " set ");
            for (int i = 0; i < event.getModifiedColumns().length; ++i) {
                str.append(" " + meta.getColumnName(event.getModifiedColumns()[i]) + "=");
                this.appendValue(str, newRow.get(event.getModifiedColumns()[i] - 1), meta.getColumnType(event.getModifiedColumns()[i]));
            }
        }
        str.delete(str.length() - 1, str.length());
        return str.toString();
    }

    protected void appendValue(StringBuilder str, Object value, int type) {
        switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 93: {
                str.append(value + ",");
                break;
            }
            default: {
                str.append("'" + value + "',");
            }
        }
    }

    public void start() {
        Log.getLogWriter().info("AsyncEventListener.start() gets called");
    }

    protected abstract void insert(Event var1) throws SQLException;

    protected abstract void delete(Event var1) throws SQLException;

    protected abstract void update(Event var1) throws SQLException;

    protected boolean isSame(Event e1, Event e2) {
        boolean isSameOldRow;
        if (e1.getType() != e2.getType()) {
            Log.getLogWriter().info("not the same type for two events");
            return false;
        }
        boolean bl = e1.getOldRow() == null ? e2.getOldRow() == null : (isSameOldRow = this.getRow(e1, false).equals(this.getRow(e2, false)));
        boolean isSameNewRow = e1.getNewRow() == null ? e2.getNewRow() == null : this.getRow(e1, true).equals(this.getRow(e2, true));
        boolean hasSameModifiedColumns = Arrays.equals(e1.getModifiedColumns(), e2.getModifiedColumns());
        boolean hasSamePK = Arrays.equals(e1.getPrimaryKey(), e2.getPrimaryKey());
        if (e1.getPrimaryKey()[0] == e2.getPrimaryKey()[0]) {
            Log.getLogWriter().info("isSameOldRow is " + isSameOldRow);
            Log.getLogWriter().info("isSameNewRow is " + isSameNewRow);
            Log.getLogWriter().info("hasSameModifiedColumns is " + hasSameModifiedColumns);
            Log.getLogWriter().info("has same primary keys is " + hasSamePK);
        }
        return isSameOldRow && isSameNewRow && Arrays.equals(e1.getModifiedColumns(), e2.getModifiedColumns()) && Arrays.equals(e1.getPrimaryKey(), e2.getPrimaryKey());
    }

    protected String getRow(Event event, boolean getNewRow) {
        TableMetaData meta = event.getResultSetMetaData();
        List row = null;
        row = getNewRow ? event.getNewRow() : event.getOldRow();
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < row.size(); ++i) {
            try {
                str.append(meta.getColumnName(i + 1) + ": " + row.get(i) + ",");
                continue;
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().warning("gets unexpected exception " + TestHelper.getStackTrace((Throwable)se));
            }
        }
        Log.getLogWriter().info(str.toString());
        return str.toString();
    }

    static {
        Log.getLogWriter().info("useResultSetImpl is " + useResultSetImpl);
    }
}

