/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlCallback.asyncEventListener;

import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.callbacks.TableMetaData;
import hydra.Log;
import java.sql.SQLException;
import java.util.List;
import sql.SQLHelper;
import sql.sqlCallback.asyncEventListener.AbstractAsyncListener;
import sql.sqlCallback.asyncEventListener.BuyordersAsyncListener;
import sql.sqlCallback.asyncEventListener.CustomersAsyncListener;
import sql.sqlCallback.asyncEventListener.EmployeesAsyncListener;
import sql.sqlCallback.asyncEventListener.NetworthAsyncListener;
import sql.sqlCallback.asyncEventListener.PortfolioAsyncListener;
import sql.sqlCallback.asyncEventListener.SecuritiesAsyncListener;
import sql.sqlCallback.asyncEventListener.SellordersAsyncListener;
import sql.sqlCallback.asyncEventListener.TxhistoryAsyncListener;

public class BasicAsyncListener
extends AbstractAsyncListener {
    protected CustomersAsyncListener customers = new CustomersAsyncListener();
    protected NetworthAsyncListener networth = new NetworthAsyncListener();
    protected SecuritiesAsyncListener securities = new SecuritiesAsyncListener();
    protected PortfolioAsyncListener portfolio = new PortfolioAsyncListener();
    protected SellordersAsyncListener sellorders = new SellordersAsyncListener();
    protected BuyordersAsyncListener buyorders = new BuyordersAsyncListener();
    protected TxhistoryAsyncListener txhistory = new TxhistoryAsyncListener();
    protected EmployeesAsyncListener employees = new EmployeesAsyncListener();

    private AbstractAsyncListener getListener(String tableName) {
        if (tableName.equalsIgnoreCase("customers")) {
            return this.customers;
        }
        if (tableName.equalsIgnoreCase("networth")) {
            return this.networth;
        }
        if (tableName.equalsIgnoreCase("securities")) {
            return this.securities;
        }
        if (tableName.equalsIgnoreCase("portfolio")) {
            return this.portfolio;
        }
        if (tableName.equalsIgnoreCase("sellorders")) {
            return this.sellorders;
        }
        if (tableName.equalsIgnoreCase("buyorders")) {
            return this.buyorders;
        }
        if (tableName.equalsIgnoreCase("txhistory")) {
            return this.txhistory;
        }
        if (tableName.equalsIgnoreCase("employees")) {
            return this.employees;
        }
        Log.getLogWriter().warning("testing configure issue, operation on unknown table");
        return null;
    }

    @Override
    public boolean processEvents(List<Event> events) {
        Log.getLogWriter().info("start processing the list of async events");
        boolean hasFailedEvent = false;
        for (Event event : events) {
            String tableName = null;
            TableMetaData meta = event.getResultSetMetaData();
            try {
                tableName = meta.getTableName(1);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            AbstractAsyncListener listener = this.getListener(tableName);
            boolean success = listener.processEvent(event);
            if (!success & testUniqueKeys) {
                hasFailedEvent = true;
            }
            if (!hasFailedEvent) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void insert(Event event) throws SQLException {
        Log.getLogWriter().warning("shoud not be called here");
    }

    @Override
    protected void delete(Event event) throws SQLException {
        Log.getLogWriter().warning("shoud not be called here");
    }

    @Override
    protected void update(Event event) throws SQLException {
        Log.getLogWriter().warning("shoud not be called here");
    }

    @Override
    public boolean processEvent(Event event) {
        Log.getLogWriter().warning("test issue, this method should not be called");
        return true;
    }

    static {
        Log.getLogWriter().info("load BasicAsyncListener");
    }
}

