/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlCallback.asyncEventListener;

import com.pivotal.gemfirexd.callbacks.Event;
import hydra.Log;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import sql.ClientDiscDBManager;
import sql.SQLHelper;
import sql.sqlCallback.SQLAsyncEventListenerTest;
import sql.sqlCallback.asyncEventListener.AbstractAsyncListener;
import util.TestException;
import util.TestHelper;

public class CustomersAsyncListener
extends AbstractAsyncListener {
    static String delete = "delete from trade.customers where cid=?";
    static String insert = "insert into trade.customers values (?,?,?,?,?)";
    private Event failedEvent = null;
    private static ThreadLocal<PreparedStatement> insertStmt = new ThreadLocal<PreparedStatement>(){

        @Override
        protected PreparedStatement initialValue() {
            PreparedStatement stmt = null;
            try {
                stmt = dConn.get().prepareStatement(insert);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return stmt;
        }
    };
    private static ThreadLocal<PreparedStatement> deleteStmt = new ThreadLocal<PreparedStatement>(){

        @Override
        protected PreparedStatement initialValue() {
            PreparedStatement stmt = null;
            try {
                stmt = dConn.get().prepareStatement(delete);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return stmt;
        }
    };
    private static ThreadLocal<Statement> stmt = new ThreadLocal<Statement>(){

        @Override
        protected Statement initialValue() {
            Statement s = null;
            try {
                s = dConn.get().createStatement();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return s;
        }
    };
    protected static ThreadLocal<Connection> dConn = new ThreadLocal<Connection>(){

        @Override
        protected Connection initialValue() {
            Connection dConn = null;
            try {
                dConn = ClientDiscDBManager.getConnection();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return dConn;
        }
    };

    @Override
    public boolean processEvents(List<Event> events) {
        Log.getLogWriter().info("start processing the list of async events");
        for (Event event : events) {
            boolean success;
            if (this.failedEvent != null) {
                if (!this.isSame(this.failedEvent, event)) {
                    if (!event.isPossibleDuplicate()) {
                        Log.getLogWriter().warning("an already processed event does not have isPossibleDuplicate() set to true");
                        continue;
                    }
                    Log.getLogWriter().info("this event has been processed before, do not retry");
                    continue;
                }
                this.failedEvent = null;
            }
            if (success = this.processEvent(event)) continue;
            if (testUniqueKeys) {
                this.failedEvent = event;
                Log.getLogWriter().info("test unique key, will retry the failed event");
                return false;
            }
            Log.getLogWriter().info("the event does not succeed in back end, but will not continue to retryto block the queue");
        }
        return true;
    }

    @Override
    public boolean processEvent(Event event) {
        try {
            Event.Type type = event.getType();
            switch (type) {
                case AFTER_UPDATE: {
                    this.update(event);
                    break;
                }
                case AFTER_INSERT: {
                    this.insert(event);
                    break;
                }
                case AFTER_DELETE: {
                    this.delete(event);
                    break;
                }
                default: {
                    Log.getLogWriter().warning("TestException: AsyncEventListener got a 'none_after' callback event: " + type);
                }
            }
            dConn.get().commit();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equals("08006") || se.getSQLState().equals("08003") || se.getSQLState().equals("08001")) {
                Log.getLogWriter().info("connection is lost");
                Connection conn = null;
                try {
                    conn = ClientDiscDBManager.getConnection();
                }
                catch (SQLException ex) {
                    SQLHelper.handleSQLException(ex);
                }
                dConn.set(conn);
                this.resetStatements();
            } else {
                Log.getLogWriter().warning("AsyncEventListener Test gets exception\n" + TestHelper.getStackTrace((Throwable)se));
            }
            return false;
        }
        return true;
    }

    @Override
    protected void insert(Event event) throws SQLException {
        List oldRow = event.getOldRow();
        List newRow = event.getNewRow();
        boolean isPossibleDuplicate = event.isPossibleDuplicate();
        if (isPossibleDuplicate) {
            ResultSet rs = stmt.get().executeQuery("select * from trade.customers where cid = " + (Integer)event.getPrimaryKey()[0]);
            if (rs.next()) {
                Log.getLogWriter().info("this row has been inserted already " + newRow);
            } else {
                this.doInsert(oldRow, newRow, isPossibleDuplicate);
            }
        } else {
            this.doInsert(oldRow, newRow, isPossibleDuplicate);
        }
    }

    private void doInsert(List<Object> oldRow, List<Object> newRow, boolean isPossibleDuplicate) throws SQLException {
        int count = 0;
        if (oldRow != null) {
            throw new TestException("BEFORE_INSERT is invoked, but oldRow is not null: " + oldRow);
        }
        insertStmt.get().setInt(1, (Integer)newRow.get(0));
        insertStmt.get().setString(2, (String)newRow.get(1));
        insertStmt.get().setDate(3, (Date)newRow.get(2));
        insertStmt.get().setString(4, (String)newRow.get(3));
        insertStmt.get().setInt(5, (Integer)newRow.get(4));
        Log.getLogWriter().info("inserting into customers in derby cid is " + (Integer)newRow.get(0) + " cust_name is " + (String)newRow.get(1) + " since is " + (Date)newRow.get(2) + " addr is " + (String)newRow.get(3) + " tid is " + (Integer)newRow.get(4));
        count = insertStmt.get().executeUpdate();
        Log.getLogWriter().info("inserted " + count + " row");
        if (count != 1 && !isPossibleDuplicate && testUniqueKeys) {
            throw new TestException("insert from listener does not insert the corresponding row in back_end, inserted row is " + count);
        }
    }

    @Override
    protected void delete(Event event) throws SQLException {
        List newRow = event.getNewRow();
        boolean isPossibleDuplicate = event.isPossibleDuplicate();
        int count = 0;
        if (newRow != null) {
            throw new TestException("BEFORE_DELETE is invoked, but newRow is not null: " + newRow);
        }
        deleteStmt.get().setInt(1, (Integer)event.getPrimaryKey()[0]);
        Log.getLogWriter().info("deleting from customers in derby where cid =" + (Integer)event.getPrimaryKey()[0]);
        count = deleteStmt.get().executeUpdate();
        Log.getLogWriter().info("deleted " + count + " row");
        if (count != 1 && !isPossibleDuplicate && testUniqueKeys) {
            SQLAsyncEventListenerTest.testException = new TestException("insert from listener does not insert the corresponding row in back_end, inserted row is " + count);
            throw SQLAsyncEventListenerTest.testException;
        }
    }

    @Override
    protected void update(Event event) throws SQLException {
        boolean isPossibleDuplicate = event.isPossibleDuplicate();
        int count = 0;
        String sql = this.getSql(event);
        sql = sql + " where cid = " + event.getPrimaryKey()[0];
        Log.getLogWriter().info("update to derby: " + sql);
        count = stmt.get().executeUpdate(sql);
        Log.getLogWriter().info("updated " + count + " row");
        if (count != 1 && !isPossibleDuplicate && testUniqueKeys) {
            SQLAsyncEventListenerTest.testException = new TestException("update from listener does not update the corresponding row in back_end, updated row is " + count);
            throw SQLAsyncEventListenerTest.testException;
        }
    }

    protected void resetStatements() {
        this.resetInsert();
        this.resetDelete();
        this.resetStmt();
    }

    protected void resetInsert() {
        PreparedStatement stmt = null;
        try {
            stmt = dConn.get().prepareStatement(insert);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        insertStmt.set(stmt);
    }

    protected void resetDelete() {
        PreparedStatement stmt = null;
        try {
            stmt = dConn.get().prepareStatement(delete);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        deleteStmt.set(stmt);
    }

    protected void resetStmt() {
        Statement s = null;
        try {
            s = dConn.get().createStatement();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        stmt.set(s);
    }
}

