/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlCallback.asyncEventListener;

import com.pivotal.gemfirexd.callbacks.Event;
import hydra.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import sql.ClientDiscDBManager;
import sql.SQLHelper;
import sql.sqlCallback.asyncEventListener.AbstractAsyncListener;
import util.TestException;
import util.TestHelper;

public class EmployeesAsyncListener
extends AbstractAsyncListener {
    static String insert = "insert into default1.employees (eid) values (?)";
    private Event failedEvent = null;
    private static ThreadLocal<PreparedStatement> insertStmt = new ThreadLocal<PreparedStatement>(){

        @Override
        protected PreparedStatement initialValue() {
            PreparedStatement stmt = null;
            try {
                stmt = dConn.get().prepareStatement(insert);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return stmt;
        }
    };
    private static ThreadLocal<Statement> stmt = new ThreadLocal<Statement>(){

        @Override
        protected Statement initialValue() {
            Statement s = null;
            try {
                s = dConn.get().createStatement();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return s;
        }
    };
    protected static ThreadLocal<Connection> dConn = new ThreadLocal<Connection>(){

        @Override
        protected Connection initialValue() {
            Connection dConn = null;
            try {
                dConn = ClientDiscDBManager.getConnection();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return dConn;
        }
    };

    @Override
    public boolean processEvents(List<Event> events) {
        Log.getLogWriter().info("start processing the list of async events");
        for (Event event : events) {
            boolean success;
            if (this.failedEvent != null) {
                if (!this.isSame(this.failedEvent, event)) {
                    if (!event.isPossibleDuplicate()) {
                        Log.getLogWriter().warning("an already processed event does not have isPossibleDuplicate() set to true");
                        continue;
                    }
                    Log.getLogWriter().info("this event has been processed before, do not retry");
                    continue;
                }
                this.failedEvent = null;
            }
            if (success = this.processEvent(event)) continue;
            this.failedEvent = event;
            if (!testUniqueKeys) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean processEvent(Event event) {
        try {
            Event.Type type = event.getType();
            switch (type) {
                case AFTER_UPDATE: {
                    this.update(event);
                    break;
                }
                case AFTER_INSERT: {
                    this.insert(event);
                    break;
                }
                case AFTER_DELETE: {
                    this.delete(event);
                    break;
                }
                default: {
                    Log.getLogWriter().warning("TestException: AsyncEventListener got a 'none_after' callback event: " + type);
                }
            }
            dConn.get().commit();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equals("08006") || se.getSQLState().equals("08003") || se.getSQLState().equals("08001")) {
                Log.getLogWriter().info("connection is lost");
                Connection conn = null;
                try {
                    conn = ClientDiscDBManager.getConnection();
                }
                catch (SQLException ex) {
                    SQLHelper.handleSQLException(ex);
                }
                dConn.set(conn);
                this.resetStatements();
            } else {
                Log.getLogWriter().warning("AsyncEventListener Test gets exception\n" + TestHelper.getStackTrace((Throwable)se));
            }
            return false;
        }
        return true;
    }

    @Override
    protected void insert(Event event) throws SQLException {
        List oldRow = event.getOldRow();
        List newRow = event.getNewRow();
        boolean isPossibleDuplicate = event.isPossibleDuplicate();
        int pk = (Integer)event.getPrimaryKey()[0];
        if (isPossibleDuplicate) {
            ResultSet rs = stmt.get().executeQuery("select * from default1.employees where eid = " + pk);
            if (rs.next()) {
                Log.getLogWriter().info("this row has been inserted already " + newRow);
            } else {
                this.doInsert(oldRow, newRow, isPossibleDuplicate, pk);
            }
        } else {
            this.doInsert(oldRow, newRow, isPossibleDuplicate, pk);
        }
    }

    private void doInsert(List<Object> oldRow, List<Object> newRow, boolean isPossibleDuplicate, int pk) throws SQLException {
        int count = 0;
        if (oldRow != null) {
            throw new TestException("BEFORE_INSERT in employeesListener is invoked, but oldRow is not null: " + oldRow);
        }
        try {
            insertStmt.get().setInt(1, pk);
        }
        catch (ClassCastException ce) {
            Log.getLogWriter().info("new row in employees eid is " + pk);
            throw ce;
        }
        Log.getLogWriter().info("inserting into employees in derby eid is " + pk);
        count = insertStmt.get().executeUpdate();
        Log.getLogWriter().info("inserted " + count + " row");
        if (count != 1 && !isPossibleDuplicate) {
            throw new TestException("insert from listener does not insert the corresponding row in back_end, inserted row is " + count);
        }
    }

    @Override
    protected void delete(Event event) throws SQLException {
        Log.getLogWriter().warning("There shoud be no delete event in employees table in the test");
    }

    @Override
    protected void update(Event event) throws SQLException {
        Log.getLogWriter().warning("There shoud be no update event in employees table in the test");
    }

    protected void resetStatements() {
        this.resetInsert();
    }

    protected void resetInsert() {
        PreparedStatement stmt = null;
        try {
            stmt = dConn.get().prepareStatement(insert);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        insertStmt.set(stmt);
    }
}

