/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlCallback.listener;

import com.pivotal.gemfirexd.callbacks.Event;
import hydra.Log;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import sql.ClientDiscDBManager;
import sql.SQLHelper;
import sql.SQLTest;
import sql.sqlCallback.listener.AbstractListener;
import util.TestException;

public class NetworthListener
extends AbstractListener {
    static String delete = "delete from trade.networth where cid = ?";
    static String insert = "insert into trade.networth values (?,?,?,?,?,?)";
    private static ThreadLocal<Connection> dConn = new ThreadLocal<Connection>(){

        @Override
        protected Connection initialValue() {
            Connection dConn = null;
            try {
                dConn = ClientDiscDBManager.getConnection();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return dConn;
        }
    };
    private static ThreadLocal<PreparedStatement> insertStmt = new ThreadLocal<PreparedStatement>(){

        @Override
        protected PreparedStatement initialValue() {
            PreparedStatement stmt = null;
            try {
                stmt = ((Connection)dConn.get()).prepareStatement(insert);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return stmt;
        }
    };
    private static ThreadLocal<PreparedStatement> deleteStmt = new ThreadLocal<PreparedStatement>(){

        @Override
        protected PreparedStatement initialValue() {
            PreparedStatement stmt = null;
            try {
                stmt = ((Connection)dConn.get()).prepareStatement(delete);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return stmt;
        }
    };
    private static ThreadLocal<Statement> stmt = new ThreadLocal<Statement>(){

        @Override
        protected Statement initialValue() {
            Statement s = null;
            try {
                s = ((Connection)dConn.get()).createStatement();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return s;
        }
    };

    @Override
    public void onEvent(Event event) throws SQLException {
        Event.Type type = event.getType();
        String eventType = null;
        boolean isPossibleDuplicate = event.isPossibleDuplicate();
        if (isPossibleDuplicate && !SQLTest.isHATest) {
            throw new TestException("Got possible duplicate event but it is  not a HA Test");
        }
        switch (type) {
            case AFTER_UPDATE: {
                this.update(event);
                break;
            }
            case AFTER_INSERT: {
                this.insert(event);
                break;
            }
            case AFTER_DELETE: {
                this.delete(event);
                break;
            }
            default: {
                throw new TestException("Listener got a 'none_after' callback event: " + eventType);
            }
        }
        dConn.get().commit();
    }

    private void doInsert(List<Object> oldRow, List<Object> newRow, boolean isPossibleDuplicate) throws SQLException {
        int count = 0;
        if (oldRow != null) {
            throw new TestException("BEFORE_INSERT is invoked, but oldRow is not null: " + oldRow);
        }
        insertStmt.get().setInt(1, (Integer)newRow.get(0));
        insertStmt.get().setBigDecimal(2, (BigDecimal)newRow.get(1));
        insertStmt.get().setBigDecimal(3, (BigDecimal)newRow.get(2));
        insertStmt.get().setInt(4, (Integer)newRow.get(3));
        insertStmt.get().setBigDecimal(5, (BigDecimal)newRow.get(4));
        insertStmt.get().setInt(6, (Integer)newRow.get(5));
        Log.getLogWriter().info("inserting into networth in derby cid is " + (Integer)newRow.get(0) + " cash is " + newRow.get(1) + " securities is " + newRow.get(2) + " loanLimit is " + newRow.get(3) + " availLoan is " + newRow.get(4) + " tid is " + newRow.get(5));
        try {
            count = insertStmt.get().executeUpdate();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        if (count != 1 && !isPossibleDuplicate) {
            throw new TestException("insert from listener does not insert the corresponding row in back_end, inserted row is " + count);
        }
    }

    private void insert(Event event) throws SQLException {
        List oldRow = event.getOldRow();
        List newRow = event.getNewRow();
        boolean isPossibleDuplicate = event.isPossibleDuplicate();
        if (isPossibleDuplicate) {
            ResultSet rs = stmt.get().executeQuery("select * from trade.networth where cid = " + (Integer)event.getPrimaryKey()[0]);
            if (rs.next()) {
                Log.getLogWriter().info("this row has been inserted already " + newRow);
            } else {
                this.doInsert(oldRow, newRow, isPossibleDuplicate);
            }
        } else {
            this.doInsert(oldRow, newRow, isPossibleDuplicate);
        }
    }

    private void delete(Event event) throws SQLException {
        List newRow = event.getNewRow();
        boolean isPossibleDuplicate = event.isPossibleDuplicate();
        int count = 0;
        if (newRow != null) {
            throw new TestException("BEFORE_DELETE is invoked, but newRow is not null: " + newRow);
        }
        deleteStmt.get().setInt(1, (Integer)event.getPrimaryKey()[0]);
        Log.getLogWriter().info("deleting from networth in derby where cid =" + (Integer)event.getPrimaryKey()[0]);
        count = deleteStmt.get().executeUpdate();
        Log.getLogWriter().info("deleted " + count + " row");
        if (count != 1 && !isPossibleDuplicate) {
            throw new TestException("delete from listener does not delete the corresponding row in back_end, deleted row is " + count);
        }
    }

    private void update(Event event) throws SQLException {
        boolean isPossibleDuplicate = event.isPossibleDuplicate();
        int count = 0;
        String sql = this.getSql(event);
        sql = sql + " where cid = " + event.getPrimaryKey()[0];
        Log.getLogWriter().info("update to derby: " + sql);
        try {
            count = stmt.get().executeUpdate(sql);
        }
        catch (SQLException se) {
            if (se.getSQLState().equalsIgnoreCase("23513")) {
                Log.getLogWriter().info("get check constraint violation, let gemfirexd perform the constraint check as well");
                return;
            }
            throw se;
        }
        if (count != 1 && !isPossibleDuplicate) {
            throw new TestException("update from listener does not update the corresponding row in back_end, updated row is " + count);
        }
    }
}

