/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlCallback.writer;

import com.pivotal.gemfirexd.callbacks.Event;
import hydra.Log;
import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import sql.ClientDiscDBManager;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.sqlCallback.writer.AbstractWriter;
import util.TestException;

public class BuyordersWriter
extends AbstractWriter {
    static String insert = "insert into trade.buyorders values (?,?,?,?,?,?,?,?)";
    static String delete = "delete from trade.buyorders where oid=?";
    private static String initStr = TestConfig.tab().stringAt(SQLPrms.backendDB_url, "jdbc:derby:test");
    private static ThreadLocal<Connection> dConn = new ThreadLocal<Connection>(){

        @Override
        protected Connection initialValue() {
            Connection dConn = null;
            try {
                dConn = ClientDiscDBManager.getConnection();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return dConn;
        }
    };
    private static ThreadLocal<PreparedStatement> insertStmt = new ThreadLocal<PreparedStatement>(){

        @Override
        protected PreparedStatement initialValue() {
            PreparedStatement stmt = null;
            try {
                stmt = ((Connection)dConn.get()).prepareStatement(insert);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return stmt;
        }
    };
    private static ThreadLocal<PreparedStatement> deleteStmt = new ThreadLocal<PreparedStatement>(){

        @Override
        protected PreparedStatement initialValue() {
            PreparedStatement stmt = null;
            try {
                stmt = ((Connection)dConn.get()).prepareStatement(delete);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return stmt;
        }
    };
    private static ThreadLocal<Statement> stmt = new ThreadLocal<Statement>(){

        @Override
        protected Statement initialValue() {
            Statement s = null;
            try {
                s = ((Connection)dConn.get()).createStatement();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return s;
        }
    };

    @Override
    public void close() throws SQLException {
    }

    @Override
    public void init(String initStr) throws SQLException {
        if (!BuyordersWriter.initStr.equals(initStr)) {
            throw new TestException("init in Writer() does not get the initStr.");
        }
    }

    @Override
    public void onEvent(Event event) throws SQLException {
        Event.Type type = event.getType();
        String eventType = null;
        boolean isPossibleDuplicate = event.isPossibleDuplicate();
        if (isPossibleDuplicate && !SQLTest.isHATest) {
            throw new TestException("Got possible duplicate event but it is  not a HA Test");
        }
        switch (type) {
            case BEFORE_DELETE: {
                this.delete(event);
                break;
            }
            case BEFORE_INSERT: {
                this.insert(event);
                break;
            }
            case BEFORE_UPDATE: {
                this.update(event);
                break;
            }
            case AFTER_UPDATE: {
                eventType = "AFTER_UPDATE";
            }
            case AFTER_INSERT: {
                eventType = "AFTER_INSERT";
            }
            case AFTER_DELETE: {
                eventType = "AFTER_DELETE";
            }
            default: {
                throw new TestException("Writer got a 'none_before' callback event: " + eventType);
            }
        }
        dConn.get().commit();
    }

    private void insert(Event event) throws SQLException {
        List oldRow = event.getOldRow();
        List newRow = event.getNewRow();
        boolean isPossibleDuplicate = event.isPossibleDuplicate();
        if (isPossibleDuplicate) {
            ResultSet rs = stmt.get().executeQuery("select * from trade.buyorders where oid = " + (Integer)event.getPrimaryKey()[0]);
            if (rs.next()) {
                Log.getLogWriter().info("this row has been inserted already " + newRow);
            } else {
                this.doInsert(oldRow, newRow, isPossibleDuplicate);
            }
        } else {
            this.doInsert(oldRow, newRow, isPossibleDuplicate);
        }
    }

    private void doInsert(List<Object> oldRow, List<Object> newRow, boolean isPossibleDuplicate) throws SQLException {
        int count = 0;
        if (oldRow != null) {
            throw new TestException("BEFORE_INSERT in buyordersWriter is invoked, but oldRow is not null: " + oldRow);
        }
        try {
            insertStmt.get().setInt(1, (Integer)newRow.get(0));
            insertStmt.get().setInt(2, (Integer)newRow.get(1));
            insertStmt.get().setInt(3, (Integer)newRow.get(2));
            insertStmt.get().setInt(4, (Integer)newRow.get(3));
            insertStmt.get().setBigDecimal(5, (BigDecimal)newRow.get(4));
            insertStmt.get().setTimestamp(6, (Timestamp)newRow.get(5));
            insertStmt.get().setString(7, (String)newRow.get(6));
            insertStmt.get().setInt(8, (Integer)newRow.get(7));
        }
        catch (ClassCastException ce) {
            Log.getLogWriter().info("new row in buyorders oid is " + newRow.get(0));
            throw ce;
        }
        Log.getLogWriter().info("inserting into buyorders in derby oid is " + (Integer)newRow.get(0) + " cid is " + (Integer)newRow.get(1) + " sid is " + newRow.get(2) + " qty is " + newRow.get(3) + " bid is " + (BigDecimal)newRow.get(4) + " ordertime is " + (Timestamp)newRow.get(5) + " status is " + newRow.get(6) + " tid is " + (Integer)newRow.get(7));
        try {
            count = insertStmt.get().executeUpdate();
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("23503")) {
                Log.getLogWriter().info("get foreign key constraint violation, let gemfirexd perform the constraint check as well");
                return;
            }
            throw se;
        }
        if (count != 1 && !isPossibleDuplicate) {
            throw new TestException("insert from writer does not insert the corresponding row in back_end, inserted row is " + count);
        }
    }

    private void delete(Event event) throws SQLException {
        List newRow = event.getNewRow();
        boolean isPossibleDuplicate = event.isPossibleDuplicate();
        int count = 0;
        if (newRow != null) {
            throw new TestException("BEFORE_DELETE is invoked, but newRow is not null: " + newRow);
        }
        deleteStmt.get().setInt(1, (Integer)event.getPrimaryKey()[0]);
        Log.getLogWriter().info("deleting from buyorders in derby where oid =" + (Integer)event.getPrimaryKey()[0]);
        count = deleteStmt.get().executeUpdate();
        Log.getLogWriter().info("deleted " + count + " row");
        if (count != 1 && !isPossibleDuplicate && !SQLTest.setTx) {
            throw new TestException("delete from writer does not delete the corresponding row in back_end, deleted row is " + count);
        }
    }

    private void update(Event event) throws SQLException {
        boolean isPossibleDuplicate = event.isPossibleDuplicate();
        int count = 0;
        String sql = this.getSql(event);
        sql = sql + " where oid = " + event.getPrimaryKey()[0];
        Log.getLogWriter().info("update to derby: " + sql);
        try {
            count = stmt.get().executeUpdate(sql);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("23503")) {
                Log.getLogWriter().info("get foreign key constraint violation, let gemfirexd perform the constraint check as well");
                return;
            }
            throw se;
        }
        if (count != 1 && !isPossibleDuplicate && !SQLTest.setTx) {
            throw new TestException("update from writer does not update the corresponding row in back_end, updated row is " + count);
        }
    }
}

