/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlCallback.writer;

import com.pivotal.gemfirexd.callbacks.Event;
import hydra.Log;
import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import sql.ClientDiscDBManager;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.sqlCallback.writer.AbstractWriter;
import util.TestException;

public class TxhistoryWriter
extends AbstractWriter {
    static String insert = "insert into trade.txhistory values (?,?,?,?,?,?,?,?)";
    static String delete = "delete from trade.txhistory where cid=? and oid=? and sid = ? and qty =? and price=? and ordertime =? and type=? and tid =?";
    static String deleteWithNullOrderTime = "delete from trade.txhistory where cid=? and oid=? and sid = ? and qty =? and price=? and ordertime is null and type=? and tid =?";
    private static String initStr = TestConfig.tab().stringAt(SQLPrms.backendDB_url, "jdbc:derby:test");
    private static ThreadLocal<Connection> dConn = new ThreadLocal<Connection>(){

        @Override
        protected Connection initialValue() {
            Connection dConn = null;
            try {
                dConn = ClientDiscDBManager.getConnection();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return dConn;
        }
    };
    private static ThreadLocal<PreparedStatement> insertStmt = new ThreadLocal<PreparedStatement>(){

        @Override
        protected PreparedStatement initialValue() {
            PreparedStatement stmt = null;
            try {
                stmt = ((Connection)dConn.get()).prepareStatement(insert);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return stmt;
        }
    };
    private static ThreadLocal<PreparedStatement> deleteStmt = new ThreadLocal<PreparedStatement>(){

        @Override
        protected PreparedStatement initialValue() {
            PreparedStatement stmt = null;
            try {
                stmt = ((Connection)dConn.get()).prepareStatement(delete);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return stmt;
        }
    };
    private static ThreadLocal<PreparedStatement> deleteWithNullOrderTimeStmt = new ThreadLocal<PreparedStatement>(){

        @Override
        protected PreparedStatement initialValue() {
            PreparedStatement stmt = null;
            try {
                stmt = ((Connection)dConn.get()).prepareStatement(deleteWithNullOrderTime);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return stmt;
        }
    };
    private static ThreadLocal<Statement> stmt = new ThreadLocal<Statement>(){

        @Override
        protected Statement initialValue() {
            Statement s = null;
            try {
                s = ((Connection)dConn.get()).createStatement();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            return s;
        }
    };

    @Override
    public void close() throws SQLException {
    }

    @Override
    public void init(String initStr) throws SQLException {
        if (!TxhistoryWriter.initStr.equals(initStr)) {
            throw new TestException("init in Writer() does not get the initStr.");
        }
    }

    @Override
    public void onEvent(Event event) throws SQLException {
        Event.Type type = event.getType();
        String eventType = null;
        boolean isPossibleDuplicate = event.isPossibleDuplicate();
        if (isPossibleDuplicate && !SQLTest.isHATest) {
            throw new TestException("Got possible duplicate event but it is  not a HA Test");
        }
        switch (type) {
            case BEFORE_DELETE: {
                this.delete(event);
                break;
            }
            case BEFORE_INSERT: {
                this.insert(event);
                break;
            }
            case BEFORE_UPDATE: {
                this.update(event);
                break;
            }
            case AFTER_UPDATE: {
                eventType = "AFTER_UPDATE";
            }
            case AFTER_INSERT: {
                eventType = "AFTER_INSERT";
            }
            case AFTER_DELETE: {
                eventType = "AFTER_DELETE";
            }
            default: {
                throw new TestException("Writer got a 'none_before' callback event: " + eventType);
            }
        }
        dConn.get().commit();
    }

    private void insert(Event event) throws SQLException {
        Log.getLogWriter().info("in txhistory writer insert event inovcation");
        List oldRow = event.getOldRow();
        List newRow = event.getNewRow();
        boolean isPossibleDuplicate = event.isPossibleDuplicate();
        if (isPossibleDuplicate) {
            Log.getLogWriter().info("possible duplicate record being inserted");
            Object o = SQLBB.getBB().getSharedMap().put((Object)"TxHistoryPosDup", (Object)true);
            if (o == null) {
                Log.getLogWriter().info("no value input in the key");
            } else {
                Log.getLogWriter().info("put into sharedMap for key TxHistoryPosDup: " + o);
            }
        }
        this.doInsert(oldRow, newRow, isPossibleDuplicate);
    }

    private void doInsert(List<Object> oldRow, List<Object> newRow, boolean isPossibleDuplicate) throws SQLException {
        if (oldRow != null) {
            throw new TestException("BEFORE_INSERT in txhistoryWriter is invoked, but oldRow is not null: " + oldRow);
        }
        insertStmt.get().setInt(1, (Integer)newRow.get(0));
        insertStmt.get().setInt(2, (Integer)newRow.get(1));
        insertStmt.get().setInt(3, (Integer)newRow.get(2));
        insertStmt.get().setInt(4, (Integer)newRow.get(3));
        insertStmt.get().setBigDecimal(5, (BigDecimal)newRow.get(4));
        insertStmt.get().setTimestamp(6, (Timestamp)newRow.get(5));
        insertStmt.get().setString(7, (String)newRow.get(6));
        insertStmt.get().setInt(8, (Integer)newRow.get(7));
        Log.getLogWriter().info("inserting into txhistory in derby cid is " + (Integer)newRow.get(0) + " oid is " + (Integer)newRow.get(1) + " sid is " + newRow.get(2) + " qty is " + newRow.get(3) + " price is " + (BigDecimal)newRow.get(4) + " ordertime is " + (Timestamp)newRow.get(5) + " type is " + newRow.get(6) + " tid is " + (Integer)newRow.get(7));
        try {
            insertStmt.get().executeUpdate();
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("23513")) {
                Log.getLogWriter().info("get check constraint violation, let gemfirexd perform the constraint check as well");
                return;
            }
            throw se;
        }
    }

    private void delete(Event event) throws SQLException {
        List oldRow = event.getOldRow();
        List newRow = event.getNewRow();
        int count = 0;
        if (newRow != null) {
            throw new TestException("BEFORE_DELETE is invoked, but newRow is not null: " + newRow);
        }
        if (event.getPrimaryKey()[0] != null) {
            Log.getLogWriter().warning("the primary key in txHistory writer is " + event.getPrimaryKey()[0]);
        }
        Log.getLogWriter().info("deleting from txhistory in derby for cid is " + (Integer)oldRow.get(0) + " oid is " + (Integer)oldRow.get(1) + " sid is " + oldRow.get(2) + " qty is " + oldRow.get(3) + " price is " + (BigDecimal)oldRow.get(4) + " ordertime is " + (Timestamp)oldRow.get(5) + " type is " + oldRow.get(6) + " tid is " + (Integer)oldRow.get(7));
        if (oldRow.get(5) == null) {
            deleteWithNullOrderTimeStmt.get().setInt(1, (Integer)oldRow.get(0));
            deleteWithNullOrderTimeStmt.get().setInt(2, (Integer)oldRow.get(1));
            deleteWithNullOrderTimeStmt.get().setInt(3, (Integer)oldRow.get(2));
            deleteWithNullOrderTimeStmt.get().setInt(4, (Integer)oldRow.get(3));
            deleteWithNullOrderTimeStmt.get().setBigDecimal(5, (BigDecimal)oldRow.get(4));
            deleteWithNullOrderTimeStmt.get().setString(6, (String)oldRow.get(6));
            deleteWithNullOrderTimeStmt.get().setInt(7, (Integer)oldRow.get(7));
            count = deleteWithNullOrderTimeStmt.get().executeUpdate();
            Log.getLogWriter().info("deleted " + count + " row");
        } else {
            deleteStmt.get().setInt(1, (Integer)oldRow.get(0));
            deleteStmt.get().setInt(2, (Integer)oldRow.get(1));
            deleteStmt.get().setInt(3, (Integer)oldRow.get(2));
            deleteStmt.get().setInt(4, (Integer)oldRow.get(3));
            deleteStmt.get().setBigDecimal(5, (BigDecimal)oldRow.get(4));
            deleteStmt.get().setTimestamp(6, (Timestamp)oldRow.get(5));
            deleteStmt.get().setString(7, (String)oldRow.get(6));
            deleteStmt.get().setInt(8, (Integer)oldRow.get(7));
            count = deleteStmt.get().executeUpdate();
            Log.getLogWriter().info("deleted " + count + " row");
        }
    }

    private void update(Event event) throws SQLException {
        List oldRow = event.getOldRow();
        if (event.getPrimaryKey()[0] != null) {
            Log.getLogWriter().warning("the primary key in txHistory writer is " + event.getPrimaryKey()[0]);
        }
        String sql = this.getSql(event);
        sql = oldRow.get(5) == null ? sql + " where cid = " + (Integer)oldRow.get(0) + " and oid = " + (Integer)oldRow.get(1) + " and sid = " + oldRow.get(2) + " and qty = " + oldRow.get(3) + " and price = " + (BigDecimal)oldRow.get(4) + " and ordertime is null " + " and type = '" + oldRow.get(6) + "' and tid = " + (Integer)oldRow.get(7) : sql + " where cid = " + (Integer)oldRow.get(0) + " and oid = " + (Integer)oldRow.get(1) + " and sid = " + oldRow.get(2) + " and qty = " + oldRow.get(3) + " and price = " + (BigDecimal)oldRow.get(4) + " and ordertime = '" + (Timestamp)oldRow.get(5) + "' and type = '" + oldRow.get(6) + "' and tid = " + (Integer)oldRow.get(7);
        Log.getLogWriter().info("update to derby: " + sql);
        stmt.get().executeUpdate(sql);
    }
}

