/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlDAP;

import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.internal.types.ObjectTypeImpl;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.ddlStatements.DAPDDLStmt;
import sql.sqlDAP.DAPHelper;
import sql.sqlDAP.SQLDAPBB;
import sql.sqlDAP.SQLDAPTest;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class DAProcedures {
    static int maxNumOfTries = 2;
    static boolean tidByList = SQLDAPTest.tidByList;
    static boolean cidByRange = SQLDAPTest.cidByRange;
    static boolean concurrentDropDAPOp = SQLDAPTest.concurrentDropDAPOp;
    public static boolean testServerGroupsInheritence = TestConfig.tab().booleanAt(SQLPrms.testServerGroupsInheritence, false);
    public static boolean isHATest = SQLTest.isHATest;
    private static ArrayList<String> portfolioPartitionKeys = null;
    private static ArrayList<String> sellordersPartitionKeys = null;
    boolean updateWrongSG = DAPDDLStmt.updateWrongSG;
    boolean testCustomProcessor = DAPDDLStmt.testCustomProcessor;
    public static boolean toReproduce46311 = TestConfig.tab().booleanAt(SQLPrms.toReproduce46311, false);

    public void callProcedures(Connection dConn, Connection gConn) {
        if (testServerGroupsInheritence & SQLTest.random.nextBoolean()) {
            this.callProceduresWithServerGroups(dConn, gConn);
        } else {
            this.callProceduresWithoutServerGroups(dConn, gConn);
        }
    }

    protected void callProceduresWithoutServerGroups(Connection dConn, Connection gConn) {
        int num = 3;
        if (SQLTest.random.nextInt(num) == 0 && cidByRange) {
            if (SQLTest.random.nextBoolean()) {
                this.callProcedureByCidRangePortfolio(dConn, gConn);
            } else {
                this.callProcedureByCidRangePortfolioUpdate(dConn, gConn);
            }
        } else if (SQLTest.random.nextInt(num) == 1 && this.testCustomProcessor) {
            this.callCustomProcedure(dConn, gConn);
        } else {
            this.callProcedureByTidList(dConn, gConn);
        }
    }

    protected void callProceduresWithServerGroups(Connection dConn, Connection gConn) {
        if (this.updateWrongSG) {
            this.callProcedureUpdateGfxdPortfolioWrongSG(dConn, gConn);
        } else {
            this.callProcedureUpdateSellordersSG(dConn, gConn);
        }
    }

    protected void callProcedureByTidList(Connection dConn, Connection gConn) {
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        String derbyProc = "trade.showDerbyBuyorders";
        String gfxdProc = "trade.showGfxdBuyorders";
        String derbyListStructProc = "trade.getListOfDerbybuyorders";
        String gfxdListStructProc = "trade.getListOfGfxdbuyorders";
        if (dConn != null) {
            if (concurrentDropDAPOp && !DAProcedures.doOp(gfxdProc)) {
                Log.getLogWriter().info("Other threads are performing op on the procedure " + gfxdProc + ", abort this operation");
                return;
            }
            if (SQLTest.random.nextBoolean()) {
                this.callProceduresByTidList(dConn, gConn, derbyProc, gfxdProc, exList);
            }
            if (concurrentDropDAPOp) {
                DAProcedures.zeroCounter(gfxdProc);
            }
        } else if (SQLTest.random.nextBoolean()) {
            this.callProceduresByTidList(gConn, gfxdProc);
        }
    }

    protected void callProceduresByTidList(Connection dConn, Connection gConn, String derbyProc, String gfxdProc, List<SQLException> exList) {
        int tid;
        int oid = SQLTest.random.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeBuyOrdersPrimary));
        ResultSet derbyRS = DAProcedures.callDerbyProceduresByTidList(dConn, derbyProc, oid, tid = this.getMyTid(), exList);
        if (derbyRS == null && exList.size() == 0) {
            return;
        }
        boolean[] successForHA = new boolean[1];
        ResultSet gfxdRS = DAProcedures.callGfxdProceduresByTidList(gConn, gfxdProc, oid, tid, exList, successForHA);
        while (!successForHA[0]) {
            Log.getLogWriter().info("failed to get result set from gfxd");
            gfxdRS = DAProcedures.callGfxdProceduresByTidList(gConn, gfxdProc, oid, tid, exList, successForHA);
        }
        SQLHelper.handleMissedSQLException(exList);
        if (gfxdRS == null && concurrentDropDAPOp) {
            return;
        }
        ResultSetHelper.compareResultSets(derbyRS, gfxdRS);
    }

    protected void callListStructProceduresByTidList(Connection dConn, Connection gConn, String derbyProc, String gfxdProc, List<SQLException> exList) {
        int tid;
        int oid = SQLTest.random.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeBuyOrdersPrimary));
        ResultSet derbyRS = DAProcedures.callDerbyProceduresByTidList(dConn, derbyProc, oid, tid = this.getMyTid(), exList);
        if (derbyRS == null && exList.size() == 0) {
            return;
        }
        List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
        if (derbyList == null) {
            return;
        }
        boolean[] successForHA = new boolean[1];
        Object[] gfxdRS = DAProcedures.callGfxdListStructProceduresByTidList(gConn, gfxdProc, oid, tid, exList, successForHA);
        while (!successForHA[0]) {
            Log.getLogWriter().info("failed to get result set from gfxd");
            gfxdRS = DAProcedures.callGfxdListStructProceduresByTidList(gConn, gfxdProc, oid, tid, exList, successForHA);
        }
        if (gfxdRS.length > 1) {
            StringBuilder aStr = new StringBuilder();
            for (int i = 0; i < gfxdRS.length; ++i) {
                aStr.append(" get the following results " + i + ": " + ((List)gfxdRS[i]).toString());
            }
            throw new TestException("should get only one Object[] but gets " + gfxdRS.length + aStr.toString());
        }
        SQLHelper.handleMissedSQLException(exList);
        if (gfxdRS == null && concurrentDropDAPOp) {
            return;
        }
        ResultSetHelper.compareResultSets(derbyList, (List)gfxdRS[0]);
    }

    protected static ResultSet callDerbyProceduresByTidList(Connection conn, String proc, int oid, int tid, List<SQLException> exList) {
        ResultSet rs = null;
        String sql = "{call " + proc + "(?, ?)}";
        Log.getLogWriter().info("call Derby " + sql + ", myTid is " + tid);
        try {
            rs = DAProcedures.callProcedureByTidList(conn, sql, oid, tid);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return null;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return rs;
    }

    protected static Object[] callGfxdListStructProceduresByTidList(Connection conn, String whichProc, int oid, int tid, List<SQLException> exList, boolean[] success) {
        Object[] rs = null;
        String sql = "{call " + whichProc + "(?, ?)" + " ON Table trade.buyorders where oid < " + oid + " and tid= " + tid + "}";
        Log.getLogWriter().info("call gfxd " + sql + ", myTid is " + tid);
        success[0] = true;
        try {
            rs = DAProcedures.callListStructProcedureByTidList(conn, sql, oid, tid);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01")) {
                Log.getLogWriter().info("got expected exception X0Z01, continuing test");
                success[0] = false;
            }
            SQLHelper.handleGFGFXDException(se, exList);
        }
        return rs;
    }

    protected static ResultSet callProcedureByTidList(Connection conn, String sql, int oid, int tid) throws SQLException {
        SQLWarning warning;
        CallableStatement cs = null;
        cs = conn.prepareCall(sql);
        Log.getLogWriter().info(sql + " with oid: " + oid + " and with tid: " + tid);
        cs.setInt(1, oid);
        cs.setInt(2, tid);
        cs.execute();
        ResultSet rs = cs.getResultSet();
        if (rs == null) {
            Log.getLogWriter().info("could not get result set");
        }
        if ((warning = cs.getWarnings()) != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rs;
    }

    protected static Object[] callListStructProcedureByTidList(Connection conn, String proc, int oid, int tid) throws SQLException {
        CallableStatement cs = null;
        cs = conn.prepareCall("{call " + proc + "(?, ?, ?)}");
        cs.registerOutParameter(3, 2000);
        cs.setInt(1, oid);
        cs.setInt(2, tid);
        cs.execute();
        Object[] rs = (Object[])cs.getObject(3);
        SQLWarning warning = cs.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rs;
    }

    protected static ResultSet callGfxdProceduresByTidList(Connection conn, String whichProc, int oid, int tid, List<SQLException> exList, boolean[] success) {
        ResultSet rs = null;
        String sql = "call " + whichProc + "(?, ?)" + " ON Table trade.buyorders where oid < " + oid + " and tid= " + tid;
        Log.getLogWriter().info("call gfxd procedure " + sql + ", myTid is " + tid);
        success[0] = true;
        try {
            rs = DAProcedures.callProcedureByTidList(conn, sql, oid, tid);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01")) {
                Log.getLogWriter().info("got expected exception, continuing test");
                success[0] = false;
            }
            SQLHelper.handleGFGFXDException(se, exList);
        }
        return rs;
    }

    protected void callProcedureByCidRangePortfolio(Connection dConn, Connection gConn) {
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        String derbyProc = "trade.showDerbyPortfolio";
        String gfxdProc = "trade.showGfxdPortfolio";
        if (dConn != null) {
            if (concurrentDropDAPOp && !DAProcedures.doOp(gfxdProc)) {
                Log.getLogWriter().info("Other threads are performing op on the procedure " + gfxdProc + ", abort this operation");
                return;
            }
            this.callProceduresByCidRangePortfolio(dConn, gConn, derbyProc, gfxdProc, exList);
            if (concurrentDropDAPOp) {
                DAProcedures.zeroCounter(gfxdProc);
            }
        } else {
            this.callProceduresByCidRangePortfolio(gConn, gfxdProc);
        }
    }

    protected void callProceduresByCidRangePortfolio(Connection dConn, Connection gConn, String derbyProc, String gfxdProc, List<SQLException> exList) {
        List<Struct> gfxdList3;
        int[] rangeEnds = DAPHelper.getRangeEnds("portfolio", SQLTest.random.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary)));
        int midPoint = (rangeEnds[0] + rangeEnds[1]) / 2;
        int cid1 = SQLTest.random.nextInt(midPoint - rangeEnds[0]) + rangeEnds[0];
        int cid2 = SQLTest.random.nextInt(rangeEnds[1] - midPoint) + midPoint;
        int sid = SQLTest.random.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary));
        int tid = this.getMyTid();
        int[] derbyData = new int[1];
        int[] gfxdData = new int[1];
        ResultSet[] derbyRS = DAProcedures.callDerbyProceduresByCidRangePortfolio(dConn, derbyProc, cid1, cid2, sid, tid, derbyData, exList);
        if (derbyRS == null && exList.size() == 0) {
            return;
        }
        boolean[] successForHA = new boolean[1];
        ResultSet[] gfxdRS = DAProcedures.callGfxdProceduresByCidRangePortfolio(gConn, gfxdProc, cid1, cid2, sid, tid, gfxdData, exList, successForHA);
        while (!successForHA[0]) {
            Log.getLogWriter().info("failed to get result set from gfxd");
            gfxdRS = DAProcedures.callGfxdProceduresByCidRangePortfolio(gConn, gfxdProc, cid1, cid2, sid, tid, gfxdData, exList, successForHA);
        }
        SQLHelper.handleMissedSQLException(exList);
        if (gfxdRS == null && concurrentDropDAPOp) {
            return;
        }
        if (derbyData[0] != gfxdData[0]) {
            throw new TestException("the out data from derby and gfxd are not equal. derby gets " + derbyData[0] + " but gfxd gets " + gfxdData[0]);
        }
        List<Struct> gfxdList = null;
        List<Struct> derbyList = null;
        for (int i = 0; i < 2; ++i) {
            if (toReproduce46311) {
                derbyList = ResultSetHelper.asList(derbyRS[i], true);
                gfxdList = ResultSetHelper.asList(gfxdRS[i], false);
            } else {
                derbyList = ResultSetHelper.asList(derbyRS[i], ResultSetHelper.getStructType(derbyRS[i]), true);
                gfxdList = ResultSetHelper.asList(gfxdRS[i], ResultSetHelper.getStructType(derbyRS[i]), false);
            }
            if (derbyList == null || gfxdList == null) continue;
            ResultSetHelper.compareResultSets(derbyList, gfxdList);
            Log.getLogWriter().info("compares results set " + (i + 1) + " is successful");
        }
        List<Struct> gfxdList2 = null;
        gfxdList2 = toReproduce46311 ? ResultSetHelper.asList(gfxdRS[2], false) : ResultSetHelper.asList(gfxdRS[2], ResultSetHelper.getStructType(derbyRS[1]), false);
        if (gfxdList2 == null) {
            if (SQLTest.isHATest) {
                Log.getLogWriter().info("could not get results after a few retries");
                return;
            }
            throw new TestException("non HA test and gemfirexd query result is " + gfxdList);
        }
        if (gfxdList != null) {
            ResultSetHelper.compareResultSets(gfxdList, gfxdList2, "second gfxd result", "third gfxd result");
        }
        if ((gfxdList3 = ResultSetHelper.asList(gfxdRS[3], false)) == null) {
            if (SQLTest.isHATest) {
                Log.getLogWriter().info("could not get results after a few retries");
                return;
            }
            throw new TestException("non HA test and gemfirexd query result is " + gfxdList3);
        }
        if (gfxdList3.size() != 1) {
            throw new TestException("DAP on portfolio by cid range does not invoked on only one node got gfxd DAP added result set of " + gfxdList3.toString());
        }
        Log.getLogWriter().info("gets the constructed result set");
    }

    public static boolean doOp(String procName) {
        int doOp = DAProcedures.getCounter(procName);
        int count = 0;
        while (doOp != 1) {
            if (count > maxNumOfTries) {
                return false;
            }
            ++count;
            MasterController.sleepForMs((int)(100 * SQLTest.random.nextInt(30)));
            doOp = DAProcedures.getCounter(procName);
        }
        return true;
    }

    protected static ResultSet[] callDerbyProceduresByCidRangePortfolio(Connection conn, String proc, int cid1, int cid2, int sid, int tid, int[] data, List<SQLException> exList) {
        ResultSet[] rs = null;
        String sql = "{call " + proc + "(?, ?, ?, ?, ?)}";
        Log.getLogWriter().info("call Derby " + sql + ", myTid is " + tid);
        try {
            rs = DAProcedures.callProcedureByCidRangePortfolio(conn, sql, cid1, cid2, sid, tid, data);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return null;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return rs;
    }

    protected static ResultSet[] callGfxdProceduresByCidRangePortfolio(Connection conn, String proc, int cid1, int cid2, int sid, int tid, int[] data, List<SQLException> exList, boolean[] success) {
        ResultSet[] rs = null;
        String sql = "{call " + proc + "(?, ?, ?, ?, ?)" + " ON Table trade.portfolio where cid > " + cid1 + " and cid< " + cid2 + " and tid=" + tid + "}";
        Log.getLogWriter().info("call gfxd procedure " + sql + ", myTid is " + tid);
        success[0] = true;
        try {
            rs = DAProcedures.callProcedureByCidRangePortfolio(conn, sql, cid1, cid2, sid, tid, data);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01")) {
                Log.getLogWriter().info("got expected exception, continuing test");
                success[0] = false;
            }
            SQLHelper.handleGFGFXDException(se, exList);
        }
        return rs;
    }

    protected static ResultSet[] callProcedureByCidRangePortfolio(Connection conn, String sql, int cid1, int cid2, int sid, int tid, int[] data) throws SQLException {
        SQLWarning warning;
        ResultSet[] rs = new ResultSet[4];
        CallableStatement cs = null;
        cs = conn.prepareCall(sql);
        Log.getLogWriter().info(sql + " with cid1: " + cid1 + " and with cid2: " + cid2 + " with sid: " + sid + " and with tid: " + tid);
        cs.setInt(1, cid1);
        cs.setInt(2, cid2);
        cs.setInt(3, sid);
        cs.setInt(4, tid);
        cs.registerOutParameter(5, 4);
        cs.execute();
        data[0] = new Integer(cs.getInt(5));
        rs[0] = cs.getResultSet();
        int i = 1;
        while (cs.getMoreResults(2)) {
            Log.getLogWriter().info("has more results");
            rs[i] = cs.getResultSet();
            ++i;
        }
        if (rs == null) {
            Log.getLogWriter().info("could not get result sets in callProcedureByCidRangePortfolio");
        }
        if ((warning = cs.getWarnings()) != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rs;
    }

    public static int getCounter(String procName) {
        if (procName.startsWith("trade.showGfxdBuyorders")) {
            int counter = (int)SQLDAPBB.getBB().getSharedCounters().incrementAndRead(SQLDAPBB.showGfxdBuyorders);
            Log.getLogWriter().info(procName + " counter is " + counter + " ");
            return counter;
        }
        if (procName.startsWith("trade.getListOfGfxdbuyorders")) {
            int counter = (int)SQLDAPBB.getBB().getSharedCounters().incrementAndRead(SQLDAPBB.getListOfGfxdBuyorders);
            Log.getLogWriter().info(procName + " counter is " + counter + " ");
            return counter;
        }
        if (procName.startsWith("trade.updateGfxdPortfolioWrongSG")) {
            int counter = (int)SQLDAPBB.getBB().getSharedCounters().incrementAndRead(SQLDAPBB.updateGfxdPortfolioWrongSG);
            Log.getLogWriter().info(procName + " counter is " + counter + " ");
            return counter;
        }
        if (procName.startsWith("trade.updateGfxdPortfolioByCidRange")) {
            int counter = (int)SQLDAPBB.getBB().getSharedCounters().incrementAndRead(SQLDAPBB.updateGfxdPortfolioByCidRange);
            Log.getLogWriter().info(procName + " counter is " + counter + " ");
            return counter;
        }
        if (procName.startsWith("trade.updateGfxdSellordersSG")) {
            int counter = (int)SQLDAPBB.getBB().getSharedCounters().incrementAndRead(SQLDAPBB.updateGfxdSellordersSG);
            Log.getLogWriter().info(procName + " counter is " + counter + " ");
            return counter;
        }
        if (procName.startsWith("trade.customGfxdProc")) {
            int counter = (int)SQLDAPBB.getBB().getSharedCounters().incrementAndRead(SQLDAPBB.customGfxdProc);
            Log.getLogWriter().info(procName + " counter is " + counter + " ");
            return counter;
        }
        return -1;
    }

    public static void zeroCounter(String procName) {
        if (procName.startsWith("trade.showGfxdBuyorders")) {
            SQLDAPBB.getBB().getSharedCounters().zero(SQLDAPBB.showGfxdBuyorders);
            Log.getLogWriter().info("zeros counter SQLDAPBB.showGfxdBuyorders");
        } else if (procName.startsWith("trade.getListOfGfxdbuyorders")) {
            SQLDAPBB.getBB().getSharedCounters().zero(SQLDAPBB.getListOfGfxdBuyorders);
            Log.getLogWriter().info("zeros counter SQLDAPBB.getListOfGfxdBuyorders");
        } else if (procName.startsWith("trade.updateGfxdPortfolioWrongSG")) {
            SQLDAPBB.getBB().getSharedCounters().zero(SQLDAPBB.updateGfxdPortfolioWrongSG);
            Log.getLogWriter().info("zeros counter SQLDAPBB.updateGfxdPortfolioWrongSG");
        } else if (procName.startsWith("trade.updateGfxdPortfolioWrongSG")) {
            SQLDAPBB.getBB().getSharedCounters().zero(SQLDAPBB.updateGfxdPortfolioByCidRange);
            Log.getLogWriter().info("zeros counter SQLDAPBB.updateGfxdPortfolioByCidRange");
        } else if (procName.startsWith("trade.updateGfxdSellordersSG")) {
            SQLDAPBB.getBB().getSharedCounters().zero(SQLDAPBB.updateGfxdSellordersSG);
            Log.getLogWriter().info("zeros counter SQLDAPBB.updateGfxdSellordersSG");
        } else if (procName.startsWith("trade.customGfxdProc")) {
            SQLDAPBB.getBB().getSharedCounters().zero(SQLDAPBB.customGfxdProc);
            Log.getLogWriter().info("zeros counter SQLDAPBB.customGfxdProc");
        }
    }

    protected int getMyTid() {
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        return myTid;
    }

    protected void callProcedureUpdateGfxdPortfolioWrongSG(Connection dConn, Connection gConn) {
        String gfxdProc = "trade.updateGfxdPortfolioWrongSG";
        Log.getLogWriter().info("gfxdProc is " + gfxdProc);
        if (dConn != null) {
            if (concurrentDropDAPOp && !DAProcedures.doOp(gfxdProc)) {
                Log.getLogWriter().info("Other threads are performing op on the procedure " + gfxdProc + ", abort this operation");
                return;
            }
            this.callProceduresUpdateGfxdPortfolioWrongSG(gConn, gfxdProc);
            if (concurrentDropDAPOp) {
                DAProcedures.zeroCounter(gfxdProc);
            }
        } else {
            this.callProceduresUpdateGfxdPortfolioWrongSG(gConn, gfxdProc);
        }
    }

    protected void callProceduresUpdateGfxdPortfolioWrongSG(Connection conn, String proc) {
        String wrongSG = SQLDAPTest.getWrongServerGroups("portfolio");
        if (wrongSG == null) {
            Log.getLogWriter().info("Not able to perform, as porfolio is created on default server groups");
            return;
        }
        int qty = SQLTest.random.nextInt(2000);
        BigDecimal subTotal = new BigDecimal(Double.toString((double)(SQLTest.random.nextInt(10000) + 1) * 0.01)).multiply(new BigDecimal(String.valueOf(qty)));
        String sql = "{call " + proc + "(?, ?)" + " ON SERVER GROUPS (" + wrongSG + ")}";
        Log.getLogWriter().info("call gfxd procedure " + sql + " with subtotal: " + subTotal + " and qty:" + qty);
        try {
            CallableStatement cs = null;
            cs = conn.prepareCall(sql);
            cs.setBigDecimal(1, subTotal);
            cs.setInt(2, qty);
        }
        catch (SQLException se) {
            DAProcedures.checkGFGFXDException(se);
        }
    }

    protected void callProcedureByCidRangePortfolioUpdate(Connection dConn, Connection gConn) {
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        String derbyProc = "trade.updateDerbyPortfolioByCidRange";
        String gfxdProc = "trade.updateGfxdPortfolioByCidRange";
        if (dConn != null) {
            if (concurrentDropDAPOp && !DAProcedures.doOp(gfxdProc)) {
                Log.getLogWriter().info("Other threads are performing op on the procedure " + gfxdProc + ", abort this operation");
                return;
            }
            this.callProceduresByCidRangePortfolioUpdate(dConn, gConn, derbyProc, gfxdProc, exList);
            if (concurrentDropDAPOp) {
                DAProcedures.zeroCounter(gfxdProc);
            }
        } else {
            this.callProceduresByCidRangePortfolioUpdate(gConn, gfxdProc);
        }
    }

    protected void callProceduresByCidRangePortfolioUpdate(Connection dConn, Connection gConn, String derbyProc, String gfxdProc, List<SQLException> exList) {
        if (this.updatePortfolioOnSubtotal()) {
            return;
        }
        int[] rangeEnds = DAPHelper.getRangeEnds("portfolio", SQLTest.random.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary)));
        int midPoint = (rangeEnds[0] + rangeEnds[1]) / 2;
        int cid1 = SQLTest.random.nextInt(midPoint - rangeEnds[0]) + rangeEnds[0];
        int cid2 = SQLTest.random.nextInt(rangeEnds[1] - midPoint) + rangeEnds[1];
        int tid = this.getMyTid();
        int qty = SQLTest.random.nextInt(2000);
        BigDecimal subTotal = new BigDecimal(Double.toString((double)(SQLTest.random.nextInt(10000) + 1) * 0.01)).multiply(new BigDecimal(String.valueOf(qty)));
        boolean success = DAProcedures.callDerbyProceduresByCidRangePortfolioUpdate(dConn, derbyProc, cid1, cid2, subTotal, tid, exList);
        if (!success) {
            return;
        }
        boolean[] successForHA = new boolean[1];
        DAProcedures.callGfxdProceduresByCidRangePortfolioUpdate(gConn, gfxdProc, cid1, cid2, subTotal, tid, exList, successForHA);
        while (!successForHA[0]) {
            Log.getLogWriter().info("failed to get result set from gfxd");
            DAProcedures.callGfxdProceduresByCidRangePortfolioUpdate(gConn, gfxdProc, cid1, cid2, subTotal, tid, exList, successForHA);
        }
        SQLHelper.handleMissedSQLException(exList);
    }

    protected static boolean callDerbyProceduresByCidRangePortfolioUpdate(Connection conn, String proc, int cid1, int cid2, BigDecimal subTotal, int tid, List<SQLException> exList) {
        String sql = "{call " + proc + "(?, ?, ?, ?)}";
        Log.getLogWriter().info("call Derby " + sql + ", myTid is " + tid);
        try {
            DAProcedures.callProcedureByCidRangePortfolioUpdate(conn, sql, cid1, cid2, subTotal, tid);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    protected static void callGfxdProceduresByCidRangePortfolioUpdate(Connection conn, String proc, int cid1, int cid2, BigDecimal subTotal, int tid, List<SQLException> exList, boolean[] success) {
        String sql = "{call " + proc + "(?, ?, ?, ?)" + " ON Table trade.portfolio where cid > " + cid1 + " and cid< " + cid2 + " and tid=" + tid + "}";
        Log.getLogWriter().info("call gfxd procedure " + sql + ", myTid is " + tid);
        success[0] = true;
        try {
            DAProcedures.callProcedureByCidRangePortfolioUpdate(conn, sql, cid1, cid2, subTotal, tid);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().info("got expected exception X0Z01, continuing test");
                success[0] = false;
            }
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    protected static void callProcedureByCidRangePortfolioUpdate(Connection conn, String sql, int cid1, int cid2, BigDecimal subTotal, int tid) throws SQLException {
        CallableStatement cs = null;
        cs = conn.prepareCall(sql);
        Log.getLogWriter().info(sql + " with cid1: " + cid1 + " and with cid2: " + cid2 + " with subTotal: " + subTotal + " and with tid: " + tid);
        cs.setInt(1, cid1);
        cs.setInt(2, cid2);
        cs.setBigDecimal(3, subTotal);
        cs.setInt(4, tid);
        cs.execute();
        SQLWarning warning = cs.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
    }

    private boolean updatePortfolioOnSubtotal() {
        if (portfolioPartitionKeys == null) {
            portfolioPartitionKeys = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"portfolioPartition");
        }
        return portfolioPartitionKeys.contains("subTotal");
    }

    protected void callProcedureUpdateSellordersSG(Connection dConn, Connection gConn) {
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        String derbyProc = "trade.updateDerbySellordersSG";
        String gfxdProc = "trade.updateGfxdSellordersSG";
        if (dConn != null) {
            if (concurrentDropDAPOp && !DAProcedures.doOp(gfxdProc)) {
                Log.getLogWriter().info("Other threads are performing op on the procedure " + gfxdProc + ", abort this operation");
                return;
            }
            this.callProceduresSellordersSGUpdate(dConn, gConn, derbyProc, gfxdProc, exList);
            if (concurrentDropDAPOp) {
                DAProcedures.zeroCounter(gfxdProc);
            }
        } else {
            this.callProceduresSellordersSGUpdate(gConn, gfxdProc);
        }
    }

    protected void callProceduresSellordersSGUpdate(Connection dConn, Connection gConn, String derbyProc, String gfxdProc, List<SQLException> exList) {
        if (this.updateSellordersOnOrderTime()) {
            return;
        }
        int tid = this.getMyTid();
        Timestamp orderTime = new Timestamp(System.currentTimeMillis());
        boolean success = DAProcedures.callDerbyProceduresSellordersSGUpdate(dConn, derbyProc, orderTime, tid, exList);
        if (!success) {
            return;
        }
        boolean[] successForHA = new boolean[1];
        DAProcedures.callGfxdProceduresSellordersSGUpdate(gConn, gfxdProc, orderTime, tid, exList, successForHA);
        while (!successForHA[0]) {
            Log.getLogWriter().info("failed to get result set from gfxd");
            DAProcedures.callGfxdProceduresSellordersSGUpdate(gConn, gfxdProc, orderTime, tid, exList, successForHA);
        }
        SQLHelper.handleMissedSQLException(exList);
    }

    protected static boolean callDerbyProceduresSellordersSGUpdate(Connection conn, String proc, Timestamp orderTime, int tid, List<SQLException> exList) {
        String sql = "{call " + proc + "(?, ?)}";
        Log.getLogWriter().info("call Derby " + sql + ", myTid is " + tid);
        try {
            DAProcedures.callProcedureSellordersSGUpdate(conn, sql, orderTime, tid);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    protected static void callGfxdProceduresSellordersSGUpdate(Connection conn, String proc, Timestamp orderTime, int tid, List<SQLException> exList, boolean[] success) {
        String sellordersSG = SQLDAPTest.getServerGroups("sellorders");
        String sgOption = sellordersSG != null ? (SQLTest.random.nextInt(10) == 1 ? " ON ALL" : " ON SERVER GROUPS (" + sellordersSG + ")") : " ON ALL";
        String sql = "{call " + proc + "(?, ?)" + sgOption + "}";
        Log.getLogWriter().info("call gfxd procedure " + sql + ", myTid is " + tid);
        success[0] = true;
        try {
            DAProcedures.callProcedureSellordersSGUpdate(conn, sql, orderTime, tid);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().info("got expected exception X0Z01, continuing test");
                success[0] = false;
            }
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    protected static void callProcedureSellordersSGUpdate(Connection conn, String sql, Timestamp orderTime, int tid) throws SQLException {
        CallableStatement cs = null;
        cs = conn.prepareCall(sql);
        Log.getLogWriter().info(sql + " with order_time: " + orderTime + " and with tid: " + tid);
        cs.setTimestamp(1, orderTime);
        cs.setInt(2, tid);
        cs.execute();
        SQLWarning warning = cs.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
    }

    private boolean updateSellordersOnOrderTime() {
        if (sellordersPartitionKeys == null) {
            sellordersPartitionKeys = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"sellordersPartition");
        }
        return sellordersPartitionKeys.contains("order_time");
    }

    protected void callCustomProcedure(Connection dConn, Connection gConn) {
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        String derbyProc = null;
        String gfxdProc = "trade.customGfxdProc";
        if (dConn != null) {
            if (concurrentDropDAPOp && !DAProcedures.doOp(gfxdProc)) {
                Log.getLogWriter().info("Other threads are performing op on the procedure " + gfxdProc + ", abort this operation");
                return;
            }
            this.callCustomProcedure(dConn, gConn, derbyProc, gfxdProc, exList);
            if (concurrentDropDAPOp) {
                DAProcedures.zeroCounter(gfxdProc);
            }
        }
    }

    protected void callCustomProcedure(Connection dConn, Connection gConn, String derbyProc, String gfxdProc, List<SQLException> exList) {
        int tid = this.getMyTid();
        int[] rangeEnds = DAPHelper.getRangeEnds("portfolio", SQLTest.random.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary)));
        int midPoint = (rangeEnds[0] + rangeEnds[1]) / 2;
        int cid1 = SQLTest.random.nextInt(midPoint - rangeEnds[0]) + rangeEnds[0];
        int cid2 = SQLTest.random.nextInt(rangeEnds[1] - midPoint) + rangeEnds[1];
        boolean[] successForHA = new boolean[1];
        DAProcedures.callGfxdCustomProcedure(gConn, gfxdProc, cid1, cid2, tid, exList, successForHA);
        while (!successForHA[0]) {
            Log.getLogWriter().info("failed to get result set from gfxd");
            DAProcedures.callGfxdCustomProcedure(gConn, gfxdProc, cid1, cid2, tid, exList, successForHA);
        }
        SQLHelper.handleMissedSQLException(exList);
    }

    protected static void callGfxdCustomProcedure(Connection conn, String proc, int cid1, int cid2, int tid, List<SQLException> exList, boolean[] success) {
        String sgOption = " ON ALL";
        String processor = " With Result Processor customProcessor";
        String sql = "{call " + proc + "(?, ?, ?)" + processor + " on table trade.customers where cid>=1" + "}";
        Log.getLogWriter().info("call gfxd procedure " + sql + ", myTid is " + tid);
        success[0] = true;
        try {
            ResultSet[] rs = DAProcedures.callCustomProcedure(conn, sql, cid1, cid2, tid);
            List<Struct> list1 = ResultSetHelper.asList(rs[0], false);
            Log.getLogWriter().info("first custom result set is: \n" + ResultSetHelper.listToString(list1));
            List<Struct> list2 = ResultSetHelper.asList(rs[1], false);
            Log.getLogWriter().info("second custom result set is: \n" + ResultSetHelper.listToString(list2));
            List<Struct> list3 = ResultSetHelper.asList(rs[2], false);
            if (list3.size() > 1) {
                throw new TestException("got duplicate resulst with <local> for get converitible type query " + ResultSetHelper.listToString(list3));
            }
            Log.getLogWriter().info("second custom result set is: \n" + ResultSetHelper.listToString(list3));
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().info("got expected exception X0Z01, continuing test");
                success[0] = false;
            }
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    protected static ResultSet[] callCustomProcedure(Connection conn, String sql, int cid1, int cid2, int tid) throws SQLException {
        SQLWarning warning;
        ResultSet[] rs = new ResultSet[3];
        CallableStatement cs = null;
        cs = conn.prepareCall(sql);
        Log.getLogWriter().info(sql + " with cid1: " + cid1 + " and with cid2: " + cid2 + " and with tid: " + tid);
        cs.setInt(1, cid1);
        cs.setInt(2, cid2);
        cs.setInt(3, tid);
        cs.execute();
        rs[0] = cs.getResultSet();
        if (cs.getMoreResults(2)) {
            rs[1] = cs.getResultSet();
        }
        if (cs.getMoreResults(2)) {
            rs[2] = cs.getResultSet();
        }
        if ((warning = cs.getWarnings()) != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rs;
    }

    protected void callProceduresByTidList(Connection gConn, String gfxdProc) {
        int oid = SQLTest.random.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeBuyOrdersPrimary));
        int tid = this.getMyTid();
        boolean[] successForHA = new boolean[1];
        ResultSet gfxdRS = DAProcedures.callGfxdProceduresByTidList(gConn, gfxdProc, oid, tid, successForHA);
        while (!successForHA[0]) {
            Log.getLogWriter().info("failed to get result set from gfxd");
            gfxdRS = DAProcedures.callGfxdProceduresByTidList(gConn, gfxdProc, oid, tid, successForHA);
        }
        if (gfxdRS == null && concurrentDropDAPOp) {
            return;
        }
        ResultSetHelper.asList(gfxdRS, false);
    }

    protected static ResultSet callGfxdProceduresByTidList(Connection conn, String whichProc, int oid, int tid, boolean[] success) {
        ResultSet rs = null;
        String sql = "{call " + whichProc + "(?, ?)" + " ON Table trade.buyorders where oid < " + oid + " and tid= " + tid + "}";
        Log.getLogWriter().info("call gfxd procedure " + sql + ", myTid is " + tid);
        success[0] = true;
        try {
            rs = DAProcedures.callProcedureByTidList(conn, sql, oid, tid);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().info("got expected exception, continuing test");
                success[0] = false;
            }
            DAProcedures.checkGFGFXDException(se);
        }
        return rs;
    }

    protected void callListStructProceduresByTidList(Connection gConn, String gfxdProc) {
        int oid = SQLTest.random.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeBuyOrdersPrimary));
        int tid = this.getMyTid();
        boolean[] successForHA = new boolean[1];
        Object[] gfxdRS = DAProcedures.callGfxdListStructProceduresByTidList(gConn, gfxdProc, oid, tid, successForHA);
        while (!successForHA[0]) {
            Log.getLogWriter().info("failed to get result set from gfxd");
            gfxdRS = DAProcedures.callGfxdListStructProceduresByTidList(gConn, gfxdProc, oid, tid, successForHA);
        }
        if (gfxdRS.length > 1) {
            StringBuilder aStr = new StringBuilder();
            for (int i = 0; i < gfxdRS.length; ++i) {
                aStr.append(" get the following results " + i + ": " + ((List)gfxdRS[i]).toString());
            }
            throw new TestException("should get only one Object[] but gets " + gfxdRS.length + aStr.toString());
        }
        if (gfxdRS == null && concurrentDropDAPOp) {
            return;
        }
    }

    protected static Object[] callGfxdListStructProceduresByTidList(Connection conn, String whichProc, int oid, int tid, boolean[] success) {
        Object[] rs = null;
        String sql = "{call " + whichProc + "(?, ?)" + " ON Table trade.buyorders where oid < " + oid + " and tid= " + tid + "}";
        Log.getLogWriter().info("call gfxd " + sql + ", myTid is " + tid);
        success[0] = true;
        try {
            rs = DAProcedures.callListStructProcedureByTidList(conn, sql, oid, tid);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().info("got expected exception X0Z01, continuing test");
                success[0] = false;
            }
            DAProcedures.checkGFGFXDException(se);
        }
        return rs;
    }

    protected static void checkGFGFXDException(SQLException se) {
        if (se.getSQLState().equals("42Y55") || se.getSQLState().equals("42X94") || se.getSQLState().equals("42Y03")) {
            Log.getLogWriter().info("expected procedrue does not exist exception, continuing test");
        } else if (se.getSQLState().equals("X0Y68")) {
            Log.getLogWriter().info("expected procedrue already exist exception, continuing test");
        } else {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void callProceduresByCidRangePortfolio(Connection gConn, String gfxdProc) {
        List<Struct> gfxdList3;
        int[] rangeEnds = DAPHelper.getRangeEnds("portfolio", SQLTest.random.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary)));
        int midPoint = (rangeEnds[0] + rangeEnds[1]) / 2;
        int cid1 = SQLTest.random.nextInt(midPoint - rangeEnds[0]) + rangeEnds[0];
        int cid2 = SQLTest.random.nextInt(rangeEnds[1] - midPoint) + midPoint;
        int sid = SQLTest.random.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary));
        int tid = this.getMyTid();
        int[] gfxdData = new int[1];
        boolean[] successForHA = new boolean[1];
        ResultSet[] gfxdRS = DAProcedures.callGfxdProceduresByCidRangePortfolio(gConn, gfxdProc, cid1, cid2, sid, tid, gfxdData, successForHA);
        while (!successForHA[0]) {
            Log.getLogWriter().info("failed to get result set from gfxd");
            gfxdRS = DAProcedures.callGfxdProceduresByCidRangePortfolio(gConn, gfxdProc, cid1, cid2, sid, tid, gfxdData, successForHA);
        }
        if (gfxdRS == null && concurrentDropDAPOp) {
            return;
        }
        List<Struct> gfxdList = null;
        for (int i = 0; i < 2; ++i) {
            gfxdList = ResultSetHelper.asList(gfxdRS[i], false);
        }
        List<Struct> gfxdList2 = ResultSetHelper.asList(gfxdRS[2], false);
        if (gfxdList2 == null) {
            if (SQLTest.isHATest) {
                Log.getLogWriter().info("could not get results after a few retries");
                return;
            }
            throw new TestException("non HA test and gemfirexd query result is " + gfxdList);
        }
        if (SQLTest.testUniqueKeys && gfxdList != null) {
            ResultSetHelper.compareResultSets(gfxdList, gfxdList2);
        }
        if ((gfxdList3 = ResultSetHelper.asList(gfxdRS[3], false)).size() != 1) {
            throw new TestException("DAP on portfolio by cid range does not invoked on only one node got gfxd DAP added result set of " + gfxdList3.toString());
        }
        Log.getLogWriter().info("gets the constructed result set");
    }

    protected static ResultSet[] callGfxdProceduresByCidRangePortfolio(Connection conn, String proc, int cid1, int cid2, int sid, int tid, int[] data, boolean[] success) {
        ResultSet[] rs = null;
        String sql = "{call " + proc + "(?, ?, ?, ?, ?)" + " ON Table trade.portfolio where cid > " + cid1 + " and cid< " + cid2 + " and tid=" + tid + "}";
        Log.getLogWriter().info("call gfxd procedure " + sql + ", myTid is " + tid);
        success[0] = true;
        try {
            rs = DAProcedures.callProcedureByCidRangePortfolio(conn, sql, cid1, cid2, sid, tid, data);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01")) {
                Log.getLogWriter().info("got expected exception, continuing test");
                success[0] = false;
            }
            DAProcedures.checkGFGFXDException(se);
        }
        return rs;
    }

    protected void callProceduresByCidRangePortfolioUpdate(Connection gConn, String gfxdProc) {
        if (this.updatePortfolioOnSubtotal()) {
            return;
        }
        int[] rangeEnds = DAPHelper.getRangeEnds("portfolio", SQLTest.random.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary)));
        int midPoint = (rangeEnds[0] + rangeEnds[1]) / 2;
        int cid1 = SQLTest.random.nextInt(midPoint - rangeEnds[0]) + rangeEnds[0];
        int cid2 = SQLTest.random.nextInt(rangeEnds[1] - midPoint) + rangeEnds[1];
        int tid = this.getMyTid();
        int qty = SQLTest.random.nextInt(2000);
        BigDecimal subTotal = new BigDecimal(Double.toString((double)(SQLTest.random.nextInt(10000) + 1) * 0.01)).multiply(new BigDecimal(String.valueOf(qty)));
        boolean[] successForHA = new boolean[1];
        DAProcedures.callGfxdProceduresByCidRangePortfolioUpdate(gConn, gfxdProc, cid1, cid2, subTotal, tid, successForHA);
        while (!successForHA[0]) {
            Log.getLogWriter().info("failed to get result set from gfxd");
            DAProcedures.callGfxdProceduresByCidRangePortfolioUpdate(gConn, gfxdProc, cid1, cid2, subTotal, tid, successForHA);
        }
    }

    protected static void callGfxdProceduresByCidRangePortfolioUpdate(Connection conn, String proc, int cid1, int cid2, BigDecimal subTotal, int tid, boolean[] success) {
        String sql = "{call " + proc + "(?, ?, ?, ?)" + " ON Table trade.portfolio where cid > " + cid1 + " and cid< " + cid2 + " and tid=" + tid + "}";
        Log.getLogWriter().info("call gfxd procedure " + sql + ", myTid is " + tid);
        success[0] = true;
        try {
            DAProcedures.callProcedureByCidRangePortfolioUpdate(conn, sql, cid1, cid2, subTotal, tid);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().info("got expected exception X0Z01, continuing test");
                success[0] = false;
            }
            DAProcedures.checkGFGFXDException(se);
        }
    }

    protected void callProceduresSellordersSGUpdate(Connection gConn, String gfxdProc) {
        if (this.updateSellordersOnOrderTime()) {
            return;
        }
        int tid = this.getMyTid();
        Timestamp orderTime = new Timestamp(System.currentTimeMillis());
        boolean[] successForHA = new boolean[1];
        DAProcedures.callGfxdProceduresSellordersSGUpdate(gConn, gfxdProc, orderTime, tid, successForHA);
        while (!successForHA[0]) {
            Log.getLogWriter().info("failed to get result set from gfxd");
            DAProcedures.callGfxdProceduresSellordersSGUpdate(gConn, gfxdProc, orderTime, tid, successForHA);
        }
    }

    protected static void callGfxdProceduresSellordersSGUpdate(Connection conn, String proc, Timestamp orderTime, int tid, boolean[] success) {
        String sellordersSG = SQLDAPTest.getServerGroups("sellorders");
        String sgOption = sellordersSG != null ? (SQLTest.random.nextInt(10) == 1 ? " ON ALL" : " ON SERVER GROUPS (" + sellordersSG + ")") : " ON ALL";
        String sql = "{call " + proc + "(?, ?)" + sgOption + "}";
        Log.getLogWriter().info("call gfxd procedure " + sql + ", myTid is " + tid);
        success[0] = true;
        try {
            DAProcedures.callProcedureSellordersSGUpdate(conn, sql, orderTime, tid);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().info("got expected exception X0Z01, continuing test");
                success[0] = false;
            }
            DAProcedures.checkGFGFXDException(se);
        }
    }

    protected static void printMetaData(ResultSet rs) {
        int numOfColumns;
        ResultSetMetaData rsmd;
        try {
            rsmd = rs.getMetaData();
            numOfColumns = rsmd.getColumnCount();
        }
        catch (SQLException se) {
            throw new TestException("could not get resultSet metaData" + TestHelper.getStackTrace((Throwable)se));
        }
        ObjectType[] oTypes = new ObjectType[numOfColumns];
        String[] fieldNames = new String[numOfColumns];
        try {
            for (int i = 0; i < numOfColumns; ++i) {
                oTypes[i] = new ObjectTypeImpl(Class.forName(rsmd.getColumnClassName(i + 1)));
                fieldNames[i] = rsmd.getColumnName(i + 1);
                Log.getLogWriter().info("field name " + i + " is " + fieldNames[i] + " type is " + rsmd.getColumnClassName(i + 1));
            }
        }
        catch (SQLException se) {
            throw new TestException("could not getStruct from resultSet\n" + TestHelper.getStackTrace((Throwable)se));
        }
        catch (ClassNotFoundException cnfe) {
            throw new TestException("no class available for a column in result set\n" + TestHelper.getStackTrace((Throwable)cnfe));
        }
    }
}

