/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlDAP;

import hydra.HydraVector;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.ddlStatements.DAPDDLStmt;
import sql.sqlDAP.DAProcedures;
import sql.sqlDAP.SQLDAPBB;
import sql.sqlDAP.SQLDAPPrms;
import util.PRObserver;

public class SQLDAPTest
extends SQLTest {
    protected static SQLDAPTest dapTest = null;
    public static boolean concurrentDropDAPOp = TestConfig.tab().booleanAt(SQLDAPPrms.concurrentDropDAPOp, false);
    public static boolean cidByRange = TestConfig.tab().booleanAt(SQLDAPPrms.cidByRange, false);
    public static boolean tidByList = TestConfig.tab().booleanAt(SQLDAPPrms.tidByList, false);
    static String dapList = "DAPList";

    public static synchronized void HydraTask_initialize() {
        if (dapTest == null) {
            dapTest = new SQLDAPTest();
            PRObserver.installObserverHook();
            PRObserver.initialize((int)RemoteTestModule.getMyVmid());
            if (sqlTest == null) {
                sqlTest = new SQLTest();
            }
        }
        dapTest.initialize();
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    public static void HydraTask_createDAProcedures() {
        dapTest.createDAProcedures();
    }

    protected void createDAProcedures() {
        Log.getLogWriter().info("performing create data aware procedure Op, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getHdfsQueryConnection();
        this.createDAProcedures(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void createDAProcedures(Connection dConn, Connection gConn) {
        DAPDDLStmt procStmt = new DAPDDLStmt();
        procStmt.createDDLs(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
    }

    public static void HydraTask_callDAProcedures() {
        dapTest.callDAProcedures();
    }

    protected void callDAProcedures() {
        Log.getLogWriter().info("call procedures, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getHdfsQueryConnection();
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (setTx && isHATest) {
            this.resetNodeFailureFlag();
        }
        if (setTx && testEviction) {
            this.resetEvictionConflictFlag();
        }
        this.callProcedures(dConn, gConn);
        if (hasDerbyServer) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    @Override
    protected void callProcedures(Connection dConn, Connection gConn) {
        new DAProcedures().callProcedures(dConn, gConn);
        if (setTx) {
            this.commit(gConn);
            this.commit(dConn);
        } else {
            this.commit(dConn);
            this.commit(gConn);
        }
    }

    public static synchronized void HydraTask_createGFXDDBSG() {
        dapTest.createGFXDDBSG();
    }

    @Override
    protected void createGFXDDBSG() {
        Properties info = this.getGemFireProperties();
        HydraVector vec = TestConfig.tab().vecAt(SQLPrms.serverGroups);
        int whichOne = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.dataStoreCount);
        whichOne = whichOne <= vec.size() ? --whichOne : vec.size() - 1;
        int myVMId = RemoteTestModule.getMyVmid();
        String sg = null;
        sg = (String)SQLDAPBB.getBB().getSharedMap().get((Object)("dataStoreSG" + myVMId));
        if (sg == null) {
            sg = (String)((HydraVector)vec.elementAt(whichOne)).elementAt(0);
            SQLDAPBB.getBB().getSharedMap().put((Object)("dataStoreSG" + myVMId), (Object)sg);
        }
        Log.getLogWriter().info("This data store for vmId " + myVMId + " is in " + sg);
        if (!sg.equals("default")) {
            info.setProperty("server-groups", sg);
        }
        info.setProperty("host-data", "true");
        Log.getLogWriter().info("Connecting with properties: " + info);
        this.startGFXDDB(info);
    }

    public static void HydraTask_getServerGroups() {
        String[] tableNames = SQLPrms.getTableNames();
        SharedMap sgMap = SQLBB.getBB().getSharedMap();
        for (String table : tableNames) {
            String tableSG = table.substring(table.indexOf(46) + 1) + "SG";
            String sg = (String)sgMap.get((Object)tableSG);
            Log.getLogWriter().info(table + " server group is " + sg);
            String[] sgArray = sg.split(",");
            ArrayList<String> sgList = new ArrayList<String>(Arrays.asList(sgArray));
            sgMap.put((Object)(tableSG + dapList), sgList);
        }
    }

    public static String getWrongServerGroups(String table) {
        SharedMap sgMap = SQLBB.getBB().getSharedMap();
        ArrayList sgList = (ArrayList)sgMap.get((Object)(table + "SG" + dapList));
        StringBuilder sb = new StringBuilder();
        if (!sgList.contains("SG1")) {
            sb.append("SG1,");
        }
        if (!sgList.contains("SG2")) {
            sb.append("SG2,");
        }
        if (!sgList.contains("SG3")) {
            sb.append("SG3,");
        }
        if (!sgList.contains("SG4")) {
            sb.append("SG4,");
        }
        if (sb.length() == 0) {
            return null;
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        return sb.toString();
    }

    public static String getServerGroups(String table) {
        SharedMap sgMap = SQLBB.getBB().getSharedMap();
        ArrayList sgList = (ArrayList)sgMap.get((Object)(table + "SG" + dapList));
        StringBuilder sb = new StringBuilder();
        if (sgList.contains("SG1")) {
            sb.append("SG1,");
        }
        if (sgList.contains("SG2")) {
            sb.append("SG2,");
        }
        if (sgList.contains("SG3")) {
            sb.append("SG3,");
        }
        if (sgList.contains("SG4")) {
            sb.append("SG4,");
        }
        if (sb.length() == 0) {
            return null;
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        return sb.toString();
    }

    public static void HydraTask_createProcessorAlias() {
        dapTest.createProcessorAlias();
    }

    protected void createProcessorAlias() {
        Connection gConn = this.getGFEConnection();
        try {
            String sql = "create alias customProcessor for 'sql.sqlDAP.CustomProcessor'";
            gConn.createStatement().execute(sql);
            Log.getLogWriter().info("executed the statement: " + sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_doDDLOp() {
        dapTest.doDDLOp();
    }
}

