/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlDisk;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.engine.Misc;
import hydra.Log;
import hydra.TestConfig;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Set;
import sql.SQLPrms;
import sql.dmlStatements.DMLStmtIF;
import sql.sqlBridge.SQLBridgeTest;
import util.TestException;

public class SQLBridgeDiskTest
extends SQLBridgeTest {
    protected static SQLBridgeDiskTest sbdt = null;
    int numOfPRs = 0;

    public static synchronized void HydraTask_initialize() {
        if (sbdt == null) {
            sbdt = new SQLBridgeDiskTest();
        }
    }

    public static void HydraTask_doDMLOp() {
        sbdt.doDiscDMLOp();
    }

    public static void HydraTask_doOpOffline() {
        sbdt.doDiscOpOffline();
    }

    protected void doDiscOpOffline() {
        Log.getLogWriter().info("starts ops during offline");
        int num = 100;
        Connection gConn = this.getGFEConnection();
        if (random.nextInt(10) == 1 && this.getMyTid() == ddlThread) {
            this.createIndex(gConn);
        }
        for (int i = 0; i < num; ++i) {
            this.doDiscDMLOp();
        }
    }

    public static void HydraTask_doOpOnline() {
        sbdt.doDiscOpOnline();
    }

    protected void doDiscOpOnline() {
        Log.getLogWriter().info("starts ops during online");
        int num = 500;
        Connection gConn = this.getGFEConnection();
        if (random.nextInt(10) == 1 && this.getMyTid() == ddlThread) {
            this.createIndex(gConn);
        }
        for (int i = 0; i < num; ++i) {
            this.doDiscDMLOp();
        }
    }

    protected void doDiscDMLOp() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.doDiscDMLOp(dConn, gConn);
        if (!setTx) {
            this.commit(dConn);
            this.closeDiscConnection(dConn);
            this.commit(gConn);
            this.closeGFEConnection(gConn);
        } else {
            this.commit(gConn);
            this.closeGFEConnection(gConn);
            this.commit(dConn);
            this.closeDiscConnection(dConn);
        }
        Log.getLogWriter().info("done dmlOp");
    }

    protected void doDiscDMLOp(Connection dConn, Connection gConn) {
        Log.getLogWriter().info("performing dmlOp, myTid is " + this.getMyTid());
        int table = dmlTables[random.nextInt(dmlTables.length)];
        DMLStmtIF dmlStmt = dmlFactory.createDiscDMLStmt(table);
        int numOfOp = 10;
        int size = 1;
        String operation = TestConfig.tab().stringAt(SQLPrms.dmlOperations);
        if (operation.equals("insert")) {
            for (int i = 0; i < numOfOp; ++i) {
                if (setTx && isHATest) {
                    this.resetNodeFailureFlag();
                }
                dmlStmt.insert(dConn, gConn, size);
                if (setTx && isHATest) {
                    this.commit(gConn);
                    this.commit(dConn);
                    break;
                }
                this.commit(dConn);
                this.commit(gConn);
            }
        } else if (operation.equals("update")) {
            for (int i = 0; i < numOfOp; ++i) {
                if (setTx && isHATest) {
                    this.resetNodeFailureFlag();
                }
                dmlStmt.update(dConn, gConn, size);
                if (setTx && isHATest) {
                    this.commit(gConn);
                    this.commit(dConn);
                    break;
                }
                this.commit(dConn);
                this.commit(gConn);
            }
        } else if (operation.equals("delete")) {
            if (setTx && isHATest) {
                this.resetNodeFailureFlag();
            }
            dmlStmt.delete(dConn, gConn);
        } else if (operation.equals("query")) {
            if (setTx && isHATest) {
                this.resetNodeFailureFlag();
            }
            dmlStmt.query(dConn, gConn);
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
    }

    public static void HydraTask_flushDisk() {
        sbdt.flushDisk();
    }

    protected void flushDisk() {
        Connection gConn = this.getGFEConnection();
        this.flushDisk(gConn);
    }

    protected void flushDisk(Connection gConn) {
        ArrayList<String[]> tables = this.getTableNames(gConn);
        for (String[] table : tables) {
            Region r = Misc.getRegionForTable((String)(table[0] + "." + table[1]), (boolean)true);
            DiskStoreImpl d = ((LocalRegion)r).getDiskStore();
            if (d == null) continue;
            Log.getLogWriter().info("flush async queue for table: " + table[0] + "." + table[1]);
            d.flush();
        }
    }

    public static void HydraTask_doSyncOfflineOps() {
        sbdt.doSyncOfflienOps();
    }

    protected void doSyncOfflienOps() {
        if (this.getMyTid() == ddlThread) {
            if (this.numOfPRs == 0) {
                GemFireCacheImpl cacheImpl = Misc.getGemFireCache();
                Log.getLogWriter().info("prs are: ");
                Set prs = cacheImpl.getPartitionedRegions();
                for (PartitionedRegion pr : prs) {
                    Log.getLogWriter().info(pr.getName());
                }
                this.numOfPRs = prs.size() - 1;
                Log.getLogWriter().info("num Of PRs is " + this.numOfPRs);
            }
            this.stopVms();
        }
        this.waitForBarrier();
        this.doDiscOpOffline();
        this.waitForBarrier();
        if (this.getMyTid() == ddlThread) {
            this.startVms(this.numOfPRs);
        }
        this.waitForBarrier();
        this.doDiscOpOnline();
        this.waitForBarrier();
    }
}

