/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlDisk.dmlStatements;

import hydra.Log;
import hydra.MasterController;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import sql.SQLHelper;
import sql.SQLTest;
import sql.dmlStatements.TradeCustomersDMLStmt;
import sql.sqlDisk.dmlStatements.TradeNetworthDiscDMLStmt;
import util.TestException;
import util.TestHelper;

public class TradeCustomersDiscDMLStmt
extends TradeCustomersDMLStmt {
    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
        int[] cid = new int[size];
        String[] cust_name = new String[size];
        Date[] since = new Date[size];
        String[] addr = new String[size];
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        boolean success = false;
        this.getDataForInsert(cid, cust_name, since, addr, size);
        boolean[] gfxdOp = new boolean[]{true};
        if (dConn != null) {
            try {
                success = this.insertToDerbyTable(dConn, cid, cust_name, since, addr, size, exList);
                int count = 0;
                while (!success) {
                    if (count >= maxNumOfTries) {
                        Log.getLogWriter().info("Could not get the lock to finish insert into derby, abort this operation");
                        return;
                    }
                    MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                    exList.clear();
                    success = this.insertToDerbyTable(dConn, cid, cust_name, since, addr, size, exList);
                    ++count;
                }
                this.insertToGFETable(gConn, cid, cust_name, since, addr, size, exList, gfxdOp);
                if (SQLTest.setTx && isHATest) {
                    this.commit(gConn);
                    if (!gfxdOp[0]) {
                        this.rollback(dConn);
                    }
                    this.commit(dConn);
                }
                if (!gfxdOp[0]) {
                    dConn.rollback();
                } else {
                    dConn.commit();
                }
                gConn.commit();
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                throw new TestException("insert to trade.customers fails\n" + TestHelper.getStackTrace((Throwable)se));
            }
        } else {
            try {
                this.insertToGFETable(gConn, cid, cust_name, since, addr, size);
            }
            catch (SQLException se) {
                if (isOfflineTest && (se.getSQLState().equals("X0Z09") || se.getSQLState().equals("X0Z08"))) {
                    Log.getLogWriter().info("got expected PartitionOfflineException, continuing testing");
                    return;
                }
                SQLHelper.printSQLException(se);
                throw new TestException("insert to gfe trade.customers fails\n" + TestHelper.getStackTrace((Throwable)se));
            }
        }
        if (hasNetworth) {
            Log.getLogWriter().info("inserting into networth table");
            TradeNetworthDiscDMLStmt networth = new TradeNetworthDiscDMLStmt();
            networth.insert(dConn, gConn, size, cid);
            try {
                if (!SQLTest.setTx) {
                    if (dConn != null) {
                        dConn.commit();
                    }
                    gConn.commit();
                } else {
                    this.commit(gConn);
                    if (dConn != null) {
                        this.commit(dConn);
                    }
                }
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected void insertToGFETable(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size, List<SQLException> exceptions, boolean[] success) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(insert);
        int tid = TradeCustomersDiscDMLStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into gemfirexd, myTid is " + tid);
        for (int i = 0; i < size; ++i) {
            try {
                count = this.insertToTable(stmt, cid[i], cust_name[i], since[i], addr[i], tid);
                if (count == (Integer)verifyRowCount.get(tid + "_insert" + i)) continue;
                Log.getLogWriter().info("Gfxd insert has different row count from that of derby derby inserted " + (Integer)verifyRowCount.get(tid + "_insert" + i) + " but gfxd inserted " + count);
                continue;
            }
            catch (SQLException se) {
                if (isOfflineTest && (se.getSQLState().equals("X0Z09") || se.getSQLState().equals("X0Z08"))) {
                    Log.getLogWriter().info("got expected PartitionOfflineException, continuing testing");
                    success[0] = false;
                    continue;
                }
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    @Override
    public void update(Connection dConn, Connection gConn, int size) {
        try {
            super.update(dConn, gConn, size);
        }
        catch (TestException te) {
            if (isOfflineTest && (te.getMessage().contains("X0Z09") || te.getMessage().contains("X0Z08"))) {
                Log.getLogWriter().info("got expected PartitionOfflineException, continuing testing");
                if (dConn != null) {
                    this.rollback(dConn);
                }
            }
            throw te;
        }
    }

    @Override
    public void delete(Connection dConn, Connection gConn) {
        try {
            super.delete(dConn, gConn);
        }
        catch (TestException te) {
            if (isOfflineTest && (te.getMessage().contains("X0Z09") || te.getMessage().contains("X0Z08"))) {
                Log.getLogWriter().info("got expected PartitionOfflineException, continuing testing");
                if (dConn != null) {
                    this.rollback(dConn);
                }
            }
            if (isOfflineTest && !SQLTest.syncHAForOfflineTest && te.getMessage().contains("23503")) {
                Log.getLogWriter().info("delete failed due to #43754, continuing testing");
                if (dConn != null) {
                    this.rollback(dConn);
                }
            }
            throw te;
        }
    }

    @Override
    public void query(Connection dConn, Connection gConn) {
        super.query(dConn, gConn);
    }
}

