/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlDisk.thinClient;

import com.pivotal.gemfirexd.tools.GfxdSystemAdmin;
import hydra.Log;
import hydra.MasterController;
import hydra.Prms;
import hydra.TestConfig;
import hydra.gemfirexd.FabricServerHelper;
import hydra.gemfirexd.GfxdConfigPrms;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import sql.GFEDBClientManager;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.ddlStatements.IndexDDLStmt;
import sql.sqlBridge.SQLBridgeTest;
import sql.sqlutil.ResultSetHelper;

public class SQLDiskThinClientTest
extends SQLBridgeTest {
    protected static SQLDiskThinClientTest sdtc = null;
    protected static boolean isLocator = false;

    public static synchronized void HydraTask_initEdges() {
        if (sdtc == null) {
            sdtc = new SQLDiskThinClientTest();
        }
        hasDerbyServer = TestConfig.tab().booleanAt(Prms.manageDerbyServer, false);
        testUniqueKeys = TestConfig.tab().booleanAt(SQLPrms.testUniqueKeys, true);
        randomData = TestConfig.tab().booleanAt(SQLPrms.randomData, false);
        isSerial = TestConfig.tab().booleanAt(Prms.serialExecution, false);
        isSingleDMLThread = TestConfig.tab().booleanAt(SQLPrms.isSingleDMLThread, false);
        usingTrigger = TestConfig.tab().booleanAt(SQLPrms.usingTrigger, false);
        queryAnyTime = TestConfig.tab().booleanAt(SQLPrms.queryAnyTime, true);
        hasNetworth = TestConfig.tab().booleanAt(SQLPrms.hasNetworth, false);
        isEdge = true;
    }

    public static synchronized void HydraTask_initLocator() {
        if (sdtc == null) {
            sdtc = new SQLDiskThinClientTest();
        }
        isLocator = true;
    }

    public static void HydraTask_createGFESchemas() {
        sdtc.createGFESchemasByClients();
    }

    public static void HydraTask_createGFETables() {
        sdtc.createGFETablesByClients();
    }

    public static synchronized void HydraTask_createDiskStores() {
        sdtc.createDiskStores();
    }

    public static void HydraTask_populateTables() {
        sdtc.populateTables();
    }

    public static void HydraTask_doDMLOp() {
        sdtc.doDMLOp();
    }

    public static void HydraTask_checkConstraints() {
        if (!withReplicatedTables) {
            sdtc.checkConstraints();
        }
    }

    @Override
    protected void checkConstraints() {
        Connection gConn = this.getGFXDClientConnection();
        this.checkUniqConstraints(gConn);
        this.checkFKConstraints(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_writePersistToBB() {
        sdtc.writePersistToBB();
    }

    @Override
    protected void writePersistToBB() {
        Connection gConn = this.getGFXDClientConnection();
        this.writePersistToBB(gConn);
        this.closeGFEConnection(gConn);
    }

    public static synchronized void HydraTask_stopFabricServer() {
        FabricServerHelper.stopFabricServer();
    }

    public static void HydraTask_verifyPersistFromBB() {
        sdtc.verifyPersistFromBB();
    }

    @Override
    protected void verifyPersistFromBB() {
        Connection gConn = this.getGFXDClientConnection();
        this.verifyPersistFromBB(gConn);
        this.closeGFEConnection(gConn);
    }

    public static synchronized void HydraTask_createDiscDB() {
        sdtc.createDiscDB();
    }

    public static synchronized void HydraTask_createDiscSchemas() {
        sdtc.createDiscSchemas();
    }

    public static void HydraTask_createDuplicateDiscSchemas() {
        sdtc.createDuplicateDiscSchemas();
    }

    public static synchronized void HydraTask_createDiscTables() {
        sdtc.createDiscTables();
    }

    public static void HydraTask_setTableCols() {
        sdtc.setTableCols();
    }

    @Override
    protected void setTableCols() {
        Connection gConn = this.getGFXDClientConnection();
        SQLDiskThinClientTest.setTableCols(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_createIndex() {
        if (createIndex) {
            sdtc.createIndex();
        }
    }

    @Override
    protected void createIndex() {
        Connection gConn = this.getGFXDClientConnection();
        this.createIndex(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    @Override
    protected void createIndex(Connection conn) {
        IndexDDLStmt indexStmt = new IndexDDLStmt();
        indexStmt.doDDLOp(null, conn);
    }

    public static void HydraTask_createConcIndex() {
        if (createIndex && random.nextInt(10 * numOfWorkers) == 1) {
            sdtc.createIndex();
        }
    }

    public static void HydraTask_verifyResultSets() {
        sdtc.verifyResultSets();
    }

    public static void HydraTask_createGfxdLocatorTask() {
        FabricServerHelper.createLocator();
    }

    public static void HydraTask_startGfxdLocatorTask() {
        String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
        FabricServerHelper.startLocator(networkServerConfig);
        List<FabricServerHelper.Endpoint> locatorList = FabricServerHelper.getSystemEndpoints();
        Log.getLogWriter().info("loctorList is " + locatorList);
        SQLBB.getBB().getSharedMap().put((Object)"locatorList", locatorList);
    }

    public static synchronized void HydraTask_shut_down_all() {
        List locatorList = (List)SQLBB.getBB().getSharedMap().get((Object)"locatorList");
        FabricServerHelper.Endpoint locator = (FabricServerHelper.Endpoint)locatorList.get(0);
        String host = locator.getHost();
        int port = locator.getPort();
        Log.getLogWriter().info("shut-down-all target locator host: " + host + " and port: " + port);
        new GfxdSystemAdmin().shutDownAll("shut-down-all", Arrays.asList("-locators=" + host + ":" + port));
    }

    public static synchronized void HydraTask_waitforServerShutdown() {
        sdtc.waitforServerShutdown();
    }

    protected void waitforServerShutdown() {
        int sleepms = 30000;
        MasterController.sleepForMs((int)sleepms);
        while (!this.serversShutdown()) {
            MasterController.sleepForMs((int)sleepms);
            Log.getLogWriter().info("servers still available, waits for " + sleepms / 1000 + " seconds");
        }
    }

    protected boolean serversShutdown() {
        String sqlstat = "select * from trade.customers";
        try {
            Connection conn = GFEDBClientManager.getConnection();
            conn.createStatement().executeQuery(sqlstat);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("08006") && se.getMessage().contains("Failed after trying all available servers")) {
                return true;
            }
            SQLHelper.printSQLException(se);
            return false;
        }
        return false;
    }

    public static void HydraTask_restart() {
        if (isLocator) {
            SQLDiskThinClientTest.HydraTask_createGfxdLocatorTask();
            SQLDiskThinClientTest.HydraTask_startGfxdLocatorTask();
        } else {
            SQLDiskThinClientTest.HydraTask_startFabricServer();
            SQLDiskThinClientTest.HydraTask_stopFabricServer();
        }
    }

    public static void HydraTask_getConvertibleQuery() {
        sdtc.getConvertibleQuery();
    }

    protected void getConvertibleQuery() {
        Connection gConn = this.getGFXDClientConnection();
        this.getConvertibleQuery(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void getConvertibleQuery(Connection conn) {
        String sql = "select cid, sid, qty from trade.portfolio where cid=? and sid =?";
        ResultSet temp = null;
        try {
            PreparedStatement ps = conn.prepareStatement(sql);
            ResultSet rs = conn.createStatement().executeQuery("select * from trade.portfolio");
            while (rs.next()) {
                ps.setInt(1, rs.getInt("CID"));
                ps.setInt(2, rs.getInt("SID"));
                temp = ps.executeQuery();
                ResultSetHelper.asList(temp, false);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_simpleTest() {
        sdtc.simpleTest();
    }

    @Override
    protected void simpleTest() {
        Connection conn = this.getGFXDClientConnection();
        this.getQuery(conn);
        this.closeGFEConnection(conn);
    }
}

