/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlTx;

import hydra.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class ForeignKeyLocked
implements Serializable {
    private HashMap<Integer, Integer> keysHeldByTxIds = new HashMap();
    String key;

    public ForeignKeyLocked(String key) {
        this.key = key;
    }

    public void removeOneLockedKeyByCurTx(int txId) {
        if (this.keysHeldByTxIds != null && this.keysHeldByTxIds.containsKey(txId)) {
            int count = this.keysHeldByTxIds.get(txId) - 1;
            this.keysHeldByTxIds.put(txId, count);
            Log.getLogWriter().info("removed one locked key " + this.key + " held by this txId " + txId + " and it still held " + count + " locks for the key");
        }
    }

    public HashMap<Integer, Integer> getKeysHeldByTxIds() {
        return this.keysHeldByTxIds;
    }

    public void removeAllLockedKeyByCurTx(int txId) {
        if (this.keysHeldByTxIds != null && this.keysHeldByTxIds.containsKey(txId)) {
            this.keysHeldByTxIds.remove(txId);
            Log.getLogWriter().info("removed locked key " + this.key + " held by this txId " + txId);
        }
    }

    public void addKeyByCurTx(int txId) {
        int count = 1;
        if (this.keysHeldByTxIds.containsKey(txId)) {
            count = this.keysHeldByTxIds.get(txId) + 1;
        }
        this.keysHeldByTxIds.put(txId, count);
        Log.getLogWriter().info("locked key " + this.key + " is being held by this txId " + txId + " for " + count + " times ");
    }

    public void findOtherTxId(int txId, ArrayList<Integer> otherTxIds) {
        Set<Integer> txIds = this.keysHeldByTxIds.keySet();
        for (int id : txIds) {
            if (id == txId) continue;
            otherTxIds.add(id);
        }
    }

    public boolean detectOtherTxIdConflict(int txId) {
        Set<Integer> txIds = this.keysHeldByTxIds.keySet();
        for (int id : txIds) {
            if (id == txId) continue;
            Log.getLogWriter().info("lock hold by the following txId" + id);
            return true;
        }
        return false;
    }

    public boolean detectOtherTxIdConflict(int txId, StringBuilder str) {
        Set<Integer> txIds = this.keysHeldByTxIds.keySet();
        for (int id : txIds) {
            if (id == txId) continue;
            str.append("The lock has been held by other txId: " + id + " for key " + this.key);
            Log.getLogWriter().info("lock hold by the following txId" + id);
            return true;
        }
        return false;
    }

    public void logCurrTxIds() {
        StringBuffer str = new StringBuffer();
        for (int txId : this.keysHeldByTxIds.keySet()) {
            str.append(txId + " ");
        }
        Log.getLogWriter().info("there are " + this.keysHeldByTxIds.size() + " txs -- txId: " + str.toString() + "holding the key " + this.key);
    }
}

