/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlTx;

import hydra.Log;
import java.io.Serializable;
import java.util.HashMap;

public class RangeForeignKey
implements Serializable {
    private boolean wholeRangeKeyAlreadyHeld = false;
    private HashMap<Integer, Integer> partialRangeKeysHeldByTxIds = new HashMap();
    private int wholeRangeKeyHeldByTxId;
    String key;

    public RangeForeignKey(String key) {
        this.key = key;
    }

    public boolean hasConflictAddWholeRangeKey(int txId) {
        if (this.wholeRangeKeyAlreadyHeld) {
            if (this.wholeRangeKeyHeldByTxId == txId) {
                return false;
            }
            Log.getLogWriter().info("whole range key " + this.key + " has been held by txId " + this.wholeRangeKeyHeldByTxId);
            return true;
        }
        if (this.partialRangeKeysHeldByTxIds.keySet().size() > 1) {
            Log.getLogWriter().info("whole range key " + this.key + " could not be held");
            return true;
        }
        if (this.partialRangeKeysHeldByTxIds.keySet().size() == 1 && !this.partialRangeKeysHeldByTxIds.keySet().contains(txId)) {
            Log.getLogWriter().info("whole range key " + this.key + "  could not be held, it is held by txId" + this.partialRangeKeysHeldByTxIds.keySet().iterator().next());
            return true;
        }
        Log.getLogWriter().info("whole range key " + this.key + " will be held by txId " + txId);
        this.wholeRangeKeyAlreadyHeld = true;
        this.wholeRangeKeyHeldByTxId = txId;
        return false;
    }

    public boolean hasConflictAddPartialRangeKey(int txId) {
        int count = 1;
        if (this.wholeRangeKeyAlreadyHeld) {
            if (this.wholeRangeKeyHeldByTxId == txId) {
                if (this.partialRangeKeysHeldByTxIds.containsKey(txId)) {
                    count = this.partialRangeKeysHeldByTxIds.get(txId) + 1;
                }
                this.partialRangeKeysHeldByTxIds.put(txId, count);
                Log.getLogWriter().info("partial range key " + this.key + " is being held by this txId " + txId);
                return false;
            }
            Log.getLogWriter().info("conflict detected as the whole range key " + this.key + " has been held by another txId " + this.wholeRangeKeyHeldByTxId);
            return true;
        }
        if (this.partialRangeKeysHeldByTxIds.containsKey(txId)) {
            count = this.partialRangeKeysHeldByTxIds.get(txId) + 1;
        }
        this.partialRangeKeysHeldByTxIds.put(txId, count);
        Log.getLogWriter().info("partial range key " + this.key + " is being held by this txId " + txId);
        return false;
    }

    public void removeWholeRangeKey(int txId) {
        if (this.wholeRangeKeyAlreadyHeld && this.wholeRangeKeyHeldByTxId == txId) {
            Log.getLogWriter().info("whole range key " + this.key + " will no longer be held by this txId " + txId);
            this.wholeRangeKeyAlreadyHeld = false;
            this.wholeRangeKeyHeldByTxId = 0;
        }
    }

    public void removePartialRangeKey(int txId) {
        if (this.partialRangeKeysHeldByTxIds != null && this.partialRangeKeysHeldByTxIds.containsKey(txId)) {
            int count = this.partialRangeKeysHeldByTxIds.get(txId) - 1;
            this.partialRangeKeysHeldByTxIds.put(txId, count);
            Log.getLogWriter().info("removed one partial range key " + this.key + " held by this txId " + txId);
        }
    }

    public void removeAllPartialRangeKeyByCurTx(int txId) {
        if (this.partialRangeKeysHeldByTxIds != null && this.partialRangeKeysHeldByTxIds.containsKey(txId)) {
            this.partialRangeKeysHeldByTxIds.remove(txId);
            Log.getLogWriter().info("removed all partial range key " + this.key + " held by this txId " + txId);
        }
    }

    public boolean getWholeRangeKeyAlreadyHeld() {
        return this.wholeRangeKeyAlreadyHeld;
    }

    public int getWholeRangeKeyHeldByTxId() {
        return this.wholeRangeKeyHeldByTxId;
    }

    public String getKey() {
        return this.key;
    }
}

