/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlTx;

import hydra.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class ReadLockedKey
implements Serializable {
    private HashMap<Integer, Integer> readLocksHeldByTxIds = new HashMap();
    String key;

    public ReadLockedKey(String key) {
        this.key = key;
    }

    public void removeOneReadLockedKeyByCurTx(int txId) {
        if (this.readLocksHeldByTxIds != null && this.readLocksHeldByTxIds.containsKey(txId)) {
            int count = this.readLocksHeldByTxIds.get(txId) - 1;
            this.readLocksHeldByTxIds.put(txId, count);
            Log.getLogWriter().info("removed one read locked key " + this.key + " held by this txId " + txId + " and it still held " + count + " read locks for the key");
        }
    }

    public void removeAllReadLockedKeyByCurTx(int txId) {
        if (this.readLocksHeldByTxIds != null && this.readLocksHeldByTxIds.containsKey(txId)) {
            this.readLocksHeldByTxIds.remove(txId);
            Log.getLogWriter().info("removed read locked key " + this.key + " held by this txId " + txId);
        }
    }

    public void addKeyByCurTx(int txId) {
        int count = 1;
        if (this.readLocksHeldByTxIds.containsKey(txId)) {
            count = this.readLocksHeldByTxIds.get(txId) + 1;
        }
        this.readLocksHeldByTxIds.put(txId, count);
        Log.getLogWriter().info("read locked key " + this.key + " is being held by this txId " + txId + " for " + count + " times ");
    }

    public void findOtherTxId(int txId, ArrayList<Integer> otherTxIds) {
        Set<Integer> txIds = this.readLocksHeldByTxIds.keySet();
        for (int id : txIds) {
            if (id == txId) continue;
            otherTxIds.add(id);
        }
    }

    public void logCurrTxIds() {
        StringBuffer str = new StringBuffer();
        for (int txId : this.readLocksHeldByTxIds.keySet()) {
            str.append(txId + " ");
        }
        Log.getLogWriter().info("there are " + this.readLocksHeldByTxIds.size() + " txs -- txId: " + str.toString() + "holding the RR read key " + this.key);
    }
}

