/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlTx;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import sql.GFEDBManager;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlDistTxRRStatements.TradeNetworthDMLDistTxRRStmt;
import sql.dmlDistTxStatements.DMLDistTxStmtIF;
import sql.dmlDistTxStatements.TradeSellOrdersDMLDistTxStmt;
import sql.dmlStatements.AbstractDMLStmt;
import sql.sqlTx.ReadLockedKey;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlTx.SQLTxBB;
import sql.sqlTx.SQLTxRRReadBB;
import sql.sqlTx.SQLTxRRWriteBB;
import sql.sqlutil.ResultSetHelper;
import util.PRObserver;
import util.TestException;
import util.TestHelper;

public class SQLDistRRTxTest
extends SQLDistTxTest {
    protected static SQLDistRRTxTest rrTest;
    public static HydraThreadLocal curTxRRReadKeys;
    public static boolean reproduce49935;

    public static void HydraTask_initConnections() throws SQLException {
        rrTest.initThreadLocalConnection();
    }

    public static void HydraTask_initThreadLocals() {
        rrTest.initThreadLocals();
    }

    @Override
    protected void initThreadLocals() {
        super.initThreadLocals();
    }

    public static synchronized void HydraTask_initialize() {
        if (rrTest == null) {
            rrTest = new SQLDistRRTxTest();
            PRObserver.installObserverHook();
            PRObserver.initialize((int)RemoteTestModule.getMyVmid());
            rrTest.initialize();
        }
        rrTest.initThreadLocals();
    }

    public static void HydraTask_createGfxdLocatorTask() {
        SQLTest.HydraTask_createGfxdLocatorTask();
    }

    public static void HydraTask_startGfxdLocatorTask() {
        SQLTest.HydraTask_startGfxdLocatorTask();
    }

    public static synchronized void HydraTask_startFabricServer() {
        rrTest.startFabricServer();
    }

    public static synchronized void HydraTask_stopFabricServer() {
        rrTest.stopFabricServer();
    }

    public static synchronized void HydraTask_startFabricServerSG() {
        rrTest.startFabricServerSG();
    }

    public static synchronized void HydraTask_startFabricServerSGDBSynchronizer() {
        rrTest.startFabricServerSGDBSynchronizer();
    }

    public static synchronized void HydraTask_createDiscDB() {
        rrTest.createDiscDB();
    }

    public static synchronized void HydraTask_createDiscSchemas() {
        rrTest.createDiscSchemas();
    }

    public static synchronized void HydraTask_createDiscTables() {
        rrTest.createDiscTables();
    }

    public static void HydraTask_createGFESchemas() {
        rrTest.createGFESchemas();
    }

    public static void HydraTask_createGFETables() {
        rrTest.createGFETables();
    }

    public static void HydraTask_populateTxTables() {
        rrTest.populateTxTables();
    }

    public static void HydraTask_populateTxTablesDBSynchronizer() {
        rrTest.populateTxTablesDBSynchronizer();
    }

    public static void HydraTask_setTableCols() {
        rrTest.setTableCols();
    }

    public static void HydraTask_createIndex() {
        rrTest.createIndex();
    }

    public static void HydraTask_verifyResultSets() {
        rrTest.verifyResultSets();
    }

    @Override
    protected void verifyResultSets() {
        if (!hasDerbyServer) {
            Log.getLogWriter().info("skipping verification of query results due to manageDerbyServer as false, myTid=" + this.getMyTid());
            this.cleanConnection(this.getGFXDTxConnection(GFEDBManager.Isolation.REPEATABLE_READ));
            return;
        }
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.REPEATABLE_READ);
        this.verifyResultSets(dConn, gConn);
    }

    public static void HydraTask_initForServerGroup() {
        rrTest.initForServerGroup();
    }

    public static void HydraTask_createDBSynchronizer() {
        rrTest.createDBSynchronizer();
    }

    public static void HydraTask_createDiskStores() {
        rrTest.createDiskStores();
    }

    @Override
    protected void createIndex() {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.REPEATABLE_READ);
        this.createRRTxIndex(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void createRRTxIndex(Connection gConn) {
        try {
            this.createIndex(gConn);
        }
        catch (TestException te) {
            if (te.getMessage().contains("40XL1")) {
                Log.getLogWriter().info("get expected lock not held exception in ddl op");
            }
            throw te;
        }
        this.commitRRGfxdOnly(gConn);
    }

    @Override
    protected void createDiskStores() {
        Connection conn = this.getGFXDTxConnection(GFEDBManager.Isolation.REPEATABLE_READ);
        this.createDiskStores(conn);
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    @Override
    protected void createDBSynchronizer() {
        Connection conn = this.getGFXDTxConnection(GFEDBManager.Isolation.REPEATABLE_READ);
        this.createNewDBSynchronizer(conn);
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    @Override
    protected void populateTxTables() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Properties info = new Properties();
        info.setProperty(syncCommits, "true");
        Connection gConn = this.getGFXDRRTxConnection(info);
        this.populateTables(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    @Override
    protected void populateTxTablesDBSynchronizer() {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.REPEATABLE_READ);
        this.populateTables(null, gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_putLastKeyDBSynchronizer() {
        rrTest.putLastKeyDBSynchronizer();
    }

    @Override
    protected void putLastKeyDBSynchronizer() {
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.REPEATABLE_READ);
        this.putLastKeyDBSynchronizer(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_verifyResultSetsDBSynchronizer() {
        rrTest.verifyResultSetsDBSynchronizer();
    }

    public static void HydraTask_doTxDMLOpDBSynchronizer() {
        rrTest.doTxDMLOpDBSynchronizer();
    }

    @Override
    protected void doTxDMLOpDBSynchronizer() {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.REPEATABLE_READ);
        this.doDMLOp(null, gConn);
    }

    public static void HydraTask_doDMLOp() {
        rrTest.doDMLOp();
    }

    @Override
    protected void doDMLOp() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = null;
        if (mixRR_RC && random.nextBoolean()) {
            gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
            this.doDMLOp(dConn, gConn, false);
        } else {
            gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.REPEATABLE_READ);
            this.doDMLOp(dConn, gConn, true);
        }
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done dmlOp");
    }

    protected void doDMLOp(Connection dConn, Connection gConn, boolean isRR) {
        if (doOpByOne && dConn != null) {
            if (!isRR) {
                this.doDMLOpByOne(dConn, gConn);
            } else {
                this.doDMLOpRRByOne(dConn, gConn);
            }
        } else {
            this.doDMLGfxdOnlyOps(gConn);
        }
    }

    @Override
    protected void doDMLGfxdOnlyOps(Connection gConn) {
        int txId = (int)SQLTxBB.getBB().getSharedCounters().incrementAndRead(SQLTxBB.txId);
        curTxId.set((Object)txId);
        Log.getLogWriter().info("performing dmlOp, myTid is " + this.getMyTid() + " and txId is " + txId);
        boolean withDerby = false;
        int total = 20;
        int numOfIter = random.nextInt(total) + 1;
        for (int i = 0; i < numOfIter; ++i) {
            gConn = this.doDMLGfxdOnlyOp(gConn, 1, withDerby);
        }
        this.commitOrRollbackGfxdOnly(gConn);
    }

    @Override
    protected void doOneGfxdOnlyDMLOp(Connection gConn, boolean withDerby) {
        String operation;
        boolean succeed = true;
        int table = dmlTables[random.nextInt(dmlTables.length)];
        DMLDistTxStmtIF dmlStmt = dmlDistTxFactory.createDMLDistTxRRStmt(table);
        if (table != 1) {
            if (table != 4) {
                if (table != 2) {
                    if (table != 3) {
                        if (table != 5) {
                            return;
                        }
                    }
                }
            }
        }
        if ((operation = TestConfig.tab().stringAt(SQLPrms.dmlOperations)).equals("insert")) {
            succeed = dmlStmt.insertGfxd(gConn, withDerby);
        } else if (operation.equals("update")) {
            succeed = dmlStmt.updateGfxd(gConn, withDerby);
        } else if (operation.equals("delete")) {
            succeed = dmlStmt.deleteGfxd(gConn, withDerby);
        } else if (operation.equals("query")) {
            succeed = dmlStmt.queryGfxd(gConn, withDerby);
        } else {
            throw new TestException("Unknown dml operation: " + operation);
        }
        if (table == 1 && operation.equals("insert") && succeed) {
            Log.getLogWriter().info("inserting into networth table");
            TradeNetworthDMLDistTxRRStmt networth = new TradeNetworthDMLDistTxRRStmt();
            succeed = networth.insertGfxd(gConn, withDerby, (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary));
        }
        if (!succeed) {
            Log.getLogWriter().info("this tx failed with exception (conflict or node failure)");
        }
    }

    @Override
    protected void commitOrRollbackGfxdOnly(Connection gConn) {
        int chanceToRollback = 20;
        if (random.nextInt(chanceToRollback) == 1 || ((Boolean)rollbackGfxdTx.get()).booleanValue()) {
            Log.getLogWriter().info("roll back the tx");
            this.rollback(gConn);
        } else {
            Log.getLogWriter().info("commit the tx");
            this.commitRRGfxdOnly(gConn);
        }
    }

    protected void commitRRGfxdOnly(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            Log.getLogWriter().info("committing the ops for gfxd");
            conn.commit();
        }
        catch (SQLException se) {
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                Log.getLogWriter().info("detected expected conflict during commit in RR, continuing test");
                return;
            }
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                this.log().info("commit failed in gfxd RR tx due to node failure, continuing test");
                return;
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected void doDMLOpRRByOne(Connection dConn, Connection gConn) {
        Log.getLogWriter().info("using RR isolation");
        boolean firstInThisRound = false;
        if (SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.firstInRound) == 1L) {
            firstInThisRound = true;
            Log.getLogWriter().info("I am the first to commit in this round");
            commitEarly.set((Object)true);
        } else if (random.nextInt(10) == 1) {
            commitEarly.set((Object)true);
        } else {
            commitEarly.set((Object)false);
        }
        boolean ticket42651fixed = true;
        int txId = (int)SQLTxBB.getBB().getSharedCounters().incrementAndRead(SQLTxBB.txId);
        curTxId.set((Object)txId);
        boolean withDerby = false;
        if (dConn != null) {
            withDerby = true;
        }
        Log.getLogWriter().info("performing dmlOp using RR, myTid is " + this.getMyTid() + " and txId is " + txId);
        HashMap modifiedKeys = new HashMap();
        curTxModifiedKeys.set(modifiedKeys);
        HashMap readLockedKeys = new HashMap();
        curTxRRReadKeys.set(readLockedKeys);
        int total = 4;
        int numOfIter = random.nextInt(total) + 1;
        int maxOps = 5;
        int numOps = random.nextInt(maxOps) + 1;
        for (int i = 0; i < numOfIter - 1; ++i) {
            this.getLock();
            this.doGfxdDMLOpRRByOne(dConn, gConn, numOps, withDerby);
            this.releaseLock();
        }
        this.getLock();
        this.doGfxdDMLOpRRByOne(dConn, gConn, numOps, withDerby);
        this.releaseLock();
        this.waitForBarrier();
        if (firstInThisRound) {
            SQLBB.getBB().getSharedCounters().zero(SQLBB.firstInRound);
            this.commitOrRollback(dConn, gConn, firstInThisRound);
            this.removeHoldKeysByThisTx();
            this.closeSelectForUpdateRS();
        }
        this.waitForBarrier();
        if (!firstInThisRound && ((Boolean)commitEarly.get()).booleanValue()) {
            this.getLock();
            this.commitOrRollback(dConn, gConn, firstInThisRound);
            this.removeHoldKeysByThisTx();
            this.closeSelectForUpdateRS();
            this.releaseLock();
        }
        this.waitForBarrier();
        if (!firstInThisRound && !((Boolean)commitEarly.get()).booleanValue()) {
            this.getLock();
            this.commitOrRollback(dConn, gConn, firstInThisRound);
            this.removeHoldKeysByThisTx();
            this.closeSelectForUpdateRS();
            this.releaseLock();
        }
        this.waitForBarrier();
    }

    protected void doGfxdDMLOpRRByOne(Connection dConn, Connection gConn, int size, boolean withDerby) {
        for (int i = 0; i < size; ++i) {
            this.doOneGfxdDMLOpRRByOne(dConn, gConn, withDerby);
        }
    }

    protected void doOneGfxdDMLOpRRByOne(Connection dConn, Connection gConn, boolean withDerby) {
        Object[] data;
        SQLException gfxdse;
        ArrayList derbyOps;
        this.doOneGfxdDMLOpRRByOne(gConn, withDerby);
        if (!ticket43170fixed && withDerby && (derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get()) != null && derbyOps.size() > 0 && (gfxdse = (SQLException)(data = (Object[])derbyOps.get(derbyOps.size() - 1))[data.length - 1]) != null && (gfxdse.getSQLState().equals("23503") || gfxdse.getSQLState().equals("23505") || gfxdse.getSQLState().equals("23513"))) {
            this.processDerbyOps(dConn, true);
            this.removeHoldKeysByThisTx();
            this.closeSelectForUpdateRS();
            this.rollback(dConn);
            this.resetDerbyOps();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doOneGfxdDMLOpRRByOne(Connection gConn, boolean withDerby) {
        String operation;
        boolean succeed = true;
        int table = dmlTables[random.nextInt(dmlTables.length)];
        DMLDistTxStmtIF dmlStmt = dmlDistTxFactory.createDMLDistTxRRStmt(table);
        boolean reproduce48167 = true;
        if (!reproduce48167) {
            if (table != 1) {
                if (table != 4) {
                    if (table != 2) {
                        return;
                    }
                }
            }
        } else if (table != 1) {
            if (table != 4) {
                if (table != 2) {
                    if (table != 3) {
                        if (table != 5) {
                            return;
                        }
                    }
                }
            }
        }
        if ((operation = TestConfig.tab().stringAt(SQLPrms.dmlOperations)).equals("insert")) {
            if (((Boolean)commitEarly.get()).booleanValue()) return;
            succeed = dmlStmt.insertGfxd(gConn, withDerby);
        } else if (operation.equals("update")) {
            succeed = dmlStmt.updateGfxd(gConn, withDerby);
        } else if (operation.equals("delete")) {
            succeed = dmlStmt.deleteGfxd(gConn, withDerby);
        } else {
            if (!operation.equals("query")) throw new TestException("Unknown entry operation: " + operation);
            succeed = dmlStmt.queryGfxd(gConn, withDerby);
        }
        if (table == 1 && operation.equals("insert") && succeed) {
            if (((Boolean)batchInsertToCustomersSucceeded.get()).booleanValue()) {
                Log.getLogWriter().info("inserting into networth table");
                TradeNetworthDMLDistTxRRStmt networth = new TradeNetworthDMLDistTxRRStmt();
                succeed = networth.insertGfxd(gConn, withDerby, (Integer)cidInserted.get());
            } else {
                Log.getLogWriter().info("insert into customers using batch failed, do not insert to networth table due to #43170. as the sqlf fails the whole batch");
                batchInsertToCustomersSucceeded.set((Object)true);
            }
        }
        if (succeed) return;
        this.rollback(gConn);
        this.removeHoldKeysByThisTx();
        this.closeSelectForUpdateRS();
        this.resetDerbyOps();
    }

    @Override
    protected void removeHoldKeysByThisTx() {
        this.removeRRWriteKeysByThisTx();
        this.removeRRReadKeysByThisTx();
        this.removeAllRangeFKsByThisTx();
    }

    protected void removeRRWriteKeysByThisTx() {
        SharedMap modifiedKeysByRRTx = SQLTxRRWriteBB.getBB().getSharedMap();
        Set alreadyHeldKeysThisTx = ((HashMap)curTxModifiedKeys.get()).keySet();
        Log.getLogWriter().info("removing the RR write keys from the Map that were held by this tx");
        for (String key : alreadyHeldKeysThisTx) {
            Log.getLogWriter().info("key to be removed is " + key);
            modifiedKeysByRRTx.remove((Object)key);
        }
        curTxModifiedKeys.set(new HashMap());
    }

    protected void removeRRReadKeysByThisTx() {
        int txId = (Integer)curTxId.get();
        SharedMap readLockedKeysByRRTx = SQLTxRRReadBB.getBB().getSharedMap();
        Set readLokedKeysByThisTx = ((HashMap)curTxRRReadKeys.get()).keySet();
        Log.getLogWriter().info("removing the RR read keys from the Map that were held by this txId: " + txId);
        for (String key : readLokedKeysByThisTx) {
            Log.getLogWriter().info("RR read key to be removed is " + key);
            ReadLockedKey readKey = (ReadLockedKey)readLockedKeysByRRTx.get((Object)key);
            readKey.removeAllReadLockedKeyByCurTx(txId);
            readLockedKeysByRRTx.put((Object)key, (Object)readKey);
        }
    }

    @Override
    protected void commitOrRollback(Connection dConn, Connection gConn, boolean firstCommit) {
        int chanceToRollback;
        this.processDerbyOps(dConn, firstCommit);
        int n = chanceToRollback = firstCommit ? 5 : 20;
        if (random.nextInt(chanceToRollback) == 1 || ((Boolean)rollbackGfxdTx.get()).booleanValue()) {
            Log.getLogWriter().info("roll back the tx");
            rollbackGfxdTx.set((Object)false);
            this.rollback(dConn);
            this.rollback(gConn);
        } else {
            this.commitRR(dConn, gConn);
        }
    }

    protected void commitRR(Connection dConn, Connection gConn) {
        Log.getLogWriter().info("commit the tx");
        try {
            Log.getLogWriter().info("committing the ops for gfxd");
            gConn.commit();
            Log.getLogWriter().info("tx is committed for gfxd");
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z02")) {
                this.verifyConflictForRR(true, se);
                Log.getLogWriter().info("got expected conflict during commit for RR");
                this.rollback(dConn);
                Log.getLogWriter().info("rollback the ops in derby");
                return;
            }
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                this.log().info("commit failed in gfxd due to node failure");
                this.rollback(dConn);
                Log.getLogWriter().info("rollback the ops in derby");
                return;
            }
            SQLHelper.handleSQLException(se);
        }
        this.verifyConflictForRR(false, null);
        this.commit(dConn);
    }

    protected void verifyConflictForRR(boolean getConflicts, SQLException se) {
        SharedMap readLockedKeysByRRTx = SQLTxRRReadBB.getBB().getSharedMap();
        int beforeSize = readLockedKeysByRRTx.size();
        Map readLockedKeysByOtherRR = readLockedKeysByRRTx.getMap();
        HashMap modifiedKeysByThisTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        Log.getLogWriter().info("at the commit, the read locked map size is " + beforeSize);
        ArrayList<Integer> otherTxIds = new ArrayList<Integer>();
        int myTxId = (Integer)SQLDistTxTest.curTxId.get();
        for (String key : modifiedKeysByThisTx.keySet()) {
            Log.getLogWriter().info("modified keys by this tx contains: " + key);
            ReadLockedKey rlkey = (ReadLockedKey)readLockedKeysByOtherRR.get(key);
            if (rlkey == null) continue;
            rlkey.findOtherTxId(myTxId, otherTxIds);
            if (otherTxIds.size() == 0) continue;
            if (getConflicts) {
                return;
            }
            StringBuffer str = new StringBuffer();
            for (int otherTxId : otherTxIds) {
                str.append(otherTxId + " ");
            }
            throw new TestException("Did not get expected conflict exception during commit as following txIds: " + str.toString() + " hold the read lock for " + "the key: " + key + " to be modified by this tx");
        }
        if (getConflicts) {
            throw new TestException("get conflict but there are no read locks held for the committed keys by other txs\n" + TestHelper.getStackTrace((Throwable)se));
        }
    }

    public static void HydraTask_checkConstraints() {
        rrTest.checkConstraints();
    }

    @Override
    protected void checkConstraints() {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.REPEATABLE_READ);
        this.checkUniqConstraints(gConn);
        this.checkFKConstraints(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_checkRRKeys() {
        rrTest.checkRRKeys();
    }

    protected void checkRRKeys() {
        if (this.getMyTid() % 3 != 0 && random.nextInt(20) != 1) {
            Log.getLogWriter().info("do dml ops instead of checking repeatable read keys");
            rrTest.doDMLOp();
            return;
        }
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.REPEATABLE_READ);
        this.checkRRKeys(gConn);
        this.commitRRGfxdOnly(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void checkRRKeys(Connection conn) {
        int whichOne = random.nextInt(5);
        switch (whichOne) {
            case 0: {
                this.checkTradeSecruitiesKeys(conn);
                break;
            }
            case 1: {
                this.checkTradeNetworthKeys(conn);
                break;
            }
            case 2: {
                this.checkTradeCustomersKeys(conn);
                break;
            }
            case 3: {
                this.checkTradeSellordersKeys(conn);
                break;
            }
            default: {
                Log.getLogWriter().info("do nothing");
            }
        }
    }

    protected void checkTradeSecruitiesKeys(Connection conn) {
        String sql = "select sec_id, symbol, exchange, price from trade.securities where sec_id>? and sec_id < ?";
        int sid = AbstractDMLStmt.getExistingSid();
        int sid1 = sid + 10;
        this.verifyRRKeys(conn, sql, sid, sid1);
    }

    protected void checkTradeNetworthKeys(Connection conn) {
        String sql = "select cid, cash, securities, loanLimit, availLoan from trade.networth where cid>? and cid < ?";
        int cid = AbstractDMLStmt.getExistingCid();
        int cid1 = cid + 10;
        this.verifyRRKeys(conn, sql, cid, cid1);
    }

    protected void checkTradeCustomersKeys(Connection conn) {
        String sql = "select cid, cust_name, since, addr from trade.customers where cid>? and cid < ?";
        int cid = AbstractDMLStmt.getExistingCid();
        int cid1 = cid + 10;
        this.verifyRRKeys(conn, sql, cid, cid1);
    }

    protected void checkTradeSellordersKeys(Connection conn) {
        String sql = "select oid, status, ask  from trade.sellorders where oid>? and oid < ?";
        int id = TradeSellOrdersDMLDistTxStmt.getExistingOid();
        int id1 = id + 20;
        this.verifyRRKeys(conn, sql, id, id1);
    }

    protected void verifyRRKeys(Connection conn, String sql, int id, int id1) {
        ResultSet rs;
        PreparedStatement stmt;
        List<Struct> rsRepeatList;
        List<Struct> rsList;
        block21: {
            rsList = null;
            rsRepeatList = null;
            try {
                PreparedStatement stmt2 = conn.prepareStatement(sql);
                Log.getLogWriter().info(sql + " -- id> " + id + " and id< " + id1);
                stmt2.setInt(1, id);
                stmt2.setInt(2, id1);
                ResultSet rs2 = stmt2.executeQuery();
                rsList = ResultSetHelper.asList(rs2, false);
            }
            catch (SQLException se) {
                if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                    this.log().info("op failed in gfxd RR tx due to node failure, continuing test");
                } else {
                    if (se.getSQLState().equalsIgnoreCase("X0Z02") && !reproduce49935) {
                        Log.getLogWriter().info("hit #49935, continue for now");
                        return;
                    }
                    SQLHelper.handleSQLException(se);
                }
            }
            catch (TestException te) {
                if (!isHATest || !te.getMessage().contains("40XD0") && !te.getMessage().contains("40XD2")) break block21;
                Log.getLogWriter().info("got expected node failure exception, continuing test");
            }
        }
        if (rsList == null) {
            if (isHATest) {
                Log.getLogWriter().info("could not get result in HA tests");
                return;
            }
            throw new TestException("Could not get resultset using RR and it is not HA test");
        }
        int sleepMS = 20000;
        Log.getLogWriter().info("sleep for " + sleepMS / 1000 + " sec to check repeatable read keys");
        MasterController.sleepForMs((int)sleepMS);
        try {
            stmt = conn.prepareStatement(sql);
            Log.getLogWriter().info(sql + " id> " + id + " and id< " + id1);
            stmt.setInt(1, id);
            stmt.setInt(2, id1);
            rs = stmt.executeQuery();
            rsRepeatList = ResultSetHelper.asList(rs, false);
        }
        catch (SQLException se) {
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                this.log().info("op failed in gfxd RR tx due to node failure, will try the op, continuing test");
            } else {
                if (se.getSQLState().equalsIgnoreCase("X0Z02") && !reproduce49935) {
                    Log.getLogWriter().info("hit #49935, continue for now");
                    return;
                }
                SQLHelper.handleSQLException(se);
            }
        }
        catch (TestException te) {
            if (isHATest && (te.getMessage().contains("40XD0") || te.getMessage().contains("40XD2"))) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
            }
            throw te;
        }
        while (rsRepeatList == null && isHATest) {
            try {
                stmt = conn.prepareStatement(sql);
                Log.getLogWriter().info(sql + " id> " + id + " and id< " + id1);
                stmt.setInt(1, id);
                stmt.setInt(2, id1);
                rs = stmt.executeQuery();
                rsRepeatList = ResultSetHelper.asList(rs, false);
            }
            catch (SQLException se) {
                if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                    this.log().info("could not retry as no HA support for txn yet");
                    return;
                }
                SQLHelper.handleSQLException(se);
            }
            catch (TestException te) {
                if (isHATest && (te.getMessage().contains("40XD0") || te.getMessage().contains("40XD2"))) {
                    this.log().info("could not retry as no HA support for txn yet");
                    return;
                }
                throw te;
            }
        }
        ResultSetHelper.compareResultSets(rsList, rsRepeatList, "original RR result", "retry RR result");
    }

    public static void HydraTask_checkModifiedRRKeys() {
        rrTest.checkGfxdModifiedRRKeys();
    }

    protected void checkGfxdModifiedRRKeys() {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.REPEATABLE_READ);
        this.printIsolationLevel(gConn);
        this.checkModifiedRRKeys(gConn);
    }

    protected void checkDerbyModifiedRRKeys() {
        Connection conn = this.getDiscConnection();
        try {
            conn.setTransactionIsolation(4);
            this.printIsolationLevel(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.checkModifiedRRKeys(conn);
    }

    protected void checkModifiedRRKeys(Connection conn) {
        ResultSet rs;
        PreparedStatement stmt;
        String sql = "select oid, status, ask, tid  from trade.sellorders where oid>? and oid < ?";
        int id = TradeSellOrdersDMLDistTxStmt.getExistingOid();
        int id1 = id + 20;
        List<Struct> rsList = null;
        List<Struct> rsRepeatList = null;
        try {
            PreparedStatement stmt2 = conn.prepareStatement(sql);
            Log.getLogWriter().info(sql + " -- id> " + id + " and id< " + id1);
            stmt2.setInt(1, id);
            stmt2.setInt(2, id1);
            ResultSet rs2 = stmt2.executeQuery();
            rsList = ResultSetHelper.asList(rs2, true);
            Log.getLogWriter().info("original result set is " + ResultSetHelper.listToString(rsList));
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        int sleepMS = 20000;
        Log.getLogWriter().info("sleep for " + sleepMS / 1000 + " sec to check repeatable read keys");
        MasterController.sleepForMs((int)sleepMS);
        try {
            int updateCount = conn.createStatement().executeUpdate("update trade.sellorders set tid = 1000000 where oid = " + (id + 1));
            Log.getLogWriter().info("in check sellorders RR key, update count is " + updateCount);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
        }
        try {
            stmt = conn.prepareStatement(sql);
            Log.getLogWriter().info(sql + " id> " + id + " and id< " + id1);
            stmt.setInt(1, id);
            stmt.setInt(2, id1);
            rs = stmt.executeQuery();
            rsRepeatList = ResultSetHelper.asList(rs, false);
            Log.getLogWriter().info("original result set is " + ResultSetHelper.listToString(rsRepeatList));
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        while (rsRepeatList == null && isHATest) {
            try {
                stmt = conn.prepareStatement(sql);
                Log.getLogWriter().info(sql + " cid> " + id + " and cid< " + id1);
                stmt.setInt(1, id);
                stmt.setInt(2, id1);
                rs = stmt.executeQuery();
                rsRepeatList = ResultSetHelper.asList(rs, false);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
        ResultSetHelper.compareResultSets(rsList, rsRepeatList, "original RR result", "retry RR result");
        this.commit(conn);
        List<Struct> rsaftercommitList = null;
        try {
            PreparedStatement stmt3 = conn.prepareStatement(sql);
            Log.getLogWriter().info(sql + " id> " + id + " and id< " + id1);
            stmt3.setInt(1, id);
            stmt3.setInt(2, id1);
            ResultSet rs3 = stmt3.executeQuery();
            rsaftercommitList = ResultSetHelper.asList(rs3, false);
            Log.getLogWriter().info("original result set is " + ResultSetHelper.listToString(rsaftercommitList));
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        ResultSetHelper.compareResultSets(rsList, rsaftercommitList, "original RR result", "RR result after commit");
    }

    public static void HydraTask_cycleStoreVms() {
        if (cycleVms) {
            rrTest.cycleStoreVms();
        }
    }

    protected Connection getGFXDRRTxConnection(Properties info) {
        Connection conn = null;
        try {
            conn = GFEDBManager.getRRTxConnection(info);
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    @Override
    protected Connection getNewGfxdConnection() {
        return this.getGFXDTxConnection(GFEDBManager.Isolation.REPEATABLE_READ);
    }

    static {
        curTxRRReadKeys = new HydraThreadLocal();
        reproduce49935 = true;
    }
}

