/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlTx;

import com.gemstone.gemfire.cache.query.Struct;
import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeapScanController;
import hydra.ClientVmInfo;
import hydra.HydraSubthread;
import hydra.HydraThreadLocal;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.AnyCyclicBarrier;
import hydra.blackboard.SharedMap;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import sql.GFEDBClientManager;
import sql.GFEDBManager;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlDistTxStatements.DMLDistTxStmtIF;
import sql.dmlDistTxStatements.TradeNetworthDMLDistTxStmt;
import sql.dmlDistTxStatements.TradeNetworthV1DMLDistTxStmt;
import sql.dmlDistTxStatements.json.TradeNetworthDMLDistTxStmtJson;
import sql.dmlStatements.AbstractDMLStmt;
import sql.sqlTx.ForeignKeyLocked;
import sql.sqlTx.RangeForeignKey;
import sql.sqlTx.SQLTxBB;
import sql.sqlTx.SQLTxBatchingBB;
import sql.sqlTx.SQLTxBatchingDeleteHoldKeysBB;
import sql.sqlTx.SQLTxBatchingFKBB;
import sql.sqlTx.SQLTxBatchingNonDeleteHoldKeysBB;
import sql.sqlTx.SQLTxDeleteHoldKeysBlockingChildBB;
import sql.sqlTx.SQLTxHoldForeignKeysBB;
import sql.sqlTx.SQLTxHoldKeysBlockingChildBB;
import sql.sqlTx.SQLTxHoldNewForeignKeysBB;
import sql.sqlTx.SQLTxPrms;
import sql.sqlTx.SQLTxSecondBB;
import sql.sqlTx.SQLTxTest;
import sql.sqlTx.thinClient.SQLDistTxClientTest;
import sql.sqlTx.txTrigger.TxTriggerProcedure;
import sql.sqlTx.txTrigger.TxTriggers;
import sql.sqlutil.DMLDistTxStmtsFactory;
import sql.sqlutil.PooledConnectionC3P0;
import sql.sqlutil.PooledConnectionDBCP;
import sql.sqlutil.PooledConnectionTomcat;
import sql.sqlutil.ResultSetHelper;
import util.PRObserver;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class SQLDistTxTest
extends SQLTxTest {
    protected static SQLDistTxTest sqlNewTxTest;
    public static HydraThreadLocal gfxdNoneTxConn;
    public static HydraThreadLocal cidInserted;
    public static HydraThreadLocal curTxId;
    public static HydraThreadLocal curTxModifiedKeys;
    public static HydraThreadLocal curTxNonDeleteHoldKeys;
    public static HydraThreadLocal curTxDeleteHoldKeys;
    public static HydraThreadLocal curTxNewHoldParentKeys;
    public static HydraThreadLocal curTxHoldParentKeys;
    public static HydraThreadLocal derbyOps;
    public static HydraThreadLocal commitEarly;
    public static HydraThreadLocal curTxFKHeld;
    public static HydraThreadLocal rollbackGfxdTx;
    public static HydraThreadLocal iteration;
    public static HydraThreadLocal selectForUpdateRS;
    public static HydraThreadLocal foreignKeyHeldWithBatching;
    public static HydraThreadLocal parentKeyHeldWithBatching;
    public static HydraThreadLocal derbyExceptionsWithBatching;
    public static HydraThreadLocal failedToGetStmtNodeFailure;
    public static HydraThreadLocal updateOnPartitionCol;
    public static HydraThreadLocal needNewConnAfterNodeFailure;
    public static HydraThreadLocal batchInsertToCustomersSucceeded;
    public static boolean ticket43170fixed;
    CountDownLatch latch = null;
    protected static boolean doOpByOne;
    protected static boolean useOriginalNonTx;
    protected static DMLDistTxStmtsFactory dmlDistTxFactory;
    public static boolean useTimeout;
    boolean is43591fixed = TestConfig.tab().booleanAt(SQLTxPrms.is43591fixed, false);
    String[] concUpdateStatements = new String[]{"update trade.portfolio set qty = qty + ? where cid>? and cid <= ? ", "update trade.sellorders set ask = ask + ? where cid>? and cid <= ? "};
    protected static int concUpdateTxMaxCid;
    protected static boolean isTicket41738Fixed;
    protected static boolean isTicket43935Fixed;
    protected static boolean isTicket43932Fixed;
    protected static boolean isTicket43909fixed;
    protected static boolean isTicket45071fixed;
    public static boolean isTicket43188fiFixed;
    public static boolean useThinClientDriverInTx;
    public static boolean mixRR_RC;
    protected boolean nobatching = TestConfig.tab().booleanAt(SQLTxPrms.nobatching, true);
    protected boolean batchingWithSecondaryData = !this.nobatching;
    public static String syncCommits;
    public static Object lock;
    public static int concUpdateCount;
    public static boolean addGenIdColInCustomersv1;
    public static final String CUSTOMERSV1TXREADY = "CUSTOMERSV1TXREADY";
    public static boolean hasSecondaryTables;
    public static boolean queryOpTimeNewTables;

    public static void HydraTask_initConnections() throws SQLException {
        sqlNewTxTest.initThreadLocalConnection();
    }

    protected void initThreadLocalConnection() throws SQLException {
        Connection gfxdConn = this.getGFEConnection();
        this.log().info("gfxdNoneTxConn isolation is set to 0 and getTransactionIsolation() is " + gfxdConn.getTransactionIsolation());
        gfxdNoneTxConn.set((Object)gfxdConn);
    }

    public static void HydraTask_initThreadLocals() {
        sqlNewTxTest.initThreadLocals();
    }

    protected void initThreadLocals() {
        ArrayList curTxRangeFK = new ArrayList();
        curTxFKHeld.set(curTxRangeFK);
        rollbackGfxdTx.set((Object)false);
        ArrayList selectForUpdateRSList = new ArrayList();
        selectForUpdateRS.set(selectForUpdateRSList);
        if (useNewTables) {
            iteration.set((Object)1);
        }
        if (this.batchingWithSecondaryData) {
            HashSet fkHold = new HashSet();
            foreignKeyHeldWithBatching.set(fkHold);
            HashSet pkHold = new HashSet();
            parentKeyHeldWithBatching.set(pkHold);
            derbyExceptionsWithBatching.set(new ArrayList());
        }
        failedToGetStmtNodeFailure.set((Object)false);
        updateOnPartitionCol.set((Object)false);
        needNewConnAfterNodeFailure.set((Object)false);
        batchInsertToCustomersSucceeded.set((Object)true);
    }

    public static synchronized void HydraTask_initialize() {
        if (sqlNewTxTest == null) {
            sqlNewTxTest = new SQLDistTxTest();
            PRObserver.installObserverHook();
            PRObserver.initialize((int)RemoteTestModule.getMyVmid());
            sqlNewTxTest.initialize();
        }
        sqlNewTxTest.initThreadLocals();
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    public static void HydraTask_createGfxdLocatorTask() {
        SQLTest.HydraTask_createGfxdLocatorTask();
    }

    public static void HydraTask_startGfxdLocatorTask() {
        SQLTest.HydraTask_startGfxdLocatorTask();
    }

    public static synchronized void HydraTask_startFabricServer() {
        sqlNewTxTest.startFabricServer();
    }

    public static synchronized void HydraTask_stopFabricServer() {
        if (sqlNewTxTest == null) {
            sqlNewTxTest = new SQLDistTxTest();
        }
        sqlNewTxTest.stopFabricServer();
    }

    public static synchronized void HydraTask_startFabricServerSG() {
        sqlNewTxTest.startFabricServerSG();
    }

    public static synchronized void HydraTask_startFabricServerSGDBSynchronizer() {
        sqlNewTxTest.startFabricServerSGDBSynchronizer();
    }

    public static synchronized void HydraTask_createDiscDB() {
        sqlNewTxTest.createDiscDB();
    }

    public static synchronized void HydraTask_createDiscSchemas() {
        sqlNewTxTest.createDiscSchemas();
    }

    public static synchronized void HydraTask_createDiscTables() {
        sqlNewTxTest.createDiscTables();
    }

    public static void HydraTask_createGFESchemas() {
        sqlNewTxTest.createGFESchemas();
    }

    public static void HydraTask_createGFETables() {
        sqlNewTxTest.createGFETables();
    }

    public static synchronized void HydraTask_dropAllTables() {
        sqlNewTxTest.dropAllTables();
    }

    public static void HydraTask_populateTxTables() {
        sqlNewTxTest.populateTxTables();
    }

    public static void HydraTask_populateTxTablesDBSynchronizer() {
        sqlNewTxTest.populateTxTablesDBSynchronizer();
    }

    public static void HydraTask_setTableCols() {
        sqlNewTxTest.setTableCols();
    }

    public static void HydraTask_alterPortfolioAddTimestamp() {
        sqlNewTxTest.alterPortfolioAddTimestamp();
    }

    public static void HydraTask_setTraceFlagsTask() {
        sqlNewTxTest.setTraceFlags(true);
    }

    public static void HydraTask_unsetTraceFlagsTask() {
        sqlNewTxTest.setTraceFlags(false);
    }

    protected void alterPortfolioAddTimestamp() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        this.alterPortfolioAddTimestamp(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void alterPortfolioAddTimestamp(Connection dConn, Connection gConn) {
    }

    public static void HydraTask_createIndex() {
        if (!RemoteTestModule.getCurrentThread().getCurrentTask().getTaskTypeString().equalsIgnoreCase("INITTASK")) {
            if (random.nextInt(numOfWorkers) == 1) {
                sqlNewTxTest.createIndex();
            } else {
                Log.getLogWriter().info("This is no op to avoid too many ddl in the test");
            }
        }
    }

    public static void HydraTask_verifyResultSets() {
        sqlNewTxTest.verifyResultSets();
    }

    @Override
    protected void verifyResultSets() {
        if (!hasDerbyServer) {
            Log.getLogWriter().info("skipping verification of query results due to manageDerbyServer as false, myTid=" + this.getMyTid());
            this.cleanConnection(this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED));
            return;
        }
        Connection dConn = this.getDiscConnection();
        Connection gConn = null;
        if (hasHdfs) {
            Properties info = new Properties();
            info.setProperty("query-HDFS", "true");
            gConn = this.getGFXDTxConnection(info);
            Log.getLogWriter().info("Get gfxd connection with properties=" + info + ", connection=" + gConn);
        } else {
            gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        }
        this.verifyResultSets(dConn, gConn);
    }

    public static void HydraTask_initForServerGroup() {
        sqlNewTxTest.initForServerGroup();
    }

    public static void HydraTask_createDBSynchronizer() {
        sqlNewTxTest.createDBSynchronizer();
    }

    public static void HydraTask_createDiskStores() {
        sqlNewTxTest.createDiskStores();
    }

    @Override
    protected void createDiskStores() {
        Connection conn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        this.createDiskStores(conn);
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    @Override
    protected void createDBSynchronizer() {
        Connection conn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        this.createNewDBSynchronizer(conn);
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_startDBSynchronizer() {
        sqlNewTxTest.startDBSynchronizer();
    }

    @Override
    protected void startDBSynchronizer() {
        boolean useNewApi = true;
        Connection conn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        if (useNewApi) {
            this.startNewDBSynchronizer(conn);
        } else {
            this.startDBSynchronizer(conn);
        }
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    @Override
    protected void createIndex() {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        this.createTxIndex(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void createTxIndex(Connection gConn) {
        try {
            this.createIndex(gConn);
        }
        catch (TestException te) {
            if (isHATest && (te.getMessage().contains("40XD0") || te.getMessage().contains("40XD2"))) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
            }
            throw te;
        }
        try {
            this.commit(gConn);
        }
        catch (TestException te) {
            if (isHATest && (te.getMessage().contains("40XD0") || te.getMessage().contains("40XD2"))) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
            }
            throw te;
        }
    }

    @Override
    protected void populateTxTables() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Properties info = new Properties();
        info.setProperty(syncCommits, "true");
        Connection gConn = this.getGFXDTxConnection(info);
        this.populateTables(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void populateTxTablesDBSynchronizer() {
        Properties info = new Properties();
        info.setProperty(syncCommits, "true");
        Connection gConn = this.getGFXDTxConnection(info);
        this.populateTables(null, gConn);
        this.closeGFEConnection(gConn);
    }

    @Override
    protected void populateTables(Connection dConn, Connection gConn) {
        if (!useOriginalNonTx) {
            for (int i = 0; i < dmlTables.length; ++i) {
                DMLDistTxStmtIF dmlStmt = dmlDistTxFactory.createDMLDistTxStmt(dmlTables[i]);
                if (dmlStmt == null) continue;
                dmlStmt.populate(dConn, gConn);
                if (dConn == null) continue;
                this.waitForBarrier();
            }
        } else {
            super.populateTables(dConn, gConn);
        }
    }

    public static void HydraTask_setCriticalHeapPercentage() {
        sqlNewTxTest.setCriticalHeapPercentage();
    }

    @Override
    protected void setCriticalHeapPercentage() {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        this.setCriticalHeapPercentage(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    protected Connection getGFXDTxConnection(GFEDBManager.Isolation isolation) {
        Connection conn = null;
        boolean retry = false;
        do {
            try {
                if (hasHdfs) {
                    Properties info = new Properties();
                    info.setProperty("query-HDFS", "true");
                    conn = GFEDBManager.getTxConnection(isolation, info);
                    Log.getLogWriter().info("Get gfxd connection with properties=" + info + ", connection=" + conn);
                } else if (isEdge) {
                    if (useC3P0 && useGfxdConfig) {
                        if (isolation == GFEDBManager.Isolation.READ_COMMITTED) {
                            conn = PooledConnectionC3P0.getRCConnection();
                        }
                        if (isolation == GFEDBManager.Isolation.REPEATABLE_READ) {
                            conn = PooledConnectionC3P0.getRRConnection();
                        }
                    } else if (useDBCP && useGfxdConfig) {
                        if (isolation == GFEDBManager.Isolation.READ_COMMITTED) {
                            conn = PooledConnectionDBCP.getRCConnection();
                        }
                        if (isolation == GFEDBManager.Isolation.REPEATABLE_READ) {
                            conn = PooledConnectionDBCP.getRRConnection();
                        }
                    } else if (useTomcatConnPool && useGfxdConfig) {
                        if (isolation == GFEDBManager.Isolation.READ_COMMITTED) {
                            conn = PooledConnectionTomcat.getRCConnection();
                        }
                        if (isolation == GFEDBManager.Isolation.REPEATABLE_READ) {
                            conn = PooledConnectionTomcat.getRRConnection();
                        }
                    } else {
                        conn = GFEDBClientManager.getTxConnection(isolation);
                    }
                } else {
                    conn = GFEDBManager.getTxConnection(isolation);
                }
                retry = false;
                if (!this.needNewConnection()) continue;
                this.resetNeedNewConnFlag();
            }
            catch (SQLException e) {
                SQLHelper.printSQLException(e);
                if (AbstractDMLStmt.gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(e)) {
                    retry = true;
                    Log.getLogWriter().info("Could not get connection due to Node failure and will retry, continue testing");
                    continue;
                }
                throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)e));
            }
        } while (retry);
        return conn;
    }

    public static void HydraTask_putLastKeyDBSynchronizer() {
        sqlNewTxTest.putLastKeyDBSynchronizer();
    }

    @Override
    protected void putLastKeyDBSynchronizer() {
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        this.putLastKeyDBSynchronizer(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_verifyResultSetsDBSynchronizer() {
        sqlNewTxTest.verifyResultSetsDBSynchronizer();
    }

    public static void HydraTask_doTxDMLOpDBSynchronizer() {
        sqlNewTxTest.doTxDMLOpDBSynchronizer();
    }

    protected void doTxDMLOpDBSynchronizer() {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        this.doDMLOp(null, gConn);
    }

    public static void HydraTask_doDMLOps() {
        int numOfOps = 20;
        for (int i = 0; i < numOfOps; ++i) {
            sqlNewTxTest.doDMLOp();
        }
    }

    public static void HydraTask_doDMLOp() {
        sqlNewTxTest.doDMLOp();
    }

    @Override
    protected void doDMLOp() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        this.doDMLOp(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        try {
            Log.getLogWriter().info("commit the gfxd txn again");
            gConn.commit();
        }
        catch (SQLException se) {
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
            }
            if (isHATest && se.getSQLState().equals("08003")) {
                Log.getLogWriter().info("connection has been closed -- this could happen when txn HA support is not ready and a new connection has been acquired, continue testing");
                Log.getLogWriter().info("done dmlOp");
                return;
            }
            SQLHelper.handleSQLException(se);
        }
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done dmlOp");
    }

    @Override
    protected void doDMLOp(Connection dConn, Connection gConn) {
        if (dConn != null) {
            if (!useOriginalNonTx) {
                if (useNewTables) {
                    this.doDMLOpNewTablesByOne(dConn, gConn);
                } else {
                    this.doDMLOpByOne(dConn, gConn);
                }
            } else {
                super.doDMLOp(dConn, gConn);
            }
        } else {
            this.doDMLGfxdOnlyOps(gConn);
        }
    }

    protected void doDMLOpNewTablesByOne(Connection dConn, Connection gConn) {
        int num = (Integer)iteration.get();
        Log.getLogWriter().info("this is iteration " + num);
        int numIt = (int)SQLTxBB.getBB().getSharedCounters().read(SQLTxBB.iterations);
        if (numIt != num) {
            throw new TestException("this thread does not have the same iteration as others,mine is " + num + ", but others have " + numIt + " need to check logs");
        }
        Log.getLogWriter().info("using RC isolation");
        boolean firstInThisRound = false;
        if (SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.firstInRound) == 1L) {
            firstInThisRound = true;
            Log.getLogWriter().info("I am the first to commit in this round");
            MasterController.sleepForMs((int)100);
            try {
                this.verifyResultSets(dConn, gConn, "trade", "customersv1");
                this.verifyResultSets(dConn, gConn, "trade", "networthv1");
            }
            catch (TestException te) {
                if (isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                    Log.getLogWriter().info("got expected node failure exception, continuing test");
                    gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
                }
                throw te;
            }
        }
        int txId = (int)SQLTxBB.getBB().getSharedCounters().incrementAndRead(SQLTxBB.txId);
        curTxId.set((Object)txId);
        boolean withDerby = false;
        if (dConn != null) {
            withDerby = true;
        }
        Log.getLogWriter().info("performing dmlOp, myTid is " + this.getMyTid() + " and txId is " + txId);
        curTxModifiedKeys.set(new HashMap());
        curTxDeleteHoldKeys.set(new HashMap());
        curTxNonDeleteHoldKeys.set(new HashMap());
        curTxHoldParentKeys.set(new HashMap());
        curTxNewHoldParentKeys.set(new HashMap());
        int total = 4;
        int numOfIter = random.nextInt(total) + 1;
        int maxOps = 5;
        int numOps = random.nextInt(maxOps) + 1;
        for (int i = 0; i < numOfIter - 1; ++i) {
            this.getLock();
            this.doGfxdDMLOpNewTablesByOne(dConn, gConn, numOps, withDerby);
            this.releaseLock();
            if (!this.needNewConnection()) continue;
            gConn = this.getNewGfxdConnection();
            this.resetNeedNewConnFlag();
        }
        this.getLock();
        this.doGfxdDMLOpNewTablesByOne(dConn, gConn, numOps, withDerby);
        this.releaseLock();
        if (this.needNewConnection()) {
            gConn = this.getNewGfxdConnection();
            this.resetNeedNewConnFlag();
        }
        this.waitForBarrier();
        if (firstInThisRound) {
            SQLBB.getBB().getSharedCounters().zero(SQLBB.firstInRound);
            this.commitOrRollback(dConn, gConn, firstInThisRound);
            this.removeNewTablesHoldKeysByThisTx();
            this.closeSelectForUpdateRS();
            int nextIt = (int)SQLTxBB.getBB().getSharedCounters().incrementAndRead(SQLTxBB.iterations);
            Log.getLogWriter().info("next round of iterations is " + nextIt);
        }
        this.waitForBarrier();
        if (!firstInThisRound) {
            if (this.batchingWithSecondaryData) {
                this.getLock();
            }
            this.commitOrRollback(dConn, gConn, firstInThisRound);
            if (!this.batchingWithSecondaryData) {
                this.getLock();
            }
            this.removeNewTablesHoldKeysByThisTx();
            if (!this.batchingWithSecondaryData) {
                this.releaseLock();
            }
            this.closeSelectForUpdateRS();
            if (this.batchingWithSecondaryData) {
                this.releaseLock();
            }
        }
        this.waitForBarrier();
    }

    protected void resetNeedNewConnFlag() {
        Boolean needNewConn = (Boolean)needNewConnAfterNodeFailure.get();
        if (needNewConn != null && needNewConn.booleanValue()) {
            needNewConnAfterNodeFailure.set((Object)false);
            Log.getLogWriter().info("needNewConnAfterNodeFailure is reset to false for new ops");
        }
    }

    @Override
    protected boolean needNewConnection() {
        Boolean needNewConn = (Boolean)needNewConnAfterNodeFailure.get();
        return needNewConn != null && needNewConn != false;
    }

    protected void doGfxdDMLOpNewTablesByOne(Connection dConn, Connection gConn, int size, boolean withDerby) {
        for (int i = 0; i < size; ++i) {
            this.doOneGfxdDMLOpNewTablesByOne(dConn, gConn, withDerby);
            if (!this.needNewConnection()) continue;
            return;
        }
    }

    protected void doOneGfxdDMLOpNewTablesByOne(Connection dConn, Connection gConn, boolean withDerby) {
        ArrayList derbyOps;
        this.doOneGfxdDMLOpNewTablesByOne(gConn, withDerby);
        if (!ticket43170fixed && withDerby && (derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get()) != null && derbyOps.size() > 0) {
            String operation;
            int lastIndex = derbyOps.size() - 1;
            Object[] data = (Object[])derbyOps.get(lastIndex);
            SQLException gfxdse = (SQLException)data[data.length - 1];
            if (gfxdse != null) {
                if (gfxdse.getSQLState().equals("23503") || gfxdse.getSQLState().equals("23505") || gfxdse.getSQLState().equals("23513")) {
                    this.processDerbyOps(dConn, true);
                    this.removeNewTablesHoldKeysByThisTx();
                    this.closeSelectForUpdateRS();
                    this.rollback(dConn);
                    this.resetDerbyOps();
                    return;
                }
                SQLHelper.handleSQLException(gfxdse);
            }
            if (queryOpTimeNewTables && (operation = (String)data[1]).equals("query")) {
                this.processDerbyQuery(dConn);
            }
        }
    }

    protected void doOneGfxdDMLOpNewTablesByOne(Connection gConn, boolean withDerby) {
        String operation;
        boolean succeed = true;
        int table = dmlTables[random.nextInt(dmlTables.length)];
        DMLDistTxStmtIF dmlStmt = dmlDistTxFactory.createNewTablesDMLDistTxStmt(table);
        if (table != 1) {
            if (table != 4) {
                return;
            }
        }
        if ((operation = TestConfig.tab().stringAt(SQLPrms.dmlOperations)).equals("insert")) {
            succeed = dmlStmt.insertGfxd(gConn, withDerby);
        } else if (operation.equals("update")) {
            succeed = dmlStmt.updateGfxd(gConn, withDerby);
        } else if (operation.equals("delete")) {
            succeed = dmlStmt.deleteGfxd(gConn, withDerby);
        } else if (operation.equals("query")) {
            succeed = dmlStmt.queryGfxd(gConn, withDerby);
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        if (table == 1 && operation.equals("insert") && succeed) {
            int chance = 3;
            if (random.nextInt(chance) == 1) {
                Log.getLogWriter().info("Does not have child row in networthv1 table");
                return;
            }
            Log.getLogWriter().info("inserting into networthv1 table");
            TradeNetworthV1DMLDistTxStmt networthv1 = new TradeNetworthV1DMLDistTxStmt();
            succeed = networthv1.insertGfxd(gConn, withDerby, (Long)cidInserted.get());
        }
        if (!succeed || this.needNewConnection()) {
            this.removeNewTablesHoldKeysByThisTx();
            this.closeSelectForUpdateRS();
            this.resetDerbyOps();
        }
    }

    protected void removeNewTablesHoldKeysByThisTx() {
        if (!this.batchingWithSecondaryData) {
            SharedMap modifiedKeysByAllTx = SQLTxBB.getBB().getSharedMap();
            Set alreadyHeldKeysThisTx = ((HashMap)curTxModifiedKeys.get()).keySet();
            Log.getLogWriter().info("removing the keys from the key Map that were held by this txn");
            for (String key : alreadyHeldKeysThisTx) {
                Log.getLogWriter().info("key to be removed is " + key);
                modifiedKeysByAllTx.remove((Object)key);
            }
            SharedMap holdDeleteBlockingKeysByAllTx = SQLTxDeleteHoldKeysBlockingChildBB.getBB().getSharedMap();
            HashMap holdDeleteKeysByTx = (HashMap)curTxDeleteHoldKeys.get();
            Log.getLogWriter().info("removing the keys from the parent key Map that were held by this txn by delete op");
            for (String key : holdDeleteKeysByTx.keySet()) {
                Log.getLogWriter().info("parent key to be removed is " + key);
                holdDeleteBlockingKeysByAllTx.remove((Object)key);
            }
            SharedMap holdBlockingKeysByAllTx = SQLTxHoldKeysBlockingChildBB.getBB().getSharedMap();
            HashMap holdNonDeleteKeysByTx = (HashMap)curTxNonDeleteHoldKeys.get();
            Log.getLogWriter().info("removing the keys from the parent key Map that were held by this txn by non delete op");
            for (String key : holdNonDeleteKeysByTx.keySet()) {
                Log.getLogWriter().info("parent key to be removed is " + key);
                holdBlockingKeysByAllTx.remove((Object)key);
            }
        } else {
            Integer myTxId = (Integer)curTxId.get();
            SharedMap modifiedKeysByAllTx = SQLTxBatchingBB.getBB().getSharedMap();
            Set alreadyHeldKeysThisTx = ((HashMap)curTxModifiedKeys.get()).keySet();
            Log.getLogWriter().info("removing the keys from the key Map that were held by this txn");
            for (String key : alreadyHeldKeysThisTx) {
                boolean contains;
                Log.getLogWriter().info("key to be removed is " + key);
                ArrayList txIdsForKey = (ArrayList)modifiedKeysByAllTx.get((Object)key);
                if (txIdsForKey != null && !(contains = txIdsForKey.remove(myTxId))) {
                    Log.getLogWriter().info("this txId does not hold the local lock yet");
                }
                if (txIdsForKey == null) continue;
                modifiedKeysByAllTx.put((Object)key, (Object)txIdsForKey);
            }
            SharedMap holdBlockingKeysByAllTx = SQLTxBatchingNonDeleteHoldKeysBB.getBB().getSharedMap();
            HashMap holdNonDeleteKeysByTx = (HashMap)curTxNonDeleteHoldKeys.get();
            Log.getLogWriter().info("removing the keys from the parent key Map that were held by this txn by non_delete op");
            for (String key : holdNonDeleteKeysByTx.keySet()) {
                boolean contains;
                Log.getLogWriter().info("key to be removed is " + key);
                ArrayList txIdsForKey = (ArrayList)holdBlockingKeysByAllTx.get((Object)key);
                if (txIdsForKey != null && !(contains = txIdsForKey.remove(myTxId))) {
                    Log.getLogWriter().info("this txId does not hold the local lock yet");
                }
                if (txIdsForKey == null) continue;
                holdBlockingKeysByAllTx.put((Object)key, (Object)txIdsForKey);
            }
            SharedMap holdDeleteBlockingKeysByAllTx = SQLTxBatchingDeleteHoldKeysBB.getBB().getSharedMap();
            HashMap holdDeleteKeysByTx = (HashMap)curTxDeleteHoldKeys.get();
            Log.getLogWriter().info("removing the keys from the parent key Map that were held by this txn by delete op");
            for (String key : holdDeleteKeysByTx.keySet()) {
                boolean contains;
                Log.getLogWriter().info("key to be removed is " + key);
                ArrayList txIdsForKey = (ArrayList)holdDeleteBlockingKeysByAllTx.get((Object)key);
                if (txIdsForKey != null && !(contains = txIdsForKey.remove(myTxId))) {
                    Log.getLogWriter().info("this txId does not hold the local lock yet");
                }
                if (txIdsForKey == null) continue;
                holdDeleteBlockingKeysByAllTx.put((Object)key, (Object)txIdsForKey);
            }
        }
        SharedMap holdForeignKeysByAllTx = SQLTxHoldForeignKeysBB.getBB().getSharedMap();
        HashMap holdParentKeysByTx = (HashMap)curTxHoldParentKeys.get();
        Log.getLogWriter().info("removing the keys from the foreing key Map that were held by this txn");
        for (String key : holdParentKeysByTx.keySet()) {
            ForeignKeyLocked fkey = (ForeignKeyLocked)holdForeignKeysByAllTx.get((Object)key);
            int txId = (Integer)curTxId.get();
            fkey.removeAllLockedKeyByCurTx(txId);
            Log.getLogWriter().info("foreign key to be removed is " + key + " for txId: " + txId);
            holdForeignKeysByAllTx.put((Object)key, (Object)fkey);
        }
        SharedMap holdNewForeignKeysByAllTx = SQLTxHoldNewForeignKeysBB.getBB().getSharedMap();
        HashMap holdNewParentKeysByTx = (HashMap)curTxNewHoldParentKeys.get();
        Log.getLogWriter().info("removing the keys from the foreing key Map that were held by this txn");
        for (String key : holdNewParentKeysByTx.keySet()) {
            ForeignKeyLocked fkey = (ForeignKeyLocked)holdNewForeignKeysByAllTx.get((Object)key);
            int txId = (Integer)curTxId.get();
            fkey.removeAllLockedKeyByCurTx(txId);
            Log.getLogWriter().info("Newly acquired foreign key to be removed is " + key + " for txId: " + txId);
            holdNewForeignKeysByAllTx.put((Object)key, (Object)fkey);
        }
        curTxModifiedKeys.set(new HashMap());
        curTxDeleteHoldKeys.set(new HashMap());
        curTxNonDeleteHoldKeys.set(new HashMap());
        curTxHoldParentKeys.set(new HashMap());
        curTxNewHoldParentKeys.set(new HashMap());
    }

    protected void doDMLOpByOne(Connection dConn, Connection gConn) {
        Log.getLogWriter().info("using RC isolation");
        boolean firstInThisRound = false;
        if (SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.firstInRound) == 1L) {
            firstInThisRound = true;
            Log.getLogWriter().info("I am the first to commit in this round");
            commitEarly.set((Object)true);
        } else if (random.nextInt(10) == 1) {
            commitEarly.set((Object)true);
        } else {
            commitEarly.set((Object)false);
        }
        boolean ticket42651fixed = true;
        int txId = (int)SQLTxBB.getBB().getSharedCounters().incrementAndRead(SQLTxBB.txId);
        curTxId.set((Object)txId);
        boolean withDerby = false;
        if (dConn != null) {
            withDerby = true;
        }
        Log.getLogWriter().info("performing dmlOp, myTid is " + this.getMyTid() + " and txId is " + txId);
        HashMap modifiedKeys = new HashMap();
        curTxModifiedKeys.set(modifiedKeys);
        int total = 4;
        int numOfIter = random.nextInt(total) + 1;
        int maxOps = 5;
        int numOps = random.nextInt(maxOps) + 1;
        for (int i = 0; i < numOfIter - 1; ++i) {
            this.getLock();
            this.doGfxdDMLOpByOne(dConn, gConn, numOps, withDerby);
            this.releaseLock();
        }
        this.getLock();
        this.doGfxdDMLOpByOne(dConn, gConn, numOps, withDerby);
        this.releaseLock();
        this.waitForBarrier();
        if (firstInThisRound) {
            SQLBB.getBB().getSharedCounters().zero(SQLBB.firstInRound);
            this.commitOrRollback(dConn, gConn, firstInThisRound);
            this.removeHoldKeysByThisTx();
            if (this.batchingWithSecondaryData) {
                this.cleanUpFKHolds();
            }
            this.closeSelectForUpdateRS();
        }
        this.waitForBarrier();
        if (!firstInThisRound && ((Boolean)commitEarly.get()).booleanValue()) {
            if (this.batchingWithSecondaryData) {
                this.getLock();
            }
            this.commitOrRollback(dConn, gConn, firstInThisRound);
            if (this.batchingWithSecondaryData) {
                this.cleanUpFKHolds();
            }
            if (!this.batchingWithSecondaryData) {
                this.getLock();
            }
            this.removeHoldKeysByThisTx();
            if (!this.batchingWithSecondaryData) {
                this.releaseLock();
            }
            this.closeSelectForUpdateRS();
            if (this.batchingWithSecondaryData) {
                this.releaseLock();
            }
        }
        this.waitForBarrier();
        if (!firstInThisRound && !((Boolean)commitEarly.get()).booleanValue()) {
            if (this.batchingWithSecondaryData) {
                this.getLock();
            }
            this.commitOrRollback(dConn, gConn, firstInThisRound);
            if (this.batchingWithSecondaryData) {
                this.cleanUpFKHolds();
            }
            if (!this.batchingWithSecondaryData) {
                this.getLock();
            }
            this.removeHoldKeysByThisTx();
            if (!this.batchingWithSecondaryData) {
                this.releaseLock();
            }
            this.closeSelectForUpdateRS();
            if (this.batchingWithSecondaryData) {
                this.releaseLock();
            }
        }
        this.waitForBarrier();
    }

    @Override
    protected void waitForBarrier() {
        int numWaitingWorker = numOfWorkers;
        if (isHATest) {
            numWaitingWorker = numOfWorkers - 1;
        }
        AnyCyclicBarrier barrier = AnyCyclicBarrier.lookup((int)numWaitingWorker, (String)"barrier");
        Log.getLogWriter().info("Waiting for " + numWaitingWorker + " to meet at barrier");
        barrier.await();
    }

    public static void HydraTask_cycleStoreVms() {
        if (cycleVms) {
            sqlNewTxTest.cycleStoreVms();
        }
    }

    protected void commitOrRollbackGfxdOnly(Connection gConn) {
        int chanceToRollback = 20;
        if (random.nextInt(chanceToRollback) == 1 || ((Boolean)rollbackGfxdTx.get()).booleanValue()) {
            Log.getLogWriter().info("roll back the tx");
            rollbackGfxdTx.set((Object)false);
            this.rollback(gConn);
        } else {
            Log.getLogWriter().info("commit the tx");
            this.commitGfxdOnly(gConn);
        }
    }

    protected boolean commitGfxdOnly(Connection gConn) {
        try {
            this.commit(gConn);
        }
        catch (TestException te) {
            if (isHATest && (te.getMessage().contains("X0Z16") || te.getMessage().contains("40XD0") || te.getMessage().contains("40XD2"))) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    protected void commitOrRollback(Connection dConn, Connection gConn, boolean firstCommit) {
        int chanceToRollback;
        if (dConn != null) {
            if (!this.batchingWithSecondaryData) {
                this.getLock();
                this.processDerbyOps(dConn, firstCommit);
                this.releaseLock();
            } else {
                this.processDerbyOpsWithBatching(dConn, firstCommit);
            }
        }
        int n = chanceToRollback = firstCommit ? 3 : 20;
        if (random.nextInt(chanceToRollback) == 1 || ((Boolean)rollbackGfxdTx.get()).booleanValue()) {
            Log.getLogWriter().info("roll back the tx");
            rollbackGfxdTx.set((Object)false);
            this.rollback(dConn);
            this.rollback(gConn);
        } else {
            this.doCommit(dConn, gConn, firstCommit);
        }
        if (useNewTables) {
            int num = (Integer)iteration.get();
            Log.getLogWriter().info("finishing this round of iteration " + num);
            iteration.set((Object)(++num));
        }
        if (this.batchingWithSecondaryData) {
            Log.getLogWriter().info("clean up derby exceptins");
            derbyExceptionsWithBatching.set(new ArrayList());
        }
    }

    protected void doCommit(Connection dConn, Connection gConn, boolean firstCommit) {
        Log.getLogWriter().info("commit the tx");
        boolean success = true;
        if (!this.batchingWithSecondaryData) {
            if (isHATest) {
                success = this.commitWithHA(gConn);
                if (success) {
                    this.commit(dConn);
                } else {
                    this.rollback(dConn);
                }
            } else {
                this.commit(gConn);
                this.commit(dConn);
            }
        } else {
            success = this.commitBatching(gConn, firstCommit);
            if (success) {
                this.commit(dConn);
            } else {
                this.rollback(dConn);
            }
        }
    }

    protected void doGfxdDMLOpByOne(Connection gConn, int size, boolean withDerby) {
        for (int i = 0; i < size; ++i) {
            this.doOneGfxdDMLOpByOne(gConn, withDerby);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doOneGfxdDMLOpByOne(Connection gConn, boolean withDerby) {
        String operation;
        boolean succeed = true;
        int table = dmlTables[random.nextInt(dmlTables.length)];
        DMLDistTxStmtIF dmlStmt = dmlDistTxFactory.createDMLDistTxStmt(table);
        if (table != 1) {
            if (table != 4) {
                if (table != 2) {
                    if (table != 3) {
                        if (table != 5) {
                            return;
                        }
                    }
                }
            }
        }
        if ((operation = TestConfig.tab().stringAt(SQLPrms.dmlOperations)).equals("insert")) {
            if (((Boolean)commitEarly.get()).booleanValue()) return;
            succeed = dmlStmt.insertGfxd(gConn, withDerby);
        } else if (operation.equals("update")) {
            succeed = dmlStmt.updateGfxd(gConn, withDerby);
        } else if (operation.equals("delete")) {
            succeed = dmlStmt.deleteGfxd(gConn, withDerby);
        } else {
            if (!operation.equals("query")) throw new TestException("Unknown entry operation: " + operation);
            succeed = dmlStmt.queryGfxd(gConn, withDerby);
        }
        if (table == 1 && operation.equals("insert") && succeed) {
            if (((Boolean)batchInsertToCustomersSucceeded.get()).booleanValue()) {
                Log.getLogWriter().info("inserting into networth table");
                if (SQLTest.hasJSON) {
                    TradeNetworthDMLDistTxStmtJson networth = new TradeNetworthDMLDistTxStmtJson();
                    succeed = networth.insertGfxd(gConn, withDerby, (Integer)cidInserted.get());
                } else {
                    TradeNetworthDMLDistTxStmt networth = new TradeNetworthDMLDistTxStmt();
                    succeed = networth.insertGfxd(gConn, withDerby, (Integer)cidInserted.get());
                }
            } else {
                Log.getLogWriter().info("insert into customers using batch failed, do not insert to networth table due to #43170. as the sqlf fails the whole batch");
                batchInsertToCustomersSucceeded.set((Object)true);
            }
        }
        if (succeed && !this.needNewConnection()) return;
        this.rollback(gConn);
        if (this.batchingWithSecondaryData) {
            this.cleanUpFKHolds();
        }
        this.removeHoldKeysByThisTx();
        this.closeSelectForUpdateRS();
        this.resetDerbyOps();
    }

    protected void doGfxdDMLOpByOne(Connection dConn, Connection gConn, int size, boolean withDerby) {
        for (int i = 0; i < size; ++i) {
            this.doOneGfxdDMLOpByOne(dConn, gConn, withDerby);
        }
    }

    protected void doOneGfxdDMLOpByOne(Connection dConn, Connection gConn, boolean withDerby) {
        Object[] data;
        SQLException gfxdse;
        ArrayList derbyOps;
        this.doOneGfxdDMLOpByOne(gConn, withDerby);
        if (!ticket43170fixed && withDerby && (derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get()) != null && derbyOps.size() > 0 && (gfxdse = (SQLException)(data = (Object[])derbyOps.get(derbyOps.size() - 1))[data.length - 1]) != null) {
            if (gfxdse.getSQLState().equals("23503") || gfxdse.getSQLState().equals("23505") || gfxdse.getSQLState().equals("23513")) {
                this.processDerbyOps(dConn, true);
                this.removeHoldKeysByThisTx();
                this.closeSelectForUpdateRS();
                this.rollback(dConn);
                this.resetDerbyOps();
            } else {
                SQLHelper.handleSQLException(gfxdse);
            }
        }
    }

    protected void processDerbyOps(Connection dConn, boolean compareQuery) {
        if (dConn == null) {
            return;
        }
        ArrayList ops = (ArrayList)derbyOps.get();
        if (ops == null) {
            Log.getLogWriter().info("derby ops is not set");
        } else {
            for (int i = 0; i < ops.size(); ++i) {
                Object[] derbyOp = (Object[])ops.get(i);
                DMLDistTxStmtIF dmlStmt = null;
                dmlStmt = useNewTables ? dmlDistTxFactory.createNewTablesDMLDistTxStmt((Integer)derbyOp[0]) : dmlDistTxFactory.createDMLDistTxStmt((Integer)derbyOp[0]);
                String operation = (String)derbyOp[1];
                if (operation.equals("insert")) {
                    dmlStmt.insertDerby(dConn, i);
                    continue;
                }
                if (operation.equals("update")) {
                    dmlStmt.updateDerby(dConn, i);
                    continue;
                }
                if (operation.equals("delete")) {
                    dmlStmt.deleteDerby(dConn, i);
                    continue;
                }
                if (operation.equals("query")) {
                    if (!useNewTables || queryOpTimeNewTables || !compareQuery) continue;
                    dmlStmt.queryDerby(dConn, i);
                    continue;
                }
                throw new TestException("Unknown entry operation: " + operation);
            }
            this.resetDerbyOps();
        }
    }

    protected void processDerbyQuery(Connection dConn) {
        if (dConn == null) {
            return;
        }
        ArrayList ops = (ArrayList)derbyOps.get();
        int lastIndex = ops.size() - 1;
        Object[] derbyOp = (Object[])ops.get(lastIndex);
        DMLDistTxStmtIF dmlStmt = null;
        if (!useNewTables) {
            throw new TestException("only new tables in txn should invoke this method");
        }
        dmlStmt = dmlDistTxFactory.createNewTablesDMLDistTxStmt((Integer)derbyOp[0]);
        dmlStmt.queryDerby(dConn, lastIndex);
    }

    protected void processDerbyOpsWithBatching(Connection dConn, boolean compareQuery) {
        if (dConn == null) {
            return;
        }
        ArrayList ops = (ArrayList)derbyOps.get();
        if (ops == null) {
            Log.getLogWriter().info("derby ops is not set");
        } else {
            for (int i = 0; i < ops.size(); ++i) {
                Object[] derbyOp = (Object[])ops.get(i);
                DMLDistTxStmtIF dmlStmt = null;
                dmlStmt = useNewTables ? dmlDistTxFactory.createNewTablesDMLDistTxStmt((Integer)derbyOp[0]) : dmlDistTxFactory.createDMLDistTxStmt((Integer)derbyOp[0]);
                String operation = (String)derbyOp[1];
                if (operation.equals("insert")) {
                    dmlStmt.insertDerby(dConn, i);
                    continue;
                }
                if (operation.equals("update")) {
                    dmlStmt.updateDerby(dConn, i);
                    continue;
                }
                if (operation.equals("delete")) {
                    dmlStmt.deleteDerby(dConn, i);
                    continue;
                }
                if (operation.equals("query")) {
                    if (!compareQuery) continue;
                    dmlStmt.queryDerby(dConn, i);
                    continue;
                }
                throw new TestException("Unknown entry operation: " + operation);
            }
            this.resetDerbyOps();
        }
    }

    protected void resetDerbyOps() {
        derbyOps.set(new ArrayList());
        Log.getLogWriter().info("derby ops has been reset");
    }

    protected void rollback(Connection conn) {
        boolean isTicket48177fixed = false;
        if (conn == null) {
            return;
        }
        try {
            conn.rollback();
        }
        catch (SQLException se) {
            if (isEdge && isHATest && !isTicket48177fixed && SQLHelper.gotTXNodeFailureException(se)) {
                Log.getLogWriter().info("got node failure exception during Tx due to #48177, continue the testing");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected void removeHoldKeysByThisTx() {
        if (!this.batchingWithSecondaryData) {
            SharedMap modifiedKeysByAllTx = SQLTxBB.getBB().getSharedMap();
            Set alreadyHeldKeysThisTx = ((HashMap)curTxModifiedKeys.get()).keySet();
            Log.getLogWriter().info("removing the keys from the key Map that were held by this txn");
            for (String key : alreadyHeldKeysThisTx) {
                Log.getLogWriter().info("key to be removed is " + key);
                modifiedKeysByAllTx.remove((Object)key);
            }
        } else {
            Integer myTxId = (Integer)curTxId.get();
            SharedMap modifiedKeysByAllTx = SQLTxBatchingBB.getBB().getSharedMap();
            Set alreadyHeldKeysThisTx = ((HashMap)curTxModifiedKeys.get()).keySet();
            Log.getLogWriter().info("removing the keys from the batchingBB Map that were held by this tx");
            for (String key : alreadyHeldKeysThisTx) {
                Log.getLogWriter().info("key to be removed is " + key);
                ArrayList txIdsForKey = (ArrayList)modifiedKeysByAllTx.get((Object)key);
                if (txIdsForKey == null) continue;
                boolean contains = txIdsForKey.remove(myTxId);
                if (!contains) {
                    Log.getLogWriter().info("this txId does not hold the local lock yet");
                }
                if (txIdsForKey.size() > 0) {
                    modifiedKeysByAllTx.put((Object)key, (Object)txIdsForKey);
                    continue;
                }
                modifiedKeysByAllTx.remove((Object)key);
            }
        }
        curTxModifiedKeys.set(new HashMap());
        if (this.batchingWithSecondaryData) {
            this.cleanUpFKHolds();
        }
        this.removeAllRangeFKsByThisTx();
    }

    protected void removeTxIdFromBatchingFKs(HashSet<String> fks) {
        Integer myTxId = (Integer)curTxId.get();
        SharedMap holdingFKTxIds = SQLTxBatchingFKBB.getBB().getSharedMap();
        for (String fk : fks) {
            HashSet txIds = (HashSet)holdingFKTxIds.get((Object)fk);
            Log.getLogWriter().info("holdingFKTxIds removed myTxId: " + myTxId + " for the this foreing key: " + fk);
            txIds.remove(myTxId);
            holdingFKTxIds.put((Object)fk, (Object)txIds);
        }
    }

    protected void cleanUpFKHolds() {
        HashSet fks = (HashSet)foreignKeyHeldWithBatching.get();
        this.removeTxIdFromBatchingFKs(fks);
        fks.clear();
        foreignKeyHeldWithBatching.set((Object)fks);
        HashSet parentKeys = (HashSet)parentKeyHeldWithBatching.get();
        parentKeys.clear();
        parentKeyHeldWithBatching.set((Object)parentKeys);
    }

    protected void removeAllRangeFKsByThisTx() {
        int txId = (Integer)curTxId.get();
        SharedMap rangeForeignKeys = SQLTxSecondBB.getBB().getSharedMap();
        ArrayList fkHeld = (ArrayList)curTxFKHeld.get();
        for (String fk : fkHeld) {
            Log.getLogWriter().info("foreign key hold is " + fk);
            RangeForeignKey rangeKey = (RangeForeignKey)rangeForeignKeys.get((Object)fk);
            rangeKey.removeAllPartialRangeKeyByCurTx(txId);
            rangeKey.removeWholeRangeKey(txId);
            if (rangeKey.getWholeRangeKeyHeldByTxId() == txId) {
                Log.getLogWriter().info("rangeKey.getWholeRangeKeyAlreadyHeld() is " + rangeKey.getWholeRangeKeyAlreadyHeld());
                Log.getLogWriter().info("rangeKey.getWholeRangeKeyHeldByTxId() is " + rangeKey.getWholeRangeKeyHeldByTxId());
                throw new TestException("Range key issue, whole range key is not removed for the tx");
            }
            rangeForeignKeys.put((Object)fk, (Object)rangeKey);
            RangeForeignKey rk = (RangeForeignKey)rangeForeignKeys.get((Object)fk);
            if (rk.getWholeRangeKeyHeldByTxId() != txId) continue;
            throw new TestException("Not able to put the range key over to the BB");
        }
        curTxFKHeld.set(new ArrayList());
    }

    protected void closeSelectForUpdateRS() {
        ArrayList selectForUpdateRSList = (ArrayList)selectForUpdateRS.get();
        for (ResultSet rs : selectForUpdateRSList) {
            try {
                rs.close();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
        for (int i = 0; i < selectForUpdateRSList.size(); ++i) {
            selectForUpdateRSList.remove(i);
        }
        selectForUpdateRS.set((Object)selectForUpdateRSList);
    }

    public static void HydraTask_createMonitoringTable() {
        sqlNewTxTest.createMonitoringTable();
    }

    protected void createMonitoringTable() {
        Connection gConn = this.getGFEConnection();
        String sql = "create table trade.monitor (tname varchar(20) not null, pk1 int not null, pk2 int ,insertCount int, updateCount int, deleteCount int, constraint monitor_pk primary key (tname, pk1, pk2))" + this.getPartitionByClause();
        try {
            gConn.createStatement().execute(sql);
            Log.getLogWriter().info("successfully " + sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected String getPartitionByClause() {
        String partition;
        int whichPartition = random.nextInt(5);
        switch (whichPartition) {
            case 0: {
                String string = " partition by List (tname) values ('customers', 'securities', 'networth''portfolio', 'buyorders', 'sellorders')";
            }
            case 1: {
                partition = " partition by column (tname) ";
                break;
            }
            case 2: {
                partition = " partition by column (pk1) ";
                break;
            }
            case 3: {
                partition = " ";
                break;
            }
            case 4: {
                return " replicate ";
            }
            default: {
                throw new TestException("should not happen");
            }
        }
        SQLBB.getBB().getSharedCounters().increment(SQLBB.numOfPRs);
        return partition + SQLPrms.getRedundancyClause(0) + SQLDistTxTest.getPersistence();
    }

    private static String getPersistence() {
        HydraVector statements = TestConfig.tab().vecAt(SQLPrms.gfePersistExtension, new HydraVector());
        if (statements.size() == 0) {
            return " ";
        }
        return " PERSISTENT ";
    }

    protected void doDMLGfxdOnlyOps(Connection gConn) {
        int txId = (int)SQLTxBB.getBB().getSharedCounters().incrementAndRead(SQLTxBB.txId);
        curTxId.set((Object)txId);
        Log.getLogWriter().info("performing dmlOp, myTid is " + this.getMyTid() + " and txId is " + txId);
        boolean withDerby = false;
        int total = 20;
        int numOfIter = random.nextInt(total) + 1;
        for (int i = 0; i < numOfIter; ++i) {
            gConn = this.doDMLGfxdOnlyOp(gConn, 1, withDerby);
        }
        this.commitOrRollbackGfxdOnly(gConn);
    }

    protected Connection doDMLGfxdOnlyOp(Connection gConn, int size, boolean withDerby) {
        for (int i = 0; i < size; ++i) {
            if (isHATest && ((Boolean)needNewConnAfterNodeFailure.get()).booleanValue()) {
                this.closeConnectionIgnoreFailure(gConn);
                gConn = this.getNewGfxdConnection();
                needNewConnAfterNodeFailure.set((Object)false);
            }
            this.doOneGfxdOnlyDMLOp(gConn, withDerby);
        }
        return gConn;
    }

    protected void doOneGfxdOnlyDMLOp(Connection gConn, boolean withDerby) {
        String operation;
        boolean succeed = true;
        int table = dmlTables[random.nextInt(dmlTables.length)];
        DMLDistTxStmtIF dmlStmt = dmlDistTxFactory.createDMLDistTxStmt(table);
        if (table != 1) {
            if (table != 4) {
                if (table != 2) {
                    if (table != 3) {
                        if (table != 5) {
                            return;
                        }
                    }
                }
            }
        }
        if ((operation = TestConfig.tab().stringAt(SQLPrms.dmlOperations)).equals("insert")) {
            succeed = dmlStmt.insertGfxd(gConn, withDerby);
        } else if (operation.equals("update")) {
            succeed = dmlStmt.updateGfxd(gConn, withDerby);
        } else if (operation.equals("delete")) {
            succeed = dmlStmt.deleteGfxd(gConn, withDerby);
        } else if (operation.equals("query")) {
            succeed = dmlStmt.queryGfxd(gConn, withDerby);
        } else {
            throw new TestException("Unknown dml operation: " + operation);
        }
        if (table == 1 && operation.equals("insert") && succeed) {
            Log.getLogWriter().info("inserting into networth table");
            TradeNetworthDMLDistTxStmt networth = new TradeNetworthDMLDistTxStmt();
            succeed = testUniqueKeys ? networth.insertGfxd(gConn, withDerby, AbstractDMLStmt.getCid(gConn)) : networth.insertGfxd(gConn, withDerby, AbstractDMLStmt.getCid());
        }
        if (!succeed) {
            Log.getLogWriter().info("this tx failed");
        }
    }

    public static void HydraTask_createMonitorTriggers() {
        sqlNewTxTest.createMonitorTriggers();
    }

    protected void createMonitorTriggers() {
        Connection gConn = this.getGFEConnection();
        TxTriggers.createMonitorTriggers(gConn);
    }

    public static void HydraTask_createTriggerProcedures() {
        sqlNewTxTest.createTriggerProcedures();
    }

    protected void createTriggerProcedures() {
        Connection gConn = this.getGFEConnection();
        TxTriggerProcedure.createTriggerProcedures(gConn);
    }

    public static void HydraTask_setTableFor42084() throws SQLException {
        sqlNewTxTest.setTableFor42084();
    }

    protected void setTableFor42084() throws SQLException {
        Connection gConn = this.getGFEConnection();
        String sql = "create table simpleTable (id int not null, color varchar(10) not null, condition int not null, constraint st_pk primary key (id))";
        if (SQLTest.isOffheap) {
            sql = sql + " OFFHEAP";
        }
        gConn.createStatement().execute(sql);
        Log.getLogWriter().info("done " + sql);
        String insert = "insert into simpleTable values (?, ?, ?)";
        PreparedStatement ps = gConn.prepareStatement(insert);
        for (int i = 1; i < 101; ++i) {
            ps.setInt(1, i);
            ps.setInt(3, i);
            if (i < 31) {
                ps.setString(2, "green");
            } else if (i < 71) {
                ps.setString(2, "red");
            } else {
                ps.setString(2, "yellow");
            }
            ps.execute();
        }
        Log.getLogWriter().info("inserted initial data ");
    }

    public static void HydraTask_doDML42084() {
        sqlNewTxTest.doDML42084();
    }

    protected void doDML42084() {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        this.doDML42084(gConn);
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done dmlOp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDML42084(Connection gConn) {
        boolean firstInThisRound = false;
        boolean secondInThisRound = false;
        boolean verifyGreen = true;
        boolean verifyYellow = true;
        int num = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.firstInRound);
        if (num == 1) {
            this.latch = new CountDownLatch(numOfWorkers - 2);
        }
        this.waitForBarrier();
        if (num == 1) {
            firstInThisRound = true;
            Log.getLogWriter().info("I am the first in this round");
            String sql = "update simpleTable set color = 'green' where condition <=30";
            Log.getLogWriter().info(sql);
            MemHeapScanController.setWaitForLatchForTEST((int)10);
            MemHeapScanController.setWaitObjectAfterFirstQualifyForTEST((CountDownLatch)this.latch);
            try {
                int count = gConn.createStatement().executeUpdate(sql);
                if (count == 0) {
                    verifyGreen = false;
                }
            }
            catch (SQLException se) {
                SQLDistTxTest.dumpResults();
                SQLHelper.handleSQLException(se);
            }
        } else if (num == 2) {
            secondInThisRound = true;
            Log.getLogWriter().info("I am the second in this round");
            String sql = "update simpleTable set color = 'yellow' where condition >70";
            Log.getLogWriter().info(sql);
            MemHeapScanController.setWaitForLatchForTEST((int)10);
            MemHeapScanController.setWaitObjectAfterFirstQualifyForTEST((CountDownLatch)this.latch);
            try {
                int count = gConn.createStatement().executeUpdate(sql);
                if (count == 0) {
                    verifyYellow = false;
                }
            }
            catch (SQLException se) {
                SQLDistTxTest.dumpResults();
                SQLHelper.handleSQLException(se);
            }
        } else {
            String sql = random.nextBoolean() ? "update simpleTable set condition = " + (random.nextInt(100) + 1) + " where id = " + (random.nextInt(100) + 1) : "update simpleTable set condition = " + (random.nextInt(100) + 1) + " where condition = " + (random.nextInt(100) + 1);
            Log.getLogWriter().info(sql);
            MemHeapScanController.setWaitForLatchForTEST((int)0);
            try {
                gConn.createStatement().executeUpdate(sql);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("X0Z02")) {
                    Log.getLogWriter().info("got expected conflict exception");
                } else {
                    SQLHelper.handleSQLException(se);
                }
            }
            finally {
                this.commit(gConn);
                this.latch.countDown();
                Log.getLogWriter().info("latch count is: " + this.latch.getCount());
            }
        }
        if (firstInThisRound) {
            SQLBB.getBB().getSharedCounters().zero(SQLBB.firstInRound);
            int curLatchCount = (int)this.latch.getCount();
            Log.getLogWriter().info("latch count is: " + curLatchCount);
            if (curLatchCount != 0) {
                throw new TestException("the update statement finishes and does not waitObjectAfterFirstQualify until the latch count to become zero");
            }
            this.commit(gConn);
            if (verifyGreen) {
                this.verifyGreen();
            }
        } else if (secondInThisRound) {
            Log.getLogWriter().info("latch count is: " + this.latch.getCount());
            this.commit(gConn);
            if (verifyYellow) {
                this.verifyYellow();
            }
        }
        this.waitForBarrier();
    }

    protected void verifyGreen() {
        String sql = "select distinct color from simpleTable where condition <31";
        Connection gConn = this.getGFEConnection();
        try {
            Log.getLogWriter().info(sql);
            ResultSet rs = gConn.createStatement().executeQuery(sql);
            Log.getLogWriter().info("finished select query");
            if (rs.next() && !rs.getString(1).equalsIgnoreCase("green")) {
                SQLDistTxTest.dumpResults();
                throw new TestException("found color is not green for condition < 31");
            }
            if (rs.next()) {
                ResultSetHelper.sendBucketDumpMessage();
                ResultSetHelper.sendResultMessage();
                throw new TestException("found more than one color for condition < 31 while this update awaits other possible conflict update to complete");
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void verifyYellow() {
        String sql = "select distinct color from simpleTable where condition >70";
        Connection gConn = this.getGFEConnection();
        try {
            Log.getLogWriter().info(sql);
            ResultSet rs = gConn.createStatement().executeQuery(sql);
            Log.getLogWriter().info("finished select query");
            if (rs.next() && !rs.getString(1).equalsIgnoreCase("yellow")) {
                ResultSetHelper.sendBucketDumpMessage();
                ResultSetHelper.sendResultMessage();
                throw new TestException("found color is not yellow for condition > 70");
            }
            if (rs.next()) {
                SQLDistTxTest.dumpResults();
                throw new TestException("found more than one color for condition > 70 while this update awaits other possible conflict update to complete");
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void dumpResults() {
        SQLTest.dumpResults();
    }

    protected void cycleStoreVmsAsync(String target) {
        int numToKill = TestConfig.tab().intAt(StopStartPrms.numVMsToStop, 1);
        int numOfPRs = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs);
        if (SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.stopStartVms) == 1L) {
            int sleepMS = 1000;
            Log.getLogWriter().info("allow  " + sleepMS / 1000 + " seconds before killing others");
            MasterController.sleepForMs((int)sleepMS);
            Object[] tmpArr = StopStartVMs.getOtherVMs((int)numToKill, (String)target);
            List vmList = (List)tmpArr[0];
            List stopModeList = (List)tmpArr[1];
            for (ClientVmInfo client : vmList) {
                PRObserver.initialize((int)client.getVmid());
            }
            List threadList = StopStartVMs.stopStartAsync((List)vmList, (List)stopModeList);
            this.finishRestartVMs(vmList, threadList, numOfPRs);
        }
    }

    protected void finishRestartVMs(final List<ClientVmInfo> vmList, final List<HydraSubthread> threadList, final int numOfPRs) {
        Thread handleRestart = new Thread(new Runnable(){

            @Override
            public void run() {
                SQLDistTxTest.this.joinThreads(vmList, threadList, numOfPRs);
            }
        });
        handleRestart.start();
    }

    protected void joinThreads(List<ClientVmInfo> vmList, List<HydraSubthread> threadList, int numOfPRs) {
        StopStartVMs.joinStopStart(vmList, threadList);
        Log.getLogWriter().info("Total number of PR is " + numOfPRs);
        PRObserver.waitForRebalRecov(vmList, (int)1, (int)numOfPRs, null, null, (boolean)false);
        SQLBB.getBB().getSharedMap().put((Object)"vmCycled", (Object)"true");
        SQLBB.getBB().getSharedCounters().zero(SQLBB.stopStartVms);
    }

    protected void doIndexOp() {
        Log.getLogWriter().info("do index op");
        Thread doIndexOp = new Thread(new Runnable(){

            @Override
            public void run() {
                SQLDistTxTest.this.createIndex();
            }
        });
        doIndexOp.start();
    }

    public static void HydraTask_setInitialData() {
        sqlNewTxTest.setInitialData();
    }

    protected void setInitialData() {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        this.setInitialData(gConn);
        int maxCid = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary);
        Log.getLogWriter().info("maxCid in the test is " + maxCid);
        concUpdateTxMaxCid = (int)SQLTxBB.getBB().getSharedCounters().add(SQLTxBB.concUpdateTxMaxCid, (long)maxCid);
        this.closeGFEConnection(gConn);
    }

    protected void setInitialData(Connection conn) {
        try {
            String[] setInitData;
            Statement s = conn.createStatement();
            for (String sql : setInitData = new String[]{"update trade.portfolio set qty = 0, availQty = 0", "update trade.sellorders set ask = 0"}) {
                Log.getLogWriter().info(sql);
                s.executeUpdate(sql);
            }
            this.commit(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_concUpdateTx() {
        sqlNewTxTest.concUpdateTx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void concUpdateTx() {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        int num = 2;
        int count = 0;
        Object object = lock;
        synchronized (object) {
            ++concUpdateCount;
            count = concUpdateCount--;
        }
        if (count < num) {
            gConn = this.concUpdateTx(gConn);
            object = lock;
            synchronized (object) {
            }
        }
        object = lock;
        synchronized (object) {
            --concUpdateCount;
        }
        this.doDMLGfxdOnlyOps(gConn);
        this.closeGFEConnection(gConn);
    }

    protected Connection concUpdateTx(Connection conn) {
        int whichUpdate = random.nextInt(this.concUpdateStatements.length);
        PreparedStatement stmt = this.getConcUpdateStmt(conn, whichUpdate);
        while (stmt == null && isHATest) {
            this.closeConnectionIgnoreFailure(conn);
            conn = this.getNewGfxdConnection();
            stmt = this.getConcUpdateStmt(conn, whichUpdate);
            int msToSleep = 3000;
            MasterController.sleepForMs((int)msToSleep);
        }
        if (concUpdateTxMaxCid == 0) {
            concUpdateTxMaxCid = (int)SQLTxBB.getBB().getSharedCounters().read(SQLTxBB.concUpdateTxMaxCid);
        }
        int maxCid = concUpdateTxMaxCid;
        int tid = this.getMyTid() + 1;
        int numOfRows = random.nextInt(10) + 8;
        int numIter = maxCid / numOfRows;
        if (maxCid < numIter) {
            throw new TestException("test issue -- not enough cid being inserted");
        }
        int interval = maxCid / numIter;
        for (int i = 0; i <= numIter; ++i) {
            boolean success = false;
            int lowCid = i * interval;
            int highCid = i == numIter ? maxCid : (i + 1) * interval;
            boolean[] needNewConn = new boolean[1];
            do {
                if (!(success = this.updateGfxdTx(stmt, tid, lowCid, highCid, whichUpdate, needNewConn))) {
                    if (!needNewConn[0]) continue;
                    this.closeConnectionIgnoreFailure(conn);
                    conn = this.getNewGfxdConnection();
                    stmt = this.getConcUpdateStmt(conn, whichUpdate);
                    continue;
                }
                success = this.commitGfxdOnly(conn);
                if (success) continue;
                this.closeConnectionIgnoreFailure(conn);
                conn = this.getNewGfxdConnection();
                stmt = this.getConcUpdateStmt(conn, whichUpdate);
            } while (!success);
        }
        if (whichUpdate == 0) {
            SQLTxBB.getBB().getSharedCounters().add(SQLTxBB.concUpdateTxPortfolioQty, (long)tid);
        }
        return conn;
    }

    protected PreparedStatement getConcUpdateStmt(Connection conn, int whichUpdate) {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(this.concUpdateStatements[whichUpdate]);
            Log.getLogWriter().info(this.concUpdateStatements[whichUpdate]);
        }
        catch (SQLException se) {
            if (SQLHelper.gotTXNodeFailureException(se) && isHATest) {
                Log.getLogWriter().info("Got node failure exception during preparing statement, continue tests");
            }
            SQLHelper.handleSQLException(se);
        }
        return stmt;
    }

    protected Connection getNewGfxdConnection() {
        if (isEdge) {
            return new SQLDistTxClientTest().getGFXDClientTxConnection();
        }
        return this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
    }

    protected boolean updateGfxdTx(PreparedStatement stmt, int tid, int lowCid, int highCid, int whichUpdate, boolean[] needNewConn) {
        boolean success = false;
        if (stmt == null) {
            if (isHATest) {
                needNewConn[0] = true;
                return false;
            }
            throw new TestException("In non HA test, PreparedStatement is " + stmt);
        }
        while (!success) {
            try {
                switch (whichUpdate) {
                    case 0: {
                        stmt.setInt(1, tid);
                        Log.getLogWriter().info("added qty is " + tid + " lowCid is " + lowCid + " highCid is " + highCid + " ");
                        break;
                    }
                    case 1: {
                        stmt.setBigDecimal(1, new BigDecimal(Double.toString((double)tid / 10.0)));
                        Log.getLogWriter().info("added ask is " + (double)tid / 10.0 + " lowCid is " + lowCid + " highCid is " + highCid + " ");
                        break;
                    }
                    default: {
                        throw new TestException("test issue -- incorrect update statment is chosen");
                    }
                }
                stmt.setInt(2, lowCid);
                stmt.setInt(3, highCid);
                stmt.executeUpdate();
                success = true;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("X0Z02")) {
                    Log.getLogWriter().info("Got expected conflict exception, will retry the tx");
                    int msToSleep = 3000;
                    MasterController.sleepForMs((int)(random.nextInt(msToSleep) + this.getMyTid() * 100));
                    needNewConn[0] = false;
                    return false;
                }
                if (AbstractDMLStmt.gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                    Log.getLogWriter().info("got node failure exception during Tx with HA support, will retry the tx");
                    int msToSleep = 3000;
                    MasterController.sleepForMs((int)random.nextInt(msToSleep));
                    needNewConn[0] = true;
                    return false;
                }
                SQLHelper.handleSQLException(se);
            }
        }
        return true;
    }

    public static void HydraTask_verifyConcUpdateTx() {
        sqlNewTxTest.verifyConcUpdateTx();
    }

    protected void verifyConcUpdateTx() {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        if (isTicket43909fixed) {
            this.verifyConcUpdateTx(gConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void verifyConcUpdateTx(Connection conn) {
        try {
            Statement s = conn.createStatement();
            String selectPortfolio = "select cid, sid, qty from trade.portfolio where cid <= " + concUpdateTxMaxCid + " order by cid";
            String selectSellorders = "select oid, cid, ask from trade.sellorders where cid <= " + concUpdateTxMaxCid;
            ResultSet rs = s.executeQuery(selectPortfolio);
            int qty = (int)SQLTxBB.getBB().getSharedCounters().read(SQLTxBB.concUpdateTxPortfolioQty);
            Log.getLogWriter().info("updated qty should be " + qty);
            List<Struct> list = ResultSetHelper.asList(rs, false);
            if (list != null && list.size() > 0) {
                for (Struct col : list) {
                    if ((Integer)col.get("QTY") == qty) continue;
                    throw new TestException(selectPortfolio + " should return same value " + qty + " for qty, but it does not for" + " cid: " + col.get("CID") + " sid: " + col.get("SID") + "\n" + ResultSetHelper.listToString(list));
                }
                rs.close();
            }
            Log.getLogWriter().info("verified qty in trade.portfolio table is correct.");
            rs = s.executeQuery(selectSellorders);
            list = null;
            BigDecimal ask = new BigDecimal(0);
            list = ResultSetHelper.asList(rs, false);
            if (list != null && list.size() > 0) {
                ask = (BigDecimal)list.get(0).get("ASK");
                for (Struct col : list) {
                    if (ask.compareTo((BigDecimal)col.get("ASK")) == 0) continue;
                    throw new TestException(selectSellorders + " should return same value for ask, but it does not for oid: " + col.get("OID") + "\n" + ResultSetHelper.listToString(list));
                }
                rs.close();
            }
            Log.getLogWriter().info("verified qty in trade.sellorder table is correct.");
            this.commit(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_useUpdatableResultSetForInit() {
        sqlNewTxTest.useUpdatableResultSet(true);
    }

    public static void HydraTask_useUpdatableResultSet() {
        sqlNewTxTest.useUpdatableResultSet(false);
    }

    protected void useUpdatableResultSet(boolean isInitTask) {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        if (isTicket43935Fixed) {
            this.useUpdatableResultSet(gConn, isInitTask);
        }
        this.closeGFEConnection(gConn);
    }

    protected void useUpdatableResultSet(Connection conn, boolean isInitTask) {
        if (isHATest) {
            throw new TestException("need to handle tx node failure condition in the test, as #43935 is fixed");
        }
        int cid1 = concUpdateTxMaxCid == 0 ? random.nextInt(100) : random.nextInt(concUpdateTxMaxCid);
        int cid2 = cid1 + 10;
        try {
            String[] updatableRs;
            Statement s = conn.createStatement(1003, 1008);
            for (String sql : updatableRs = new String[]{"select * from trade.customers where cid > " + cid1 + " and cid < " + cid2}) {
                ResultSet rs = s.executeQuery(sql);
                int prevCid = 0;
                boolean checkPrevRowLockNotHeld = false;
                while (rs.next()) {
                    int cid = rs.getInt("CID");
                    Log.getLogWriter().info("this row's cid is " + cid);
                    if (random.nextBoolean()) {
                        rs.updateString("CUST_NAME", "updated_custname");
                        rs.updateRow();
                        this.checkLockHeldForThisRow(cid);
                        checkPrevRowLockNotHeld = false;
                    } else {
                        checkPrevRowLockNotHeld = true;
                    }
                    if (isInitTask & checkPrevRowLockNotHeld) {
                        this.checkLockNotHeldForPreviousRow(prevCid);
                    }
                    rs.getString("ADDR");
                    prevCid = cid;
                }
                rs.close();
            }
            this.commit(conn);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z02")) {
                if (isInitTask) {
                    throw new TestException("only one ddl thread in this init task, we should not see the conflict exception" + TestHelper.getStackTrace((Throwable)se));
                }
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected void checkLockHeldForThisRow(int cid) {
        Connection conn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        try {
            Statement s = conn.createStatement();
            s.executeUpdate("update trade.customers set cust_name = 'custname' where cid = " + cid);
            throw new TestException("Updatable result set cursor does not obtain the lock on the current row");
        }
        catch (SQLException se) {
            if (!se.getSQLState().equals("X0Z02")) {
                SQLHelper.handleSQLException(se);
            }
            try {
                conn.commit();
            }
            catch (SQLException se2) {
                if (se2.getSQLState().equals("X0Z02")) {
                    throw new TestException("commit got conflict exception");
                }
                SQLHelper.handleSQLException(se2);
            }
            this.closeGFEConnection(conn);
            return;
        }
    }

    protected void checkLockNotHeldForPreviousRow(int cid) {
        Connection conn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        try {
            Statement s = conn.createStatement();
            String name = "custname" + random.nextInt(1000);
            s.executeUpdate("update trade.customers set cust_name = '" + name + "' where cid = " + cid);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z02")) {
                throw new TestException("Updatable result set cursor does not release the lock on the previous row");
            }
            SQLHelper.handleSQLException(se);
        }
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_useScrollableUpdatableResultSet() {
        sqlNewTxTest.useScrollableUpdatableResultSet();
    }

    protected void useScrollableUpdatableResultSet() {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        if (isTicket43932Fixed && isTicket45071fixed) {
            this.useScrollableUpdatableResultSet(gConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void useScrollableUpdatableResultSet(Connection conn) {
        int tid;
        if (isHATest) {
            throw new TestException("need to handle tx node failure condition in the test, as #43932 and #45071 are fixed");
        }
        if (concUpdateTxMaxCid == 0) {
            concUpdateTxMaxCid = (int)SQLTxBB.getBB().getSharedCounters().read(SQLTxBB.concUpdateTxMaxCid);
        }
        if ((tid = this.getMyTid() + 1) % 3 != 0 && random.nextInt(10) != 1) {
            Log.getLogWriter().info("will not exectue this method to reduce the concurrent updates in the table");
            return;
        }
        int maxCid = concUpdateTxMaxCid;
        int interval = 10;
        int numIter = maxCid / interval;
        boolean success = false;
        for (int i = 0; i <= numIter; ++i) {
            int lowCid = i * interval;
            int highCid = i == numIter ? maxCid : (i + 1) * interval;
            success = this.updateScrollableRsTx(conn, tid, lowCid, highCid);
            while (!success) {
                success = this.updateScrollableRsTx(conn, tid, lowCid, highCid);
            }
            this.commit(conn);
        }
    }

    protected boolean updateScrollableRsTx(Connection conn, int tid, int lowCid, int highCid) {
        try {
            Statement s = conn.createStatement(1004, 1008);
            String sql = "select * from trade.networth where cid > " + lowCid + " and cid <= " + highCid;
            if (!isTicket43935Fixed) {
                sql = sql + " for update of securities";
            }
            Log.getLogWriter().info(sql);
            ResultSet updatableRs = s.executeQuery(sql);
            int totalRows = 0;
            while (updatableRs.next()) {
                ++totalRows;
            }
            Log.getLogWriter().info("total rows are " + totalRows);
            boolean success = this.updateScrollableRsTx(updatableRs, tid, totalRows);
            updatableRs.close();
            return success;
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
            return true;
        }
    }

    protected boolean updateScrollableRsTx(ResultSet rs, int tid, int totalRows) {
        try {
            if (totalRows == 0) {
                return true;
            }
            if (totalRows == 1) {
                rs.first();
                return this.updateURSRowTx(rs, tid);
            }
            int firstHalf = totalRows / 2;
            rs.absolute(-(totalRows - firstHalf));
            boolean success = this.updateURSRowTx(rs, tid);
            if (!success) {
                return success;
            }
            while (rs.next()) {
                success = this.updateURSRowTx(rs, tid);
                if (success) continue;
                return success;
            }
            rs.absolute(firstHalf);
            success = this.updateURSRowTx(rs, tid);
            if (!success) {
                return success;
            }
            while (rs.previous()) {
                success = this.updateURSRowTx(rs, tid);
                if (success) continue;
                return success;
            }
            rs.last();
            if (random.nextInt(100) == 0) {
                if (rs.relative(-1)) {
                    success = this.deleteURSRowTx(rs);
                }
                if (!success) {
                    return success;
                }
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    protected boolean updateURSRowTx(ResultSet updatableRs, int tid) {
        try {
            int cid = updatableRs.getInt("CID");
            BigDecimal sec = updatableRs.getBigDecimal("SECURITIES").add(new BigDecimal(tid));
            updatableRs.updateBigDecimal("SECURITIES", sec);
            updatableRs.updateRow();
            Log.getLogWriter().info("update trade.networth set securities to be " + sec + " for cid: " + cid);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z02")) {
                SQLHelper.printSQLException(se);
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    protected boolean deleteURSRowTx(ResultSet updatableRs) {
        try {
            int cid = updatableRs.getInt("CID");
            updatableRs.deleteRow();
            Log.getLogWriter().info("delete from trade.networth for cid: " + cid);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z02")) {
                SQLHelper.printSQLException(se);
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    public static void HydraTask_useNonScrollableUpdatableResultSet() {
        sqlNewTxTest.useNonScrollableUpdatableResultSet();
    }

    protected void useNonScrollableUpdatableResultSet() {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        if (isTicket43935Fixed) {
            this.useNonScrollableUpdatableResultSet(gConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void useNonScrollableUpdatableResultSet(Connection conn) {
        if (isHATest) {
            throw new TestException("need to handle tx node failure condition in the test, as #43935 is fixed");
        }
        if (concUpdateTxMaxCid == 0) {
            concUpdateTxMaxCid = (int)SQLTxBB.getBB().getSharedCounters().read(SQLTxBB.concUpdateTxMaxCid);
        }
        int tid = this.getMyTid() + 1;
        int maxCid = concUpdateTxMaxCid;
        int interval = 10;
        int numIter = maxCid / interval;
        for (int i = 0; i <= numIter; ++i) {
            int lowCid = i * interval;
            int highCid = i == numIter ? maxCid : (i + 1) * interval;
            boolean success = this.updateNonScrollableRsTx(conn, tid, lowCid, highCid);
            while (!success) {
                success = this.updateNonScrollableRsTx(conn, tid, lowCid, highCid);
            }
            this.commit(conn);
        }
    }

    protected boolean updateNonScrollableRsTx(Connection conn, int tid, int lowCid, int highCid) {
        try {
            Statement s = conn.createStatement(1003, 1008);
            String sql = "select * from trade.networth where cid > " + lowCid + " and cid <= " + highCid;
            ResultSet updatableRs = s.executeQuery(sql);
            boolean success = this.updateNonScrollableRsTx(updatableRs, tid);
            updatableRs.close();
            return success;
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
            return true;
        }
    }

    protected boolean updateNonScrollableRsTx(ResultSet rs, int tid) {
        try {
            while (rs.next()) {
                boolean success = this.updateURSRowTx(rs, tid);
                if (success) continue;
                return success;
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    public static void HydraTask_verifyUpdatbleRsTx() {
        sqlNewTxTest.verifyUpdatbleRsTx();
    }

    protected void verifyUpdatbleRsTx() {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        this.verifyUpdatbleRsTx(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void verifyUpdatbleRsTx(Connection conn) {
        try {
            Statement s = conn.createStatement();
            String selectNetworth = "select cid, securities from trade.networth where cid <= " + concUpdateTxMaxCid + " order by cid";
            ResultSet rs = s.executeQuery(selectNetworth);
            List<Struct> list = ResultSetHelper.asList(rs, false);
            if (list != null) {
                BigDecimal sec = (BigDecimal)list.get(0).get("SECURITIES");
                for (Struct col : list) {
                    if (((BigDecimal)col.get("SECURITIES")).equals(sec)) continue;
                    throw new TestException(selectNetworth + " should return same value " + sec + " for securities, but it does not for" + " cid: " + col.get("CID") + "\n" + ResultSetHelper.listToString(list));
                }
                rs.close();
                Log.getLogWriter().info("verified that networth table has the same value for securities column of " + sec);
            }
            this.commit(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_useSelectForUpdateTx() {
        sqlNewTxTest.useSelectForUpdateTx();
    }

    protected void useSelectForUpdateTx() {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        this.useSelectForUpdateTx(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void useSelectForUpdateTx(Connection conn) {
        if (concUpdateTxMaxCid == 0) {
            concUpdateTxMaxCid = (int)SQLTxBB.getBB().getSharedCounters().read(SQLTxBB.concUpdateTxMaxCid);
        }
        int tid = this.getMyTid() + 1;
        int maxCid = concUpdateTxMaxCid;
        int interval = 10;
        int numIter = maxCid / interval;
        boolean success = false;
        for (int i = 0; i <= numIter; ++i) {
            int lowCid = i * interval;
            int highCid = i == numIter ? maxCid : (i + 1) * interval;
            success = this.updateSelectForUpdateTx(conn, tid, lowCid, highCid);
            while (!success) {
                MasterController.sleepForMs((int)(tid * 113));
                success = this.updateSelectForUpdateTx(conn, tid, lowCid, highCid);
            }
            this.commit(conn);
        }
    }

    protected boolean updateSelectForUpdateTx(Connection conn, int tid, int lowCid, int highCid) {
        try {
            Statement s = isTicket41738Fixed ? conn.createStatement() : conn.createStatement(1003, 1008);
            s.setCursorName("updateCursor");
            String sql = "select * from trade.networth where cid > " + lowCid + " and cid <= " + highCid + " FOR UPDATE OF securities";
            Log.getLogWriter().info(sql);
            ResultSet updatableRs = s.executeQuery(sql);
            PreparedStatement psCurrentOf = null;
            PreparedStatement psPK = null;
            if (isTicket41738Fixed) {
                psCurrentOf = conn.prepareStatement("update trade.networth set securities = securities + ?  where current of updateCursor");
            }
            psPK = conn.prepareStatement("update trade.networth set securities = securities + ?  where cid = ? ");
            if (isTicket41738Fixed && random.nextBoolean()) {
                boolean success = this.updateSelectForUpdateTx(updatableRs, psCurrentOf, tid);
                updatableRs.close();
                return success;
            }
            if (random.nextBoolean()) {
                boolean success = this.updateSelectForUpdatePKTx(updatableRs, psPK, tid);
                updatableRs.close();
                return success;
            }
            boolean success = this.updateSelectForUpdateRsTx(updatableRs, tid);
            updatableRs.close();
            return success;
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z02")) {
                SQLHelper.printSQLException(se);
                this.log().info("got expected conflict exception, needs to retry the op");
                return false;
            }
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                this.log().info("got node failure exception, needs to retry the op");
                return false;
            }
            SQLHelper.handleSQLException(se);
            return true;
        }
    }

    protected boolean updateSelectForUpdateTx(ResultSet rs, PreparedStatement ps, int tid) {
        if (isHATest) {
            throw new TestException("need to handle tx node failure condition in the test, as #43932 and #41738 are fixed");
        }
        try {
            while (rs.next()) {
                boolean success = this.updateSFURowTx(rs, ps, tid);
                if (success) continue;
                return success;
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    protected boolean updateSelectForUpdatePKTx(ResultSet rs, PreparedStatement ps, int tid) {
        try {
            while (rs.next()) {
                boolean success = this.updateRowSFU_PKTx(rs, ps, tid);
                if (success) continue;
                return success;
            }
        }
        catch (SQLException se) {
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                Log.getLogWriter().info("got node failure exception, needs to retry the op");
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    protected boolean updateSelectForUpdateRsTx(ResultSet rs, int tid) {
        try {
            while (rs.next()) {
                boolean success = this.updateRowSFU_URSTx(rs, tid);
                if (!success) {
                    return success;
                }
                if (random.nextInt(concUpdateTxMaxCid) != 0) continue;
                success = this.deleteRowSFU_URSTx(rs);
            }
        }
        catch (SQLException se) {
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                Log.getLogWriter().info("got node failure exception, needs to retry the op");
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    protected boolean updateRowSFU_URSTx(ResultSet updatableRs, int tid) {
        try {
            int cid = updatableRs.getInt("CID");
            BigDecimal sec = updatableRs.getBigDecimal("SECURITIES").add(new BigDecimal(tid));
            updatableRs.updateBigDecimal("SECURITIES", sec);
            updatableRs.updateRow();
            Log.getLogWriter().info("update trade.networth set securities to be " + sec + " for cid: " + cid);
        }
        catch (SQLException se) {
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                Log.getLogWriter().info("got node failure exception, needs to retry the op");
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    protected boolean deleteRowSFU_URSTx(ResultSet updatableRs) {
        try {
            int cid = updatableRs.getInt("CID");
            updatableRs.deleteRow();
            Log.getLogWriter().info("delete from trade.networth for cid: " + cid);
        }
        catch (SQLException se) {
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                Log.getLogWriter().info("got node failure exception, needs to retry the op");
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    protected boolean updateRowSFU_PKTx(ResultSet updatableRs, PreparedStatement ps, int tid) {
        try {
            int cid = updatableRs.getInt("CID");
            ps.setBigDecimal(1, new BigDecimal(tid));
            ps.setInt(2, cid);
            ps.executeUpdate();
            Log.getLogWriter().info("update trade.networth set securities = securities + " + tid + " for cid: " + cid);
        }
        catch (SQLException se) {
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                this.log().info("got node failure exception, needs to retry the op");
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    protected boolean updateSFURowTx(ResultSet updatableRs, PreparedStatement ps, int tid) {
        try {
            int cid = updatableRs.getInt("CID");
            ps.setBigDecimal(1, new BigDecimal(tid));
            int num = ps.executeUpdate();
            if (num == 1) {
                Log.getLogWriter().info("update trade.networth set securities + " + tid + " for cid: " + cid);
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z02")) {
                SQLHelper.printSQLException(se);
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    public static void HydraTask_checkConstraints() {
        sqlNewTxTest.checkConstraints();
    }

    @Override
    protected void checkConstraints() {
        Connection gConn = this.getGFXDTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        this.checkUniqConstraints(gConn);
        this.checkFKConstraints(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    protected boolean commitBatching(Connection conn, boolean firstCommit) {
        try {
            Log.getLogWriter().info("committing the ops for gfxd");
            conn.commit();
        }
        catch (SQLException se) {
            ArrayList derbyExceptions = (ArrayList)derbyExceptionsWithBatching.get();
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (useNewTables) {
                    return this.verifyNewTablesBatchingConflictAtCommit(se, true);
                }
                return this.verifyBatchingConflictAtCommit(firstCommit, se, true);
            }
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                return false;
            }
            if (derbyExceptions.contains(se.getSQLState())) {
                Log.getLogWriter().info("gfxd commit failed due to batching for " + se);
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        if (useNewTables) {
            return this.verifyNewTablesBatchingConflictAtCommit(null, false);
        }
        return this.verifyBatchingConflictAtCommit(firstCommit, null, false);
    }

    protected boolean commitWithHA(Connection conn) {
        try {
            Log.getLogWriter().info("committing the ops for gfxd");
            conn.commit();
            Log.getLogWriter().info("tx is committed for gfxd");
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (SQLHelper.gotTXNodeFailureException(se)) {
                this.log().info("commit failed in gfxd due to node failure");
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    protected boolean verifyBatchingConflictAtCommit(boolean firstCommit, SQLException se, boolean getsConflict) {
        SharedMap modifiedKeysByAllTx = SQLTxBatchingBB.getBB().getSharedMap();
        HashMap modifiedKeysByThisTx = (HashMap)curTxModifiedKeys.get();
        Integer myTxId = (Integer)curTxId.get();
        boolean expectFKConflict = this.expectBatchingFKConflict(modifiedKeysByAllTx.getMap());
        if (!getsConflict && firstCommit && expectFKConflict) {
            throw new TestException("commit with batching should get conflict exception but not, need to check log for foreing key constraints");
        }
        for (String key : modifiedKeysByThisTx.keySet()) {
            ArrayList txIdsForTheKey = (ArrayList)modifiedKeysByAllTx.get((Object)key);
            boolean contains = txIdsForTheKey.remove(myTxId);
            if (!contains) {
                throw new TestException("test issue, a key is not added in the batchingBB map");
            }
            if (txIdsForTheKey.size() <= 0) continue;
            if (!getsConflict) {
                throw new TestException("commit with batching should get conflict exception but not, for key: " + key + ", there are following other txId hold the" + " lock locally: " + txIdsForTheKey.toString());
            }
            Log.getLogWriter().info("get expected conflict exception during commit");
            return false;
        }
        if (getsConflict) {
            if (expectFKConflict) {
                Log.getLogWriter().info("get expected conflict exception during commit");
                return false;
            }
            throw new TestException("does not expect a conflict during commit, but gets " + TestHelper.getStackTrace((Throwable)se));
        }
        if (!expectFKConflict) {
            return true;
        }
        throw new TestException("should get a conflict during commit, but does not. Need to check logs for more info");
    }

    protected boolean verifyNewTablesBatchingConflictAtCommit(SQLException se, boolean getsConflict) {
        boolean expectConflictAtCommit = false;
        StringBuilder conflictMsg = new StringBuilder();
        expectConflictAtCommit = this.expectConflictAtCommit(conflictMsg);
        if (getsConflict) {
            if (expectConflictAtCommit) {
                Log.getLogWriter().info("Got expected conflict exception during commit when batching is on");
                return false;
            }
            throw new TestException("Got unexpected conflict during commit for batching txn." + TestHelper.getStackTrace((Throwable)se));
        }
        if (expectConflictAtCommit) {
            throw new TestException("Does not get expected conflict exception, but " + conflictMsg.toString());
        }
        return true;
    }

    protected boolean expectConflictAtCommit(StringBuilder conflictMsg) {
        ForeignKeyLocked fkLocked;
        int txId;
        Set keys;
        HashMap modifiedKeysByThisTx = (HashMap)curTxModifiedKeys.get();
        HashMap holdNonDeleteKeysByThisTx = (HashMap)curTxNonDeleteHoldKeys.get();
        HashMap holdDeleteKeysByThisTx = (HashMap)curTxDeleteHoldKeys.get();
        HashMap holdForeignKeysByThisTx = (HashMap)curTxHoldParentKeys.get();
        HashMap holdNewForeignKeysByThisTx = (HashMap)curTxNewHoldParentKeys.get();
        SharedMap modifiedKeysByAllTx = SQLTxBatchingBB.getBB().getSharedMap();
        SharedMap holdBlockingKeysByAllTx = SQLTxBatchingNonDeleteHoldKeysBB.getBB().getSharedMap();
        SharedMap holdDeleteBlockingKeysByAllTx = SQLTxBatchingDeleteHoldKeysBB.getBB().getSharedMap();
        SharedMap holdForeignKeysByAllTx = SQLTxHoldForeignKeysBB.getBB().getSharedMap();
        SharedMap holdNewForeignKeysByAllTx = SQLTxHoldNewForeignKeysBB.getBB().getSharedMap();
        if (modifiedKeysByThisTx != null) {
            for (String key : modifiedKeysByThisTx.keySet()) {
                ArrayList list = (ArrayList)modifiedKeysByAllTx.get((Object)key);
                if (list.size() <= 1) continue;
                conflictMsg.append("This txId: " + curTxId.get() + " should get conflict " + "exception as the following txIds: " + list + " hold the local " + "lock for the key: " + key);
                return true;
            }
        }
        if (holdNonDeleteKeysByThisTx != null) {
            keys = holdNonDeleteKeysByThisTx.keySet();
            for (String key : keys) {
                txId = (Integer)holdNonDeleteKeysByThisTx.get(key);
                fkLocked = (ForeignKeyLocked)holdNewForeignKeysByAllTx.get((Object)key);
                if (fkLocked == null || !fkLocked.detectOtherTxIdConflict(txId, conflictMsg)) continue;
                return true;
            }
        }
        if (holdDeleteKeysByThisTx != null) {
            keys = holdDeleteKeysByThisTx.keySet();
            for (String key : keys) {
                txId = (Integer)holdDeleteKeysByThisTx.get(key);
                fkLocked = (ForeignKeyLocked)holdForeignKeysByAllTx.get((Object)key);
                if (fkLocked != null && fkLocked.detectOtherTxIdConflict(txId, conflictMsg)) {
                    return true;
                }
                fkLocked = (ForeignKeyLocked)holdNewForeignKeysByAllTx.get((Object)key);
                if (fkLocked == null || !fkLocked.detectOtherTxIdConflict(txId, conflictMsg)) continue;
                return true;
            }
        }
        if (holdForeignKeysByThisTx != null && this.checkForeignKeysWithBatching(holdForeignKeysByThisTx, holdDeleteBlockingKeysByAllTx, conflictMsg)) {
            return true;
        }
        if (holdNewForeignKeysByThisTx != null) {
            if (this.checkForeignKeysWithBatching(holdNewForeignKeysByThisTx, holdBlockingKeysByAllTx, conflictMsg)) {
                return true;
            }
            if (this.checkForeignKeysWithBatching(holdNewForeignKeysByThisTx, holdDeleteBlockingKeysByAllTx, conflictMsg)) {
                return true;
            }
        }
        return false;
    }

    protected boolean checkForeignKeysWithBatching(HashMap<String, ForeignKeyLocked> holdForeignKeysByThisTx, SharedMap holdBlockingKeysByAllTx, StringBuilder str) {
        if (holdForeignKeysByThisTx == null) {
            return false;
        }
        Set<String> keys = holdForeignKeysByThisTx.keySet();
        for (String key : keys) {
            ArrayList blockingTxIds;
            ForeignKeyLocked fks = holdForeignKeysByThisTx.get(key);
            Set<Integer> txIds = fks.getKeysHeldByTxIds().keySet();
            if (txIds.size() > 1) {
                throw new TestException("Test issue, current txn should only hold one txId. But it has follwing txIds " + txIds.toArray());
            }
            int myTxId = txIds.iterator().next();
            int holdTimes = fks.getKeysHeldByTxIds().get(myTxId);
            if (holdTimes <= 0 || (blockingTxIds = (ArrayList)holdBlockingKeysByAllTx.get((Object)key)) == null) continue;
            Iterator i$ = blockingTxIds.iterator();
            while (i$.hasNext()) {
                int txId = (Integer)i$.next();
                if (txId == myTxId) continue;
                String msg = "Another txId: " + txId + " holds " + "the foreign key: " + key + " needs for op in this txn: " + myTxId;
                str.append(msg);
                Log.getLogWriter().info(msg);
                return true;
            }
        }
        Log.getLogWriter().info("This op does not hold foreign keys causing conflict for existing parent table ops");
        return false;
    }

    protected boolean expectBatchingFKConflict(Map modifiedKeysByAllTx) {
        Integer myTxId = (Integer)curTxId.get();
        HashSet holdFKsByThisTx = (HashSet)foreignKeyHeldWithBatching.get();
        for (String key : holdFKsByThisTx) {
            ArrayList txIdsForTheKey = (ArrayList)modifiedKeysByAllTx.get(key);
            if (txIdsForTheKey == null || txIdsForTheKey.size() <= 1 && (txIdsForTheKey.size() != 1 || txIdsForTheKey.contains(myTxId))) continue;
            Iterator i$ = txIdsForTheKey.iterator();
            while (i$.hasNext()) {
                int txId = (Integer)i$.next();
                HashSet holdParentKeys = (HashSet)SQLBB.getBB().getSharedMap().get((Object)(AbstractDMLStmt.parentKeyHeldTxid + txId));
                if (holdParentKeys == null) continue;
                for (String holdParentKey : holdParentKeys) {
                    if (!holdParentKey.equals(key)) continue;
                    Log.getLogWriter().info("should get conflict for foreign key " + key + " with following txIds: " + txIdsForTheKey);
                    return true;
                }
            }
        }
        SharedMap holdingFKTxIds = SQLTxBatchingFKBB.getBB().getSharedMap();
        HashSet holdParentKeyByThisTx = (HashSet)parentKeyHeldWithBatching.get();
        for (String key : holdParentKeyByThisTx) {
            HashSet txIds = (HashSet)holdingFKTxIds.get((Object)key);
            if (txIds == null || txIds.size() <= 1 && (txIds.size() != 1 || txIds.contains(myTxId))) continue;
            Log.getLogWriter().info("should get conflict for foreign key " + key + " with txIds: " + txIds);
            return true;
        }
        return false;
    }

    protected void closeConnectionIgnoreFailure(Connection conn) {
        try {
            conn.rollback();
            conn.close();
        }
        catch (SQLException sqle) {
            Log.getLogWriter().info("Ignoring exception in connection close " + sqle.getSQLState());
        }
    }

    public static void HydraTask_clearTables() {
        sqlNewTxTest.clearTablesInOrder();
    }

    @Override
    protected void clearTablesInOrder() {
        if (!hasDerbyServer) {
            return;
        }
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFEConnection();
        this.clearTablesInOrder(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_alterCustomersTableGenerateAlways() {
        sqlNewTxTest.alterCustomersTableGenerateAlways();
    }

    protected void alterCustomersTableGenerateAlways() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        try {
            if (addGenIdColInCustomersv1) {
                this.alterCustomersAddGenId(dConn, gConn);
                this.updateGenIdCol(dConn, gConn);
            }
            this.alterCustomersTableGenerateAlways(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.closeGFEConnection(gConn);
    }

    protected void alterCustomersAddGenId(Connection dConn, Connection gConn) throws SQLException {
        String sqlDerby = "alter table trade.customersv1 add column genId bigint with default 1 not null";
        String sql = "alter table trade.customersv1 add column genId bigint GENERATED BY DEFAULT AS IDENTITY";
        if (dConn != null) {
            Log.getLogWriter().info("executing in derby: " + sqlDerby);
            this.executeStatement(dConn, sqlDerby);
            Log.getLogWriter().info("executed in derby: " + sqlDerby);
            this.commit(dConn);
        }
        Log.getLogWriter().info("executing in gfxd: " + sql);
        this.executeStatement(gConn, sql);
        Log.getLogWriter().info("executed in gfxd: " + sql);
        this.commit(gConn);
    }

    protected void updateGenIdCol(Connection dConn, Connection gConn) throws SQLException {
        String setSchema;
        String sql = "update customersv1 set genId = cid";
        String string = setSchema = random.nextBoolean() ? "set schema trade" : "set current schema = trade";
        if (dConn != null) {
            Log.getLogWriter().info("executing in derby: " + setSchema);
            this.executeStatement(dConn, setSchema);
            Log.getLogWriter().info("executed in derby: " + setSchema);
            Log.getLogWriter().info("executing in derby: " + sql);
            this.executeStatement(dConn, sql);
            Log.getLogWriter().info("executed in derby: " + sql);
            this.commit(dConn);
        }
        Log.getLogWriter().info("executing in gfxd: " + setSchema);
        this.executeStatement(gConn, setSchema);
        Log.getLogWriter().info("executed in gfxd: " + setSchema);
        Log.getLogWriter().info("executing in gfxd: " + sql);
        this.executeStatement(gConn, sql);
        Log.getLogWriter().info("executed in gfxd: " + sql);
        this.commit(gConn);
    }

    protected void alterCustomersTableGenerateAlways(Connection conn) {
        String alterTable = "";
        alterTable = addGenIdColInCustomersv1 ? "alter table trade.customersv1 ALTER COLUMN genId SET GENERATED ALWAYS AS IDENTITY" : "alter table trade.customersv1 ALTER COLUMN cid SET GENERATED ALWAYS AS IDENTITY";
        try {
            Log.getLogWriter().info((SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ") + "executing " + alterTable);
            conn.createStatement().execute(alterTable);
            Log.getLogWriter().info((SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ") + "executed " + alterTable);
            this.commit(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_createNewTables() {
        sqlNewTxTest.createNewTables();
    }

    protected void createNewTables() {
        sqlNewTxTest.addCustomerV1Table();
        sqlNewTxTest.addNetworthV1Table();
        SQLTxBB.getBB().getSharedCounters().increment(SQLTxBB.iterations);
    }

    protected void addCustomerV1Table() {
        boolean reproduce50116 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50116, true);
        try {
            if (reproduce50116) {
                this.createCustomersV1Table();
                this.selectIntoTable("customers", "customersv1");
                this.alterTableAddIterationCol("customersv1");
            } else {
                this.createCustomersV1Table();
                this.selectIntoTable("customers", "customersv1");
                this.alterTableAddIterationCol("customersv1");
            }
            SQLBB.getBB().getSharedMap().put((Object)CUSTOMERSV1TXREADY, (Object)true);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        int numOfPRs = (Integer)SQLBB.getBB().getSharedMap().get((Object)"custNumOfPRs");
        SQLBB.getBB().getSharedCounters().add(SQLBB.numOfPRs, (long)numOfPRs);
        Log.getLogWriter().info("numOfPRs now is " + SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs));
    }

    protected void addNetworthV1Table() {
        boolean reproduce50547 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50547, false);
        boolean reproduce50550 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50550, false);
        try {
            this.createNetworthV1Table();
            this.selectIntoTable("networth", "networthv1");
            this.alterTableAddIterationCol("networthv1");
            if (reproduce50547) {
                this.alterTableAddNetworthFKColConstraint();
                this.updateNetworthFKCol();
            } else {
                this.alterTableAddNetworthFKCol();
                if (reproduce50550) {
                    this.alterTableAddNetworthFKTableConstraint();
                    this.updateNetworthFKCol();
                } else {
                    this.updateNetworthFKCol();
                    this.alterTableAddNetworthFKTableConstraint();
                }
            }
            this.alterNetworthv1DropFKConstraint();
            SQLBB.getBB().getSharedMap().put((Object)CUSTOMERSV1TXREADY, (Object)true);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        int numOfPRs = (Integer)SQLBB.getBB().getSharedMap().get((Object)"networthNumOfPRs");
        SQLBB.getBB().getSharedCounters().add(SQLBB.numOfPRs, (long)numOfPRs);
        Log.getLogWriter().info("numOfPRs now is " + SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs));
    }

    protected void createCustomersV1Table() throws SQLException {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.createCustomersV1Table(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void createCustomersV1Table(Connection dConn, Connection gConn) throws SQLException {
        if (!tableColsSet) {
            SQLDistTxTest.setTableCols(gConn);
        }
        boolean reproduce50118 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50118, false);
        String str = null;
        for (String ddl : cachedGfeDDLs) {
            if (!ddl.toLowerCase().contains("create table trade.customers ")) continue;
            str = ddl;
        }
        if (str == null) {
            throw new TestException("gfeDDL does not contain customers table");
        }
        if (!reproduce50118) {
            str = str.replace("trade.customers", "trade.customersv1");
            if (!addGenIdColInCustomersv1) {
                str = str.replace("cid int", "cid bigint");
            }
        }
        String createCustomersv1 = "create table trade.customersv1 (cid " + (addGenIdColInCustomersv1 ? "int" : "bigint") + " not null, " + "cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))";
        String createCustomersv1UseSelect = reproduce50118 ? "create table trade.customersv1 as select * from trade.customers with no data" : str;
        String createDerbyIndexTid = "create index indexcustomerv1tid on trade.customersv1 (tid)";
        if (dConn != null) {
            Log.getLogWriter().info("executing in derby: " + createCustomersv1);
            this.executeStatement(dConn, createCustomersv1);
            Log.getLogWriter().info("executed in derby: " + createCustomersv1);
            Log.getLogWriter().info("executing in derby: " + createDerbyIndexTid);
            this.executeStatement(dConn, createDerbyIndexTid);
            Log.getLogWriter().info("executed in derby: " + createDerbyIndexTid);
            this.commit(dConn);
        }
        Log.getLogWriter().info("executing in gfxd: " + createCustomersv1UseSelect);
        this.executeStatement(gConn, createCustomersv1UseSelect);
        Log.getLogWriter().info("executed in gfxd: " + createCustomersv1UseSelect);
        if (reproduce50118) {
            String addPrimaryKey = "alter table trade.customersv1 add constraint customer_pk_v1 primary key (cid)";
            Log.getLogWriter().info("executing in gfxd: " + addPrimaryKey);
            this.executeStatement(gConn, addPrimaryKey);
            Log.getLogWriter().info("executed in gfxd: " + addPrimaryKey);
        }
        SQLDistTxTest.setTableCols(gConn, "trade.customersv1");
        this.commit(gConn);
    }

    protected void createNetworthV1Table() throws SQLException {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.createNetworthV1Table(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void createNetworthV1Table(Connection dConn, Connection gConn) throws SQLException {
        if (!tableColsSet) {
            SQLDistTxTest.setTableCols(gConn);
        }
        String str = null;
        String dropAvailloanCheckConstraint = "alter table trade.networthv1 drop CHECK availloan_ck_v1";
        boolean dropAvailloanCheck = random.nextInt(5) != 1;
        for (String ddl : cachedGfeDDLs) {
            if (!ddl.toLowerCase().contains("create table trade.networth ")) continue;
            str = ddl;
        }
        if (str == null) {
            throw new TestException("gfeDDL does not contain customers table");
        }
        str = str.replace("trade.networth ", "trade.networthv1 ");
        str = str.replace("trade.customers", "trade.customersv1");
        str = str.replace("cid int", "cid bigint");
        str = str.replace("_pk ", "_pk_v1 ");
        str = str.replace("_fk ", "_fk_v1 ");
        str = str.replace("_ch ", "_ch_v1 ");
        str = str.replace("_ck ", "_ck_v1 ");
        String createNetworthv1 = "create table trade.networthv1 (cid bigint not null, cash decimal (30, 1), securities decimal (30, 1), loanlimit int, availloan decimal (30, 1),  tid int, constraint netw_pk_v1 primary key (cid), constraint cust_newt_fk_v1 foreign key (cid) references trade.customersv1 (cid) on delete restrict, constraint cash_ch_v1 check (cash>=0), constraint sec_ch_v1 check (securities >=0), constraint availloan_ck_v1 check (loanlimit>=availloan and availloan >=0))";
        String createDerbyIndexTid = "create index indexnetworthv1tid on trade.networthv1 (tid)";
        if (dConn != null) {
            Log.getLogWriter().info("executing in derby: " + createNetworthv1);
            this.executeStatement(dConn, createNetworthv1);
            Log.getLogWriter().info("executed in derby: " + createNetworthv1);
            Log.getLogWriter().info("executing in derby: " + createDerbyIndexTid);
            this.executeStatement(dConn, createDerbyIndexTid);
            Log.getLogWriter().info("executed in derby: " + createDerbyIndexTid);
            this.commit(dConn);
            if (dropAvailloanCheck) {
                Log.getLogWriter().info("executing in derby: " + dropAvailloanCheckConstraint);
                this.executeStatement(dConn, dropAvailloanCheckConstraint);
                Log.getLogWriter().info("executed in derby: " + dropAvailloanCheckConstraint);
                this.commit(dConn);
            }
        }
        Log.getLogWriter().info("executing in gfxd: " + str);
        this.executeStatement(gConn, str);
        Log.getLogWriter().info("executed in gfxd: " + str);
        SQLDistTxTest.setTableCols(gConn, "trade.networthv1");
        this.commit(gConn);
        if (dropAvailloanCheck) {
            Log.getLogWriter().info("executing in gfxd: " + dropAvailloanCheckConstraint);
            this.executeStatement(gConn, dropAvailloanCheckConstraint);
            Log.getLogWriter().info("executed in gfxd: " + dropAvailloanCheckConstraint);
            this.commit(gConn);
        }
    }

    protected void selectIntoTable(String tableName, String newTableName) throws SQLException {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.selectIntoTable(dConn, gConn, tableName, newTableName);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void selectIntoTable(Connection dConn, Connection gConn, String tableName, String newTableName) throws SQLException {
        String setSchema;
        String sql = "insert into " + newTableName + " (select * from " + tableName + ")";
        String string = setSchema = random.nextBoolean() ? "set schema trade" : "set current schema = trade";
        if (dConn != null) {
            Log.getLogWriter().info("executing in derby: " + setSchema);
            this.executeStatement(dConn, setSchema);
            Log.getLogWriter().info("executed in derby: " + setSchema);
            Log.getLogWriter().info("executing in derby: " + sql);
            this.executeStatement(dConn, sql);
            Log.getLogWriter().info("executed in derby: " + sql);
            this.commit(dConn);
        }
        Log.getLogWriter().info("executing in gfxd: " + setSchema);
        this.executeStatement(gConn, setSchema);
        Log.getLogWriter().info("executed in gfxd: " + setSchema);
        Log.getLogWriter().info("executing in gfxd: " + sql);
        this.executeStatement(gConn, sql);
        Log.getLogWriter().info("executed in gfxd: " + sql);
        this.commit(gConn);
    }

    protected void alterTableAddIterationCol(String tableName) throws SQLException {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.alterTableAddIterationCol(dConn, gConn, tableName);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void alterTableAddIterationCol(Connection dConn, Connection gConn, String tableName) throws SQLException {
        String sql = "alter table trade." + tableName + " add column round int " + (random.nextBoolean() ? "" : "with ") + "DEFAULT " + 0;
        this.executeSQLCommand(dConn, gConn, sql);
    }

    protected void alterTableAddNetworthFKColConstraint() throws SQLException {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.alterTableAddNetworthFKColConstraint(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void alterTableAddNetworthFKColConstraint(Connection dConn, Connection gConn) throws SQLException {
        String sql = "alter table trade.networthv1 add column c_cid bigint constraint cust_newt_fk_v1_2 references trade.customersv1 (cid) on delete restrict " + (random.nextBoolean() ? "" : "with ") + "DEFAULT " + 1;
        this.executeSQLCommand(dConn, gConn, sql);
    }

    protected void executeSQLCommand(Connection dConn, Connection gConn, String sql) throws SQLException {
        if (dConn != null) {
            Log.getLogWriter().info("executing in derby: " + sql);
            this.executeStatement(dConn, sql);
            Log.getLogWriter().info("executed in derby: " + sql);
            this.commit(dConn);
        }
        Log.getLogWriter().info("executing in gfxd: " + sql);
        this.executeStatement(gConn, sql);
        Log.getLogWriter().info("executed in gfxd: " + sql);
        this.commit(gConn);
    }

    protected void alterTableAddNetworthFKCol() throws SQLException {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.alterTableAddNetworthFKCol(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void alterTableAddNetworthFKCol(Connection dConn, Connection gConn) throws SQLException {
        String sql = "alter table trade.networthv1 add column c_cid bigint " + (random.nextBoolean() ? "" : "with ") + "DEFAULT " + 1;
        this.executeSQLCommand(dConn, gConn, sql);
    }

    protected void alterTableAddNetworthFKTableConstraint() throws SQLException {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.alterTableAddNetworthFKTableConstraint(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void alterTableAddNetworthFKTableConstraint(Connection dConn, Connection gConn) throws SQLException {
        String sql = "alter table trade.networthv1 add constraint cust_newt_fk_v1_2 FOREIGN KEY (c_cid) references trade.customersv1 (cid) on delete restrict ";
        this.executeSQLCommand(dConn, gConn, sql);
    }

    protected void alterNetworthv1DropFKConstraint() throws SQLException {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.alterNetworthv1DropFKConstraint(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void alterNetworthv1DropFKConstraint(Connection dConn, Connection gConn) throws SQLException {
        String sql = "alter table trade.networthv1 drop " + (random.nextBoolean() ? "FOREIGN KEY" : "constraint") + " cust_newt_fk_v1";
        this.executeSQLCommand(dConn, gConn, sql);
    }

    protected void updateNetworthFKCol() throws SQLException {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.updateNetworthFKCol(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void updateNetworthFKCol(Connection dConn, Connection gConn) throws SQLException {
        String sql = "update trade.networthv1 set c_cid = cid";
        this.executeSQLCommand(dConn, gConn, sql);
    }

    protected void dropTable(String tableName) throws SQLException {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.dropTable(dConn, gConn, tableName);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void dropTable(Connection dConn, Connection gConn, String tableName) throws SQLException {
        String derbySql = "drop table trade." + tableName;
        String sql = "drop table " + (random.nextBoolean() ? "if exists " : "") + "trade." + tableName;
        if (dConn != null) {
            Log.getLogWriter().info("executing in derby: " + derbySql);
            this.executeStatement(dConn, derbySql);
            Log.getLogWriter().info("executed in derby: " + derbySql);
            this.commit(dConn);
        }
        Log.getLogWriter().info("executing in gfxd: " + sql);
        this.executeStatement(gConn, sql);
        Log.getLogWriter().info("executed in gfxd: " + sql);
        this.commit(gConn);
    }

    protected void createCustomersView() throws SQLException {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.createCustomersView(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void createCustomersView(Connection dConn, Connection gConn) throws SQLException {
        String sql = "create view trade.customers as select cid, cust_name, since, addr, tid from trade.customersv1";
        if (dConn != null) {
            Log.getLogWriter().info("executing in derby: " + sql);
            this.executeStatement(dConn, sql);
            Log.getLogWriter().info("executed in derby: " + sql);
            this.commit(dConn);
        }
        Log.getLogWriter().info("executing in gfxd: " + sql);
        this.executeStatement(gConn, sql);
        Log.getLogWriter().info("executed in gfxd: " + sql);
        this.commit(gConn);
    }

    @Override
    protected void addPortfolioV1Table() {
        boolean reproduce50116 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50116, true);
        try {
            if (reproduce50116) {
                this.createPortfolioV1Table();
                this.selectIntoPortfolioV1Table();
                this.alterTableAddDataCol();
                this.alterTableAlterConstraint();
                this.dropPortfolioTable();
                this.createPortfolioView();
            } else {
                this.createPortfolioV1Table();
                this.selectIntoPortfolioV1Table();
                this.alterTableAddDataCol();
                this.alterTableAlterConstraint();
            }
            SQLBB.getBB().getSharedMap().put((Object)"portfoliov1IsReady", (Object)true);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    static {
        gfxdNoneTxConn = new HydraThreadLocal();
        cidInserted = new HydraThreadLocal();
        curTxId = new HydraThreadLocal();
        curTxModifiedKeys = new HydraThreadLocal();
        curTxNonDeleteHoldKeys = new HydraThreadLocal();
        curTxDeleteHoldKeys = new HydraThreadLocal();
        curTxNewHoldParentKeys = new HydraThreadLocal();
        curTxHoldParentKeys = new HydraThreadLocal();
        derbyOps = new HydraThreadLocal();
        commitEarly = new HydraThreadLocal();
        curTxFKHeld = new HydraThreadLocal();
        rollbackGfxdTx = new HydraThreadLocal();
        iteration = new HydraThreadLocal();
        selectForUpdateRS = new HydraThreadLocal();
        foreignKeyHeldWithBatching = new HydraThreadLocal();
        parentKeyHeldWithBatching = new HydraThreadLocal();
        derbyExceptionsWithBatching = new HydraThreadLocal();
        failedToGetStmtNodeFailure = new HydraThreadLocal();
        updateOnPartitionCol = new HydraThreadLocal();
        needNewConnAfterNodeFailure = new HydraThreadLocal();
        batchInsertToCustomersSucceeded = new HydraThreadLocal();
        ticket43170fixed = false;
        doOpByOne = TestConfig.tab().booleanAt(SQLTxPrms.doOpByOne, false);
        useOriginalNonTx = TestConfig.tab().booleanAt(SQLTxPrms.useOriginalNonTx, false);
        dmlDistTxFactory = new DMLDistTxStmtsFactory();
        useTimeout = TestConfig.tab().booleanAt(SQLTxPrms.useTimeout, false);
        concUpdateTxMaxCid = 0;
        isTicket41738Fixed = false;
        isTicket43935Fixed = false;
        isTicket43932Fixed = true;
        isTicket43909fixed = true;
        isTicket45071fixed = TestConfig.tab().booleanAt(SQLPrms.isTicket45071fixed, false);
        isTicket43188fiFixed = false;
        useThinClientDriverInTx = TestConfig.tab().booleanAt(SQLTxPrms.useThinClientDriverInTx, false);
        mixRR_RC = TestConfig.tab().booleanAt(SQLTxPrms.mixRR_RC, false);
        syncCommits = "sync-commits";
        lock = new Object();
        concUpdateCount = 0;
        addGenIdColInCustomersv1 = false;
        hasSecondaryTables = TestConfig.tab().booleanAt(SQLPrms.hasSecondaryTables, true);
        queryOpTimeNewTables = true;
    }
}

