/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlTx;

import com.pivotal.gemfirexd.internal.drda.NetworkServerControl;
import hydra.ClientVmInfo;
import hydra.DistributedSystemHelper;
import hydra.HostHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.PortHelper;
import hydra.Prms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import sql.GFEDBClientManager;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.sqlTx.SQLTxTest;
import util.PRObserver;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class SQLTxBridgeTest
extends SQLTxTest {
    protected static SQLTxBridgeTest sqlTxbtest;
    protected static boolean useMcast;
    protected static String locatorString;
    protected static Properties bootProps;
    protected static Properties connProps;
    protected static String hostName;
    protected static int portNo;
    protected static NetworkServerControl netServer;

    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startAndConnectLocatorTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void stopLocatorTask() {
        DistributedSystemHelper.stopLocator();
    }

    public static synchronized void HydraTask_initialize() {
        if (sqlTxbtest == null) {
            sqlTxbtest = new SQLTxBridgeTest();
        }
        PRObserver.installObserverHook();
        PRObserver.initialize((int)RemoteTestModule.getMyVmid());
        bootProps = sqlTxbtest.getGemFireProperties();
        bootProps.setProperty("host-data", "true");
        hostName = HostHelper.getIPAddress().getHostName();
        Log.getLogWriter().info("Connecting with properties: " + bootProps);
        sqlTxbtest.initialize();
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    public static synchronized void HydraTask_initialize_replayHA() {
        Object initDelayed = SQLBB.getBB().getSharedMap().get((Object)("initDelayed_" + RemoteTestModule.getMyVmid()));
        if (initDelayed == null) {
            SQLBB.getBB().getSharedMap().put((Object)("initDelayed_" + RemoteTestModule.getMyVmid()), (Object)"true");
            Log.getLogWriter().info("first time for init DDL replay, do nothing");
            return;
        }
        if (sqlTxbtest == null) {
            sqlTxbtest = new SQLTxBridgeTest();
            SQLTxBridgeTest.HydraTask_initialize();
            sqlTxbtest.createGFXDDB();
            int numOfPRs = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs);
            ArrayList<ClientVmInfo> vms = new ArrayList<ClientVmInfo>();
            vms.add(new ClientVmInfo(RemoteTestModule.getMyVmid()));
            PRObserver.waitForRebalRecov(vms, (int)1, (int)numOfPRs, null, null, (boolean)false);
            StopStartVMs.StopStart_initTask();
        }
        int sleepMS = 30000;
        Log.getLogWriter().info("sleep for " + sleepMS / 1000 + " sec");
        MasterController.sleepForMs((int)sleepMS);
    }

    public static synchronized void HydraTask_initConnBridgePort() {
        ArrayList<Integer> portLists;
        portNo = PortHelper.getRandomPort();
        int count = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.initServerPort);
        while (count != 1) {
            count = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.initServerPort);
        }
        HashMap map = (HashMap)SQLBB.getBB().getSharedMap().get((Object)"serverPorts");
        if (map == null) {
            map = new HashMap();
            portLists = new ArrayList<Integer>();
        } else {
            portLists = (ArrayList<Integer>)map.get(hostName);
            if (portLists == null) {
                portLists = new ArrayList();
            }
        }
        portLists.add(portNo);
        map.put(hostName, portLists);
        SQLBB.getBB().getSharedMap().put((Object)"serverPorts", map);
        SQLBB.getBB().getSharedCounters().zero(SQLBB.initServerPort);
        Log.getLogWriter().info("host " + hostName + " port " + portNo + " is available for client connection");
    }

    protected static String getLocatorString() {
        List endpoints = DistributedSystemHelper.getEndpoints();
        return DistributedSystemHelper.endpointsToString((List)endpoints);
    }

    public static synchronized void HydraTask_createGFXDDB() {
        sqlTxbtest.createGFXDDB();
        Object tableCreated = SQLBB.getBB().getSharedMap().get((Object)("tableCreated_" + RemoteTestModule.getMyVmid()));
        if (tableCreated == null) {
            SQLBB.getBB().getSharedMap().put((Object)("tableCreated_" + RemoteTestModule.getMyVmid()), (Object)"true");
            Log.getLogWriter().info("first time, table has not been created, do nothing");
            return;
        }
        if (isHATest) {
            SQLTxBridgeTest.addObserver();
        }
    }

    @Override
    protected void createGFXDDB() {
        this.startGFXDDB(bootProps);
    }

    protected static void addObserver() {
        int numOfPRs = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs);
        ArrayList<ClientVmInfo> vms = new ArrayList<ClientVmInfo>();
        vms.add(new ClientVmInfo(RemoteTestModule.getMyVmid()));
        PRObserver.waitForRebalRecov(vms, (int)1, (int)numOfPRs, null, null, (boolean)false);
        StopStartVMs.StopStart_initTask();
    }

    public static synchronized void HydraTask_initEdges() {
        if (sqlTxbtest == null) {
            sqlTxbtest = new SQLTxBridgeTest();
        }
        hasDerbyServer = TestConfig.tab().booleanAt(Prms.manageDerbyServer, false);
        testUniqueKeys = TestConfig.tab().booleanAt(SQLPrms.testUniqueKeys, true);
        randomData = TestConfig.tab().booleanAt(SQLPrms.randomData, false);
        isSerial = TestConfig.tab().booleanAt(Prms.serialExecution, false);
        isSingleDMLThread = TestConfig.tab().booleanAt(SQLPrms.isSingleDMLThread, false);
        usingTrigger = TestConfig.tab().booleanAt(SQLPrms.usingTrigger, false);
        queryAnyTime = TestConfig.tab().booleanAt(SQLPrms.queryAnyTime, true);
        hasNetworth = TestConfig.tab().booleanAt(SQLPrms.hasNetworth, false);
        isEdge = true;
    }

    public static synchronized void HydraTask_createGFXDNetServer() throws Exception {
        sqlTxbtest.createGFXDNetServer();
    }

    protected void createGFXDNetServer() throws Exception {
        netServer = new NetworkServerControl(InetAddress.getLocalHost(), portNo);
        netServer.start(new PrintWriter(System.out));
        while (true) {
            MasterController.sleepForMs((int)500);
            try {
                netServer.ping();
            }
            catch (Exception e) {
                Log.getLogWriter().info("could not ping netServer " + TestHelper.getStackTrace((Throwable)e));
                continue;
            }
            break;
        }
        netServer.logConnections(true);
    }

    public static void HydraTask_createGFESchemasByClients() {
        sqlTxbtest.createGFESchemasByClients();
    }

    protected void createGFESchemasByClients() {
        Connection conn = this.getGFXDClientTxConnection();
        Log.getLogWriter().info("creating schema in gfxd.");
        if (!testServerGroupsInheritence) {
            this.createSchemas(conn);
        } else {
            String[] schemas = SQLPrms.getGFESchemas();
            this.createSchemas(conn, schemas);
        }
        Log.getLogWriter().info("done creating schema in gfxd.");
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_createGFETablesByClients() {
        sqlTxbtest.createGFETablesByClients();
    }

    protected void createGFETablesByClients() {
        Connection conn = this.getGFXDClientTxConnection();
        Log.getLogWriter().info("creating tables in gfxd.");
        this.createTables(conn);
        Log.getLogWriter().info("done creating tables in gfxd.");
        this.closeGFEConnection(conn);
    }

    protected Connection getGFXDClientTxConnection() {
        Connection conn = null;
        try {
            conn = GFEDBClientManager.getTxConnection();
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get the thin client tx connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected Connection getGFXDClientTxConnection(Properties info) {
        Connection conn = null;
        try {
            conn = GFEDBClientManager.getTxConnection(info);
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get the thin client tx connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    public static void HydraTask_populateTxTables() {
        sqlTxbtest.populateTxTables();
    }

    @Override
    protected void populateTxTables() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDClientTxConnection();
        this.populateTxTables(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_doTxDMLOps() {
        sqlTxbtest.doTxDMLOps();
    }

    public static void HydraTask_doTxOps() {
        sqlTxbtest.doTxOps();
    }

    @Override
    protected void doTxOps() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDClientTxConnection();
        if (random.nextInt(numOfWorkers / 2) == 0) {
            this.doTxDDLOps(dConn, gConn);
        } else {
            this.doTxDMLOps(dConn, gConn);
        }
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    @Override
    protected void doTxDMLOps() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDClientTxConnection();
        this.doTxDMLOps(dConn, gConn);
    }

    public static void HydraTask_createIndex() {
        sqlTxbtest.createIndex();
    }

    @Override
    protected void createIndex() {
        Connection gConn = this.getGFXDClientTxConnection();
        this.createIndex(gConn);
    }

    @Override
    protected List<ClientVmInfo> stopStartVMs(int numToKill) {
        return this.stopStartVMs(numToKill, "store");
    }

    public static void HydraTask_setTableCols() {
        sqlTxbtest.setTableCols();
    }

    @Override
    protected void setTableCols() {
        Connection gConn = this.getGFXDClientTxConnection();
        SQLTxBridgeTest.setTableCols(gConn);
    }

    public static synchronized void HydraTask_cycleStoreVms() {
        sqlTxbtest.cycleStoreVms();
    }

    public static synchronized void HydraTask_createDiscDB() {
        sqlTxbtest.createDiscDB();
    }

    public static synchronized void HydraTask_createDiscSchemas() {
        sqlTxbtest.createDiscSchemas();
    }

    public static synchronized void HydraTask_createDiscTables() {
        sqlTxbtest.createDiscTables();
    }

    public static void HydraTask_verifyResultSets() {
        sqlTxbtest.verifyResultSets();
    }

    @Override
    protected void verifyResultSets() {
        if (!hasDerbyServer) {
            Log.getLogWriter().info("skipping verify of query results due to manageDerbyServer as false, myTid=" + this.getMyTid());
            this.cleanConnection(this.getGFXDClientTxConnection());
            return;
        }
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFXDClientTxConnection();
        this.verifyResultSets(dConn, gConn);
    }

    static {
        netServer = null;
    }
}

