/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlTx;

import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.AnyCyclicBarrier;
import hydra.blackboard.SharedLock;
import hydra.blackboard.SharedMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import sql.GFEDBManager;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlStatements.AbstractDMLStmt;
import sql.dmlTxStatements.DMLTxStmtIF;
import sql.dmlTxStatements.TradeCustomersDMLTxStmt;
import sql.sqlTx.SQLDerbyTxBB;
import sql.sqlTx.SQLTxBB;
import sql.sqlutil.DMLTxStmtsFactory;
import sql.sqlutil.GFXDTxHelper;
import sql.sqlutil.ResultSetHelper;
import util.PRObserver;
import util.TestException;
import util.TestHelper;

public class SQLTxTest
extends SQLTest {
    protected static SQLTxTest sqlTxTest;
    public static boolean isTxTest;
    protected static DMLTxStmtsFactory dmlTxFactory;
    private static String thisTxId;
    private static boolean oneOpPerTx;
    public static HydraThreadLocal curTxId;
    public static final String TXLOCK = "lockToPerformTx";
    public static final String LOCK_SERVICE_NAME = "MyLockService";
    protected static SharedLock lock;
    protected static DistributedLockService dls;

    public static synchronized void HydraTask_initializeGFXD() {
        if (sqlTxTest == null) {
            sqlTxTest = new SQLTxTest();
            PRObserver.installObserverHook();
            PRObserver.initialize((int)RemoteTestModule.getMyVmid());
            sqlTxTest.initialize();
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        isTxTest = TestConfig.tab().booleanAt(SQLPrms.hasTx, true);
    }

    public static synchronized void HydraTask_createDiscDB() {
        sqlTxTest.createDiscDB();
    }

    public static synchronized void HydraTask_createDiscSchemas() {
        sqlTxTest.createDiscSchemas();
    }

    public static synchronized void HydraTask_createDiscTables() {
        sqlTxTest.createDiscTables();
    }

    public static synchronized void HydraTask_createGFXDDB() {
        sqlTxTest.createGFXDDB();
    }

    public static synchronized void HydraTask_createGFXDDBForAccessors() {
        sqlTxTest.createGFXDDBForAccessors();
    }

    public static void HydraTask_createGFESchemas() {
        sqlTxTest.createGFESchemas();
    }

    public static void HydraTask_createGFETables() {
        sqlTxTest.createGFETables();
    }

    public static void HydraTask_populateTxTables() {
        sqlTxTest.populateTxTables();
    }

    public static void HydraTask_insertCustomersTxConflict() {
        sqlTxTest.insertCustomersTxConflict();
    }

    public static void HydraTask_updateCustomersTxConflict() {
        sqlTxTest.updateCustomersTxConflict();
    }

    public static void HydraTask_doTxDMLOps() {
        sqlTxTest.doTxDMLOps();
    }

    public static void HydraTask_doTxOps() {
        sqlTxTest.doTxOps();
    }

    public static void HydraTask_testDerby() {
        sqlTxTest.testDerbyForeignKey();
    }

    protected void testDerbyUniqKey() {
        sqlTxTest.createTableUniqKey();
        this.waitForBarrier();
        sqlTxTest.testUniqKey();
    }

    protected void createTableUniqKey() {
        Connection dConn = this.getDiscConnection();
        if (this.getMyTid() == 1) {
            String t1 = "create table trade.t1 (id int not null, f1 int, constraint t1_pk primary key (id), constraint t1_uniq unique (f1))";
            try {
                dConn.createStatement().execute(t1);
                dConn.commit();
                Log.getLogWriter().info("uniq table created");
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected void testUniqKey() {
        Log.getLogWriter().info("into uniq key testing");
        Connection dConn = this.getDiscConnection();
        int count = 0;
        try {
            PreparedStatement stmt;
            String sql;
            if (this.getMyTid() == 1) {
                Log.getLogWriter().info("inserting into t1");
                sql = "insert into trade.t1 values (1, 1)";
                count = dConn.createStatement().executeUpdate(sql);
                Log.getLogWriter().info("insert into t1 of row: " + count);
            }
            if (this.getMyTid() == 0) {
                MasterController.sleepForMs((int)2000);
                Log.getLogWriter().info("inserting into t1");
                try {
                    sql = "insert into trade.t1 values (?, ?)";
                    stmt = dConn.prepareStatement(sql);
                    stmt.setInt(1, 2);
                    stmt.setInt(2, 1);
                    count = stmt.executeUpdate();
                    Log.getLogWriter().info("insert into t1 of row:" + count);
                }
                catch (SQLException e) {
                    Log.getLogWriter().info("insert into t1 failed");
                    SQLHelper.printSQLException(e);
                }
            }
            this.waitForBarrier();
            this.getLock();
            if (this.getMyTid() == 0) {
                dConn.commit();
                Log.getLogWriter().info("commit insert into t2");
            } else if (this.getMyTid() == 1) {
                dConn.commit();
                Log.getLogWriter().info("commit insert into t1");
            }
            this.releaseLock();
            this.waitForBarrier();
            if (this.getMyTid() == 1) {
                MasterController.sleepForMs((int)2000);
                Log.getLogWriter().info("deleting from t1 ");
                sql = "delete from trade.t1 where id = 1 ";
                count = dConn.createStatement().executeUpdate(sql);
                Log.getLogWriter().info("delete from t1 of row: " + count);
            }
            if (this.getMyTid() == 0) {
                Log.getLogWriter().info("inserting into t2");
                try {
                    sql = "insert into trade.t2 values (?, ?)";
                    stmt = dConn.prepareStatement(sql);
                    stmt.setInt(1, 1);
                    stmt.setInt(2, 1);
                    count = stmt.executeUpdate();
                    Log.getLogWriter().info("insert into t2 of row:" + count);
                }
                catch (SQLException e) {
                    Log.getLogWriter().info("insert into t2 failed");
                    SQLHelper.printSQLException(e);
                }
            }
            this.waitForBarrier();
            this.getLock();
            if (this.getMyTid() == 0) {
                dConn.commit();
                Log.getLogWriter().info("commit insert into t2");
            } else if (this.getMyTid() == 1) {
                dConn.commit();
                Log.getLogWriter().info("commit insert into t1");
            }
            this.releaseLock();
            this.waitForBarrier();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void testDerbyForeignKey() {
        sqlTxTest.createTableForeignKey();
        this.waitForBarrier();
        sqlTxTest.testForeignKey();
    }

    protected void testDerbyConcUpdate() {
        sqlTxTest.createTableUpdate();
        this.waitForBarrier();
        sqlTxTest.testConcUpdate();
    }

    protected void testDerbyRepeatableRead() {
        sqlTxTest.createTableUpdate();
        this.waitForBarrier();
        sqlTxTest.testRepeatableRead();
    }

    protected void createTableUpdate() {
        Connection dConn = this.getGFEConnection();
        if (this.getMyTid() == 1) {
            String t3 = "create table trade.t3 (id int not null, f1 varchar(10), f2 int, constraint t3_pk primary key (id))";
            try {
                dConn.createStatement().execute(t3);
                dConn.commit();
                Log.getLogWriter().info("tables are created");
                int count = 0;
                Log.getLogWriter().info("inserting into t3");
                String sql = "insert into trade.t3 values (1, 'red', 2)";
                count = dConn.createStatement().executeUpdate(sql);
                Log.getLogWriter().info("insert into t3 for " + count + " row: " + sql);
                sql = "insert into trade.t3 values (2, 'yellow', 201)";
                count = dConn.createStatement().executeUpdate(sql);
                Log.getLogWriter().info("insert into t3 for " + count + " row: " + sql);
                dConn.commit();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected void testConcUpdate() {
        Log.getLogWriter().info("into concurrent update testing");
        Connection dConn = this.getGFEConnection();
        int count = 0;
        String sql = null;
        try {
            dConn.setTransactionIsolation(2);
            this.printIsolationLevel(dConn);
            if (this.getMyTid() == 1) {
                sql = "update trade.t3 set f1='green' where f2>100";
                Log.getLogWriter().info("updating t3 " + sql);
                count = dConn.createStatement().executeUpdate(sql);
                Log.getLogWriter().info("update t3 number of row: " + count);
            }
            this.waitForBarrier();
            if (this.getMyTid() == 0) {
                try {
                    sql = "update trade.t3 set f2=1 where id =2";
                    Log.getLogWriter().info("updating t3 " + sql);
                    count = dConn.createStatement().executeUpdate(sql);
                    Log.getLogWriter().info("update t3 number of row: " + count);
                    dConn.commit();
                    Log.getLogWriter().info(sql + " is committed");
                }
                catch (SQLException e) {
                    Log.getLogWriter().info("update to t3 failed " + sql);
                    SQLHelper.printSQLException(e);
                }
            }
            this.waitForBarrier();
            if (this.getMyTid() == 1) {
                dConn.commit();
                sql = "select * from trade.t3";
                ResultSet rs = dConn.createStatement().executeQuery(sql);
                List<Struct> list = ResultSetHelper.asList(rs, true);
                Log.getLogWriter().info("table list is " + ResultSetHelper.listToString(list));
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void testRepeatableRead() {
        Log.getLogWriter().info("into derby repeatable read testing");
        Connection dConn = this.getDiscConnection();
        int count = 0;
        String sql = null;
        try {
            ResultSet rs;
            dConn.setTransactionIsolation(4);
            this.printIsolationLevel(dConn);
            if (this.getMyTid() == 1) {
                sql = "select * from trade.t3 where f2>100";
                Log.getLogWriter().info("querying t3: " + sql);
                rs = dConn.createStatement().executeQuery(sql);
                Log.getLogWriter().info("query results are: " + ResultSetHelper.listToString(ResultSetHelper.asList(rs, true)));
            }
            this.waitForBarrier();
            if (this.getMyTid() == 0) {
                try {
                    sql = "update trade.t3 set f1='green' where id =1";
                    Log.getLogWriter().info("updating t3 " + sql);
                    count = dConn.createStatement().executeUpdate(sql);
                    Log.getLogWriter().info("update t3 number of row: " + count);
                    dConn.commit();
                    Log.getLogWriter().info(sql + " is committed");
                }
                catch (SQLException e) {
                    Log.getLogWriter().info("update to t3 failed " + sql);
                    SQLHelper.printSQLException(e);
                }
            }
            this.waitForBarrier();
            if (this.getMyTid() == 1) {
                dConn.commit();
                sql = "select * from trade.t3";
                rs = dConn.createStatement().executeQuery(sql);
                List<Struct> list = ResultSetHelper.asList(rs, true);
                Log.getLogWriter().info("table list is " + ResultSetHelper.listToString(list));
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void createTableForeignKey() {
        Connection dConn = this.getDiscConnection();
        if (this.getMyTid() == 1) {
            String t1 = "create table trade.t1 (id int not null, f1 int, constraint t1_pk primary key (id))";
            String t2 = "create table trade.t2 (id int not null, t1id int, constraint t2_pk primary key (id), constraint t2_fk foreign key (t1id) references trade.t1 (id) on delete restrict)";
            try {
                dConn.createStatement().execute(t1);
                dConn.createStatement().execute(t2);
                dConn.commit();
                Log.getLogWriter().info("tables are created");
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected void testForeignKey() {
        Log.getLogWriter().info("into foreign key testing");
        Connection dConn = this.getDiscConnection();
        int count = 0;
        try {
            String sql;
            if (this.getMyTid() == 1) {
                Log.getLogWriter().info("inserting into t1");
                sql = "insert into trade.t1 values (1, 1)";
                count = dConn.createStatement().executeUpdate(sql);
                Log.getLogWriter().info("insert into t1 of row: " + count);
            }
            if (this.getMyTid() == 0) {
                MasterController.sleepForMs((int)2000);
                Log.getLogWriter().info("inserting into t2");
                try {
                    sql = "insert into trade.t2 values (?, ?)";
                    PreparedStatement stmt = dConn.prepareStatement(sql);
                    stmt.setInt(1, 1);
                    stmt.setInt(2, 1);
                    count = stmt.executeUpdate();
                    Log.getLogWriter().info("insert into t2 of row:" + count);
                }
                catch (SQLException e) {
                    Log.getLogWriter().info("insert into t2 failed");
                    SQLHelper.printSQLException(e);
                }
            }
            this.waitForBarrier();
            this.getLock();
            if (this.getMyTid() == 0) {
                dConn.commit();
                Log.getLogWriter().info("commit insert into t2");
            } else if (this.getMyTid() == 1) {
                dConn.commit();
                Log.getLogWriter().info("commit insert into t1");
            }
            this.releaseLock();
            this.waitForBarrier();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void populateTxTables() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDTxConnection();
        this.populateTxTables(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void doTxDMLOps() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDTxConnection();
        this.doTxDMLOps(dConn, gConn);
    }

    protected void doTxOps() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDTxConnection();
        if (random.nextInt(numOfWorkers / 2) == 0) {
            this.doTxDDLOps(dConn, gConn);
        } else {
            this.doTxDMLOps(dConn, gConn);
        }
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void populateTxTables(Connection dConn, Connection gConn) {
        Log.getLogWriter().info("setting hydra thread local curTxId to 0");
        curTxId.set((Object)0);
        for (int i = 0; i < dmlTables.length; ++i) {
            DMLTxStmtIF dmlTxStmt = dmlTxFactory.createDMLTxStmt(dmlTables[i]);
            if (dmlTxStmt == null) continue;
            dmlTxStmt.populateTx(dConn, gConn);
            if (dConn == null) continue;
            this.waitForBarrier();
        }
    }

    protected void doTxDDLOps(Connection dConn, Connection gConn) {
        if (dConn == null) {
            this.doGFXDTxDDLOps(gConn);
            return;
        }
        this.waitForBarrier();
        this.doVariousTxDDLOps(dConn, gConn);
        this.waitForBarrier();
    }

    protected void doVariousTxDDLOps(Connection dConn, Connection gConn) {
        this.createIndex(gConn);
        try {
            gConn.commit();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void doGFXDTxDDLOps(Connection gConn) {
        this.createIndex();
    }

    public static void HydraTask_setTableCols() {
        sqlTxTest.setTableCols();
    }

    protected void doTxDMLOps(Connection dConn, Connection gConn) {
        if (dConn == null) {
            this.doGFXDTxDMLOps(gConn);
            return;
        }
        int txId = (int)SQLTxBB.getBB().getSharedCounters().incrementAndRead(SQLTxBB.txId);
        int maxOps = 10;
        int numOfOps = 0;
        numOfOps = oneOpPerTx ? 1 : random.nextInt(maxOps) + 1;
        Log.getLogWriter().info("This tx " + txId + " will perform " + numOfOps + " operations.");
        HashMap<String, Integer> modifiedKeys = new HashMap<String, Integer>();
        modifiedKeys.put(thisTxId, txId);
        ArrayList<SQLException> dExList = new ArrayList<SQLException>();
        ArrayList<SQLException> sExList = new ArrayList<SQLException>();
        ArrayList derbyOps = new ArrayList();
        SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, derbyOps);
        if (AbstractDMLStmt.byCidRange) {
            int cid = random.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary));
            Log.getLogWriter().info("txId " + txId + " use cids colocated with " + cid);
            SQLBB.getBB().getSharedMap().put((Object)("cid_txId_" + txId), (Object)cid);
        }
        Log.getLogWriter().info("setting hydra thread local curTxId to " + txId);
        curTxId.set((Object)txId);
        for (int i = 0; i < numOfOps; ++i) {
            this.doTxDMLOneOp(dConn, gConn, modifiedKeys, dExList, sExList);
        }
        boolean rollback = false;
        boolean expectFailure = false;
        boolean gotException = false;
        boolean ignoreInDoubtTx = false;
        SQLException gfxdCommitEx = null;
        SharedMap modifiedKeysByOtherTx = null;
        if (random.nextInt(numOfWorkers) == 1) {
            rollback = true;
        }
        this.waitForBarrier();
        if (rollback) {
            try {
                Log.getLogWriter().info("rollback the operation in gfxd");
                gConn.rollback();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        } else {
            this.getLock();
            try {
                modifiedKeysByOtherTx = SQLTxBB.getBB().getSharedMap();
                int beforeSize = modifiedKeysByOtherTx.size();
                Log.getLogWriter().info("before the commit, the tx bb map size is " + beforeSize);
                modifiedKeys.remove(thisTxId);
                int mapSize = modifiedKeys.size();
                Log.getLogWriter().info("to commit, modified key map size is " + mapSize);
                HashMap<String, Integer> mapIfCommit = new HashMap<String, Integer>();
                mapIfCommit.putAll(modifiedKeys);
                mapIfCommit.putAll(modifiedKeysByOtherTx.getMap());
                int afterSize = mapIfCommit.size();
                Log.getLogWriter().info("if commit, the tx bb map size is " + afterSize);
                if (beforeSize + mapSize == afterSize) {
                    Log.getLogWriter().info("committing gfxd tx, does not expect failure");
                } else {
                    for (String key : modifiedKeys.keySet()) {
                        if (!modifiedKeysByOtherTx.containsKey((Object)key)) continue;
                        if (modifiedKeys.get(key) == -100 && (Integer)modifiedKeysByOtherTx.get((Object)key) == -100) {
                            Log.getLogWriter().info("Got two tx to insert same in txHisotry, this is  acceptable for non primary key table, this key is " + key);
                            continue;
                        }
                        expectFailure = true;
                        Log.getLogWriter().info("committing gfxd tx, expects failure");
                    }
                }
                gConn.commit();
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                gotException = true;
                if (se.getSQLState().equalsIgnoreCase("X0Z02") && !expectFailure) {
                    throw new TestException("Got commit conflict exception, but it should not as the tx does not have conflict keys");
                }
                if (se.getSQLState().equalsIgnoreCase("X0Z02") && expectFailure) {
                    Log.getLogWriter().info("Got the expected commit Conflict exception");
                }
                if (se.getSQLState().equalsIgnoreCase("X0Z05") && oneOpPerTx) {
                    Log.getLogWriter().info("For one operation per Tx, in doubt tx could be ignored");
                    gfxdCommitEx = se;
                    ignoreInDoubtTx = true;
                }
                SQLHelper.handleSQLException(se);
            }
            if (expectFailure && !gotException) {
                StringBuffer str = new StringBuffer();
                StringBuffer txHistoryStr = new StringBuffer();
                str.append("This tx " + txId + " has modified the following keys " + "which are modified by other tx:\n");
                for (String key : modifiedKeys.keySet()) {
                    if (!modifiedKeysByOtherTx.containsKey((Object)key)) continue;
                    if (modifiedKeys.get(key) < 0) {
                        if (modifiedKeys.get(key) == -100 && (Integer)modifiedKeysByOtherTx.get((Object)key) == -100) continue;
                        txHistoryStr.append(key + " in txHistory is modified/inserted in more than " + "one transaction concurrently");
                        continue;
                    }
                    str.append(key + " is already modified by txId: " + modifiedKeysByOtherTx.get((Object)key) + "\n");
                }
                throw new TestException("Expect commit conflict exception, but the tx does not get it\n" + str.toString() + "\n" + txHistoryStr.toString());
            }
            if (!gotException) {
                modifiedKeysByOtherTx.putAll(modifiedKeys);
            }
            derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            if (!expectFailure) {
                Log.getLogWriter().info("performing tx ops in derby for txId " + txId);
                Log.getLogWriter().info("derby tx has " + derbyOps.size() + " operations");
                for (Object[] derbyOp : derbyOps) {
                    DMLTxStmtIF dmlTxStmt = dmlTxFactory.createDMLTxStmt((Integer)derbyOp[0]);
                    dmlTxStmt.performDerbyTxOps(dConn, derbyOp, dExList);
                }
            }
            try {
                if (expectFailure) {
                    Log.getLogWriter().info("expect failure, roll back the derby tx");
                    dConn.rollback();
                } else {
                    Log.getLogWriter().info("committing derby tx, does not expect failure");
                    dConn.commit();
                }
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            if (!expectFailure || ignoreInDoubtTx) {
                Log.getLogWriter().info("compare two exception lists");
                if (gfxdCommitEx != null) {
                    if (dExList.get(0) == null) {
                        throw new TestException("gfxd got in doubt exception, but derby did not have exception by the same cause");
                    }
                    SQLHelper.isSameRootSQLException(dExList.get(0).getSQLState(), gfxdCommitEx);
                } else {
                    SQLHelper.compareExceptionLists(dExList, sExList);
                }
            }
            this.releaseLock();
        }
        this.waitForBarrier();
        SQLTxBB.getBB().getSharedMap().clear();
    }

    protected void doTxDMLOneOp(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        Log.getLogWriter().info("performing dmlTxOp, myTid is " + this.getMyTid());
        int table = dmlTables[random.nextInt(dmlTables.length)];
        while (modifiedKeys.size() == 1 && GFXDTxHelper.isReplicate(table) && !oneOpPerTx) {
            Log.getLogWriter().info("table name is " + table);
            table = dmlTables[random.nextInt(dmlTables.length)];
        }
        DMLTxStmtIF dmlTxStmt = dmlTxFactory.createDMLTxStmt(table);
        if (dmlTxStmt != null) {
            String operation = TestConfig.tab().stringAt(SQLPrms.dmlOperations);
            if (operation.equals("query")) {
                operation = "update";
            }
            if (operation.equals("insert")) {
                dmlTxStmt.insertTx(dConn, gConn, modifiedKeys, dExList, sExList);
            } else if (operation.equals("update")) {
                dmlTxStmt.updateTx(dConn, gConn, modifiedKeys, dExList, sExList);
            } else if (operation.equals("delete")) {
                dmlTxStmt.deleteTx(dConn, gConn, modifiedKeys, dExList, sExList);
            } else if (!operation.equals("query")) {
                throw new TestException("Unknown entry operation: " + operation);
            }
        } else {
            Log.getLogWriter().info("tx for this table has not been implemented yet");
        }
    }

    protected void doGFXDTxDMLOps(Connection gConn) {
        int txId = (int)SQLTxBB.getBB().getSharedCounters().incrementAndRead(SQLTxBB.txId);
        int maxOps = 5;
        int numOfOps = 0;
        numOfOps = oneOpPerTx ? 1 : random.nextInt(maxOps) + 1;
        Log.getLogWriter().info("This tx " + txId + " will perform " + numOfOps + " operations.");
        HashMap<String, Integer> modifiedKeys = new HashMap<String, Integer>();
        modifiedKeys.put(thisTxId, txId);
        ArrayList<SQLException> sExList = new ArrayList<SQLException>();
        if (AbstractDMLStmt.byCidRange) {
            int cid = random.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary));
            Log.getLogWriter().info("txId " + txId + " use cids colocated with " + cid);
            SQLBB.getBB().getSharedMap().put((Object)("cid_txId_" + txId), (Object)cid);
        }
        for (int i = 0; i < numOfOps; ++i) {
            this.doTxDMLOneOp(null, gConn, modifiedKeys, null, sExList);
        }
        try {
            gConn.commit();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                Log.getLogWriter().info("Got the commit Conflict exception, continuing testing");
            }
            if (se.getSQLState().equalsIgnoreCase("X0Z05")) {
                Log.getLogWriter().info("Got the in doubt transaction exception, continuing testing");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    @Override
    protected void waitForBarrier() {
        AnyCyclicBarrier barrier = AnyCyclicBarrier.lookup((int)numOfWorkers, (String)"barrier");
        Log.getLogWriter().info("Waiting for " + numOfWorkers + " to meet at barrier");
        barrier.await();
    }

    protected void insertCustomersTxConflict() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDTxConnection();
        this.printIsolationLevel(gConn);
        this.insertCustomersTxConflict(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void insertCustomersTxConflict(Connection dConn, Connection gConn) {
        int size = TestConfig.tab().intAt(SQLPrms.initCustomersSizePerThread, 100);
        TradeCustomersDMLTxStmt cust = new TradeCustomersDMLTxStmt();
        cust.insertCustomersTxConflict(dConn, gConn, size);
    }

    protected void updateCustomersTxConflict() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDTxConnection();
        this.updateCustomersTxConflict(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void updateCustomersTxConflict(Connection dConn, Connection gConn) {
        int size = 5;
        TradeCustomersDMLTxStmt cust = new TradeCustomersDMLTxStmt();
        cust.updateCustomersTxConflict(dConn, gConn, size);
    }

    protected Connection getGFXDTxConnection() {
        Connection conn = null;
        try {
            conn = GFEDBManager.getTxConnection();
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected Connection getGFXDTxConnection(Properties info) {
        Connection conn = null;
        try {
            conn = GFEDBManager.getTxConnection(info);
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    public static void HydraTask_verifyResultSets() {
        sqlTxTest.verifyResultSets();
    }

    public static void HydraTask_updateUsingScatterWhereCaluse() {
        sqlTxTest.updateCustomersScatter();
    }

    private void updateCustomersScatter() {
        TradeCustomersDMLTxStmt custTx = new TradeCustomersDMLTxStmt();
        Connection gConn = this.getGFXDTxConnection();
        this.printIsolationLevel(gConn);
        custTx.updateCustomersTxScatter(null, gConn);
    }

    protected void printIsolationLevel(Connection conn) {
        try {
            String isoLevel;
            int isolation = conn.getTransactionIsolation();
            switch (isolation) {
                case 0: {
                    isoLevel = "TRANSACTION_NONE";
                    break;
                }
                case 2: {
                    isoLevel = "TRANSACTION_READ_COMMITTED";
                    break;
                }
                case 4: {
                    isoLevel = "TRANSACTION_REPEATABLE_READ";
                    break;
                }
                case 8: {
                    isoLevel = "TRANSACTION_SERIALIZABLE";
                    break;
                }
                default: {
                    isoLevel = "unknown";
                }
            }
            Log.getLogWriter().info("the connection isolation level is " + isoLevel);
            SQLWarning w = conn.getWarnings();
            SQLHelper.printSQLWarning(w);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    protected void getLock() {
        if (!SQLTest.isEdge) {
            if (dls == null) {
                dls = SQLTxTest.getLockService();
            }
            dls.lock((Object)TXLOCK, -1L, -1L);
        } else {
            if (lock == null) {
                lock = SQLBB.getBB().getSharedLock();
            }
            lock.lock();
        }
    }

    @Override
    protected void releaseLock() {
        if (!SQLTest.isEdge) {
            dls.unlock((Object)TXLOCK);
        } else {
            lock.unlock();
        }
    }

    private static DistributedLockService getLockService() {
        DistributedLockService dls = DistributedLockService.getServiceNamed((String)LOCK_SERVICE_NAME);
        if (dls == null) {
            InternalDistributedSystem ds = InternalDistributedSystem.getConnectedInstance();
            if (ds == null) {
                throw new TestException("DistributedSystem is " + ds);
            }
            dls = DistributedLockService.create((String)LOCK_SERVICE_NAME, (DistributedSystem)ds);
        }
        return dls;
    }

    static {
        isTxTest = true;
        dmlTxFactory = new DMLTxStmtsFactory();
        thisTxId = "thisTxId";
        oneOpPerTx = TestConfig.tab().booleanAt(SQLPrms.oneOpPerTx, false);
        curTxId = new HydraThreadLocal();
    }
}

