/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlTx.thinClient;

import hydra.ClientVmInfo;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.Prms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.gemfirexd.GfxdConfigPrms;
import hydra.gemfirexd.NetworkServerHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import sql.GFEDBClientManager;
import sql.GFEDBManager;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.dmlStatements.AbstractDMLStmt;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlTx.SQLTxBB;
import sql.sqlutil.PooledConnectionC3P0;
import sql.sqlutil.PooledConnectionDBCP;
import sql.sqlutil.PooledConnectionTomcat;
import util.PRObserver;
import util.TestException;
import util.TestHelper;

public class SQLDistTxClientTest
extends SQLDistTxTest {
    protected static SQLDistTxClientTest sqlTxClientTest;
    static boolean isTicket43188Fixed;
    public static Object lock;
    public static int concUpdateCount;
    public static boolean useGemFireXDHA;

    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startAndConnectLocatorTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void stopLocatorTask() {
        DistributedSystemHelper.stopLocator();
    }

    public static synchronized void HydraTask_initializeServer() {
        if (sqlTxClientTest == null) {
            sqlTxClientTest = new SQLDistTxClientTest();
        }
        PRObserver.installObserverHook();
        PRObserver.initialize((int)RemoteTestModule.getMyVmid());
        SQLDistTxClientTest.initializeParams();
    }

    public static synchronized void HydraTask_initClient() {
        if (sqlTxClientTest == null) {
            sqlTxClientTest = new SQLDistTxClientTest();
        }
        hasDerbyServer = TestConfig.tab().booleanAt(Prms.manageDerbyServer, false);
        testUniqueKeys = TestConfig.tab().booleanAt(SQLPrms.testUniqueKeys, true);
        randomData = TestConfig.tab().booleanAt(SQLPrms.randomData, false);
        isSerial = TestConfig.tab().booleanAt(Prms.serialExecution, false);
        isSingleDMLThread = TestConfig.tab().booleanAt(SQLPrms.isSingleDMLThread, false);
        usingTrigger = TestConfig.tab().booleanAt(SQLPrms.usingTrigger, false);
        queryAnyTime = TestConfig.tab().booleanAt(SQLPrms.queryAnyTime, true);
        hasNetworth = TestConfig.tab().booleanAt(SQLPrms.hasNetworth, false);
        isEdge = true;
    }

    private static void initializeParams() {
        hasDerbyServer = TestConfig.tab().booleanAt(Prms.manageDerbyServer, false);
        testUniqueKeys = TestConfig.tab().booleanAt(SQLPrms.testUniqueKeys, true);
        randomData = TestConfig.tab().booleanAt(SQLPrms.randomData, false);
        isSerial = TestConfig.tab().booleanAt(Prms.serialExecution, false);
        isSingleDMLThread = TestConfig.tab().booleanAt(SQLPrms.isSingleDMLThread, false);
        usingTrigger = TestConfig.tab().booleanAt(SQLPrms.usingTrigger, false);
        queryAnyTime = TestConfig.tab().booleanAt(SQLPrms.queryAnyTime, true);
        hasNetworth = TestConfig.tab().booleanAt(SQLPrms.hasNetworth, false);
    }

    public static synchronized void HydraTask_startFabricServer() {
        sqlTxClientTest.startFabricServer();
    }

    public static synchronized void HydraTask_stopFabricServer() {
        sqlTxClientTest.stopFabricServer();
    }

    public static synchronized void HydraTask_startNetworkServer() {
        String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
        NetworkServerHelper.startNetworkServers(networkServerConfig);
    }

    public static void HydraTask_createGfxdSchemasByClients() {
        sqlTxClientTest.createGfxdSchemasByClients();
    }

    protected void createGfxdSchemasByClients() {
        Connection conn = this.getGFXDClientTxConnection();
        Log.getLogWriter().info("creating schema in gfxd.");
        if (!testServerGroupsInheritence) {
            this.createSchemas(conn);
        } else {
            String[] schemas = SQLPrms.getGFESchemas();
            this.createSchemas(conn, schemas);
        }
        Log.getLogWriter().info("done creating schema in gfxd.");
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_createGfxdTablesByClients() {
        sqlTxClientTest.createGfxdTablesByClients();
    }

    protected void createGfxdTablesByClients() {
        Connection conn = this.getGFXDClientTxConnection();
        Log.getLogWriter().info("creating tables in gfxd.");
        this.createTables(conn);
        Log.getLogWriter().info("done creating tables in gfxd.");
        this.closeGFEConnection(conn);
    }

    public Connection getGFXDClientTxConnection() {
        Connection conn = null;
        boolean retry = false;
        do {
            try {
                conn = useC3P0 && useGfxdConfig ? PooledConnectionC3P0.getRCConnection() : (useDBCP && useGfxdConfig ? PooledConnectionDBCP.getRCConnection() : (useTomcatConnPool && useGfxdConfig ? PooledConnectionTomcat.getRCConnection() : GFEDBClientManager.getTxConnection(GFEDBManager.Isolation.READ_COMMITTED)));
                retry = false;
                if (!this.needNewConnection()) continue;
                SQLDistTxTest.needNewConnAfterNodeFailure.set((Object)false);
                Log.getLogWriter().info("got new connection: needNewConnAfterNodeFailure is reset to false");
            }
            catch (SQLException e) {
                SQLHelper.printSQLException(e);
                if (AbstractDMLStmt.gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(e)) {
                    retry = true;
                    Log.getLogWriter().info("Could not get connection due to Node failure and will retry, continue testing");
                    continue;
                }
                throw new TestException("Not able to get the connection " + TestHelper.getStackTrace((Throwable)e));
            }
        } while (retry);
        return conn;
    }

    public static void HydraTask_createDiscDB() {
        sqlTxClientTest.createDiscDB();
    }

    public static void HydraTask_createDiscSchemas() {
        sqlTxClientTest.createDiscSchemas();
    }

    public static void HydraTask_createDiscTables() {
        sqlTxClientTest.createDiscTables();
    }

    public static void HydraTask_setTableCols() {
        sqlTxClientTest.setTableCols();
    }

    @Override
    protected void setTableCols() {
        Connection gConn = this.getGFXDClientTxConnection();
        SQLDistTxClientTest.setTableCols(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_initConnections() throws SQLException {
        sqlTxClientTest.initThreadLocalConnection();
    }

    @Override
    protected void initThreadLocalConnection() throws SQLException {
        Connection gfxdConn = this.getGFXDClientConnection();
        this.log().info("gfxdNoneTxConn isolation is set to 0 and getTransactionIsolation() is " + gfxdConn.getTransactionIsolation());
        gfxdNoneTxConn.set((Object)gfxdConn);
    }

    public static void HydraTask_initThreadLocals() {
        sqlTxClientTest.initThreadLocals();
    }

    public static void HydraTask_setCriticalHeapPercentage() {
        sqlTxClientTest.setCriticalHeapPercentage();
    }

    public static void HydraTask_createNewTables() {
        sqlTxClientTest.createNewTables();
    }

    @Override
    protected void createNewTables() {
        sqlTxClientTest.addCustomerV1Table();
        sqlTxClientTest.addNetworthV1Table();
        SQLTxBB.getBB().getSharedCounters().increment(SQLTxBB.iterations);
    }

    public static void HydraTask_alterCustomersTableGenerateAlways() {
        sqlTxClientTest.alterCustomersTableGenerateAlways();
    }

    @Override
    protected void alterCustomersTableGenerateAlways() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDClientTxConnection();
        try {
            if (addGenIdColInCustomersv1) {
                this.alterCustomersAddGenId(dConn, gConn);
                this.updateGenIdCol(dConn, gConn);
            }
            this.alterCustomersTableGenerateAlways(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.closeGFEConnection(gConn);
    }

    @Override
    protected void setCriticalHeapPercentage() {
        Connection gConn = this.getGFXDClientTxConnection();
        this.setCriticalHeapPercentage(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_populateTxTables() {
        sqlTxClientTest.populateTxTables();
    }

    @Override
    protected void populateTxTables() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Properties info = new Properties();
        info.setProperty(syncCommits, "true");
        Connection gConn = this.getGFXDClientTxConnection(info);
        this.populateTables(dConn, gConn);
        this.commit(gConn);
        this.commit(dConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_verifyResultSets() {
        sqlTxClientTest.verifyResultSets();
    }

    @Override
    protected void verifyResultSets() {
        if (!hasDerbyServer) {
            Log.getLogWriter().info("skipping verification of query results due to manageDerbyServer as false, myTid=" + this.getMyTid());
            this.cleanConnection(this.getGFEConnection());
            return;
        }
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFXDClientTxConnection();
        this.verifyResultSets(dConn, gConn);
    }

    public static void HydraTask_doDMLOp() {
        sqlTxClientTest.doDMLOp();
    }

    @Override
    protected void doDMLOp() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFXDClientTxConnection();
        this.doDMLOp(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        try {
            Log.getLogWriter().info("commit the gfxd txn again");
            gConn.commit();
        }
        catch (SQLException se) {
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return;
            }
            if (isHATest && se.getSQLState().equals("08003")) {
                Log.getLogWriter().info("connection has been closed -- this could happen when txn HA support is not ready and a new connection has been acquired, continue testing");
                Log.getLogWriter().info("done dmlOp");
                return;
            }
            SQLHelper.handleSQLException(se);
        }
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done dmlOp");
    }

    public static void HydraTask_createIndex() {
        sqlTxClientTest.createIndex();
    }

    @Override
    protected void createIndex() {
        Connection gConn = random.nextBoolean() ? this.getGFXDClientConnection() : this.getGFXDClientTxConnection();
        this.createTxIndex(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_setInitialData() {
        sqlTxClientTest.setInitialData();
    }

    @Override
    protected void setInitialData() {
        Connection gConn = this.getGFXDClientTxConnection();
        this.setInitialData(gConn);
        int maxCid = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary);
        Log.getLogWriter().info("maxCid in the test is " + maxCid);
        concUpdateTxMaxCid = (int)SQLTxBB.getBB().getSharedCounters().add(SQLTxBB.concUpdateTxMaxCid, (long)maxCid);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_concUpdateTx() {
        sqlTxClientTest.concUpdateTx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void concUpdateTx() {
        Connection gConn = this.getGFXDClientTxConnection();
        int num = 3;
        int count = 0;
        Object object = lock;
        synchronized (object) {
            ++concUpdateCount;
            count = concUpdateCount--;
        }
        if (count < num) {
            gConn = this.concUpdateTx(gConn);
            object = lock;
            synchronized (object) {
            }
        }
        object = lock;
        synchronized (object) {
            --concUpdateCount;
        }
        this.doDMLGfxdOnlyOps(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_verifyConcUpdateTx() {
        sqlTxClientTest.verifyConcUpdateTx();
    }

    @Override
    protected void verifyConcUpdateTx() {
        Connection gConn = this.getGFXDClientTxConnection();
        if (isTicket43909fixed) {
            this.verifyConcUpdateTx(gConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_useUpdatableResultSetForInit() {
        sqlTxClientTest.useUpdatableResultSet(true);
    }

    public static void HydraTask_useUpdatableResultSet() {
        sqlTxClientTest.useUpdatableResultSet(false);
    }

    @Override
    protected void useUpdatableResultSet(boolean isInitTask) {
        Connection gConn = this.getGFXDClientTxConnection();
        if (isTicket43935Fixed) {
            this.useUpdatableResultSet(gConn, isInitTask);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_useScrollableUpdatableResultSet() {
        sqlTxClientTest.useScrollableUpdatableResultSet();
    }

    @Override
    protected void useScrollableUpdatableResultSet() {
        Connection gConn = this.getGFXDClientTxConnection();
        if (isTicket43932Fixed && isTicket45071fixed) {
            this.useScrollableUpdatableResultSet(gConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_useNonScrollableUpdatableResultSet() {
        sqlTxClientTest.useNonScrollableUpdatableResultSet();
    }

    @Override
    protected void useNonScrollableUpdatableResultSet() {
        Connection gConn = this.getGFXDClientTxConnection();
        if (isTicket43935Fixed) {
            this.useNonScrollableUpdatableResultSet(gConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_verifyUpdatbleRsTx() {
        sqlTxClientTest.verifyUpdatbleRsTx();
    }

    @Override
    protected void verifyUpdatbleRsTx() {
        Connection gConn = this.getGFXDClientTxConnection();
        this.verifyUpdatbleRsTx(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_useSelectForUpdateTx() {
        sqlTxClientTest.useSelectForUpdateTx();
    }

    @Override
    protected void useSelectForUpdateTx() {
        Connection gConn = this.getGFXDClientTxConnection();
        this.useSelectForUpdateTx(gConn);
        this.closeGFEConnection(gConn);
    }

    @Override
    protected boolean updateSelectForUpdateTx(Connection conn, int tid, int lowCid, int highCid) {
        try {
            Statement s = isTicket41738Fixed ? conn.createStatement() : conn.createStatement(1003, 1008);
            s.setCursorName("updateCursor");
            String sql = "select * from trade.networth where cid > " + lowCid + " and cid <= " + highCid + " FOR UPDATE OF securities";
            Log.getLogWriter().info(sql);
            ResultSet updatableRs = s.executeQuery(sql);
            PreparedStatement psCurrentOf = null;
            PreparedStatement psPK = null;
            if (isTicket41738Fixed) {
                psCurrentOf = conn.prepareStatement("update trade.networth set securities = securities + ?  where current of updateCursor");
            }
            psPK = conn.prepareStatement("update trade.networth set securities = securities + ?  where cid = ? ");
            boolean success = false;
            if (isTicket41738Fixed && isTicket43188Fixed) {
                success = this.updateSelectForUpdateTx(updatableRs, psCurrentOf, tid);
                updatableRs.close();
                return success;
            }
            if (random.nextBoolean()) {
                success = this.updateSelectForUpdatePKTx(updatableRs, psPK, tid);
                updatableRs.close();
                return success;
            }
            if (!isTicket43188Fixed) {
                success = this.updateSelectForUpdatePKTx(updatableRs, psPK, tid);
                updatableRs.close();
                return success;
            }
            success = this.updateSelectForUpdateRsTx(updatableRs, tid);
            updatableRs.close();
            return success;
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z02")) {
                SQLHelper.printSQLException(se);
                return false;
            }
            SQLHelper.handleSQLException(se);
            return true;
        }
    }

    public static void HydraTask_checkConstraints() {
        sqlTxClientTest.checkConstraints();
    }

    @Override
    protected void checkConstraints() {
        Connection gConn = this.getGFXDClientTxConnection();
        this.checkUniqConstraints(gConn);
        this.checkFKConstraints(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    @Override
    protected boolean commitGfxdOnly(Connection conn) {
        if (this.batchingWithSecondaryData || isHATest) {
            try {
                Log.getLogWriter().info("committing the ops for gfxd");
                conn.commit();
            }
            catch (SQLException se) {
                if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                    Log.getLogWriter().info("detected expected conflict during commit due to batching, continuing test");
                    return false;
                }
                if (SQLHelper.gotTXNodeFailureException(se) && isHATest) {
                    this.log().info("commit failed in gfxd due to node failure " + se + "(" + se.getSQLState() + ")", (Throwable)se);
                    return false;
                }
                SQLHelper.handleSQLException(se);
            }
        } else {
            super.commit(conn);
        }
        return true;
    }

    public static void HydraTask_cycleStoreVms() {
        if (cycleVms) {
            sqlTxClientTest.cycleStoreVms();
        }
    }

    @Override
    protected List<ClientVmInfo> stopStartVMs(int numToKill) {
        if (useGemFireXDHA) {
            return this.stopStartVMs(numToKill, "server");
        }
        return this.stopStartVMs(numToKill, "store");
    }

    private Connection getGFXDClientTxConnection(Properties info) {
        Connection conn = null;
        try {
            conn = useC3P0 && useGfxdConfig ? PooledConnectionC3P0.getRCConnection(info) : (useDBCP && useGfxdConfig ? PooledConnectionDBCP.getRCConnection(info) : (useTomcatConnPool && useGfxdConfig ? PooledConnectionTomcat.getRCConnection(info) : GFEDBClientManager.getTxConnection(info)));
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    static {
        isTicket43188Fixed = false;
        lock = new Object();
        concUpdateCount = 0;
        useGemFireXDHA = TestConfig.tab().booleanAt(SQLPrms.useGemFireXDHA, false);
    }
}

