/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlTx.thinClient.repeatableRead;

import hydra.ClientVmInfo;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.Prms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.gemfirexd.GfxdConfigPrms;
import hydra.gemfirexd.NetworkServerHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import sql.GFEDBClientManager;
import sql.GFEDBManager;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.dmlStatements.AbstractDMLStmt;
import sql.sqlTx.SQLDistRRTxTest;
import sql.sqlutil.PooledConnectionC3P0;
import sql.sqlutil.PooledConnectionDBCP;
import sql.sqlutil.PooledConnectionTomcat;
import util.PRObserver;
import util.TestException;
import util.TestHelper;

public class RRTxClientTest
extends SQLDistRRTxTest {
    protected static RRTxClientTest rrClientTest;
    public static boolean useGemFireXDHA;

    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startAndConnectLocatorTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void stopLocatorTask() {
        DistributedSystemHelper.stopLocator();
    }

    public static synchronized void HydraTask_initializeServer() {
        if (rrClientTest == null) {
            rrClientTest = new RRTxClientTest();
        }
        PRObserver.installObserverHook();
        PRObserver.initialize((int)RemoteTestModule.getMyVmid());
        RRTxClientTest.initializeParams();
    }

    public static synchronized void HydraTask_initClient() {
        if (rrClientTest == null) {
            rrClientTest = new RRTxClientTest();
        }
        hasDerbyServer = TestConfig.tab().booleanAt(Prms.manageDerbyServer, false);
        testUniqueKeys = TestConfig.tab().booleanAt(SQLPrms.testUniqueKeys, true);
        randomData = TestConfig.tab().booleanAt(SQLPrms.randomData, false);
        isSerial = TestConfig.tab().booleanAt(Prms.serialExecution, false);
        isSingleDMLThread = TestConfig.tab().booleanAt(SQLPrms.isSingleDMLThread, false);
        usingTrigger = TestConfig.tab().booleanAt(SQLPrms.usingTrigger, false);
        queryAnyTime = TestConfig.tab().booleanAt(SQLPrms.queryAnyTime, true);
        hasNetworth = TestConfig.tab().booleanAt(SQLPrms.hasNetworth, false);
        isEdge = true;
    }

    private static void initializeParams() {
        hasDerbyServer = TestConfig.tab().booleanAt(Prms.manageDerbyServer, false);
        testUniqueKeys = TestConfig.tab().booleanAt(SQLPrms.testUniqueKeys, true);
        randomData = TestConfig.tab().booleanAt(SQLPrms.randomData, false);
        isSerial = TestConfig.tab().booleanAt(Prms.serialExecution, false);
        isSingleDMLThread = TestConfig.tab().booleanAt(SQLPrms.isSingleDMLThread, false);
        usingTrigger = TestConfig.tab().booleanAt(SQLPrms.usingTrigger, false);
        queryAnyTime = TestConfig.tab().booleanAt(SQLPrms.queryAnyTime, true);
        hasNetworth = TestConfig.tab().booleanAt(SQLPrms.hasNetworth, false);
    }

    public static synchronized void HydraTask_startFabricServer() {
        rrClientTest.startFabricServer();
    }

    public static synchronized void HydraTask_startNetworkServer() {
        String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
        NetworkServerHelper.startNetworkServers(networkServerConfig);
    }

    public static synchronized void HydraTask_stopFabricServer() {
        rrClientTest.stopFabricServer();
    }

    public static void HydraTask_createGfxdSchemasByClients() {
        rrClientTest.createGfxdSchemasByClients();
    }

    protected void createGfxdSchemasByClients() {
        Connection conn = this.getGFXDClientRRTxConnection();
        Log.getLogWriter().info("creating schema in gfxd.");
        if (!testServerGroupsInheritence) {
            this.createSchemas(conn);
        } else {
            String[] schemas = SQLPrms.getGFESchemas();
            this.createSchemas(conn, schemas);
        }
        Log.getLogWriter().info("done creating schema in gfxd.");
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_createGfxdTablesByClients() {
        rrClientTest.createGfxdTablesByClients();
    }

    protected void createGfxdTablesByClients() {
        Connection conn = this.getGFXDClientRRTxConnection();
        Log.getLogWriter().info("creating tables in gfxd.");
        this.createTables(conn);
        Log.getLogWriter().info("done creating tables in gfxd.");
        this.closeGFEConnection(conn);
    }

    protected Connection getGFXDClientTxConnection() {
        Connection conn = null;
        try {
            conn = GFEDBClientManager.getTxConnection(GFEDBManager.Isolation.READ_COMMITTED);
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get the connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected Connection getGFXDClientRRTxConnection() {
        Connection conn = null;
        boolean retry = false;
        do {
            try {
                conn = useC3P0 && useGfxdConfig ? PooledConnectionC3P0.getRRConnection() : (useDBCP && useGfxdConfig ? PooledConnectionDBCP.getRRConnection() : (useTomcatConnPool && useGfxdConfig ? PooledConnectionTomcat.getRRConnection() : GFEDBClientManager.getTxConnection(GFEDBManager.Isolation.REPEATABLE_READ)));
                retry = false;
            }
            catch (SQLException e) {
                SQLHelper.printSQLException(e);
                if (AbstractDMLStmt.gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(e)) {
                    retry = true;
                    Log.getLogWriter().info("Could not get connection due to Node failure and will retry, continue testing");
                    continue;
                }
                throw new TestException("Not able to get the connection " + TestHelper.getStackTrace((Throwable)e));
            }
        } while (retry);
        return conn;
    }

    @Override
    protected Connection getNewGfxdConnection() {
        return this.getGFXDClientRRTxConnection();
    }

    public static void HydraTask_createDiscDB() {
        rrClientTest.createDiscDB();
    }

    public static void HydraTask_createDiscSchemas() {
        rrClientTest.createDiscSchemas();
    }

    public static void HydraTask_createDiscTables() {
        rrClientTest.createDiscTables();
    }

    public static void HydraTask_setTableCols() {
        rrClientTest.setTableCols();
    }

    @Override
    protected void setTableCols() {
        Connection gConn = this.getGFXDClientRRTxConnection();
        RRTxClientTest.setTableCols(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_initConnections() {
        rrClientTest.initThreadLocalConnection();
    }

    @Override
    protected void initThreadLocalConnection() {
        Connection gfxdConn = this.getGFXDClientConnection();
        gfxdNoneTxConn.set((Object)gfxdConn);
    }

    public static void HydraTask_initThreadLocals() {
        rrClientTest.initThreadLocals();
    }

    public static void HydraTask_populateTxTables() {
        rrClientTest.populateTxTables();
    }

    @Override
    protected void populateTxTables() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Properties info = new Properties();
        info.setProperty(syncCommits, "true");
        Connection gConn = this.getGFXDClientRRTxConnection(info);
        this.populateTables(dConn, gConn);
        this.commit(gConn);
        this.commit(dConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_verifyResultSets() {
        rrClientTest.verifyResultSets();
    }

    @Override
    protected void verifyResultSets() {
        if (!hasDerbyServer) {
            Log.getLogWriter().info("skipping verification of query results due to manageDerbyServer as false, myTid=" + this.getMyTid());
            this.cleanConnection(this.getGFEConnection());
            return;
        }
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFXDClientRRTxConnection();
        this.verifyResultSets(dConn, gConn);
    }

    public static void HydraTask_doDMLOp() {
        rrClientTest.doDMLOp();
    }

    @Override
    protected void doDMLOp() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = null;
        if (mixRR_RC && random.nextBoolean()) {
            gConn = this.getGFXDClientTxConnection();
            this.doDMLOp(dConn, gConn, false);
        } else {
            gConn = this.getGFXDClientRRTxConnection();
            this.doDMLOp(dConn, gConn, true);
        }
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done dmlOp");
    }

    public static void HydraTask_createIndex() {
        rrClientTest.createIndex();
    }

    @Override
    protected void createIndex() {
        Connection gConn = random.nextBoolean() ? this.getGFXDClientConnection() : this.getGFXDClientRRTxConnection();
        this.createRRTxIndex(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_checkConstraints() {
        rrClientTest.checkConstraints();
    }

    @Override
    protected void checkConstraints() {
        Connection gConn = this.getGFXDClientRRTxConnection();
        this.checkUniqConstraints(gConn);
        this.checkFKConstraints(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_checkRRKeys() {
        rrClientTest.checkRRKeys();
    }

    @Override
    protected void checkRRKeys() {
        if (this.getMyTid() % 3 != 0 && random.nextInt(20) != 1) {
            Log.getLogWriter().info("do dml ops instead of checking repeatable read keys");
            this.doDMLOp();
            return;
        }
        Connection gConn = this.getGFXDClientRRTxConnection();
        this.checkRRKeys(gConn);
        this.commitRRGfxdOnly(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_cycleStoreVms() {
        if (cycleVms) {
            rrClientTest.cycleStoreVms();
        }
    }

    @Override
    protected List<ClientVmInfo> stopStartVMs(int numToKill) {
        if (useGemFireXDHA) {
            return this.stopStartVMs(numToKill, "server");
        }
        return this.stopStartVMs(numToKill, "store");
    }

    protected Connection getGFXDClientRRTxConnection(Properties info) {
        Connection conn = null;
        try {
            conn = useC3P0 && useGfxdConfig ? PooledConnectionC3P0.getRRConnection(info) : (useDBCP && useGfxdConfig ? PooledConnectionDBCP.getRRConnection(info) : (useTomcatConnPool && useGfxdConfig ? PooledConnectionTomcat.getRRConnection(info) : GFEDBClientManager.getRRTxConnection(info)));
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    static {
        useGemFireXDHA = TestConfig.tab().booleanAt(SQLPrms.useGemFireXDHA, false);
    }
}

