/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlutil;

import sql.joinStatements.AbstractJoinStmt;
import sql.subqueryStatements.CustPortfSoSubqueryStmt;
import sql.subqueryStatements.CustomersNetworthSubqueryStmt;
import sql.subqueryStatements.CustomersSecuritiesPortfolioSubqueryStmt;
import sql.subqueryStatements.MultiTablesSubqueryStmt;
import sql.subqueryStatements.SecuritiesPortfolioSubqueryStmt;
import sql.subqueryStatements.SubqueryStmtIF;
import util.TestException;

public class ColocatedSubqueryStmtsFactory {
    public static final int TRADE_CUSTOMERS_NETWORTH = 1;
    public static final int TRADE_SECURITIES_PORTFOLIO = 2;
    public static final int TRADE_CUSTOMERS_SECURITIES_PORTFOLIO = 3;
    public static final int TRADE_CUSTOMERS_PORTFOLIO_SELLORDERS = 4;
    public static final int TRADE_MULTITABLES = 5;

    public SubqueryStmtIF createQueryStmt(int whichSubquery) {
        AbstractJoinStmt subqueryStmtIF;
        switch (whichSubquery) {
            case 1: {
                subqueryStmtIF = new CustomersNetworthSubqueryStmt();
                break;
            }
            case 2: {
                subqueryStmtIF = new SecuritiesPortfolioSubqueryStmt();
                break;
            }
            case 3: {
                subqueryStmtIF = new CustomersSecuritiesPortfolioSubqueryStmt();
                break;
            }
            case 4: {
                subqueryStmtIF = new CustPortfSoSubqueryStmt();
                break;
            }
            case 5: {
                subqueryStmtIF = new MultiTablesSubqueryStmt();
                break;
            }
            default: {
                throw new TestException("Unknown operation " + whichSubquery);
            }
        }
        return subqueryStmtIF;
    }

    public static int getInt(String subquery) {
        int whichSubquery = -1;
        if (subquery.equalsIgnoreCase("trade.customers_networth")) {
            whichSubquery = 1;
        } else if (subquery.equalsIgnoreCase("trade.securities_portfolio")) {
            whichSubquery = 2;
        } else if (subquery.equalsIgnoreCase("trade.customers_securities_portfolio")) {
            whichSubquery = 3;
        } else if (subquery.equalsIgnoreCase("trade.customers_portfolio_sellorders")) {
            whichSubquery = 4;
        } else if (subquery.equalsIgnoreCase("trade.multitables")) {
            whichSubquery = 5;
        }
        return whichSubquery;
    }
}

