/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlutil;

import sql.ddlStatements.AuthorizationDDLStmt;
import sql.ddlStatements.DAPDDLStmt;
import sql.ddlStatements.DDLStmtIF;
import sql.ddlStatements.FunctionDDLStmt;
import sql.ddlStatements.ProcedureDDLStmt;
import util.TestException;

public class DDLStmtsFactory {
    public static final int PROCEDURE = 1;
    public static final int AUTHORIZATION = 2;
    public static final int FUNCTION = 3;
    public static final int DAP = 4;

    public DDLStmtIF createDDLStmt(int whichDDL) {
        DDLStmtIF ddlStmtIF;
        switch (whichDDL) {
            case 1: {
                ddlStmtIF = new ProcedureDDLStmt();
                break;
            }
            case 2: {
                ddlStmtIF = new AuthorizationDDLStmt();
                break;
            }
            case 3: {
                ddlStmtIF = new FunctionDDLStmt();
                break;
            }
            case 4: {
                ddlStmtIF = new DAPDDLStmt();
                break;
            }
            default: {
                throw new TestException("Unknown operation " + whichDDL);
            }
        }
        return ddlStmtIF;
    }

    public static int getInt(String ddl) {
        int whichDDL = -1;
        if (ddl.equalsIgnoreCase("procedure")) {
            whichDDL = 1;
        } else if (ddl.equalsIgnoreCase("authorization")) {
            whichDDL = 2;
        } else if (ddl.equalsIgnoreCase("function")) {
            whichDDL = 3;
        } else if (ddl.equalsIgnoreCase("dap")) {
            whichDDL = 4;
        }
        return whichDDL;
    }
}

