/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlutil;

import sql.SQLTest;
import sql.dmlStatements.AbstractDMLStmt;
import sql.dmlStatements.DMLStmtIF;
import sql.dmlStatements.EmpDepartmentDMLStmt;
import sql.dmlStatements.EmpEmployeesDMLStmt;
import sql.dmlStatements.TradeBuyOrdersDMLStmt;
import sql.dmlStatements.TradeCompaniesDMLStmt;
import sql.dmlStatements.TradeCustomerProfileDMLStmt;
import sql.dmlStatements.TradeCustomersDMLStmt;
import sql.dmlStatements.TradeNetworthDMLStmt;
import sql.dmlStatements.TradePortfolioDMLStmt;
import sql.dmlStatements.TradePortfolioV1DMLStmt;
import sql.dmlStatements.TradeSecuritiesDMLStmt;
import sql.dmlStatements.TradeSellOrdersDMLStmt;
import sql.dmlStatements.TradeSellOrdersDupDMLStmt;
import sql.dmlStatements.TradeTxHistoryDMLStmt;
import sql.dmlStatements.json.TradeBuyOrderDMLStmtJson;
import sql.dmlStatements.json.TradeCustomersDMLStmtJson;
import sql.dmlStatements.json.TradeNetworthDMLStmtJson;
import sql.dmlStatements.json.TradeSecuritiesDMLStmtJson;
import sql.dmlStatements.writer.TradeBuyOrdersWriterDMLStmt;
import sql.dmlStatements.writer.TradeCustomersWriterDMLStmt;
import sql.dmlStatements.writer.TradeNetworthWriterDMLStmt;
import sql.dmlStatements.writer.TradePortfolioV1WriterDMLStmt;
import sql.dmlStatements.writer.TradePortfolioWriterDMLStmt;
import sql.dmlStatements.writer.TradeSecuritiesWriterDMLStmt;
import sql.dmlStatements.writer.TradeSellOrdersWriterDMLStmt;
import sql.dmlStatements.writer.TradeTxHistoryWriterDMLStmt;
import sql.sqlDisk.dmlStatements.TradeBuyOrdersDiscDMLStmt;
import sql.sqlDisk.dmlStatements.TradeCompaniesDiscDMLStmt;
import sql.sqlDisk.dmlStatements.TradeCustomersDiscDMLStmt;
import sql.sqlDisk.dmlStatements.TradeNetworthDiscDMLStmt;
import sql.sqlDisk.dmlStatements.TradePortfolioDiscDMLStmt;
import sql.sqlDisk.dmlStatements.TradePortfolioV1DiscDMLStmt;
import sql.sqlDisk.dmlStatements.TradeSecuritiesDiscDMLStmt;
import sql.sqlDisk.dmlStatements.TradeSellOrdersDiscDMLStmt;
import sql.sqlDisk.dmlStatements.TradeTxHistoryDiscDMLStmt;
import util.TestException;

public class DMLStmtsFactory {
    public static final int TRADE_CUSTOMERS = 1;
    public static final int TRADE_SECURITIES = 2;
    public static final int TRADE_PORTFOLIO = 3;
    public static final int TRADE_NETWORTH = 4;
    public static final int TRADE_SELLORDERS = 5;
    public static final int TRADE_BUYORDERS = 6;
    public static final int TRADE_TXHISTORY = 7;
    public static final int EMP_DEPARTMENT = 8;
    public static final int EMP_EMPLOYEES = 9;
    public static final int TRADE_CUSTOMERPROFILE = 10;
    public static final int TRADE_SELLORDERSDUP = 11;
    public static final int TRADE_COMPANIES = 12;
    public static final int TRADE_PORTFOLIOV1 = 13;

    public DMLStmtIF createDMLStmt(int whichTable) {
        AbstractDMLStmt dmlStmtIF;
        switch (whichTable) {
            case 1: {
                if (SQLTest.hasJSON) {
                    dmlStmtIF = new TradeCustomersDMLStmtJson();
                    break;
                }
                dmlStmtIF = new TradeCustomersDMLStmt();
                break;
            }
            case 2: {
                if (SQLTest.hasJSON) {
                    dmlStmtIF = new TradeSecuritiesDMLStmtJson();
                    break;
                }
                dmlStmtIF = new TradeSecuritiesDMLStmt();
                break;
            }
            case 3: {
                dmlStmtIF = new TradePortfolioDMLStmt();
                break;
            }
            case 4: {
                if (SQLTest.hasJSON) {
                    dmlStmtIF = new TradeNetworthDMLStmtJson();
                    break;
                }
                dmlStmtIF = new TradeNetworthDMLStmt();
                break;
            }
            case 5: {
                dmlStmtIF = new TradeSellOrdersDMLStmt();
                break;
            }
            case 6: {
                if (SQLTest.hasJSON) {
                    dmlStmtIF = new TradeBuyOrderDMLStmtJson();
                    break;
                }
                dmlStmtIF = new TradeBuyOrdersDMLStmt();
                break;
            }
            case 7: {
                dmlStmtIF = new TradeTxHistoryDMLStmt();
                break;
            }
            case 8: {
                dmlStmtIF = new EmpDepartmentDMLStmt();
                break;
            }
            case 9: {
                dmlStmtIF = new EmpEmployeesDMLStmt();
                break;
            }
            case 10: {
                dmlStmtIF = new TradeCustomerProfileDMLStmt();
                break;
            }
            case 11: {
                dmlStmtIF = new TradeSellOrdersDupDMLStmt();
                break;
            }
            case 12: {
                dmlStmtIF = new TradeCompaniesDMLStmt();
                break;
            }
            case 13: {
                dmlStmtIF = new TradePortfolioV1DMLStmt();
                break;
            }
            default: {
                throw new TestException("Unknown operation " + whichTable);
            }
        }
        return dmlStmtIF;
    }

    public DMLStmtIF createWriterDMLStmt(int whichTable) {
        AbstractDMLStmt dmlStmtIF;
        switch (whichTable) {
            case 1: {
                dmlStmtIF = new TradeCustomersWriterDMLStmt();
                break;
            }
            case 2: {
                dmlStmtIF = new TradeSecuritiesWriterDMLStmt();
                break;
            }
            case 3: {
                dmlStmtIF = new TradePortfolioWriterDMLStmt();
                break;
            }
            case 4: {
                dmlStmtIF = new TradeNetworthWriterDMLStmt();
                break;
            }
            case 5: {
                dmlStmtIF = new TradeSellOrdersWriterDMLStmt();
                break;
            }
            case 6: {
                dmlStmtIF = new TradeBuyOrdersWriterDMLStmt();
                break;
            }
            case 7: {
                dmlStmtIF = new TradeTxHistoryWriterDMLStmt();
                break;
            }
            case 13: {
                dmlStmtIF = new TradePortfolioV1WriterDMLStmt();
                break;
            }
            default: {
                throw new TestException("Unknown operation " + whichTable);
            }
        }
        return dmlStmtIF;
    }

    public DMLStmtIF createDiscDMLStmt(int whichTable) {
        AbstractDMLStmt dmlStmtIF;
        switch (whichTable) {
            case 1: {
                dmlStmtIF = new TradeCustomersDiscDMLStmt();
                break;
            }
            case 2: {
                dmlStmtIF = new TradeSecuritiesDiscDMLStmt();
                break;
            }
            case 3: {
                dmlStmtIF = new TradePortfolioDiscDMLStmt();
                break;
            }
            case 4: {
                dmlStmtIF = new TradeNetworthDiscDMLStmt();
                break;
            }
            case 5: {
                dmlStmtIF = new TradeSellOrdersDiscDMLStmt();
                break;
            }
            case 6: {
                dmlStmtIF = new TradeBuyOrdersDiscDMLStmt();
                break;
            }
            case 7: {
                dmlStmtIF = new TradeTxHistoryDiscDMLStmt();
                break;
            }
            case 12: {
                dmlStmtIF = new TradeCompaniesDiscDMLStmt();
                break;
            }
            case 13: {
                dmlStmtIF = new TradePortfolioV1DiscDMLStmt();
                break;
            }
            default: {
                throw new TestException("Unknown operation " + whichTable);
            }
        }
        return dmlStmtIF;
    }

    public static int getInt(String tableName) {
        int whichTable = -1;
        if (tableName.equalsIgnoreCase("trade.customers")) {
            whichTable = 1;
        } else if (tableName.equalsIgnoreCase("trade.securities")) {
            whichTable = 2;
        } else if (tableName.equalsIgnoreCase("trade.portfolio")) {
            whichTable = 3;
        } else if (tableName.equalsIgnoreCase("trade.networth")) {
            whichTable = 4;
        } else if (tableName.equalsIgnoreCase("trade.sellorders")) {
            whichTable = 5;
        } else if (tableName.equalsIgnoreCase("trade.buyorders")) {
            whichTable = 6;
        } else if (tableName.equalsIgnoreCase("trade.txhistory")) {
            whichTable = 7;
        } else if (tableName.equalsIgnoreCase("emp.department")) {
            whichTable = 8;
        } else if (tableName.equalsIgnoreCase("emp.employees")) {
            whichTable = 9;
        } else if (tableName.equalsIgnoreCase("trade.customerprofile")) {
            whichTable = 10;
        } else if (tableName.equalsIgnoreCase("trade.sellordersdup")) {
            whichTable = 11;
        } else if (tableName.equalsIgnoreCase("trade.companies")) {
            whichTable = 12;
        } else if (tableName.equalsIgnoreCase("trade.portfoliov1")) {
            whichTable = 13;
        }
        return whichTable;
    }
}

