/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlutil;

import sql.dmlStatements.AbstractDMLStmt;
import sql.dmlTxStatements.DMLTxStmtIF;
import sql.dmlTxStatements.TradeBuyOrdersDMLTxStmt;
import sql.dmlTxStatements.TradeCustomersDMLTxStmt;
import sql.dmlTxStatements.TradeNetworthDMLTxStmt;
import sql.dmlTxStatements.TradePortfolioDMLTxStmt;
import sql.dmlTxStatements.TradeSecuritiesDMLTxStmt;
import sql.dmlTxStatements.TradeSellOrdersDMLTxStmt;
import sql.dmlTxStatements.TradeTxHistoryDMLTxStmt;
import util.TestException;

public class DMLTxStmtsFactory {
    public static final int TRADE_CUSTOMERS = 1;
    public static final int TRADE_SECURITIES = 2;
    public static final int TRADE_PORTFOLIO = 3;
    public static final int TRADE_NETWORTH = 4;
    public static final int TRADE_SELLORDERS = 5;
    public static final int TRADE_BUYORDERS = 6;
    public static final int TRADE_TXHISTORY = 7;

    public DMLTxStmtIF createDMLTxStmt(int whichTable) {
        AbstractDMLStmt dmlStmtIF = null;
        switch (whichTable) {
            case 1: {
                dmlStmtIF = new TradeCustomersDMLTxStmt();
                break;
            }
            case 2: {
                dmlStmtIF = new TradeSecuritiesDMLTxStmt();
                break;
            }
            case 3: {
                dmlStmtIF = new TradePortfolioDMLTxStmt();
                break;
            }
            case 4: {
                dmlStmtIF = new TradeNetworthDMLTxStmt();
                break;
            }
            case 5: {
                dmlStmtIF = new TradeSellOrdersDMLTxStmt();
                break;
            }
            case 6: {
                dmlStmtIF = new TradeBuyOrdersDMLTxStmt();
                break;
            }
            case 7: {
                dmlStmtIF = new TradeTxHistoryDMLTxStmt();
                break;
            }
            default: {
                throw new TestException("Unknown operation " + whichTable);
            }
        }
        return dmlStmtIF;
    }

    public static int getInt(String tableName) {
        int whichTable = -1;
        if (tableName.equalsIgnoreCase("trade.customers")) {
            whichTable = 1;
        } else if (tableName.equalsIgnoreCase("trade.securities")) {
            whichTable = 2;
        } else if (tableName.equalsIgnoreCase("trade.portfolio")) {
            whichTable = 3;
        } else if (tableName.equalsIgnoreCase("trade.networth")) {
            whichTable = 4;
        } else if (tableName.equalsIgnoreCase("trade.sellorders")) {
            whichTable = 5;
        } else if (tableName.equalsIgnoreCase("trade.buyorders")) {
            whichTable = 6;
        } else if (tableName.equalsIgnoreCase("trade.txhistory")) {
            whichTable = 7;
        }
        return whichTable;
    }
}

