/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlutil;

import hydra.Log;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import sql.SQLBB;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlStatements.AbstractDMLStmt;
import sql.dmlTxStatements.DMLTxStmtIF;
import sql.sqlutil.DMLTxStmtsFactory;

public class GFXDTxHelper {
    private static ArrayList<Integer>[] tidListArray;
    private static HashMap<Integer, Integer> tidListMap;
    private static String partitionByList;
    private static ArrayList<int[]> cidRangeList;
    private static String partitionByRange;

    public static String getTidListPartition() {
        if (partitionByList == null) {
            GFXDTxHelper.setTidListPartition();
        }
        return partitionByList;
    }

    public static String getCidRangePartition() {
        if (partitionByRange == null) {
            int totalCid = (int)TestConfig.tab().longAt(SQLPrms.totalCids, 10000L);
            GFXDTxHelper.setCidRangePartition(totalCid);
        }
        return partitionByRange;
    }

    private static void setTidListPartition() {
        GFXDTxHelper.setTidListArray(SQLTest.numOfStores, SQLTest.numOfWorkers);
        SQLBB.getBB().getSharedMap().put((Object)"tidListArray", tidListArray);
        GFXDTxHelper.setTidListMap();
        SQLBB.getBB().getSharedMap().put((Object)"tidListMap", tidListMap);
        StringBuffer str = new StringBuffer();
        str.append('(');
        for (int i = 0; i < tidListArray.length; ++i) {
            str.append("VALUES (");
            for (Integer tid : tidListArray[i]) {
                str.append(tid);
                str.append(", ");
            }
            str.delete(str.lastIndexOf(", "), str.length());
            str.append("), ");
        }
        str.delete(str.lastIndexOf(", "), str.length());
        str.append(") ");
        Log.getLogWriter().info("string is " + str.toString());
        partitionByList = str.toString();
    }

    private static void setTidListArray(int size, int numWorkers) {
        tidListArray = new ArrayList[size];
        ArrayList<Integer> seed = new ArrayList<Integer>();
        for (int i = 0; i < numWorkers; ++i) {
            seed.add(i);
        }
        int bucketSize = numWorkers / size;
        if (bucketSize == 0) {
            ++bucketSize;
        }
        for (int i = 0; i < size - 1; ++i) {
            GFXDTxHelper.tidListArray[i] = new ArrayList();
            for (int j = 0; j < bucketSize; ++j) {
                if (seed.size() <= 0) continue;
                tidListArray[i].add((Integer)seed.remove(SQLTest.random.nextInt(seed.size())));
            }
        }
        GFXDTxHelper.tidListArray[size - 1] = new ArrayList();
        tidListArray[size - 1].addAll(seed);
    }

    private static void setCidRangePartition(int totalCid) {
        GFXDTxHelper.setCidRange(SQLTest.numOfStores, totalCid);
        SQLBB.getBB().getSharedMap().put((Object)"cidRangeList", cidRangeList);
        StringBuffer str = new StringBuffer();
        str.append('(');
        for (int[] rangeBound : cidRangeList) {
            str.append("VALUES BETWEEN ");
            str.append(rangeBound[0]);
            str.append(" AND ");
            str.append(rangeBound[1]);
            str.append(", ");
        }
        str.delete(str.lastIndexOf(", "), str.length());
        str.append(") ");
        Log.getLogWriter().info("string is " + str.toString());
        partitionByRange = str.toString();
    }

    private static void setCidRange(int size, int totalCid) {
        int rangeSize = totalCid / size;
        cidRangeList = new ArrayList();
        int start = 0;
        int end = start + rangeSize;
        for (int i = 0; i < size; ++i) {
            int[] cidRange = new int[]{start, end};
            cidRangeList.add(cidRange);
            start = end;
            end = i < size - 2 ? start + rangeSize : totalCid;
        }
    }

    private static void setTidListMap() {
        tidListMap = new HashMap();
        for (int i = 0; i < tidListArray.length; ++i) {
            for (Integer tid : tidListArray[i]) {
                tidListMap.put(tid, i);
            }
        }
    }

    public static int getColocatedTid(String tableName, int tid) {
        if (tidListMap == null) {
            tidListMap = (HashMap)SQLBB.getBB().getSharedMap().get((Object)"tidListMap");
        }
        if (tidListArray == null) {
            tidListArray = (ArrayList[])SQLBB.getBB().getSharedMap().get((Object)"tidListArray");
        }
        int i = 0;
        i = GFXDTxHelper.isReplicate(tableName) ? tidListMap.get(SQLTest.random.nextInt(tid)).intValue() : tidListMap.get(tid).intValue();
        return tidListArray[i].get(SQLTest.random.nextInt(tidListArray[i].size()));
    }

    public static int getColocatedCid(String tableName, int cid) {
        if (GFXDTxHelper.isReplicate(tableName)) {
            return SQLTest.random.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary));
        }
        if (cidRangeList == null) {
            cidRangeList = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"cidRangeList");
        }
        int rangeSize = cidRangeList.get(0)[1];
        for (int[] rangeBound : cidRangeList) {
            if (cid < rangeBound[0] || cid >= rangeBound[1]) continue;
            return SQLTest.random.nextInt(rangeSize - AbstractDMLStmt.cidRangeForTxOp) + rangeBound[0];
        }
        return cidRangeList.get(cidRangeList.size() - 1)[1] + SQLTest.random.nextInt(200);
    }

    public static int[] getRangeEnds(String tableName, int cid) {
        int[] ends = new int[2];
        if (GFXDTxHelper.isReplicate(tableName)) {
            ends[0] = SQLTest.random.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary));
            ends[1] = ends[0] + 200;
        }
        if (cidRangeList == null) {
            cidRangeList = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"cidRangeList");
        }
        int rangeSize = cidRangeList.get(0)[1];
        for (int[] rangeBound : cidRangeList) {
            if (cid < rangeBound[0] || cid >= rangeBound[1]) continue;
            ends[0] = rangeBound[0];
            ends[1] = rangeBound[1];
            break;
        }
        if (cid > cidRangeList.get(cidRangeList.size() - 1)[1]) {
            ends[0] = cidRangeList.get(cidRangeList.size() - 1)[1];
            ends[1] = ends[0] + 200;
        }
        return ends;
    }

    public static boolean isReplicate(String tableName) {
        return SQLBB.getBB().getSharedMap().get((Object)(tableName + "replicate")) != null;
    }

    public static boolean isReplicate(int whichTable) {
        DMLTxStmtIF dmlTxStmt = new DMLTxStmtsFactory().createDMLTxStmt(whichTable);
        if (dmlTxStmt != null) {
            return GFXDTxHelper.isReplicate(dmlTxStmt.getMyTableName());
        }
        return false;
    }

    public static boolean isColocatedCid(String tableName, int txId, int key) {
        if (GFXDTxHelper.isReplicate(tableName)) {
            return true;
        }
        if (cidRangeList == null) {
            cidRangeList = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"cidRangeList");
        }
        int txIdCid = (Integer)SQLBB.getBB().getSharedMap().get((Object)(AbstractDMLStmt.cid_txId + txId));
        for (int[] rangeBound : cidRangeList) {
            if (key < rangeBound[0] || key >= rangeBound[1]) continue;
            return txIdCid >= rangeBound[0] && txIdCid < rangeBound[1];
        }
        return true;
    }
}

