/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlutil;

import sql.joinStatements.AbstractJoinStmt;
import sql.joinStatements.CustPortfSoJoinStmt;
import sql.joinStatements.CustomersNetworthJoinStmt;
import sql.joinStatements.CustomersSecuritiesPortfolioJoinStmt;
import sql.joinStatements.JoinTableStmtIF;
import sql.joinStatements.MultiTablesJoinStmt;
import sql.joinStatements.SecuritiesPortfolioJoinStmt;
import util.TestException;

public class JoinTableStmtsFactory {
    public static final int TRADE_CUSTOMERS_NETWORTH = 1;
    public static final int TRADE_SECURITIES_PORTFOLIO = 2;
    public static final int TRADE_CUSTOMERS_SECURITIES_PORTFOLIO = 3;
    public static final int TRADE_CUSTOMERS_PORTFOLIO_SELLORDERS = 4;
    public static final int TRADE_MULTITABLES = 5;

    public JoinTableStmtIF createQueryStmt(int whichJoin) {
        AbstractJoinStmt joinStmtIF;
        switch (whichJoin) {
            case 1: {
                joinStmtIF = new CustomersNetworthJoinStmt();
                break;
            }
            case 2: {
                joinStmtIF = new SecuritiesPortfolioJoinStmt();
                break;
            }
            case 3: {
                joinStmtIF = new CustomersSecuritiesPortfolioJoinStmt();
                break;
            }
            case 4: {
                joinStmtIF = new CustPortfSoJoinStmt();
                break;
            }
            case 5: {
                joinStmtIF = new MultiTablesJoinStmt();
                break;
            }
            default: {
                throw new TestException("Unknown operation " + whichJoin);
            }
        }
        return joinStmtIF;
    }

    public static int getInt(String joinTable) {
        int whichJoin = -1;
        if (joinTable.equalsIgnoreCase("trade.customers_networth")) {
            whichJoin = 1;
        } else if (joinTable.equalsIgnoreCase("trade.securities_portfolio")) {
            whichJoin = 2;
        } else if (joinTable.equalsIgnoreCase("trade.customers_securities_portfolio")) {
            whichJoin = 3;
        } else if (joinTable.equalsIgnoreCase("trade.customers_portfolio_sellorders")) {
            whichJoin = 4;
        } else if (joinTable.equalsIgnoreCase("trade.multitables")) {
            whichJoin = 5;
        }
        return whichJoin;
    }
}

