/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlutil;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import hydra.Log;
import hydra.TestConfig;
import hydra.gemfirexd.NetworkServerHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import sql.GFEDBClientManager;
import sql.GFEDBManager;
import sql.SQLPrms;
import util.TestException;
import util.TestHelper;

public class PooledConnectionC3P0
extends GFEDBClientManager {
    private static ComboPooledDataSource ds;
    private static Properties connProp;
    private static int numOfWorkers;

    public static Connection getConnection() throws SQLException {
        if (ds == null) {
            PooledConnectionC3P0.getDataSource(GFEDBManager.Isolation.NONE);
        }
        return ds.getConnection();
    }

    public static Connection getRCConnection() throws SQLException {
        if (ds == null) {
            PooledConnectionC3P0.getDataSource(GFEDBManager.Isolation.READ_COMMITTED);
        }
        return ds.getConnection();
    }

    public static Connection getRRConnection() throws SQLException {
        if (ds == null) {
            PooledConnectionC3P0.getDataSource(GFEDBManager.Isolation.REPEATABLE_READ);
        }
        return ds.getConnection();
    }

    public static Connection getRCConnection(Properties p) throws SQLException {
        if (ds == null) {
            connProp.putAll((Map<?, ?>)p);
            PooledConnectionC3P0.getDataSource(GFEDBManager.Isolation.READ_COMMITTED);
        }
        return ds.getConnection();
    }

    public static Connection getRRConnection(Properties p) throws SQLException {
        if (ds == null) {
            connProp.putAll((Map<?, ?>)p);
            PooledConnectionC3P0.getDataSource(GFEDBManager.Isolation.REPEATABLE_READ);
        }
        return ds.getConnection();
    }

    public static synchronized ComboPooledDataSource getDataSource(GFEDBManager.Isolation isolation) {
        if (ds == null) {
            PooledConnectionC3P0.setupDataSource(isolation);
        }
        return ds;
    }

    private static void setupDataSource(GFEDBManager.Isolation isolation) {
        ds = new ComboPooledDataSource();
        NetworkServerHelper.Endpoint locatorEndPoint = (NetworkServerHelper.Endpoint)NetworkServerHelper.getNetworkLocatorEndpoints().get(0);
        String hostname = PooledConnectionC3P0.getHostNameFromEndpoint(locatorEndPoint);
        int port = PooledConnectionC3P0.getPortFromEndpoint(locatorEndPoint);
        connProp.putAll((Map<?, ?>)PooledConnectionC3P0.getExtraConnProp());
        try {
            ds.setProperties(connProp);
            ds.setDriverClass(driver);
            ds.setJdbcUrl(protocol + hostname + ":" + port);
            ds.setMinPoolSize(5);
            ds.setAcquireIncrement(5);
            ds.setMaxPoolSize(numOfWorkers + 100);
            ds.setMaxStatementsPerConnection(10);
            if (isolation == GFEDBManager.Isolation.NONE) {
                ds.setConnectionCustomizerClassName("sql.sqlutil.MyConnectionCustomizer");
            } else if (isolation == GFEDBManager.Isolation.READ_COMMITTED) {
                ds.setConnectionCustomizerClassName("sql.sqlutil.IsolationRCConnectionCustomizer");
            } else {
                ds.setConnectionCustomizerClassName("sql.sqlutil.IsolationRRConnectionCustomizer");
            }
            Log.getLogWriter().info("Pooled data source url is set as " + ds.getJdbcUrl());
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Object, Object> entry : connProp.entrySet()) {
                sb.append((String)entry.getKey() + " is set to " + (String)entry.getValue() + "\n");
            }
            Log.getLogWriter().info("Pooled data source setting the following connection prop: " + sb.toString());
        }
        catch (Exception e) {
            throw new TestException("could not set data source" + TestHelper.getStackTrace((Throwable)e));
        }
    }

    static {
        connProp = new Properties();
        numOfWorkers = TestConfig.tab().intAt(SQLPrms.numOfWorkers, 0);
        if (numOfWorkers == 0) {
            throw new TestException("numOfWorkers needs to be set to run this test");
        }
    }
}

