/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlutil;

import hydra.Log;
import hydra.MasterController;
import hydra.gemfirexd.NetworkServerHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.dbcp.BasicDataSource;
import sql.GFEDBClientManager;
import sql.GFEDBManager;
import util.TestException;
import util.TestHelper;

public class PooledConnectionDBCP
extends GFEDBClientManager {
    private static volatile BasicDataSource ds;
    private static volatile boolean dsSet;
    private static Properties connProp;
    private static Integer lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection() throws SQLException {
        if (ds == null) {
            Integer n = lock;
            synchronized (n) {
                PooledConnectionDBCP.getDataSource(GFEDBManager.Isolation.NONE);
            }
        }
        while (!dsSet) {
            Log.getLogWriter().info("waiting ds to be set");
            MasterController.sleepForMs((int)1000);
        }
        return ds.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getRCConnection() throws SQLException {
        if (ds == null) {
            Integer n = lock;
            synchronized (n) {
                PooledConnectionDBCP.getDataSource(GFEDBManager.Isolation.READ_COMMITTED);
            }
        }
        while (!dsSet) {
            Log.getLogWriter().info("waiting ds to be set");
            MasterController.sleepForMs((int)1000);
        }
        return ds.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getRRConnection() throws SQLException {
        if (ds == null) {
            Integer n = lock;
            synchronized (n) {
                PooledConnectionDBCP.getDataSource(GFEDBManager.Isolation.REPEATABLE_READ);
            }
        }
        while (!dsSet) {
            Log.getLogWriter().info("waiting ds to be set");
            MasterController.sleepForMs((int)1000);
        }
        return ds.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getRCConnection(Properties p) throws SQLException {
        if (ds == null) {
            Integer n = lock;
            synchronized (n) {
                connProp.putAll((Map<?, ?>)p);
                PooledConnectionDBCP.getDataSource(GFEDBManager.Isolation.READ_COMMITTED);
            }
        }
        while (!dsSet) {
            Log.getLogWriter().info("waiting ds to be set");
            MasterController.sleepForMs((int)1000);
        }
        return ds.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getRRConnection(Properties p) throws SQLException {
        if (ds == null) {
            Integer n = lock;
            synchronized (n) {
                connProp.putAll((Map<?, ?>)p);
                PooledConnectionDBCP.getDataSource(GFEDBManager.Isolation.REPEATABLE_READ);
            }
        }
        while (!dsSet) {
            Log.getLogWriter().info("waiting ds to be set");
            MasterController.sleepForMs((int)1000);
        }
        return ds.getConnection();
    }

    public static BasicDataSource getDataSource(GFEDBManager.Isolation isolation) {
        if (ds == null) {
            PooledConnectionDBCP.setupDataSource(isolation);
            Log.getLogWriter().info("max active is " + ds.getMaxActive());
        }
        return ds;
    }

    private static void setupDataSource(GFEDBManager.Isolation isolation) {
        ds = new BasicDataSource();
        NetworkServerHelper.Endpoint locatorEndPoint = (NetworkServerHelper.Endpoint)NetworkServerHelper.getNetworkLocatorEndpoints().get(0);
        String hostname = PooledConnectionDBCP.getHostNameFromEndpoint(locatorEndPoint);
        int port = PooledConnectionDBCP.getPortFromEndpoint(locatorEndPoint);
        connProp.putAll((Map<?, ?>)PooledConnectionDBCP.getExtraConnProp());
        try {
            ds.setDriverClassName(driver);
            ds.setUrl(protocol + hostname + ":" + port);
            ds.setMaxActive(100);
            if (isolation != GFEDBManager.Isolation.NONE) {
                if (isolation == GFEDBManager.Isolation.READ_COMMITTED) {
                    ds.setDefaultTransactionIsolation(2);
                    ds.setDefaultAutoCommit(false);
                } else {
                    ds.setDefaultTransactionIsolation(4);
                    ds.setDefaultAutoCommit(false);
                }
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Object, Object> entry : connProp.entrySet()) {
                ds.addConnectionProperty((String)entry.getKey(), (String)entry.getValue());
                sb.append((String)entry.getKey() + " is set to " + (String)entry.getValue() + "\n");
            }
            dsSet = true;
            Log.getLogWriter().info("basic source url is set as " + ds.getUrl());
            Log.getLogWriter().info("basic data source setting the following connection prop: " + sb.toString());
        }
        catch (Exception e) {
            throw new TestException("could not set data source" + TestHelper.getStackTrace((Throwable)e));
        }
    }

    static {
        dsSet = false;
        connProp = new Properties();
        lock = 1;
    }
}

