/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlutil;

import hydra.Log;
import hydra.MasterController;
import hydra.gemfirexd.NetworkServerHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import sql.GFEDBClientManager;
import sql.GFEDBManager;
import util.TestException;
import util.TestHelper;

public class PooledConnectionTomcat
extends GFEDBClientManager {
    private static volatile DataSource ds;
    private static volatile boolean dsSet;
    private static Properties connProp;
    private static Integer lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection() throws SQLException {
        if (ds == null) {
            Integer n = lock;
            synchronized (n) {
                PooledConnectionTomcat.getDataSource(GFEDBManager.Isolation.NONE);
            }
        }
        while (!dsSet) {
            Log.getLogWriter().info("waiting ds to be set");
            MasterController.sleepForMs((int)1000);
        }
        return PooledConnectionTomcat.getDataSource(GFEDBManager.Isolation.NONE).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getRCConnection() throws SQLException {
        if (ds == null) {
            Integer n = lock;
            synchronized (n) {
                PooledConnectionTomcat.getDataSource(GFEDBManager.Isolation.READ_COMMITTED);
            }
        }
        while (!dsSet) {
            Log.getLogWriter().info("waiting ds to be set");
            MasterController.sleepForMs((int)1000);
        }
        return PooledConnectionTomcat.getDataSource(GFEDBManager.Isolation.READ_COMMITTED).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getRRConnection() throws SQLException {
        if (ds == null) {
            Integer n = lock;
            synchronized (n) {
                PooledConnectionTomcat.getDataSource(GFEDBManager.Isolation.REPEATABLE_READ);
            }
        }
        while (!dsSet) {
            Log.getLogWriter().info("waiting ds to be set");
            MasterController.sleepForMs((int)1000);
        }
        return PooledConnectionTomcat.getDataSource(GFEDBManager.Isolation.REPEATABLE_READ).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getRCConnection(Properties p) throws SQLException {
        if (ds == null) {
            Integer n = lock;
            synchronized (n) {
                connProp.putAll((Map<?, ?>)p);
                PooledConnectionTomcat.getDataSource(GFEDBManager.Isolation.READ_COMMITTED);
            }
        }
        while (!dsSet) {
            Log.getLogWriter().info("waiting ds to be set");
            MasterController.sleepForMs((int)1000);
        }
        return ds.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getRRConnection(Properties p) throws SQLException {
        if (ds == null) {
            Integer n = lock;
            synchronized (n) {
                connProp.putAll((Map<?, ?>)p);
                PooledConnectionTomcat.getDataSource(GFEDBManager.Isolation.REPEATABLE_READ);
            }
        }
        while (!dsSet) {
            Log.getLogWriter().info("waiting ds to be set");
            MasterController.sleepForMs((int)1000);
        }
        return ds.getConnection();
    }

    public static DataSource getDataSource(GFEDBManager.Isolation isolation) {
        if (ds == null) {
            PooledConnectionTomcat.setupDataSource(isolation);
            MasterController.sleepForMs((int)1000);
            Log.getLogWriter().info("max active is " + ds.getMaxActive());
        }
        return ds;
    }

    private static PoolProperties getPoolProperties() {
        NetworkServerHelper.Endpoint locatorEndPoint = (NetworkServerHelper.Endpoint)NetworkServerHelper.getNetworkLocatorEndpoints().get(0);
        String hostname = PooledConnectionTomcat.getHostNameFromEndpoint(locatorEndPoint);
        int port = PooledConnectionTomcat.getPortFromEndpoint(locatorEndPoint);
        connProp.putAll((Map<?, ?>)PooledConnectionTomcat.getExtraConnProp());
        PoolProperties p = new PoolProperties();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, Object> entry : connProp.entrySet()) {
            sb.append((String)entry.getKey() + "=" + (String)entry.getValue() + ";");
        }
        int lastIndex = sb.lastIndexOf(";");
        if (lastIndex != -1) {
            sb.deleteCharAt(lastIndex);
        }
        p.setConnectionProperties(sb.toString());
        Log.getLogWriter().info("Tomcat data source setting the following connection prop: " + sb.toString());
        p.setUrl(protocol + hostname + ":" + port);
        p.setDriverClassName(driver);
        return p;
    }

    private static void setupDataSource(GFEDBManager.Isolation isolation) {
        ds = new DataSource();
        try {
            ds.setPoolProperties((PoolConfiguration)PooledConnectionTomcat.getPoolProperties());
            ds.setMaxActive(100);
            if (isolation == GFEDBManager.Isolation.NONE) {
                ds.setDefaultTransactionIsolation(0);
            } else if (isolation == GFEDBManager.Isolation.READ_COMMITTED) {
                ds.setDefaultTransactionIsolation(2);
                ds.setDefaultAutoCommit(Boolean.valueOf(false));
            } else {
                ds.setDefaultTransactionIsolation(4);
                ds.setDefaultAutoCommit(Boolean.valueOf(false));
            }
            dsSet = true;
            Log.getLogWriter().info("tomcat data source url is set as " + ds.getUrl());
            Log.getLogWriter().info("tomcat data source DefaultTransactionIsolation is set to " + ds.getDefaultTransactionIsolation());
            Log.getLogWriter().info("tomcat data source DefaultAutoCommit is set to " + ds.getDefaultAutoCommit());
        }
        catch (Exception e) {
            throw new TestException("could not set data source" + TestHelper.getStackTrace((Throwable)e));
        }
    }

    static {
        dsSet = false;
        connProp = new Properties();
        lock = 1;
    }
}

