/*
 * Decompiled with CFR 0.152.
 */
package sql.sqlutil;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.internal.types.ObjectTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.StructTypeImpl;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.query.types.StructType;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdDumpLocalResultMessage;
import hydra.Log;
import hydra.TestConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlStatements.TradeBuyOrdersDMLStmt;
import sql.sqlDAP.SQLDAPTest;
import sql.sqlutil.GFXDStructImpl;
import util.TestException;
import util.TestHelper;

public class ResultSetHelper {
    static boolean setCriticalHeap;
    static boolean isTicket42171Fixed;
    public static final boolean reproduce46886 = true;
    public static boolean useMD5Checksum;
    public static boolean testworkaroundFor51519;
    public static int longVarCharSize;
    public static String defaultTimeZone;

    public static StructTypeImpl getStructType(ResultSet rs) {
        int numOfColumns;
        ResultSetMetaData rsmd;
        try {
            rsmd = rs.getMetaData();
            numOfColumns = rsmd.getColumnCount();
        }
        catch (SQLException se) {
            throw new TestException("could not get resultSet metaData" + TestHelper.getStackTrace((Throwable)se));
        }
        ObjectType[] oTypes = new ObjectType[numOfColumns];
        String[] fieldNames = new String[numOfColumns];
        try {
            for (int i = 0; i < numOfColumns; ++i) {
                Class<?> clazz = null;
                clazz = rsmd.getColumnClassName(i + 1).contains("byte[]") ? Class.forName("sql.sqlutil.ResultSetHelper$ByteClass") : (rsmd.getColumnClassName(i + 1).contains("JSON") ? Class.forName("java.lang.String") : Class.forName(rsmd.getColumnClassName(i + 1)));
                oTypes[i] = new ObjectTypeImpl(clazz);
                fieldNames[i] = rsmd.getColumnName(i + 1);
            }
        }
        catch (SQLException se) {
            throw new TestException("could not getStruct from resultSet\n" + TestHelper.getStackTrace((Throwable)se));
        }
        catch (ClassNotFoundException cnfe) {
            throw new TestException("no class available for a column in result set\n" + TestHelper.getStackTrace((Throwable)cnfe));
        }
        StructTypeImpl sType = new StructTypeImpl(fieldNames, oTypes);
        return sType;
    }

    public static List<Struct> asList(ResultSet rs, StructTypeImpl sType, boolean isDerby) {
        if (rs == null) {
            return null;
        }
        boolean[] success = new boolean[1];
        List<Struct> aList = null;
        aList = ResultSetHelper.asList(rs, sType, success, isDerby);
        if (success[0]) {
            return aList;
        }
        return null;
    }

    public static void logResultSet(LogWriter lw, ResultSet rs) {
        ResultSetHelper.logResultSet(lw, rs, 20);
    }

    public static void logResultSet(LogWriter lw, ResultSet rs, int colWidths) {
        if (rs == null) {
            return;
        }
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int colCount = rsmd.getColumnCount();
            StringBuffer colNamesSB = new StringBuffer();
            for (int i = 1; i <= colCount; ++i) {
                String label = String.format("%1$#" + colWidths + "s", rsmd.getColumnLabel(i));
                colNamesSB.append(label + "|");
            }
            lw.info(colNamesSB.toString());
            while (rs.next()) {
                StringBuffer row = new StringBuffer();
                for (int i = 1; i <= colCount; ++i) {
                    String value = rs.getString(i);
                    if (value == null) {
                        value = "null";
                    }
                    value = value.substring(0, Math.min(20, value.length()));
                    value = String.format("%1$#" + colWidths + "s", value.trim());
                    row.append(value + "|");
                }
                lw.info(row.toString());
            }
        }
        catch (SQLException se) {
            throw new TestException("Error logging result set", (Throwable)se);
        }
    }

    public static List<Struct> asList(ResultSet rs, boolean isDerby) {
        if (rs == null) {
            return null;
        }
        return ResultSetHelper.asList(rs, ResultSetHelper.getStructType(rs), isDerby);
    }

    public static List<Struct> asList(ResultSet rs, StructTypeImpl sType, boolean[] success, boolean isDerby) {
        if (rs == null) {
            return null;
        }
        success[0] = true;
        String[] fieldNames = sType.getFieldNames();
        ObjectType[] oTypes = sType.getFieldTypes();
        int columnSize = fieldNames.length;
        ArrayList<Struct> aList = new ArrayList<Struct>();
        try {
            while (rs.next()) {
                Object[] objects = new Object[columnSize];
                for (int i = 0; i < columnSize; ++i) {
                    if (Blob.class.isAssignableFrom(oTypes[i].resolveClass())) {
                        Blob blob = rs.getBlob(i + 1);
                        if (blob != null) {
                            if (blob.length() > 0L) {
                                if (useMD5Checksum) {
                                    objects[i] = ResultSetHelper.convertByteArrayToChecksum(blob.getBytes(1L, (int)blob.length()), blob.length());
                                    continue;
                                }
                                objects[i] = ResultSetHelper.convertByteArrayToString(blob.getBytes(1L, (int)blob.length()));
                                continue;
                            }
                            objects[i] = "empty";
                            continue;
                        }
                        objects[i] = rs.getObject(i + 1);
                        continue;
                    }
                    if (Clob.class.isAssignableFrom(oTypes[i].resolveClass())) {
                        Clob clob = rs.getClob(i + 1);
                        if (clob != null) {
                            if (clob.length() > 0L) {
                                BufferedReader reader = new BufferedReader(clob.getCharacterStream());
                                objects[i] = useMD5Checksum ? ResultSetHelper.convertBufferedReaderToChecksum(reader, clob.length()) : ResultSetHelper.convertCharArrayToString(reader, (int)clob.length());
                                try {
                                    reader.close();
                                    continue;
                                }
                                catch (IOException e) {
                                    throw new TestException("could not close the BufferedReader" + TestHelper.getStackTrace((Throwable)e));
                                }
                            }
                            objects[i] = "empty profile";
                            continue;
                        }
                        objects[i] = rs.getObject(i + 1);
                        continue;
                    }
                    if (oTypes[i].getSimpleClassName().equalsIgnoreCase("ResultSetHelper$ByteClass")) {
                        byte[] bytes = rs.getBytes(i + 1);
                        if (bytes != null) {
                            if (bytes.length > 0) {
                                objects[i] = ResultSetHelper.convertByteArrayToString(bytes);
                                continue;
                            }
                            objects[i] = "empty";
                            continue;
                        }
                        objects[i] = rs.getObject(i + 1);
                        continue;
                    }
                    if (oTypes[i].getSimpleClassName().equalsIgnoreCase("String")) {
                        String s = rs.getString(i + 1);
                        if (s != null && s.length() > longVarCharSize) {
                            objects[i] = ResultSetHelper.convertStringToChecksum(s, s.length());
                            continue;
                        }
                        objects[i] = s;
                        continue;
                    }
                    if (oTypes[i].getSimpleClassName().equalsIgnoreCase("Timestamp") && testworkaroundFor51519) {
                        objects[i] = rs.getTimestamp(i + 1, ResultSetHelper.getCal());
                        continue;
                    }
                    if (oTypes[i].getSimpleClassName().equalsIgnoreCase("Date") && testworkaroundFor51519) {
                        objects[i] = rs.getDate(i + 1, ResultSetHelper.getCal());
                        continue;
                    }
                    objects[i] = rs.getObject(i + 1);
                    if (!(objects[i] instanceof Short)) continue;
                }
                GFXDStructImpl aStruct = new GFXDStructImpl(sType, objects);
                aList.add((Struct)aStruct);
                boolean logQueryResults = false;
                if (!logQueryResults) continue;
                Log.getLogWriter().info(aStruct.toString());
            }
        }
        catch (SQLException se) {
            if (isDerby) {
                ResultSetHelper.handleException(se, success);
                return null;
            }
            if (se.getSQLState().equals("23503") && !isTicket42171Fixed && TradeBuyOrdersDMLStmt.testLoaderCreateRandomRow) {
                Log.getLogWriter().info("Got bug #42171");
            }
            ResultSetHelper.handleGFXDException(se, success);
            return null;
        }
        return aList;
    }

    public static Calendar getCal() {
        return Calendar.getInstance(TimeZone.getTimeZone(defaultTimeZone));
    }

    public static List<Integer> getCidsAsList(Connection conn, ResultSet rs) {
        boolean[] success = new boolean[1];
        List<Integer> aList = null;
        aList = ResultSetHelper.getCidsAsList(conn, rs, success);
        if (success[0]) {
            return aList;
        }
        return null;
    }

    public static List<Integer> getCidsAsList(Connection conn, ResultSet rs, boolean[] success) {
        success[0] = true;
        ArrayList<Integer> aList = new ArrayList<Integer>();
        try {
            while (rs.next()) {
                int cid = rs.getInt("CID");
                aList.add(new Integer(cid));
            }
        }
        catch (SQLException se) {
            if (SQLHelper.isDerbyConn(conn)) {
                ResultSetHelper.handleException(se, success);
            }
            ResultSetHelper.handleGFXDException(se, success);
        }
        return aList;
    }

    public static List<String> getJsonAsList(Connection conn, ResultSet rs) throws SQLException {
        ArrayList<String> aList = new ArrayList<String>();
        while (rs.next()) {
            String json = rs.getString(1);
            aList.add(json);
        }
        return aList;
    }

    protected static void handleException(SQLException se, boolean[] success) {
        if (se.getSQLState().equals("XN008")) {
            Log.getLogWriter().info("Query processing has been terminated due to an error on the server");
            success[0] = false;
        } else if (se.getSQLState().equals("40XL1")) {
            Log.getLogWriter().info("could not get lock during query processing");
            success[0] = false;
        } else if (se.getSQLState().equals("40001")) {
            Log.getLogWriter().info("could not be obtained a lock due to a deadlock, cycle of locks");
            success[0] = false;
        } else {
            SQLHelper.printSQLException(se);
            throw new TestException("could not extract value from the resultSet\n" + TestHelper.getStackTrace((Throwable)se));
        }
    }

    protected static void handleGFXDException(SQLException se, boolean[] success) {
        if (se.getSQLState().equals("X0Z01") && SQLTest.isHATest) {
            Log.getLogWriter().warning("GFXD_NODE_SHUTDOWN happened converting to list and need to retry the query");
            success[0] = false;
        } else if ((se.getSQLState().equals("X0Z09") || se.getSQLState().equals("X0Z08")) && SQLTest.isOfflineTest) {
            Log.getLogWriter().warning("got expected Offline exception, continuing test");
            success[0] = false;
        } else {
            if (setCriticalHeap && se.getSQLState().equals("XCL54")) {
                Log.getLogWriter().warning("memory runs low and get query cancellation exception");
                boolean[] getCanceled = (boolean[])SQLTest.getCanceled.get();
                if (getCanceled == null) {
                    getCanceled = new boolean[]{true};
                }
                SQLTest.getCanceled.set((Object)getCanceled);
                success[0] = false;
                return;
            }
            SQLHelper.printSQLException(se);
            throw new TestException("could not extract value from resultSet\n" + TestHelper.getStackTrace((Throwable)se));
        }
    }

    public static boolean compareResultSets(ResultSet derbyResultSet, ResultSet gfxdResultSet) {
        boolean[] getCanceled;
        StructTypeImpl sti = ResultSetHelper.getStructType(derbyResultSet);
        List<Struct> derbyList = ResultSetHelper.asList(derbyResultSet, sti, true);
        if (derbyList == null) {
            return false;
        }
        StructTypeImpl gfxdsti = null;
        gfxdsti = SQLDAPTest.cidByRange || SQLDAPTest.tidByList ? sti : ResultSetHelper.getStructType(gfxdResultSet);
        List<Struct> GFEList = ResultSetHelper.asList(gfxdResultSet, gfxdsti, false);
        if (GFEList == null && SQLTest.isHATest) {
            Log.getLogWriter().warning("Could not convert GFE resultSet to list due to #41471");
            return false;
        }
        if (GFEList == null && setCriticalHeap && (getCanceled = (boolean[])SQLTest.getCanceled.get())[0]) {
            Log.getLogWriter().info("memory runs low -- avoiding the comparison");
            return false;
        }
        ResultSetHelper.compareResultSets(derbyList, GFEList);
        return true;
    }

    public static boolean compareSortedResultSets(ResultSet derbyResultSet, ResultSet GFEResultSet) {
        boolean[] getCanceled;
        StructTypeImpl sti = ResultSetHelper.getStructType(derbyResultSet);
        List<Struct> derbyList = ResultSetHelper.asList(derbyResultSet, sti, true);
        if (derbyList == null) {
            return false;
        }
        List<Struct> GFEList = ResultSetHelper.asList(GFEResultSet, sti, false);
        if (GFEList == null && SQLTest.isHATest) {
            Log.getLogWriter().warning("Could not convert GFE resultSet to list due to #41471");
            return false;
        }
        if (GFEList == null && setCriticalHeap && (getCanceled = (boolean[])SQLTest.getCanceled.get())[0]) {
            Log.getLogWriter().info("memory runs low -- avoiding the comparison");
            return false;
        }
        ResultSetHelper.compareSortedResultSets(derbyList, GFEList);
        return true;
    }

    public static void compareResultSets(List<Struct> derbyResultSet, List<Struct> GFEResultSet) {
        ResultSetHelper.compareResultSets(derbyResultSet, GFEResultSet, "derby", "gfxd");
    }

    public static void compareResultSets(List<Struct> firstResultSet, List<Struct> secondResultSet, String first, String second) {
        StringBuffer sb;
        Log.getLogWriter().info("size of resultSet from " + first + " is " + firstResultSet.size());
        Log.getLogWriter().info("size of resultSet from " + second + " is " + secondResultSet.size());
        ArrayList<Struct> secondResultSetCopy = new ArrayList<Struct>(secondResultSet);
        StringBuffer aStr = new StringBuffer();
        for (int i = 0; i < firstResultSet.size(); ++i) {
            secondResultSetCopy.remove(firstResultSet.get(i));
        }
        ArrayList<Struct> unexpected = secondResultSetCopy;
        ArrayList<Struct> missing = null;
        if (firstResultSet.size() != secondResultSet.size() || unexpected.size() > 0) {
            ArrayList<Struct> firstResultSetCopy = new ArrayList<Struct>(firstResultSet);
            for (int i = 0; i < secondResultSet.size(); ++i) {
                firstResultSetCopy.remove(secondResultSet.get(i));
            }
            missing = firstResultSetCopy;
            if (missing.size() > 0) {
                aStr.append("the following " + missing.size() + " elements were missing from " + second + " resultSet: " + ResultSetHelper.listToString(missing));
            }
        }
        if (unexpected.size() > 0) {
            aStr.append("the following " + unexpected.size() + " unexpected elements resultSet: " + ResultSetHelper.listToString(unexpected));
        }
        boolean findCompaniesDiff = false;
        Struct aMissingRow = null;
        StructType sType = null;
        String[] fieldNames = null;
        ObjectType[] oTypes = null;
        Object[] values = null;
        boolean addLoggingFor46886 = false;
        if (missing != null && missing.size() > 0) {
            aMissingRow = (Struct)missing.get(0);
            sType = aMissingRow.getStructType();
            fieldNames = sType.getFieldNames();
            oTypes = sType.getFieldTypes();
            values = aMissingRow.getFieldValues();
            if (addLoggingFor46886) {
                sb = new StringBuffer();
                for (ObjectType objectType : oTypes) {
                    sb.append(objectType.getSimpleClassName() + " ");
                }
                Log.getLogWriter().info("missing row class names from rsmd are " + sb.toString());
                sb.delete(0, sb.length());
                for (String string : fieldNames) {
                    sb.append(string + " ");
                }
                Log.getLogWriter().info("missing row field names are " + sb.toString());
                sb.delete(0, sb.length());
                Object[] objectArray = values;
                int len$ = objectArray.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Object object = objectArray[i$];
                    if (object != null) {
                        sb.append(object.getClass().getName() + " ");
                        if (object.getClass().getName().contains("Integer")) {
                            sb.append("Integer " + object);
                            continue;
                        }
                        if (!object.getClass().getName().contains("Short")) continue;
                        sb.append("Short " + object);
                        continue;
                    }
                    sb.append("null ");
                }
                Log.getLogWriter().info("missing row object class names are " + sb.toString());
            }
            for (String fieldName : fieldNames) {
                if (!fieldName.equalsIgnoreCase("companyinfo")) continue;
                findCompaniesDiff = true;
            }
            if (findCompaniesDiff) {
                String symbol = (String)aMissingRow.get("SYMBOL");
                String string = (String)aMissingRow.get("EXCHANGE");
                for (Struct unexpectedRow : unexpected) {
                    if (!symbol.equalsIgnoreCase((String)unexpectedRow.get("SYMBOL")) || !string.equalsIgnoreCase((String)unexpectedRow.get("EXCHANGE"))) continue;
                    aStr.append("There is difference for symbol: " + symbol + " exchange: " + string + ":\n");
                    for (String fieldName : fieldNames) {
                        if (!fieldName.equalsIgnoreCase("COMPANYINFO") && !fieldName.equalsIgnoreCase("NOTE") || unexpectedRow.get(fieldName) == null || aMissingRow.get(fieldName) == null || unexpectedRow.get(fieldName).equals(aMissingRow.get(fieldName))) continue;
                        aStr.append("column: " + fieldName + " missing is " + aMissingRow.get(fieldName) + " and unexpected is " + unexpectedRow.get(fieldName) + "\n" + ResultSetHelper.findStringDifference(aMissingRow.get(fieldName).toString(), unexpectedRow.get(fieldName).toString(), "missing", "unexpected"));
                    }
                }
            }
        }
        if (unexpected != null && unexpected.size() > 0 && addLoggingFor46886) {
            sType = ((Struct)unexpected.get(0)).getStructType();
            fieldNames = sType.getFieldNames();
            oTypes = sType.getFieldTypes();
            values = ((Struct)unexpected.get(0)).getFieldValues();
            sb = new StringBuffer();
            for (ObjectType objectType : oTypes) {
                sb.append(objectType.getSimpleClassName() + " ");
            }
            Log.getLogWriter().info("unexpected row class names from rsmd are " + sb.toString());
            sb.delete(0, sb.length());
            for (String string : fieldNames) {
                sb.append(string + " ");
            }
            Log.getLogWriter().info("unexpected row field names are " + sb.toString());
            sb.delete(0, sb.length());
            for (Object object : values) {
                if (object != null) {
                    sb.append(object.getClass().getName() + " ");
                    if (object.getClass().getName().contains("Integer")) {
                        sb.append("Integer " + object);
                        continue;
                    }
                    if (!object.getClass().getName().contains("Short")) continue;
                    sb.append("Short " + object);
                    continue;
                }
                sb.append("null ");
            }
            Log.getLogWriter().info("unexpected row object class names are " + sb.toString());
        }
        if (aStr.length() != 0) {
            Log.getLogWriter().info("ResultSet from " + first + " is " + ResultSetHelper.listToString(firstResultSet));
            Log.getLogWriter().info("ResultSet from " + second + " is " + ResultSetHelper.listToString(secondResultSet));
            Log.getLogWriter().info("ResultSet difference is " + aStr.toString());
            if (SQLTest.isOfflineTest && !SQLTest.syncHAForOfflineTest && !SQLTest.setTx) {
                Log.getLogWriter().warning("possibly hit #43754, got the following data mismatch: " + aStr.toString());
                return;
            }
            throw new TestException(aStr.toString());
        }
        if (firstResultSet.size() != secondResultSet.size()) {
            if (firstResultSet.size() < secondResultSet.size()) {
                throw new TestException("There are more data in " + second + " ResultSet");
            }
            throw new TestException("There are fewer data in " + second + " ResultSet");
        }
        Log.getLogWriter().info("verified that results are correct");
    }

    public static Throwable sendResultMessage() {
        try {
            GfxdDumpLocalResultMessage dmsg = new GfxdDumpLocalResultMessage();
            InternalDistributedSystem ds = ResultSetHelper.getDistributedSystem();
            if (ds == null) {
                Log.getLogWriter().info("no ds available, no msg is sent");
            } else {
                dmsg.executeLocally(ds.getDistributionManager(), SQLPrms.getDumpBackingMap());
            }
        }
        catch (Exception e) {
            Log.getLogWriter().info("Unexpected exception thrown: " + TestHelper.getStackTrace((Throwable)e));
            return e;
        }
        return null;
    }

    public static Throwable sendBucketDumpMessage() {
        try {
            GfxdDumpLocalResultMessage.sendBucketInfoDumpMsg(null, (boolean)SQLPrms.getDumpBackingMap());
        }
        catch (Exception e) {
            Log.getLogWriter().info("Unexpected exception thrown: " + TestHelper.getStackTrace((Throwable)e));
            return e;
        }
        return null;
    }

    public static Throwable dumpLocalBucket() {
        try {
            GfxdDumpLocalResultMessage.sendBucketInfoDumpMsg(Collections.singleton(Misc.getDistributedSystem().getDistributedMember()), (boolean)SQLPrms.getDumpBackingMap());
        }
        catch (Exception e) {
            Log.getLogWriter().info("Unexpected exception thrown: " + TestHelper.getStackTrace((Throwable)e));
            return e;
        }
        return null;
    }

    public static void compareSortedResultSets(List<Struct> derbyResultSet, List<Struct> GFEResultSet) {
        ResultSetHelper.compareSortedResultSets(derbyResultSet, GFEResultSet, "derby", "gfxd");
    }

    public static void compareSortedResultSets(List<Struct> firstResultSet, List<Struct> secondResultSet, String firstRs, String secondRs) {
        Log.getLogWriter().info("size of resultSet from " + firstRs + " is " + firstResultSet.size());
        Log.getLogWriter().info("size of resultSet from " + secondRs + " is " + secondResultSet.size());
        StringBuffer aStr = new StringBuffer();
        if (!firstResultSet.equals(secondResultSet)) {
            aStr.append("the results from order by clause are not equal\n");
            int size = firstResultSet.size() < secondResultSet.size() ? firstResultSet.size() : secondResultSet.size();
            for (int i = 0; i < size; ++i) {
                if (firstResultSet.get(i).equals(secondResultSet.get(i))) continue;
                aStr.append("the " + (i + 1) + "th element in the resultSet is different\n");
                aStr.append(firstRs + " has " + firstResultSet.get(i).toString() + "\n");
                aStr.append(secondRs + " has " + secondResultSet.get(i).toString() + "\n");
            }
        }
        if (aStr.length() != 0) {
            Log.getLogWriter().info("ResultSet from " + firstRs + " is " + ResultSetHelper.listToString(firstResultSet));
            Log.getLogWriter().info("ResultSet from " + secondRs + " is " + ResultSetHelper.listToString(secondResultSet));
            if (SQLTest.isOfflineTest && !SQLTest.syncHAForOfflineTest) {
                Log.getLogWriter().warning("possibly hit #43754, got the following data mismatch: " + aStr.toString());
                return;
            }
            throw new TestException(aStr.toString());
        }
        if (firstResultSet.size() == secondResultSet.size()) {
            Log.getLogWriter().info("verified that results are correct");
        }
    }

    public static String listToString(List<Struct> aList) {
        if (aList == null) {
            throw new TestException("test issue, need to check in the test and not pass in null list here");
        }
        StringBuffer aStr = new StringBuffer();
        aStr.append("The size of list is " + (aList == null ? "0" : Integer.valueOf(aList.size())) + "\n");
        for (int i = 0; i < aList.size(); ++i) {
            Struct aStruct = aList.get(i);
            if (aStruct instanceof Struct) {
                GFXDStructImpl si = (GFXDStructImpl)aStruct;
                aStr.append(si.toString());
            }
            aStr.append("\n");
        }
        return aStr.toString();
    }

    private static InternalDistributedSystem getDistributedSystem() {
        try {
            GemFireCacheImpl cache = Misc.getGemFireCache();
            return cache.getDistributedSystem();
        }
        catch (Exception e) {
            Log.getLogWriter().info("could not get the distributed system");
            Log.getLogWriter().severe(TestHelper.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static String convertByteArrayToString(byte[] byteArray) {
        if (byteArray == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (byte b : byteArray) {
            sb.append(b + ", ");
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        sb.append('}');
        return sb.toString();
    }

    public static String convertCharArrayToString(BufferedReader reader, int size) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        try {
            int readChars;
            while ((readChars = reader.read()) != -1) {
                sb.append(readChars + ", ");
            }
        }
        catch (Exception e) {
            throw new TestException("could not read in the charaters " + TestHelper.getStackTrace((Throwable)e));
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        sb.append('}');
        return sb.toString();
    }

    public static String convertBufferedReaderToChecksum(BufferedReader reader, long size) {
        if (size > Integer.MAX_VALUE) {
            throw new TestException("test needs to handle large clob size");
        }
        byte[] bytes = null;
        try {
            String readChars;
            while ((readChars = reader.readLine()) != null) {
                bytes = readChars.getBytes();
            }
        }
        catch (Exception e) {
            if (SQLTest.isHATest && e instanceof IOException) {
                Log.getLogWriter().info("hit #47695, ignored");
                return null;
            }
            throw new TestException("could not read in the charaters " + TestHelper.getStackTrace((Throwable)e));
        }
        if (bytes != null) {
            return ResultSetHelper.convertByteArrayToChecksum(bytes, bytes.length);
        }
        return null;
    }

    public static String convertByteArrayToChecksum(byte[] bytes, long size) {
        if (size > Integer.MAX_VALUE) {
            throw new TestException("test needs to handle large clob size");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(bytes);
            byte[] digest = md.digest();
            StringBuffer sb = new StringBuffer();
            for (byte b : digest) {
                sb.append(Integer.toHexString(b & 0xFF));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new TestException("could not convert clob to MD5 checksum" + TestHelper.getStackTrace((Throwable)e));
        }
    }

    public static String convertClobToChecksum(Clob clob, long size) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(clob.getCharacterStream());
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        return ResultSetHelper.convertBufferedReaderToChecksum(reader, size);
    }

    public static String convertStringToChecksum(String str, long size) {
        if (size > Integer.MAX_VALUE) {
            throw new TestException("test could not handle large string size yet");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = str.getBytes();
            md.update(bytes);
            byte[] digest = md.digest();
            StringBuffer sb = new StringBuffer();
            for (byte b : digest) {
                sb.append(Integer.toHexString(b & 0xFF));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new TestException("could not convert clob to MD5 checksum" + TestHelper.getStackTrace((Throwable)e));
        }
    }

    public static boolean compareDuplicateResultSets(ResultSet derbyResultSet, ResultSet GFEResultSet) {
        Object o = SQLBB.getBB().getSharedMap().get((Object)"TxHistoryPosDup");
        if (o != null) {
            Log.getLogWriter().info("could not compare results in txHistory as duplicate row might be inserted");
            return true;
        }
        return ResultSetHelper.compareResultSets(derbyResultSet, GFEResultSet);
    }

    public static String findStringDifference(String one, String two, String first, String second) {
        int size = one.length() < two.length() ? one.length() : two.length();
        for (int i = 0; i < size; ++i) {
            if (one.charAt(i) == two.charAt(i)) continue;
            return "difference starts from position " + i + " in " + first + " String is " + one.substring(i, i + 100 < size ? i + 100 : size) + " but in " + second + " String is " + two.substring(i, i + 100 < size ? i + 100 : size);
        }
        if (one.length() != two.length()) {
            return "sizes of two strings are different " + first + " String size is " + one.length() + " but the " + second + " String size is " + two.length();
        }
        throw new TestException("could not found difference for these two Strings");
    }

    static {
        isTicket42171Fixed = false;
        longVarCharSize = 1000;
        defaultTimeZone = "PST";
        try {
            setCriticalHeap = SQLTest.setCriticalHeap;
        }
        catch (ExceptionInInitializerError err) {
            setCriticalHeap = false;
        }
        try {
            useMD5Checksum = TestConfig.tab().booleanAt(SQLPrms.useMD5Checksum, true);
        }
        catch (ExceptionInInitializerError err) {
            useMD5Checksum = false;
        }
        catch (NullPointerException npe) {
            useMD5Checksum = false;
        }
        try {
            testworkaroundFor51519 = TestConfig.tab().booleanAt(SQLPrms.testworkaroundFor51519, false) && !SQLTest.hasDerbyServer;
        }
        catch (ExceptionInInitializerError err) {
            testworkaroundFor51519 = false;
        }
        catch (NullPointerException npe) {
            testworkaroundFor51519 = false;
        }
    }

    class ByteClass {
        ByteClass() {
        }
    }
}

